/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableSpaceOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableSpaceOraclev10g && ((TableSpaceOraclev10g)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)object;
        this.storageDesign = tableSpaceOraclev10g.getStorageDesign();
        if (!tableSpaceOraclev10g.isNullInstance()) {
            List list = tableSpaceOraclev10g.getDataFiles();
            this.appendComment(stringBuffer, tableSpaceOraclev10g);
            this.appendCreate(stringBuffer2, tableSpaceOraclev10g);
            string = stringBuffer2.toString();
            this.appendDataFiles(stringBuffer2, tableSpaceOraclev10g, list, bl);
            this.appendMinimumExtent(stringBuffer2, tableSpaceOraclev10g, bl);
            this.appendBlockSize(stringBuffer2, tableSpaceOraclev10g, bl);
            this.appendLogging(stringBuffer2, tableSpaceOraclev10g, bl);
            this.appendForceLogging(stringBuffer2, tableSpaceOraclev10g, bl);
            this.appendStatus(stringBuffer2, tableSpaceOraclev10g, bl);
            this.appendContents(stringBuffer2, tableSpaceOraclev10g, bl);
            this.appendDefaultStorage(stringBuffer2, tableSpaceOraclev10g, bl);
            this.appendExtentManagement(stringBuffer2, tableSpaceOraclev10g, bl);
            this.appendSegmentManagement(stringBuffer2, tableSpaceOraclev10g, bl);
            this.appendFlashBackMode(stringBuffer2, tableSpaceOraclev10g, bl);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBTableSpaceOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            SSBTableSpaceOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            DDLFileMaker.incrementCreateTablespace();
        }
    }

    private void appendFlashBackMode(StringBuffer stringBuffer, TableSpaceOraclev10g tableSpaceOraclev10g, boolean bl) {
        if (tableSpaceOraclev10g.getFlashBack() != null) {
            SSBTableSpaceOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "FLASHBACK");
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, tableSpaceOraclev10g.getFlashBack());
        }
    }

    private void appendCreate(StringBuffer stringBuffer, TableSpaceOraclev10g tableSpaceOraclev10g) {
        SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "CREATE");
        if (!"".equals(tableSpaceOraclev10g.getFileType())) {
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, tableSpaceOraclev10g.getFileType());
        }
        SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
        SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOraclev10g.getName()));
    }

    private void appendSegmentManagement(StringBuffer stringBuffer, TableSpaceOraclev10g tableSpaceOraclev10g, boolean bl) {
        String string;
        String string2 = tableSpaceOraclev10g.getContents();
        String string3 = tableSpaceOraclev10g.getExtentManagement();
        if (string2.equalsIgnoreCase("PERMANENT") && string3.equalsIgnoreCase("LOCAL") && !"".equals(string = tableSpaceOraclev10g.getSegmentManagement())) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append("    ").append("SEGMENT SPACE MANAGEMENT ").append(string);
        }
    }

    private void appendBlockSize(StringBuffer stringBuffer, TableSpaceOraclev10g tableSpaceOraclev10g, boolean bl) {
        int n = tableSpaceOraclev10g.getBlockSize();
        if (n > 0) {
            SSBTableSpaceOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "BLOCKSIZE");
            this.appendStringWithSpace(stringBuffer, n);
        }
    }

    private void appendDataFiles(StringBuffer stringBuffer, TableSpaceOraclev10g tableSpaceOraclev10g, List list, boolean bl) {
        Iterator iterator = list.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            DataFileOracle dataFileOracle = (DataFileOracle)iterator.next();
            if (!bl2) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append("    ");
                SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "DATAFILE");
                bl2 = true;
            } else {
                SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, ',');
            }
            String string = dataFileOracle.getFileName().trim();
            if (!string.equals("")) {
                SSBTableSpaceOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, this.addQuotes(string, true));
            }
            if (dataFileOracle.getSize() > 0L) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "SIZE");
                this.appendStringWithSpace(stringBuffer, dataFileOracle.getSize());
                SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, dataFileOracle.getMeasureUnit());
            }
            if (dataFileOracle.getReuse().equalsIgnoreCase("YES") && !string.equals("")) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "REUSE");
            }
            if (!"ON".equalsIgnoreCase(dataFileOracle.getAutoextend()) && !"OFF".equalsIgnoreCase(dataFileOracle.getAutoextend())) continue;
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "AUTOEXTEND");
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, dataFileOracle.getAutoextend());
            if (!dataFileOracle.getAutoextend().equalsIgnoreCase("ON")) continue;
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "NEXT");
            this.appendStringWithSpace(stringBuffer, dataFileOracle.getNextBlockSize());
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "K");
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "MAXSIZE");
            if (dataFileOracle.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "UNLIMITED");
                continue;
            }
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, dataFileOracle.getMaxSize());
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "K");
        }
    }

    private void appendMinimumExtent(StringBuffer stringBuffer, TableSpaceOraclev10g tableSpaceOraclev10g, boolean bl) {
        int n;
        if ("DICTIONARY".equalsIgnoreCase(tableSpaceOraclev10g.getExtentManagement()) && (n = tableSpaceOraclev10g.getMinExtLen()) > 0) {
            SSBTableSpaceOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "MINIMUM");
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "EXTENT");
            this.appendStringWithSpace(stringBuffer, n);
        }
    }

    private void appendLogging(StringBuffer stringBuffer, TableSpaceOraclev10g tableSpaceOraclev10g, boolean bl) {
        SSBTableSpaceOraclev10g.appendNewLine(stringBuffer, bl, 1);
        SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, tableSpaceOraclev10g.getLogging());
    }

    private void appendForceLogging(StringBuffer stringBuffer, TableSpaceOraclev10g tableSpaceOraclev10g, boolean bl) {
        if ("YES".equalsIgnoreCase(tableSpaceOraclev10g.getForceLogging())) {
            SSBTableSpaceOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "FORCE");
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
        }
    }

    private void appendStatus(StringBuffer stringBuffer, TableSpaceOraclev10g tableSpaceOraclev10g, boolean bl) {
        String string = tableSpaceOraclev10g.getStatus();
        SSBTableSpaceOraclev10g.appendNewLine(stringBuffer, bl, 1);
        SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, string);
    }

    private void appendContents(StringBuffer stringBuffer, TableSpaceOraclev10g tableSpaceOraclev10g, boolean bl) {
        String string = tableSpaceOraclev10g.getContents();
        SSBTableSpaceOraclev10g.appendNewLine(stringBuffer, bl, 1);
        SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, string);
    }

    private void appendDefaultStorage(StringBuffer stringBuffer, TableSpaceOraclev10g tableSpaceOraclev10g, boolean bl) {
        String string = tableSpaceOraclev10g.getDSCompression();
        if ("LOCAL".equalsIgnoreCase(tableSpaceOraclev10g.getExtentManagement())) {
            if (!string.equals("")) {
                SSBTableSpaceOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "DEFAULT");
                SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, string);
            }
        } else {
            SSBTableSpaceOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "DEFAULT");
            if (!string.equals("")) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, string);
            }
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "STORAGE");
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, '(');
            long l = tableSpaceOraclev10g.getDSInitialExtent();
            long l2 = tableSpaceOraclev10g.getDSNextExtent();
            int n = tableSpaceOraclev10g.getDSMinExtents();
            String string2 = tableSpaceOraclev10g.getDSMaxExtents();
            int n2 = tableSpaceOraclev10g.getDSPctIncrease();
            if (l > 0L) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, l);
            }
            if (l2 > 0L) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, l2);
            }
            if (n > 1) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "MINEXTENTS");
                this.appendStringWithSpace(stringBuffer, n);
            }
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, string2);
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, n2);
            SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendExtentManagement(StringBuffer stringBuffer, TableSpaceOraclev10g tableSpaceOraclev10g, boolean bl) {
        String string = tableSpaceOraclev10g.getExtentManagement();
        SSBTableSpaceOraclev10g.appendNewLine(stringBuffer, bl, 1);
        SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "EXTENT");
        SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "MANAGEMENT");
        SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, string);
        if (string.equalsIgnoreCase("LOCAL")) {
            if (tableSpaceOraclev10g.getEMLocalSubtype().equalsIgnoreCase("AUTOALLOCATE")) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "AUTOALLOCATE");
            } else if (tableSpaceOraclev10g.getEMLocalSubtype().equalsIgnoreCase("UNIFORM")) {
                SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "UNIFORM");
                if (tableSpaceOraclev10g.getEMUniformSize() > 0) {
                    SSBTableSpaceOraclev10g.appendStringWithSpace(stringBuffer, "SIZE");
                    this.appendStringWithSpace(stringBuffer, tableSpaceOraclev10g.getEMUniformSize());
                }
            }
        }
    }
}

