/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.MethodParamProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.MethodProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.MethodProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StructuredTypeProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TypeElementProxyOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBStructuredTypeOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        if (object instanceof StructuredType) {
            StructuredType structuredType = (StructuredType)object;
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl, 0);
            this.appendComment(stringBuffer, structuredType);
        } else if (object instanceof StructuredTypeProxyOraclev10g) {
            StructuredTypeProxyOraclev10g structuredTypeProxyOraclev10g = (StructuredTypeProxyOraclev10g)object;
            this.storageDesign = structuredTypeProxyOraclev10g.getStorageDesign();
            if (!structuredTypeProxyOraclev10g.getStructuredType().isPredefined()) {
                SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, structuredTypeProxyOraclev10g);
                this.appendFullDefinition(stringBuffer, structuredTypeProxyOraclev10g, bl);
                this.appendCreateTypeBody(stringBuffer, structuredTypeProxyOraclev10g, bl);
                this.appendPermissions(stringBuffer, structuredTypeProxyOraclev10g);
                DDLFileMaker.incrementCreateStructuredType();
            }
        }
    }

    private void appendFullDefinition(StringBuffer stringBuffer, StructuredTypeProxyOraclev10g structuredTypeProxyOraclev10g, boolean bl) {
        String string;
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = "";
        SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl, 0);
        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "CREATE");
        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "OR");
        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "REPLACE");
        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "TYPE");
        if (structuredTypeProxyOraclev10g.getOwner() != null && !"".equals(string = structuredTypeProxyOraclev10g.getOwner().getName())) {
            SSBStructuredTypeOraclev10g.appendString(stringBuffer2, this.storageDesign.getFormatedName(string));
            SSBStructuredTypeOraclev10g.appendString(stringBuffer2, '.');
        }
        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(structuredTypeProxyOraclev10g.getName()));
        string2 = stringBuffer2.toString();
        if (!"".equalsIgnoreCase(structuredTypeProxyOraclev10g.getGlobalOid())) {
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 1);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "OID");
            SSBStructuredTypeOraclev10g.appendString(stringBuffer2, '\'');
            SSBStructuredTypeOraclev10g.appendString(stringBuffer2, structuredTypeProxyOraclev10g.getGlobalOid());
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, '\'');
        }
        if (!"".equalsIgnoreCase(structuredTypeProxyOraclev10g.getInvokerRights())) {
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 1);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "AUTHID");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, structuredTypeProxyOraclev10g.getInvokerRights());
        }
        if ("".equalsIgnoreCase(structuredTypeProxyOraclev10g.getSuperType())) {
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 1);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "AS");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "OBJECT");
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 1);
        } else {
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 1);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "UNDER");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, structuredTypeProxyOraclev10g.getSuperType());
        }
        this.appendSqljObjectType(stringBuffer2, structuredTypeProxyOraclev10g, bl);
        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, '(');
        SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 2);
        this.appendElements(stringBuffer2, structuredTypeProxyOraclev10g, bl);
        this.appendMethods(stringBuffer2, structuredTypeProxyOraclev10g, bl);
        SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 1);
        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, ')');
        if ("NO".equalsIgnoreCase(structuredTypeProxyOraclev10g.getFinal())) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "NOT");
        }
        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "FINAL");
        if ("NO".equalsIgnoreCase(structuredTypeProxyOraclev10g.getInstantiable())) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "NOT");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "INSTANTIABLE");
        }
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
        SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisherWithSlash(stringBuffer2, bl);
        SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
    }

    private void appendSqljObjectType(StringBuffer stringBuffer, StructuredTypeProxyOraclev10g structuredTypeProxyOraclev10g, boolean bl) {
        if ("YES".equalsIgnoreCase(structuredTypeProxyOraclev10g.getMapToJavaClass())) {
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "EXTERNAL");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "NAME");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, structuredTypeProxyOraclev10g.getJavaClass());
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "LANGUAGE");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "JAVA");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "USING");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, structuredTypeProxyOraclev10g.getJavaInstanceUsing());
        }
    }

    private void appendElements(StringBuffer stringBuffer, StructuredTypeProxyOraclev10g structuredTypeProxyOraclev10g, boolean bl) {
        boolean bl2 = true;
        StructuredType structuredType = structuredTypeProxyOraclev10g.getStructuredType();
        TypeElement[] typeElementArray = structuredType.getElements();
        for (int i = 0; i < typeElementArray.length; ++i) {
            TypeElementProxyOraclev10g typeElementProxyOraclev10g = (TypeElementProxyOraclev10g)structuredTypeProxyOraclev10g.getElementByDesignObject(typeElementArray[i]);
            if (!bl2) {
                this.appendComma(stringBuffer);
                SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl, 2);
            } else {
                bl2 = false;
            }
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(typeElementProxyOraclev10g.getName()));
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, typeElementProxyOraclev10g.getDatatype(this.storageDesign.getRDBMSType().getName()));
            if ("".equalsIgnoreCase(typeElementProxyOraclev10g.getSqlJAttr())) continue;
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "EXTERNAL");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "NAME");
            SSBStructuredTypeOraclev10g.appendString(stringBuffer, '\'');
            SSBStructuredTypeOraclev10g.appendString(stringBuffer, typeElementProxyOraclev10g.getSqlJAttr());
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, '\'');
        }
    }

    private void appendMethods(StringBuffer stringBuffer, StructuredTypeProxyOracle structuredTypeProxyOracle, boolean bl) {
        boolean bl2;
        Iterator iterator = structuredTypeProxyOracle.getMethods().iterator();
        boolean bl3 = bl2 = structuredTypeProxyOracle.getElements().size() == 0;
        while (iterator.hasNext()) {
            MethodProxyOraclev10g methodProxyOraclev10g = (MethodProxyOraclev10g)iterator.next();
            if (!bl2) {
                this.appendComma(stringBuffer);
                SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl, 2);
            } else {
                bl2 = false;
            }
            this.appendInheritanceClauses(stringBuffer, methodProxyOraclev10g, bl);
            boolean bl4 = "YES".equalsIgnoreCase(methodProxyOraclev10g.getConstructor());
            if (!bl4) {
                if (structuredTypeProxyOracle.getMapOrderFunction() == methodProxyOraclev10g) {
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, structuredTypeProxyOracle.getMapOrderType());
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "MEMBER");
                } else if ("YES".equalsIgnoreCase(methodProxyOraclev10g.getIsStatic())) {
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "STATIC");
                } else {
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "MEMBER");
                }
            }
            this.appendProcSpec(stringBuffer, structuredTypeProxyOracle, methodProxyOraclev10g, bl4, bl);
            this.appendPragmaClause(stringBuffer, methodProxyOraclev10g, bl);
        }
    }

    private void appendInheritanceClauses(StringBuffer stringBuffer, MethodProxyOraclev10g methodProxyOraclev10g, boolean bl) {
        if (!"NO".equalsIgnoreCase(methodProxyOraclev10g.getOverriding())) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "OVERRIDING");
        }
        if ("NO".equalsIgnoreCase(methodProxyOraclev10g.getInstantiable())) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "NOT");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "INSTANTIABLE");
        } else if ("YES".equalsIgnoreCase(methodProxyOraclev10g.getIsFinal())) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "FINAL");
        }
    }

    private void appendProcSpec(StringBuffer stringBuffer, StructuredTypeProxyOracle structuredTypeProxyOracle, MethodProxyOraclev10g methodProxyOraclev10g, boolean bl, boolean bl2) {
        if (bl) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "CONSTRUCTOR");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "FUNCTION");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(structuredTypeProxyOracle.getName()));
        } else {
            if ("PROCEDURE".equalsIgnoreCase(methodProxyOraclev10g.getMethodType())) {
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "PROCEDURE");
            } else {
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "FUNCTION");
            }
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(methodProxyOraclev10g.getName()));
        }
        if (methodProxyOraclev10g.getParams().size() > 0 || "NO".equalsIgnoreCase(methodProxyOraclev10g.getCopySelf())) {
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            boolean bl3 = true;
            if ("NO".equalsIgnoreCase(methodProxyOraclev10g.getCopySelf()) && "NO".equalsIgnoreCase(methodProxyOraclev10g.getIsStatic())) {
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "SELF");
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "IN");
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "OUT");
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "NOCOPY");
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(structuredTypeProxyOracle.getName()));
                bl3 = false;
            }
            Iterator iterator = methodProxyOraclev10g.getParams().iterator();
            while (iterator.hasNext()) {
                MethodParamProxyOracle methodParamProxyOracle = (MethodParamProxyOracle)iterator.next();
                if (bl3) {
                    bl3 = false;
                } else {
                    this.appendComma(stringBuffer);
                    SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                }
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(methodParamProxyOracle.getName()));
                if (!"".equalsIgnoreCase(methodParamProxyOracle.getDirectionType())) {
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, methodParamProxyOracle.getDirectionType());
                }
                if ("NO".equalsIgnoreCase(methodParamProxyOracle.getCopyArgument())) {
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "NOCOPY");
                }
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, methodParamProxyOracle.getDatatype(this.storageDesign.getRDBMSType().getName()));
            }
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
        if (bl) {
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "RETURN");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "SELF");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "AS");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "RESULT");
        } else if (((Method)methodProxyOraclev10g.getObject()).getReturnValue() != null) {
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "RETURN");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, ((Method)methodProxyOraclev10g.getObject()).getReturnValue().getDataType(this.storageDesign.getRDBMSType().getName()));
        }
        if (methodProxyOraclev10g.getDeterministic().equalsIgnoreCase("YES")) {
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "DETERMINISTIC");
        }
        if (methodProxyOraclev10g.getParallel().equalsIgnoreCase("YES")) {
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "PARALLEL_ENABLE");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, methodProxyOraclev10g.getPartitioningAndStreaming());
        }
        if (methodProxyOraclev10g.getPipeliningAndAggregation().equalsIgnoreCase("Pipelined")) {
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "PIPELINED");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, methodProxyOraclev10g.getPipeliningAndAggregationImpl());
        } else if (methodProxyOraclev10g.getPipeliningAndAggregation().equalsIgnoreCase("Pipelined Using")) {
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "PIPELINED USING");
        } else if (methodProxyOraclev10g.getPipeliningAndAggregation().equalsIgnoreCase("Aggregate Using")) {
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "AGGREGATE USING");
        }
        if (!"PL/SQL".equalsIgnoreCase(methodProxyOraclev10g.getImplLanguage())) {
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "AS");
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl2, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "LANGUAGE");
            if ("Java".equalsIgnoreCase(methodProxyOraclev10g.getImplLanguage())) {
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "JAVA");
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "NAME");
                SSBStructuredTypeOraclev10g.appendString(stringBuffer, '\'');
                SSBStructuredTypeOraclev10g.appendString(stringBuffer, methodProxyOraclev10g.getJavaName());
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, '\'');
            } else if ("C".equalsIgnoreCase(methodProxyOraclev10g.getImplLanguage())) {
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "C");
                if (!"".equalsIgnoreCase(methodProxyOraclev10g.getCName())) {
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "NAME");
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, methodProxyOraclev10g.getCName());
                }
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "LIBRARY");
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, methodProxyOraclev10g.getCLibrary());
                if ("YES".equalsIgnoreCase(methodProxyOraclev10g.getWithContext())) {
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "WITH");
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "CONTEXT");
                }
                if (!"".equalsIgnoreCase(methodProxyOraclev10g.getCPartemeters())) {
                    SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "PARAMETERS");
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, methodProxyOraclev10g.getCPartemeters());
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
            }
        }
    }

    private void appendPragmaClause(StringBuffer stringBuffer, MethodProxyOracle methodProxyOracle, boolean bl) {
        if (!"".equalsIgnoreCase(methodProxyOracle.getPragmaClause())) {
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "PRAGMA");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "RESTRICT_REFERENCES");
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, methodProxyOracle.getPragmaClause());
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendCreateTypeBody(StringBuffer stringBuffer, StructuredTypeProxyOracle structuredTypeProxyOracle, boolean bl) {
        if (this.hasPLSQLMethod(structuredTypeProxyOracle)) {
            Object object;
            StringBuffer stringBuffer2 = new StringBuffer();
            String string = "";
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer, bl, 0);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "CREATE");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "OR");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "REPLACE");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "TYPE");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "BODY");
            if (structuredTypeProxyOracle.getOwner() != null && !"".equals(object = structuredTypeProxyOracle.getOwner().getName())) {
                SSBStructuredTypeOraclev10g.appendString(stringBuffer2, this.storageDesign.getFormatedName((String)object));
                SSBStructuredTypeOraclev10g.appendString(stringBuffer2, '.');
            }
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(structuredTypeProxyOracle.getName()));
            string = stringBuffer2.toString();
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 1);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "AS");
            object = structuredTypeProxyOracle.getMethods().iterator();
            while (object.hasNext()) {
                MethodProxyOraclev10g methodProxyOraclev10g = (MethodProxyOraclev10g)object.next();
                boolean bl2 = "YES".equalsIgnoreCase(methodProxyOraclev10g.getConstructor());
                if (!bl2 && "NO".equalsIgnoreCase(methodProxyOraclev10g.getInstantiable())) continue;
                SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                if (!bl2) {
                    if (structuredTypeProxyOracle.getMapOrderFunction() == methodProxyOraclev10g) {
                        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, structuredTypeProxyOracle.getMapOrderType());
                        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "MEMBER");
                    } else if ("YES".equalsIgnoreCase(methodProxyOraclev10g.getIsStatic())) {
                        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "STATIC");
                        if ("YES".equalsIgnoreCase(methodProxyOraclev10g.getIsFinal())) {
                            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "FINAL");
                        }
                    } else {
                        if ("YES".equalsIgnoreCase(methodProxyOraclev10g.getOverriding())) {
                            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "OVERRIDING");
                        }
                        if ("YES".equalsIgnoreCase(methodProxyOraclev10g.getIsFinal())) {
                            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "FINAL");
                        }
                        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "MEMBER");
                    }
                    if ("PROCEDURE".equalsIgnoreCase(methodProxyOraclev10g.getMethodType())) {
                        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "PROCEDURE");
                    } else {
                        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "FUNCTION");
                    }
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(methodProxyOraclev10g.getName()));
                } else {
                    if ("YES".equalsIgnoreCase(methodProxyOraclev10g.getIsFinal())) {
                        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "FINAL");
                    }
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "CONSTRUCTOR");
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "FUNCTION");
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(structuredTypeProxyOracle.getName()));
                }
                if (methodProxyOraclev10g.getParams().size() > 0 || "NO".equalsIgnoreCase(methodProxyOraclev10g.getCopySelf())) {
                    SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 2);
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, '(');
                    SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 2);
                    boolean bl3 = true;
                    if ("NO".equalsIgnoreCase(methodProxyOraclev10g.getCopySelf()) && "NO".equalsIgnoreCase(methodProxyOraclev10g.getIsStatic())) {
                        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "SELF");
                        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "IN");
                        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "OUT");
                        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "NOCOPY");
                        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(structuredTypeProxyOracle.getName()));
                        bl3 = false;
                    }
                    Iterator iterator = methodProxyOraclev10g.getParams().iterator();
                    while (iterator.hasNext()) {
                        MethodParamProxyOracle methodParamProxyOracle = (MethodParamProxyOracle)iterator.next();
                        if (bl3) {
                            bl3 = false;
                        } else {
                            this.appendComma(stringBuffer2);
                            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 2);
                        }
                        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(methodParamProxyOracle.getName()));
                        if (!"".equalsIgnoreCase(methodParamProxyOracle.getDirectionType())) {
                            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, methodParamProxyOracle.getDirectionType());
                        }
                        if ("NO".equalsIgnoreCase(methodParamProxyOracle.getCopyArgument())) {
                            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "NOCOPY");
                        }
                        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, methodParamProxyOracle.getDatatype(this.storageDesign.getRDBMSType().getName()));
                    }
                    SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 2);
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, ')');
                }
                if (bl2) {
                    SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 2);
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "RETURN");
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "SELF");
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "AS");
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "RESULT");
                } else if (((Method)methodProxyOraclev10g.getObject()).getReturnValue() != null) {
                    SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 2);
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "RETURN");
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, ((Method)methodProxyOraclev10g.getObject()).getReturnValue().getDataType(this.storageDesign.getRDBMSType().getName()));
                }
                SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "AS");
                SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                if ("PL/SQL".equalsIgnoreCase(methodProxyOraclev10g.getImplLanguage())) {
                    if (!"".equalsIgnoreCase(methodProxyOraclev10g.getPLSQLBody().trim())) {
                        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, methodProxyOraclev10g.getPLSQLBody());
                        continue;
                    }
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "-- Empty PL/SQL Body");
                    SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "BEGIN NULL; END;");
                    continue;
                }
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "LANGUAGE");
                if ("Java".equalsIgnoreCase(methodProxyOraclev10g.getImplLanguage())) {
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "JAVA");
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "NAME");
                    SSBStructuredTypeOraclev10g.appendString(stringBuffer2, '\'');
                    SSBStructuredTypeOraclev10g.appendString(stringBuffer2, methodProxyOraclev10g.getJavaName());
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, '\'');
                    continue;
                }
                if (!"C".equalsIgnoreCase(methodProxyOraclev10g.getImplLanguage())) continue;
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "C");
                if (!"".equalsIgnoreCase(methodProxyOraclev10g.getCName())) {
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "NAME");
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, methodProxyOraclev10g.getCName());
                }
                SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 2);
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "LIBRARY");
                if ("".equalsIgnoreCase(methodProxyOraclev10g.getCLibrary())) {
                    SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 2);
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "-- Empty library");
                } else {
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, methodProxyOraclev10g.getCLibrary());
                }
                if (!"".equalsIgnoreCase(methodProxyOraclev10g.getAgentArguments())) {
                    SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 2);
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "AGENT");
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "IN");
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, '(');
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, methodProxyOraclev10g.getAgentArguments());
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, ')');
                }
                if ("YES".equalsIgnoreCase(methodProxyOraclev10g.getWithContext())) {
                    SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 2);
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "WITH");
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "CONTEXT");
                }
                if ("".equalsIgnoreCase(methodProxyOraclev10g.getCPartemeters())) continue;
                SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 2);
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "PARAMETERS");
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, '(');
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, methodProxyOraclev10g.getCPartemeters());
                SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, ')');
            }
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 1);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "END");
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisherWithSlash(stringBuffer2, bl);
            SSBStructuredTypeOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
    }

    private boolean hasPLSQLMethod(StructuredTypeProxyOracle structuredTypeProxyOracle) {
        Iterator iterator = structuredTypeProxyOracle.getMethods().iterator();
        while (iterator.hasNext()) {
            MethodProxyOraclev10g methodProxyOraclev10g = (MethodProxyOraclev10g)iterator.next();
            if (!"PL/SQL".equalsIgnoreCase(methodProxyOraclev10g.getImplLanguage()) || !"YES".equalsIgnoreCase(methodProxyOraclev10g.getInstantiable())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof StructuredTypeProxyOraclev10g && ((StructuredTypeProxyOraclev10g)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof StructuredType && ((StructuredType)object).isMarkedGenerate();
    }

    protected void appendPermissions(StringBuffer stringBuffer, StructuredTypeProxyOracle structuredTypeProxyOracle) {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)structuredTypeProxyOracle.getStorageDesign();
        StringBuffer stringBuffer2 = new StringBuffer();
        PermissionsSetOracle permissionsSetOracle = storageDesignOracle.getPermissionsSet();
        Iterator iterator = permissionsSetOracle.iterator();
        while (iterator.hasNext()) {
            PermissionsOracle permissionsOracle = (PermissionsOracle)iterator.next();
            if (!structuredTypeProxyOracle.equals(permissionsOracle.getStructuredTypeOracle()) || permissionsOracle.getUser() == null && permissionsOracle.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissionsOracle.getPrivileges())) {
                this.appendPrivileges(stringBuffer, stringBuffer2, permissionsOracle, structuredTypeProxyOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissionsOracle.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(stringBuffer, stringBuffer2, permissionsOracle, structuredTypeProxyOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer stringBuffer, StringBuffer stringBuffer2, PermissionsOracle permissionsOracle, StructuredTypeProxyOracle structuredTypeProxyOracle, StorageDesignOracle storageDesignOracle, boolean bl) {
        stringBuffer2.append(NEWLINE);
        this.appendComment(stringBuffer2, permissionsOracle);
        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer2, "GRANT");
        if (bl) {
            stringBuffer2.append(permissionsOracle.getPrivilegesWithGrantOption());
        } else {
            stringBuffer2.append(permissionsOracle.getPrivileges());
        }
        this.appendObject(stringBuffer2, structuredTypeProxyOracle, storageDesignOracle);
        this.appendTo(stringBuffer2, permissionsOracle, storageDesignOracle);
        if (bl) {
            this.appendGrantOption(stringBuffer2, permissionsOracle);
        }
        String string = stringBuffer2.toString();
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(';');
        stringBuffer2.append(NEWLINE);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
    }

    private void appendObject(StringBuffer stringBuffer, StructuredTypeProxyOracle structuredTypeProxyOracle, StorageDesign storageDesign) {
        stringBuffer.append(NEWLINE);
        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "ON");
        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(structuredTypeProxyOracle.getLongName()));
    }

    private void appendTo(StringBuffer stringBuffer, PermissionsOracle permissionsOracle, StorageDesign storageDesign) {
        SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "TO");
        if ("YES".equalsIgnoreCase(permissionsOracle.getPublic())) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "PUBLIC");
        } else if (permissionsOracle.getUser() != null) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(permissionsOracle.getUser().getName()));
        } else if (permissionsOracle.getRole() != null) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(permissionsOracle.getRole().getName()));
        }
    }

    private void appendGrantOption(StringBuffer stringBuffer, PermissionsOracle permissionsOracle) {
        if (permissionsOracle.getRole() == null) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
        }
    }
}

