/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBTableOraclev10g;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionLobItemOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PermissionsOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SnapshotOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.LobStorageOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSnapshotOraclev10g
extends AbstractSSBOracle {
    SSBTableOraclev10g sSBTableOraclev10g;
    protected StorageDesignOraclev10g storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        SnapshotOraclev10g snapshotOraclev10g = (SnapshotOraclev10g)object;
        TableProxyOracle tableProxyOracle = snapshotOraclev10g.getImplementedTable();
        if (!snapshotOraclev10g.isMarkedGenerate()) {
            if (tableProxyOracle != null && this.sSBTableOraclev10g != null) {
                this.sSBTableOraclev10g.appendIndexes(stringBuffer, tableProxyOracle, bl);
            }
            return;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        this.storageDesign = (StorageDesignOraclev10g)snapshotOraclev10g.getStorageDesign();
        this.appendComment(stringBuffer, snapshotOraclev10g);
        this.appendCreateSnapshot(stringBuffer2, snapshotOraclev10g);
        String string = stringBuffer2.toString();
        if (tableProxyOracle != null || snapshotOraclev10g.getOnPrebuildTable() == null) {
            if (snapshotOraclev10g.getCluster() != null) {
                this.appendCluster(stringBuffer2, snapshotOraclev10g, bl);
            } else {
                this.appendSegment(stringBuffer2, snapshotOraclev10g, bl);
            }
            if (tableProxyOracle != null && this.sSBTableOraclev10g != null) {
                this.sSBTableOraclev10g.appendPartitionList(stringBuffer2, (TableProxyOraclev10g)tableProxyOracle, bl);
            } else {
                this.appendPartitioning(stringBuffer2, snapshotOraclev10g, bl);
            }
            this.appendParallelClause(stringBuffer2, snapshotOraclev10g, bl);
            if (!snapshotOraclev10g.getBuild().equals("IMMEDIATE")) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer2, "BUILD");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer2, snapshotOraclev10g.getBuild());
            }
        } else {
            this.appendPrebuild(stringBuffer2, snapshotOraclev10g, bl);
        }
        this.appendUsingIndex(stringBuffer2, snapshotOraclev10g, bl);
        this.appendRefreshClause(stringBuffer2, snapshotOraclev10g, bl);
        this.appendForUpdate(stringBuffer2, snapshotOraclev10g, bl);
        this.appendQueryRewrite(stringBuffer2, snapshotOraclev10g, bl);
        this.appendSubquery(stringBuffer2, snapshotOraclev10g, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        SSBSnapshotOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        DDLFileMaker.incrementCreateSnapshot();
        SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 0);
        this.appendCommentOn(stringBuffer2, snapshotOraclev10g, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        if (tableProxyOracle != null && this.sSBTableOraclev10g != null) {
            this.sSBTableOraclev10g.appendIndexes(stringBuffer, tableProxyOracle, bl);
        }
        this.appendPermissions(stringBuffer, snapshotOraclev10g, bl);
        SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 0);
    }

    private void appendCreateSnapshot(StringBuffer stringBuffer, SnapshotOraclev10g snapshotOraclev10g) {
        this.appendCreate(stringBuffer);
        SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "MATERIALIZED");
        SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "VIEW");
        SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(snapshotOraclev10g.getLongName()));
    }

    private void appendSegment(StringBuffer stringBuffer, SnapshotOraclev10g snapshotOraclev10g, boolean bl) {
        this.appendPhysicalAttributes(stringBuffer, snapshotOraclev10g.getSegment(), bl);
        this.appendTableSpace(stringBuffer, snapshotOraclev10g, bl);
        this.appendLobStorage(stringBuffer, snapshotOraclev10g.getLobStorage(), bl);
        this.appendAttributes(stringBuffer, snapshotOraclev10g, bl);
    }

    private void appendParallelClause(StringBuffer stringBuffer, SnapshotOracle snapshotOracle, boolean bl) {
        if ("YES".equalsIgnoreCase(snapshotOracle.getParalelClause())) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "PARALLEL");
        }
    }

    private void appendPrebuild(StringBuffer stringBuffer, SnapshotOracle snapshotOracle, boolean bl) {
        if (snapshotOracle.getImplementedTable() != null || snapshotOracle.getOnPrebuildTable() == null) {
            if (!snapshotOracle.getBuild().equals("IMMEDIATE")) {
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "BUILD");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, snapshotOracle.getBuild());
            }
        } else {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "ON");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "PREBUILT");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "TABLE");
            if ("NO".equalsIgnoreCase(snapshotOracle.getReducedPrecision())) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "WITHOUT REDUCED PRECISION");
            }
        }
    }

    private void appendUsingIndex(StringBuffer stringBuffer, SnapshotOracle snapshotOracle, boolean bl) {
        if (snapshotOracle.getUseIndex().equals("YES")) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "USING");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "INDEX");
            if (snapshotOracle.getIndexTablespace() != null) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(snapshotOracle.getIndexTablespace().getName()));
            } else if (snapshotOracle.getIndexSegment() != null) {
                this.appendPhysicalAttributes(stringBuffer, snapshotOracle.getIndexSegment(), bl);
            }
        } else if (snapshotOracle.getUseIndex().equals("NO")) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "USING");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "NO");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "INDEX");
        }
    }

    private void appendRefreshClause(StringBuffer stringBuffer, SnapshotOraclev10g snapshotOraclev10g, boolean bl) {
        if ("NEVER".equalsIgnoreCase(snapshotOraclev10g.getRefresh())) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "NEVER");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "REFRESH");
        } else if ("YES".equals(snapshotOraclev10g.getRefresh())) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "REFRESH");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, snapshotOraclev10g.getRefreshType());
            if (!"".equalsIgnoreCase(snapshotOraclev10g.getAction())) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, snapshotOraclev10g.getAction());
            } else {
                if (!"".equalsIgnoreCase(snapshotOraclev10g.getStartDate())) {
                    SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "START DATE");
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, snapshotOraclev10g.getStartDate());
                }
                if (!"".equalsIgnoreCase(snapshotOraclev10g.getNextDate())) {
                    SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "NEXT");
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, snapshotOraclev10g.getNextDate());
                }
            }
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "WITH");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, snapshotOraclev10g.getWith());
            if (snapshotOraclev10g.getUsingConstraint().equalsIgnoreCase("TRUSTED")) {
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, true, 2);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "USING");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "TRUSTED");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "CONSTRAINTS");
            } else if ("YES".equalsIgnoreCase(snapshotOraclev10g.getDefaultSegment())) {
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, true, 2);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "USING");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "DEFAULT");
                if (!"LOCAL".equalsIgnoreCase(snapshotOraclev10g.getSegmentType())) {
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, snapshotOraclev10g.getSegmentType());
                }
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "ROLLBACK");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "SEGMENT");
            } else if (snapshotOraclev10g.getRollbackSegment() != null) {
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, true, 2);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "USING");
                if (!"LOCAL".equalsIgnoreCase(snapshotOraclev10g.getSegmentType())) {
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, snapshotOraclev10g.getSegmentType());
                }
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "ROLLBACK");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "SEGMENT");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(snapshotOraclev10g.getRollbackSegment().getName()));
            }
        }
    }

    private void appendForUpdate(StringBuffer stringBuffer, SnapshotOracle snapshotOracle, boolean bl) {
        if ("YES".equalsIgnoreCase(snapshotOracle.getForUpdate())) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "FOR");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "UPDATE");
        }
    }

    private void appendQueryRewrite(StringBuffer stringBuffer, SnapshotOraclev10g snapshotOraclev10g, boolean bl) {
        if ("ENABLE".equalsIgnoreCase(snapshotOraclev10g.getQueryRewrite())) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "ENABLE");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "QUERY REWRITE");
        }
    }

    private void appendSubquery(StringBuffer stringBuffer, SnapshotOraclev10g snapshotOraclev10g, boolean bl) {
        SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
        SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "AS");
        SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, snapshotOraclev10g.getSubquery().trim());
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SnapshotOraclev10g;
    }

    private void appendLobStorage(StringBuffer stringBuffer, LobStorageOracle lobStorageOracle, boolean bl) {
        if (lobStorageOracle != null) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "LOB");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOracle.getColumn()));
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "STORE AS");
            if (lobStorageOracle.getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "SECUREFILE");
            } else if (lobStorageOracle.getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "BASICFILE");
            }
            if (!lobStorageOracle.getLobSegmentName().equalsIgnoreCase("")) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOracle.getLobSegmentName()));
            }
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            if (lobStorageOracle.getTableSpace() != null) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOracle.getTableSpace().getName()));
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            }
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "STORAGE");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 3);
            if (lobStorageOracle.getSCInitialExtent() > 0L) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCInitialExtent());
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 3);
            }
            if (lobStorageOracle.getSCNextExtent() > 0L) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCNextExtent());
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 3);
            }
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCPctIncrease());
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 3);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCMinExtents());
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 3);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCMaxExtents());
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 3);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCFreeLists());
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 3);
            if (lobStorageOracle.getSCFreelistGroups() > 1) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "FREELIST");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "GROUPS");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCFreelistGroups());
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 3);
            }
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, lobStorageOracle.getSCBufferPool());
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            if (lobStorageOracle.getChunk() > 0) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "CHUNK");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getChunk());
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            }
            if (lobStorageOracle.getOldVersions().equalsIgnoreCase("RETENTION")) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "RETENTION");
            } else {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "PCTVERSION");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getPCTVersion());
            }
            if (lobStorageOracle.getFreepools() > 0 && lobStorageOracle.getSCFreelistGroups() <= 1) {
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "FREEPOOLS");
                this.appendStringWithSpace(stringBuffer, lobStorageOracle.getFreepools());
            }
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            if ("ENABLE".equalsIgnoreCase(lobStorageOracle.getStorageInRow())) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "ENABLE");
            } else {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "DISABLE");
            }
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "STORAGE IN ROW");
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, lobStorageOracle.getCache());
            if (!"CACHE".equalsIgnoreCase(lobStorageOracle.getCache()) || lobStorageOracle.getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                if ("YES".equalsIgnoreCase(lobStorageOracle.getLogging())) {
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(lobStorageOracle.getLogging())) {
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
                } else if ("FILESYSTEM_LIKE_LOGGING".equalsIgnoreCase(lobStorageOracle.getLogging()) && lobStorageOracle.getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "FILESYSTEM_LIKE_LOGGING");
                }
            }
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendTableSpace(StringBuffer stringBuffer, SnapshotOraclev10g snapshotOraclev10g, boolean bl) {
        TableSpaceOracle tableSpaceOracle = snapshotOraclev10g.getTablespace();
        if (tableSpaceOracle != null && !"[NONE]".equalsIgnoreCase(tableSpaceOracle.getName())) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        } else if (snapshotOraclev10g.getSegment() != null && snapshotOraclev10g.getSegment().getTableSpace() != null) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(snapshotOraclev10g.getSegment().getTableSpace().getName()));
        }
    }

    private void appendAttributes(StringBuffer stringBuffer, SnapshotOraclev10g snapshotOraclev10g, boolean bl) {
        if ("YES".equalsIgnoreCase(snapshotOraclev10g.getLogging())) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
        } else if ("NO".equalsIgnoreCase(snapshotOraclev10g.getLogging())) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
        }
        if ("YES".equalsIgnoreCase(snapshotOraclev10g.getCache())) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "CACHE");
        } else if ("NO".equalsIgnoreCase(snapshotOraclev10g.getCache())) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "NOCACHE");
        }
    }

    private void appendCluster(StringBuffer stringBuffer, SnapshotOraclev10g snapshotOraclev10g, boolean bl) {
        ClusterOracle clusterOracle = snapshotOraclev10g.getCluster();
        if (clusterOracle != null) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "CLUSTER");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(clusterOracle.getLongName()));
            if (!"".equalsIgnoreCase(snapshotOraclev10g.getClusterColumns())) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev10g.getClusterColumns()));
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendPhysicalAttributes(StringBuffer stringBuffer, SegmentOracle segmentOracle, boolean bl) {
        if (segmentOracle != null && segmentOracle.isMarkedGenerate()) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "PCTFREE");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getPCTFree());
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "PCTUSED");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getPCTUsed());
            if (segmentOracle.getInitrans() > 1) {
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "INITRANS");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getInitrans());
            }
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "STORAGE");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            if (segmentOracle.getSCInitialExtent() > 0L) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getSCInitialExtent());
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            }
            if (segmentOracle.getSCNextExtent() > 0L) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getSCNextExtent());
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            }
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCPctIncrease());
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCMinExtents());
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, segmentOracle.getSCMaxExtents());
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCFreeLists());
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "FREELIST");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "GROUPS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCFreelistGroups());
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, segmentOracle.getSCBufferPool());
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendPartitioning(StringBuffer stringBuffer, SnapshotOraclev10g snapshotOraclev10g, boolean bl) {
        PartitionListOraclev10g partitionListOraclev10g = (PartitionListOraclev10g)snapshotOraclev10g.getPartitionList();
        if (partitionListOraclev10g != null) {
            String string = partitionListOraclev10g.getPartitionType();
            String string2 = partitionListOraclev10g.getSubpartitionType();
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            if ("RANGE".equalsIgnoreCase(string) || "COMPOSITE BY HASH".equalsIgnoreCase(string) || "COMPOSITE BY LIST".equalsIgnoreCase(string)) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "BY");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "RANGE");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev10g.getColumns()));
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
                if (string2.equalsIgnoreCase("HASH")) {
                    SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "BY");
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "HASH");
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev10g.getSubPartColumns()));
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
                    if ("NO".equals(partitionListOraclev10g.getUseSubpartStorageTemplate()) && (partitionListOraclev10g.getSubPartitionsQuantity() > 1 || !"".equals(partitionListOraclev10g.getSubPartitionsTableSpaces()))) {
                        SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                        SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                        this.appendStringWithSpace(stringBuffer, partitionListOraclev10g.getSubPartitionsQuantity());
                        if (!"".equals(partitionListOraclev10g.getSubPartitionsTableSpaces())) {
                            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev10g.getAllSubPartitionsTableSpaces()));
                            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
                        }
                    }
                } else if (string2.equalsIgnoreCase("LIST")) {
                    SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "BY");
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "LIST");
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev10g.getSubPartColumns()));
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
                boolean bl2 = !string2.equalsIgnoreCase("");
                this.appendPartitions(stringBuffer, partitionListOraclev10g, true, bl2, bl);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(string)) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "BY");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "HASH");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev10g.getColumns()));
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "PARTITIONS");
                this.appendStringWithSpace(stringBuffer, partitionListOraclev10g.getHashPQuantity());
                if (!"".equals(partitionListOraclev10g.getHashPTableSpaces())) {
                    SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev10g.getAllHashPTableSpaces()));
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
                if (!"".equals(partitionListOraclev10g.getIOTOverflowHashPTS())) {
                    SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "OVERFLOW");
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev10g.getAllIOTOverflowHashPTS()));
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(string)) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "BY");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "HASH");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev10g.getColumns()));
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
                this.appendHashPartitions(stringBuffer, partitionListOraclev10g, bl);
            } else if ("LIST".equalsIgnoreCase(string)) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "BY");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "LIST");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(snapshotOraclev10g.getColumns()));
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
                this.appendListPartitions(stringBuffer, partitionListOraclev10g, bl);
            }
        }
    }

    protected void appendPartStorage(StringBuffer stringBuffer, AbstractStorageObjectOracle abstractStorageObjectOracle, boolean bl) {
        TableSpaceOracle tableSpaceOracle = null;
        TableSpaceOracle tableSpaceOracle2 = null;
        String string = "";
        StorageObjectCollection storageObjectCollection = null;
        if (abstractStorageObjectOracle instanceof PartitionOraclev10g) {
            tableSpaceOracle = ((PartitionOraclev10g)abstractStorageObjectOracle).getTableSpace();
            string = ((PartitionOraclev10g)abstractStorageObjectOracle).getDataSegmentCompression();
            storageObjectCollection = ((PartitionOraclev10g)abstractStorageObjectOracle).getLobs();
        } else if (abstractStorageObjectOracle instanceof HashPartitionOraclev10g) {
            tableSpaceOracle = ((HashPartitionOraclev10g)abstractStorageObjectOracle).getTableSpace();
            tableSpaceOracle2 = ((HashPartitionOraclev10g)abstractStorageObjectOracle).getIotOverflowTablespace();
            storageObjectCollection = ((HashPartitionOraclev10g)abstractStorageObjectOracle).getLobs();
        } else if (abstractStorageObjectOracle instanceof ListStorageTemplatePartitionOraclev10g) {
            tableSpaceOracle = ((ListStorageTemplatePartitionOraclev10g)abstractStorageObjectOracle).getTablespace();
            string = ((ListStorageTemplatePartitionOraclev10g)abstractStorageObjectOracle).getDataSegmentCompression();
            storageObjectCollection = ((ListStorageTemplatePartitionOraclev10g)abstractStorageObjectOracle).getLobs();
        }
        if (tableSpaceOracle != null) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        }
        if (tableSpaceOracle2 != null) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "OVERFLOW");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle2.getName()));
        }
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            if (string.equalsIgnoreCase("NO")) {
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "NOCOMPRESS");
            } else if (string.equalsIgnoreCase("YES")) {
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
            }
        }
        if (storageObjectCollection != null) {
            Iterator iterator = storageObjectCollection.iterator();
            while (iterator.hasNext()) {
                AbstractStorageObjectOracle abstractStorageObjectOracle2;
                Object e = iterator.next();
                if (e instanceof LobStorageOraclev10g) {
                    abstractStorageObjectOracle2 = (LobStorageOraclev10g)e;
                    if (((LobStorageOracle)abstractStorageObjectOracle2).getTableSpace() == null && ((LobStorageOracle)abstractStorageObjectOracle2).getLobSegmentName().trim().equals("")) continue;
                    SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
                    this.appendLobPartitioningStorage(stringBuffer, abstractStorageObjectOracle2.getName(), ((LobStorageOracle)abstractStorageObjectOracle2).getColumn(), abstractStorageObjectOracle2, ((LobStorageOracle)abstractStorageObjectOracle2).getTableSpace(), bl);
                    continue;
                }
                if (!(e instanceof HashPartitionLobItemOraclev10g) || ((HashPartitionLobItemOracle)(abstractStorageObjectOracle2 = (HashPartitionLobItemOraclev10g)e)).getTableSpace() == null) continue;
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
                this.appendLobPartitioningStorage(stringBuffer, abstractStorageObjectOracle2.getName(), ((HashPartitionLobItemOracle)abstractStorageObjectOracle2).getLobColumn(), "", ((HashPartitionLobItemOracle)abstractStorageObjectOracle2).getTableSpace(), bl);
            }
        }
    }

    protected void appendListPartitions(StringBuffer stringBuffer, PartitionListOraclev10g partitionListOraclev10g, boolean bl) {
        SnapshotOracle snapshotOracle = partitionListOraclev10g.getSnapshot();
        Iterator iterator = snapshotOracle.getPartitions().iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            ListPartitionOraclev10g listPartitionOraclev10g = (ListPartitionOraclev10g)iterator.next();
            if (bl2) {
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                bl2 = false;
            } else {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ',');
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            }
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listPartitionOraclev10g.getName()));
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "VALUES");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
            if (!"".equalsIgnoreCase(listPartitionOraclev10g.getColumns())) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, listPartitionOraclev10g.getColumns());
            } else {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "DEFAULT");
            }
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
            if (listPartitionOraclev10g.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "NOCOMPRESS");
            } else if (listPartitionOraclev10g.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
            }
            if (listPartitionOraclev10g.getSegment() == null) {
                if (listPartitionOraclev10g.getTablespace() != null) {
                    SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listPartitionOraclev10g.getTablespace().getName()));
                }
                if (this.storageDesign.isOpen()) {
                    if (listPartitionOraclev10g.getLogging().equalsIgnoreCase("YES")) {
                        SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                        SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                    } else if (listPartitionOraclev10g.getLogging().equalsIgnoreCase("NO")) {
                        SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                        SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
                    }
                }
            }
            Iterator iterator2 = listPartitionOraclev10g.getLobStorages().iterator();
            while (iterator2.hasNext()) {
                LobStorageOracle lobStorageOracle = (LobStorageOracle)iterator2.next();
                this.appendLobStorage(stringBuffer, lobStorageOracle, bl);
            }
            if (partitionListOraclev10g.getSubpartitionType().length() <= 0) continue;
            this.appendSubPartitions(stringBuffer, listPartitionOraclev10g, partitionListOraclev10g, bl);
        }
        if (!bl2) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendPartitions(StringBuffer stringBuffer, PartitionListOraclev10g partitionListOraclev10g, boolean bl, boolean bl2, boolean bl3) {
        StorageObjectCollection storageObjectCollection = partitionListOraclev10g.getSnapshot().getPartitionsCollection();
        if (storageObjectCollection.size() > 0) {
            Object[] objectArray = storageObjectCollection.toArray();
            Arrays.sort(objectArray, new PossitionComparator());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                arrayList.add(objectArray[i]);
            }
            Iterator iterator = arrayList.iterator();
            boolean bl4 = true;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof PartitionOracle)) continue;
                PartitionOracle partitionOracle = (PartitionOracle)e;
                if (bl4) {
                    SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl3, 1);
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    bl4 = false;
                } else {
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ',');
                }
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl3, 1);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOracle.getName()));
                if (bl) {
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, partitionOracle.getValueList());
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
                this.appendPhysicalAttributes(stringBuffer, partitionOracle.getSegment(), bl3);
                Iterator iterator2 = partitionOracle.getLobs().iterator();
                while (iterator2.hasNext()) {
                    LobStorageOracle lobStorageOracle = (LobStorageOracle)iterator2.next();
                    this.appendLobStorage(stringBuffer, lobStorageOracle, bl3);
                }
                if (!bl2) continue;
                this.appendSubPartitions(stringBuffer, partitionOracle, partitionListOraclev10g, bl3);
            }
            if (!bl4) {
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl3, 1);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    protected void appendSubPartitions(StringBuffer stringBuffer, AbstractStorageObjectOracle abstractStorageObjectOracle, PartitionListOraclev10g partitionListOraclev10g, boolean bl) {
        if (partitionListOraclev10g.getSubpartitionType().equalsIgnoreCase("HASH")) {
            PartitionOraclev10g partitionOraclev10g;
            if (abstractStorageObjectOracle instanceof PartitionOraclev10g && !this.appendHashSubPartitions(stringBuffer, (partitionOraclev10g = (PartitionOraclev10g)abstractStorageObjectOracle).getPartitions(), partitionListOraclev10g, bl) && partitionOraclev10g.getSubPartitionsQuantity() > 0) {
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                this.appendStringWithSpace(stringBuffer, partitionOraclev10g.getSubPartitionsQuantity());
                if (!"".equalsIgnoreCase(partitionOraclev10g.getSubPartitionsTableSpaces())) {
                    SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionOraclev10g.getAllSubPartitionsTableSpaces()));
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
            }
        } else if (partitionListOraclev10g.getSubpartitionType().equalsIgnoreCase("LIST") && abstractStorageObjectOracle instanceof PartitionOraclev10g) {
            this.appendListSubPartitions(stringBuffer, ((PartitionOraclev10g)abstractStorageObjectOracle).getListPartitions(), bl);
        }
    }

    protected void appendListSubPartitions(StringBuffer stringBuffer, StorageObjectCollection storageObjectCollection, boolean bl) {
        if (storageObjectCollection.size() > 0) {
            boolean bl2 = true;
            Iterator iterator = storageObjectCollection.iterator();
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
            while (iterator.hasNext()) {
                ListStorageTemplatePartitionOraclev10g listStorageTemplatePartitionOraclev10g = (ListStorageTemplatePartitionOraclev10g)iterator.next();
                if (!bl2) {
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ',');
                } else {
                    bl2 = false;
                }
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listStorageTemplatePartitionOraclev10g.getName()));
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "VALUES");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, listStorageTemplatePartitionOraclev10g.getValueList());
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
                this.appendPartStorage(stringBuffer, listStorageTemplatePartitionOraclev10g, bl);
            }
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected boolean appendHashSubPartitions(StringBuffer stringBuffer, StorageObjectCollection storageObjectCollection, PartitionListOraclev10g partitionListOraclev10g, boolean bl) {
        boolean bl2 = false;
        if (partitionListOraclev10g.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
            Iterator iterator = storageObjectCollection.iterator();
            boolean bl3 = true;
            while (iterator.hasNext()) {
                HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)iterator.next();
                if (bl3) {
                    SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    bl3 = false;
                    bl2 = true;
                } else {
                    this.appendComma(stringBuffer);
                    SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                }
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOracle.getName()));
                if (hashPartitionOracle.getTableSpace() == null) continue;
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOracle.getTableSpace().getName()));
                Iterator iterator2 = hashPartitionOracle.getLobItems().iterator();
                while (iterator2.hasNext()) {
                    HashPartitionLobItemOracle hashPartitionLobItemOracle = (HashPartitionLobItemOracle)iterator2.next();
                    SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "LOB");
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    this.appendStringWithSpace(stringBuffer, hashPartitionLobItemOracle);
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
                    if (hashPartitionLobItemOracle.getTableSpace() == null) continue;
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "STORE AS");
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionLobItemOracle.getTableSpace().getName()));
                    SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
                }
            }
            if (!bl3) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        }
        return bl2;
    }

    protected boolean appendHashPartitions(StringBuffer stringBuffer, PartitionListOracle partitionListOracle, boolean bl) {
        boolean bl2 = false;
        SnapshotOracle snapshotOracle = partitionListOracle.getSnapshot();
        Iterator iterator = snapshotOracle.getPartitions().iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)iterator.next();
            if (bl3) {
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
                bl3 = false;
                bl2 = true;
            } else {
                this.appendComma(stringBuffer);
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            }
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOracle.getName()));
            if (hashPartitionOracle.getTableSpace() != null) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOracle.getTableSpace().getName()));
            }
            this.appendHashPLobItems(stringBuffer, hashPartitionOracle, bl);
        }
        if (!bl3) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
        return bl2;
    }

    private void appendHashPLobItems(StringBuffer stringBuffer, HashPartitionOracle hashPartitionOracle, boolean bl) {
        HashPartitionLobItemSetOracle hashPartitionLobItemSetOracle = ((StorageDesignOracle)hashPartitionOracle.getStorageDesign()).getHashPartitionLobItemSet();
        Iterator iterator = hashPartitionLobItemSetOracle.iterator();
        while (iterator.hasNext()) {
            HashPartitionLobItemOracle hashPartitionLobItemOracle = (HashPartitionLobItemOracle)iterator.next();
            if (hashPartitionLobItemOracle.getHashPartition() == null || !hashPartitionLobItemOracle.getHashPartition().toString().equalsIgnoreCase(hashPartitionOracle.toString())) continue;
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 2);
            this.appendLobPartitioningStorage(stringBuffer, hashPartitionLobItemOracle.getName(), hashPartitionLobItemOracle.getLobColumn(), "", hashPartitionLobItemOracle.getTableSpace(), bl);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer stringBuffer, String string, Object object, Object object2, TableSpaceOracle tableSpaceOracle, boolean bl) {
        SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "LOB");
        SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
        String string2 = "";
        if (object != null) {
            string2 = object.toString();
        }
        if (string2.length() > 0) {
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
        } else {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("--  ERROR: Lob ");
            stringBuffer.append(string);
            stringBuffer.append(" has no Column specified");
            DDLFileMaker.incrementErrors();
        }
        SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
        SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "STORE AS");
        if (object2 instanceof LobStorageOraclev11g) {
            if (((LobStorageOraclev11g)object2).getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "SECUREFILE");
            } else if (((LobStorageOraclev11g)object2).getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "BASICFILE");
            }
        }
        String string3 = "";
        if (object2 instanceof LobStorageOraclev10g) {
            string3 = ((LobStorageOraclev10g)object2).getLobSegmentName();
        }
        if (!string3.equalsIgnoreCase("")) {
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string3));
        } else if (tableSpaceOracle == null) {
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
        }
        if (tableSpaceOracle != null) {
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendPermissions(StringBuffer stringBuffer, SnapshotOraclev10g snapshotOraclev10g, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        PermissionsSetOracle permissionsSetOracle = ((StorageDesignOracle)snapshotOraclev10g.getStorageDesign()).getPermissionsSet();
        Iterator iterator = permissionsSetOracle.iterator();
        while (iterator.hasNext()) {
            PermissionsOraclev10g permissionsOraclev10g = (PermissionsOraclev10g)iterator.next();
            if (permissionsOraclev10g.getSnapshot() != null && permissionsOraclev10g.getSnapshot().equals(snapshotOraclev10g) && !permissionsOraclev10g.getPrivileges().equalsIgnoreCase("")) {
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 0);
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, permissionsOraclev10g);
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer2, "GRANT");
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer2, permissionsOraclev10g.getPrivileges());
                this.appendObject(stringBuffer2, permissionsOraclev10g, bl);
                this.appendTo(stringBuffer2, permissionsOraclev10g);
                string = stringBuffer2.toString();
                this.appendHierrarchyOption(stringBuffer2, permissionsOraclev10g);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                stringBuffer2.append(';');
                SSBSnapshotOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
            if (permissionsOraclev10g.getSnapshot() == null || !permissionsOraclev10g.getSnapshot().equals(snapshotOraclev10g) || permissionsOraclev10g.getPrivilegesWithGrantOption().equalsIgnoreCase("")) continue;
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 0);
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 0);
            this.appendComment(stringBuffer, permissionsOraclev10g);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer2, "GRANT");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer2, permissionsOraclev10g.getPrivilegesWithGrantOption());
            this.appendObject(stringBuffer2, permissionsOraclev10g, bl);
            this.appendTo(stringBuffer2, permissionsOraclev10g);
            string = stringBuffer2.toString();
            this.appendHierrarchyOption(stringBuffer2, permissionsOraclev10g);
            this.appendGrantOption(stringBuffer2, permissionsOraclev10g);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            stringBuffer2.append(';');
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
    }

    private void appendObject(StringBuffer stringBuffer, PermissionsOraclev10g permissionsOraclev10g, boolean bl) {
        if (permissionsOraclev10g.getSnapshot() != null) {
            SSBSnapshotOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "ON");
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getSnapshot().getLongName()));
        }
    }

    private void appendTo(StringBuffer stringBuffer, PermissionsOraclev10g permissionsOraclev10g) {
        SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "TO");
        if ("YES".equalsIgnoreCase(permissionsOraclev10g.getPublic())) {
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "PUBLIC");
        } else {
            if (permissionsOraclev10g.getUser() != null) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getUser().getName()));
            }
            if (permissionsOraclev10g.getRole() != null) {
                SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev10g.getRole().getName()));
            }
        }
    }

    private void appendGrantOption(StringBuffer stringBuffer, PermissionsOraclev10g permissionsOraclev10g) {
        if (permissionsOraclev10g.getRole() == null) {
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer stringBuffer, PermissionsOraclev10g permissionsOraclev10g) {
        if ("YES".equalsIgnoreCase(permissionsOraclev10g.getHierarchyOption())) {
            stringBuffer.append(NEWLINE);
            SSBSnapshotOraclev10g.appendStringWithSpace(stringBuffer, "WITH HIERARCHY OPTION");
        }
    }

    public SSBTableOraclev10g getSSBTableOraclev10g() {
        return this.sSBTableOraclev10g;
    }

    public void setSSBTableOraclev10g(SSBTableOraclev10g sSBTableOraclev10g) {
        this.sSBTableOraclev10g = sSBTableOraclev10g;
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (((PartitionOracle)object).getPosition() > ((PartitionOracle)object2).getPosition()) {
                return 1;
            }
            if (((PartitionOracle)object).getPosition() < ((PartitionOracle)object2).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

