/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionLobItemOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionLobItemSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexOraclev10g
extends AbstractSSBOracle {
    protected StorageDesignOraclev10g storageDesign;
    private Object sType;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && !(object instanceof FKProxyOracle) && ((Index)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof IndexProxy && !(object instanceof FKProxyOracle) && ((IndexProxy)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Object object2;
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        Index index = null;
        IndexProxyOraclev10g indexProxyOraclev10g = null;
        if (object instanceof Index) {
            index = (Index)object;
            object2 = (StorageDesignOraclev10g)this.getStorageDesign(object);
            indexProxyOraclev10g = (IndexProxyOraclev10g)((StorageDesignOraclev10g)object2).getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxyOraclev10g) {
            indexProxyOraclev10g = (IndexProxyOraclev10g)object;
            index = (Index)indexProxyOraclev10g.getObject();
        }
        if (index != null && !index.isOidKey() && indexProxyOraclev10g != null) {
            this.storageDesign = (StorageDesignOraclev10g)indexProxyOraclev10g.getStorageDesign();
            if (index.getElements().length > 0 || index.hasIndexExpression()) {
                if (indexProxyOraclev10g.isMarkedGenerate()) {
                    if (indexProxyOraclev10g.isCommentChanged()) {
                        this.appendComment(stringBuffer, indexProxyOraclev10g);
                    } else {
                        this.appendComment(stringBuffer, index);
                    }
                    object2 = indexProxyOraclev10g.getName();
                    if (((String)object2).length() > indexProxyOraclev10g.getMaxNameLength()) {
                        SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 0);
                        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "--  ERROR: Index name length exceeds maximum allowed length(" + indexProxyOraclev10g.getMaxNameLength() + ")");
                        SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer2, "CREATE");
                    if (indexProxyOraclev10g.isUnique()) {
                        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer2, "UNIQUE");
                    } else if (indexProxyOraclev10g.getBitmapIndex()) {
                        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer2, "BITMAP");
                    }
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer2, "INDEX");
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(indexProxyOraclev10g.getUserNameAndName()));
                    string = stringBuffer2.toString();
                    this.appendTable(stringBuffer2, indexProxyOraclev10g);
                    this.appendElementList(stringBuffer2, index, indexProxyOraclev10g, true);
                    if (!index.isSpatialIndex() && indexProxyOraclev10g.getIndexType().equals("")) {
                        this.appendGlobalOrLocal(stringBuffer2, indexProxyOraclev10g, bl);
                        this.appendIndexAttributes(stringBuffer2, indexProxyOraclev10g, bl);
                    }
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    SSBIndexOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                    this.appendLineFinisher(stringBuffer2, bl);
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    DDLFileMaker.incrementCreateIndex();
                }
            } else {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 0);
                stringBuffer.append("-- Error - Index ");
                stringBuffer.append(this.storageDesign.getFormatedName(index.getName()));
                stringBuffer.append(" has no columns");
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 0);
                DDLFileMaker.incrementErrors();
            }
        }
    }

    private void appendTable(StringBuffer stringBuffer, IndexProxy indexProxy) {
        TableProxy tableProxy = indexProxy.getTableProxy();
        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "ON");
        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
    }

    private void appendElementList(StringBuffer stringBuffer, Index index, IndexProxyOraclev10g indexProxyOraclev10g, boolean bl) {
        if (index.hasIndexExpression()) {
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOraclev10g.appendString(stringBuffer, ' ');
            SSBIndexOraclev10g.appendString(stringBuffer, index.getIndexExpression());
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        } else {
            ColumnProxy columnProxy = null;
            ColumnProxy[] columnProxyArray = indexProxyOraclev10g.getColumnProxies();
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            if (columnProxyArray.length < 1) {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "-- No Columns");
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            }
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            for (int i = 0; i < columnProxyArray.length; ++i) {
                if (i != 0) {
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ',');
                }
                columnProxy = columnProxyArray[i];
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBIndexOraclev10g.appendString(stringBuffer, ' ');
                String string = this.storageDesign.getFormatedName(columnProxy.getName());
                if (index.isSpatialIndex()) {
                    Datatype datatype = columnProxy.getDataType();
                    if (this.sType == null) {
                        this.sType = columnProxy.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName("SDO_GEOMETRY");
                    }
                    if (datatype instanceof StructuredType) {
                        StructuredType structuredType = (StructuredType)datatype;
                        for (TypeElement typeElement : structuredType.getAllElements()) {
                            if (typeElement.getType() != this.sType) continue;
                            string = string.concat(".").concat(this.storageDesign.getFormatedName(typeElement.getName()));
                            break;
                        }
                    }
                }
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, string);
                if (index.isSpatialIndex() || !indexProxyOraclev10g.getIndexType().equals("")) continue;
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, index.getColumnSortOrder(columnProxy));
            }
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
        if (indexProxyOraclev10g != null) {
            if (index.isSpatialIndex()) {
                this.appendSpatialIndex(stringBuffer, index, indexProxyOraclev10g, bl);
            } else {
                this.appendDomainIndexProps(stringBuffer, index, indexProxyOraclev10g, bl);
            }
        }
    }

    private void appendDomainIndexProps(StringBuffer stringBuffer, Index index, IndexProxyOracle indexProxyOracle, boolean bl) {
        String string;
        if (!index.isSpatialIndex() && !(string = indexProxyOracle.getIndexType()).equals("")) {
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "INDEXTYPE");
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "IS");
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
            String string2 = indexProxyOracle.getIndexDomainParameters();
            if (!string2.equals("")) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARAMETERS");
                SSBIndexOraclev10g.appendString(stringBuffer, '(');
                SSBIndexOraclev10g.appendString(stringBuffer, '\'');
                SSBIndexOraclev10g.appendString(stringBuffer, string2);
                SSBIndexOraclev10g.appendString(stringBuffer, '\'');
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendSpatialIndex(StringBuffer stringBuffer, Index index, IndexProxyOraclev10g indexProxyOraclev10g, boolean bl) {
        if (index.isSpatialIndex()) {
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "INDEXTYPE");
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "IS");
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "MDSYS.SPATIAL_INDEX");
            if (!index.getGeodetic().equals("YES") || index.getLayerType() != null && !index.getLayerType().equals("") || index.getDimensionsNumber() != 2 || indexProxyOraclev10g.getNonLeaf().equalsIgnoreCase("YES") || indexProxyOraclev10g.getTableSpace() != null || indexProxyOraclev10g.getBatchSize() != 1000 || indexProxyOraclev10g.getWorkTablespace() != null) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARAMETERS");
                SSBIndexOraclev10g.appendString(stringBuffer, '(');
                SSBIndexOraclev10g.appendString(stringBuffer, '\'');
                if (!index.getGeodetic().equals("YES")) {
                    SSBIndexOraclev10g.appendString(stringBuffer, "geodetic");
                    SSBIndexOraclev10g.appendString(stringBuffer, '=');
                    this.appendString(stringBuffer, Boolean.FALSE);
                }
                if (index.getLayerType() != null && !index.getLayerType().equals("")) {
                    SSBIndexOraclev10g.appendSpace(stringBuffer);
                    SSBIndexOraclev10g.appendString(stringBuffer, "layer_gtype");
                    SSBIndexOraclev10g.appendString(stringBuffer, '=');
                    SSBIndexOraclev10g.appendString(stringBuffer, index.getLayerType());
                }
                if (index.getDimensionsNumber() != 2) {
                    SSBIndexOraclev10g.appendSpace(stringBuffer);
                    SSBIndexOraclev10g.appendString(stringBuffer, "sdo_indx_dims");
                    SSBIndexOraclev10g.appendString(stringBuffer, '=');
                    this.appendString(stringBuffer, index.getDimensionsNumber());
                }
                if (indexProxyOraclev10g.getBatchSize() != 1000) {
                    SSBIndexOraclev10g.appendSpace(stringBuffer);
                    SSBIndexOraclev10g.appendString(stringBuffer, "sdo_dml_batch_size=");
                    this.appendString(stringBuffer, indexProxyOraclev10g.getBatchSize());
                }
                if (indexProxyOraclev10g.getTableSpace() != null) {
                    SSBIndexOraclev10g.appendSpace(stringBuffer);
                    SSBIndexOraclev10g.appendString(stringBuffer, "tablespace=");
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyOraclev10g.getTableSpace().getName()));
                }
                if (indexProxyOraclev10g.getWorkTablespace() != null) {
                    SSBIndexOraclev10g.appendSpace(stringBuffer);
                    SSBIndexOraclev10g.appendString(stringBuffer, "work_tablespace=");
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyOraclev10g.getWorkTablespace().getName()));
                }
                if (indexProxyOraclev10g.getNonLeaf().equalsIgnoreCase("YES")) {
                    SSBIndexOraclev10g.appendSpace(stringBuffer);
                    SSBIndexOraclev10g.appendString(stringBuffer, "sdo_non_leaf_tbl=TRUE");
                }
                SSBIndexOraclev10g.appendString(stringBuffer, '\'');
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
            this.appendSpatialIndexPartitions(stringBuffer, indexProxyOraclev10g, bl);
        }
    }

    private void appendSpatialIndexPartitions(StringBuffer stringBuffer, IndexProxyOraclev10g indexProxyOraclev10g, boolean bl) {
        if ("LOCAL".equalsIgnoreCase(indexProxyOraclev10g.getIndexPartitioned())) {
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOCAL");
            TableProxyOraclev10g tableProxyOraclev10g = (TableProxyOraclev10g)indexProxyOraclev10g.getTableProxy();
            PartitionListOraclev10g partitionListOraclev10g = (PartitionListOraclev10g)tableProxyOraclev10g.getPartitionList();
            if (partitionListOraclev10g != null) {
                this.appendSpatialPartitions(stringBuffer, indexProxyOraclev10g, partitionListOraclev10g, bl);
            }
        }
    }

    private void appendSpatialPartitions(StringBuffer stringBuffer, IndexProxyOraclev10g indexProxyOraclev10g, PartitionListOraclev10g partitionListOraclev10g, boolean bl) {
        PartitionSetOraclev10g partitionSetOraclev10g = (PartitionSetOraclev10g)((StorageDesignOraclev10g)partitionListOraclev10g.getStorageDesign()).getPartitionSet();
        Object[] objectArray = partitionSetOraclev10g.toArray();
        Arrays.sort(objectArray, new PossitionComparator());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        Iterator iterator = arrayList.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            SegmentOraclev10g segmentOraclev10g;
            PartitionOraclev10g partitionOraclev10g = (PartitionOraclev10g)iterator.next();
            if (partitionOraclev10g.getPartitionList() == null || !partitionOraclev10g.getPartitionList().getObjectID().equalsIgnoreCase(partitionListOraclev10g.getObjectID())) continue;
            if (bl2) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                bl2 = false;
            } else {
                stringBuffer.append(',');
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            }
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            LocalIndexProperties localIndexProperties = this.getPropsForIndex((IndexProxyOracle)indexProxyOraclev10g, partitionOraclev10g);
            if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
            } else {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOraclev10g.getName()));
            }
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARAMETERS");
            SSBIndexOraclev10g.appendString(stringBuffer, '(');
            SSBIndexOraclev10g.appendString(stringBuffer, '\'');
            if (localIndexProperties.getTableSpace() != null) {
                SSBIndexOraclev10g.appendString(stringBuffer, "tablespace=");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getTableSpace().getName()));
            }
            if ((segmentOraclev10g = (SegmentOraclev10g)localIndexProperties.getSegment()) != null && segmentOraclev10g.isMarkedGenerate()) {
                SSBIndexOraclev10g.appendSpace(stringBuffer);
                SSBIndexOraclev10g.appendString(stringBuffer, "sdo_rdr_pctfree=");
                SSBIndexOraclev10g.appendString(stringBuffer, String.valueOf(segmentOraclev10g.getPCTFree()).trim());
                if (segmentOraclev10g.getSCInitialExtent() > 0L) {
                    SSBIndexOraclev10g.appendSpace(stringBuffer);
                    SSBIndexOraclev10g.appendString(stringBuffer, "initial=");
                    SSBIndexOraclev10g.appendString(stringBuffer, String.valueOf(segmentOraclev10g.getSCInitialExtent()).trim());
                }
                if (segmentOraclev10g.getSCNextExtent() > 0L) {
                    SSBIndexOraclev10g.appendSpace(stringBuffer);
                    SSBIndexOraclev10g.appendString(stringBuffer, "next=");
                    SSBIndexOraclev10g.appendString(stringBuffer, String.valueOf(segmentOraclev10g.getSCNextExtent()).trim());
                }
                SSBIndexOraclev10g.appendSpace(stringBuffer);
                SSBIndexOraclev10g.appendString(stringBuffer, "pctincrease=");
                this.appendString(stringBuffer, segmentOraclev10g.getSCPctIncrease());
                SSBIndexOraclev10g.appendSpace(stringBuffer);
                SSBIndexOraclev10g.appendString(stringBuffer, "minextents=");
                this.appendString(stringBuffer, segmentOraclev10g.getSCMinExtents());
                SSBIndexOraclev10g.appendSpace(stringBuffer);
                SSBIndexOraclev10g.appendString(stringBuffer, "maxextents=");
                SSBIndexOraclev10g.appendString(stringBuffer, segmentOraclev10g.getSCMaxExtents());
            }
            if (localIndexProperties.getWorkTablespace() != null) {
                SSBIndexOraclev10g.appendSpace(stringBuffer);
                SSBIndexOraclev10g.appendString(stringBuffer, "work_tablespace=");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getWorkTablespace().getName()));
            }
            if (localIndexProperties.getLayerType() != null && !localIndexProperties.getLayerType().equals("")) {
                SSBIndexOraclev10g.appendSpace(stringBuffer);
                SSBIndexOraclev10g.appendString(stringBuffer, "layer_gtype=");
                SSBIndexOraclev10g.appendString(stringBuffer, localIndexProperties.getLayerType());
            }
            if (indexProxyOraclev10g.getNonLeaf().equalsIgnoreCase("YES")) {
                SSBIndexOraclev10g.appendSpace(stringBuffer);
                SSBIndexOraclev10g.appendString(stringBuffer, "sdo_non_leaf_tbl=TRUE");
            }
            SSBIndexOraclev10g.appendString(stringBuffer, '\'');
            SSBIndexOraclev10g.appendString(stringBuffer, ')');
        }
        if (!bl2) {
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOraclev10g.appendString(stringBuffer, ')');
        }
    }

    private void appendGlobalOrLocal(StringBuffer stringBuffer, IndexProxyOraclev10g indexProxyOraclev10g, boolean bl) {
        String string = indexProxyOraclev10g.getIndexPartitioned();
        if ("LOCAL".equalsIgnoreCase(string)) {
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOCAL");
            this.appendPartitionList(stringBuffer, indexProxyOraclev10g, (TableProxyOraclev10g)indexProxyOraclev10g.getTableProxy(), bl);
        } else {
            IndexGlobalPartitionsListOraclev10g indexGlobalPartitionsListOraclev10g = (IndexGlobalPartitionsListOraclev10g)indexProxyOraclev10g.getIndexGlobalPartitionsList();
            if (indexGlobalPartitionsListOraclev10g != null) {
                String string2 = "";
                if ("GLOBAL BY RANGE".equalsIgnoreCase(string)) {
                    string2 = "RANGE";
                } else if ("GLOBAL HASH PARTITIONED BY QUANTITY".equalsIgnoreCase(string) || "GLOBAL HASH PARTITIONED BY LIST".equalsIgnoreCase(string)) {
                    string2 = "HASH";
                } else {
                    return;
                }
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "GLOBAL");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "BY");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, string2);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllGlobalPartColumns()));
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
                if ("GLOBAL BY RANGE".equalsIgnoreCase(string)) {
                    this.appendGlobalRangePartitions(stringBuffer, indexProxyOraclev10g, bl);
                } else if ("GLOBAL HASH PARTITIONED BY QUANTITY".equalsIgnoreCase(string)) {
                    SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITIONS");
                    this.appendStringWithSpace(stringBuffer, indexGlobalPartitionsListOraclev10g.getHashPQuantity());
                    if (!"".equals(indexGlobalPartitionsListOraclev10g.getHashPTableSpaces())) {
                        SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllHashPTS()));
                        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
                    }
                    if (!"".equals(indexGlobalPartitionsListOraclev10g.getIOTOverflowHashPTS())) {
                        SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "OVERFLOW");
                        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(indexGlobalPartitionsListOraclev10g.getAllIOTOverflowHashPTS()));
                        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
                    }
                } else if ("GLOBAL HASH PARTITIONED BY LIST".equalsIgnoreCase(string)) {
                    this.appendGlobalHashPartitions(stringBuffer, indexProxyOraclev10g, bl);
                }
            }
        }
    }

    private void appendGlobalRangePartitions(StringBuffer stringBuffer, IndexProxyOraclev10g indexProxyOraclev10g, boolean bl) {
        Iterator iterator = indexProxyOraclev10g.getGlobalPartitions().iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            IndexGlobalPartitionOraclev10g indexGlobalPartitionOraclev10g = (IndexGlobalPartitionOraclev10g)iterator.next();
            if (bl2) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                bl2 = false;
            } else {
                stringBuffer.append(',');
            }
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexGlobalPartitionOraclev10g.getName()));
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, indexGlobalPartitionOraclev10g.getValueList());
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            if (indexGlobalPartitionOraclev10g.getTableSpace() != null) {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexGlobalPartitionOraclev10g.getTableSpace().getName()));
            }
            this.appendSegment(stringBuffer, (SegmentOraclev10g)indexGlobalPartitionOraclev10g.getSegment(), bl, 2);
            if (!this.storageDesign.isOpen()) continue;
            if ("YES".equalsIgnoreCase(indexGlobalPartitionOraclev10g.getLogging())) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(indexGlobalPartitionOraclev10g.getLogging())) continue;
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
        }
        if (!bl2) {
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendGlobalHashPartitions(StringBuffer stringBuffer, IndexProxyOraclev10g indexProxyOraclev10g, boolean bl) {
        Iterator iterator = indexProxyOraclev10g.getGlobalPartitions().iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            IndexHashPartitionOraclev10g indexHashPartitionOraclev10g = (IndexHashPartitionOraclev10g)iterator.next();
            if (bl2) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                bl2 = false;
            } else {
                stringBuffer.append(',');
            }
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexHashPartitionOraclev10g.getName()));
            if (indexHashPartitionOraclev10g.getTableSpace() != null) {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexHashPartitionOraclev10g.getTableSpace().getName()));
            }
            if (indexHashPartitionOraclev10g.getOverflowTableSpace() != null) {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "OVERFLOW");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexHashPartitionOraclev10g.getOverflowTableSpace().getName()));
            }
            this.appendHashPLobItems(stringBuffer, indexHashPartitionOraclev10g, bl);
        }
        if (!bl2) {
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendHashPLobItems(StringBuffer stringBuffer, IndexHashPartitionOraclev10g indexHashPartitionOraclev10g, boolean bl) {
        IndexHashPartitionLobItemSetOraclev10g indexHashPartitionLobItemSetOraclev10g = (IndexHashPartitionLobItemSetOraclev10g)((StorageDesignOraclev10g)indexHashPartitionOraclev10g.getStorageDesign()).getIndexHashPartitionLobItemSet();
        Iterator iterator = indexHashPartitionLobItemSetOraclev10g.iterator();
        while (iterator.hasNext()) {
            IndexHashPartitionLobItemOraclev10g indexHashPartitionLobItemOraclev10g = (IndexHashPartitionLobItemOraclev10g)iterator.next();
            if (indexHashPartitionLobItemOraclev10g.getIndexHashPartition() == null || !indexHashPartitionLobItemOraclev10g.getIndexHashPartition().getObjectID().equalsIgnoreCase(indexHashPartitionOraclev10g.getObjectID())) continue;
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            this.appendLobPartitioningStorage(stringBuffer, indexHashPartitionLobItemOraclev10g.getName(), indexHashPartitionLobItemOraclev10g.getLobColumn(), "", indexHashPartitionLobItemOraclev10g.getTableSpace(), bl);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer stringBuffer, String string, Object object, String string2, TableSpaceOracle tableSpaceOracle, boolean bl) {
        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOB");
        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
        String string3 = "";
        if (object != null) {
            string3 = object.toString();
        }
        if (string3.length() > 0) {
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string3));
        } else {
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("--  ERROR: Lob ");
            stringBuffer.append(string);
            stringBuffer.append(" has no Column specified");
            DDLFileMaker.incrementErrors();
        }
        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORE AS");
        if (!string2.equalsIgnoreCase("")) {
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
        } else if (tableSpaceOracle == null) {
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
        }
        if (tableSpaceOracle != null) {
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendSegment(StringBuffer stringBuffer, SegmentOraclev10g segmentOraclev10g, boolean bl, int n) {
        if (segmentOraclev10g != null && segmentOraclev10g.isMarkedGenerate()) {
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PCTFREE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getPCTFree());
            if (segmentOraclev10g.getInitrans() > 2) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "INITRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getInitrans());
            }
            if (segmentOraclev10g.getMaxTrans() > 2) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "MAXTRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getMaxTrans());
            }
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORAGE");
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n + 1);
            if (segmentOraclev10g.getSCInitialExtent() > 0L) {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCInitialExtent());
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n + 1);
            }
            if (segmentOraclev10g.getSCNextExtent() > 0L) {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCNextExtent());
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n + 1);
            }
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCPctIncrease());
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n + 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCMinExtents());
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n + 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCMaxExtents());
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n + 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCFreeLists());
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n + 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "FREELIST");
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "GROUPS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCFreelistGroups());
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, n + 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, segmentOraclev10g.getSCBufferPool());
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendIndexAttributes(StringBuffer stringBuffer, IndexProxyOraclev10g indexProxyOraclev10g, boolean bl) {
        TableProxyOracle tableProxyOracle = (TableProxyOracle)indexProxyOraclev10g.getTableProxy();
        boolean bl2 = tableProxyOracle.getTemporary().equalsIgnoreCase("YES");
        if (!bl2) {
            if (indexProxyOraclev10g.getTableSpace() != null) {
                stringBuffer.append(NEWLINE).append("    ");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyOraclev10g.getTableSpace().getName()));
            }
            this.appendSegment(stringBuffer, (SegmentOraclev10g)indexProxyOraclev10g.getSegment(), bl, 1);
        }
        if (this.storageDesign.isOpen()) {
            if (!bl2) {
                if ("YES".equalsIgnoreCase(indexProxyOraclev10g.getLogging())) {
                    stringBuffer.append(NEWLINE).append("    ");
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(indexProxyOraclev10g.getLogging())) {
                    stringBuffer.append(NEWLINE).append("    ");
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
                }
            }
            if ("YES".equalsIgnoreCase(indexProxyOraclev10g.getOnline())) {
                stringBuffer.append(NEWLINE).append("    ");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "ONLINE");
            }
            if ("YES".equalsIgnoreCase(indexProxyOraclev10g.getComputeStatistics())) {
                stringBuffer.append(NEWLINE).append("    ");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPUTE STATISTICS");
            }
            if (indexProxyOraclev10g.getCompress() > 0) {
                stringBuffer.append(NEWLINE).append("    ");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
                this.appendStringWithSpace(stringBuffer, indexProxyOraclev10g.getCompress());
            }
            if (!indexProxyOraclev10g.getBitmapIndex() && !indexProxyOraclev10g.isPartitioned()) {
                if ("NO".equalsIgnoreCase(indexProxyOraclev10g.getSortedRows())) {
                    stringBuffer.append(NEWLINE).append("    ");
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOSORT");
                } else if ("REVERSE".equalsIgnoreCase(indexProxyOraclev10g.getSortedRows())) {
                    stringBuffer.append(NEWLINE).append("    ");
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "REVERSE");
                }
            }
            if (!bl2 && "YES".equalsIgnoreCase(indexProxyOraclev10g.getParallel())) {
                stringBuffer.append(NEWLINE).append("    ");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARALLEL");
                if (!"".equalsIgnoreCase(indexProxyOraclev10g.getDegree())) {
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, indexProxyOraclev10g.getDegree());
                }
            }
        }
    }

    public void appendPartitionList(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        PartitionListOraclev10g partitionListOraclev10g = (PartitionListOraclev10g)tableProxyOraclev10g.getPartitionList();
        if (partitionListOraclev10g != null) {
            boolean bl2;
            String string;
            String string2 = partitionListOraclev10g.getPartitionType();
            String string3 = partitionListOraclev10g.getSubpartitionType();
            if (string3.equalsIgnoreCase("HASH") && !"".equals((string = indexProxyOracle.getAllHashSubPartitionsTableSpaces()).trim())) {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(string));
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
            boolean bl3 = bl2 = !string3.equals("");
            if ("RANGE".equalsIgnoreCase(string2) || "COMPOSITE BY HASH".equalsIgnoreCase(string2) || "COMPOSITE BY LIST".equalsIgnoreCase(string2)) {
                this.appendPartitions(stringBuffer, indexProxyOracle, partitionListOraclev10g, bl2, bl);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(string2) || "HASH BY LIST OF PARTITIONS".equalsIgnoreCase(string2)) {
                this.appendHashPartitions(stringBuffer, partitionListOraclev10g, indexProxyOracle, bl);
            } else if ("LIST".equalsIgnoreCase(string2)) {
                this.appendListPartitions(stringBuffer, partitionListOraclev10g, indexProxyOracle, bl);
            }
        }
    }

    protected void appendListPartitions(StringBuffer stringBuffer, PartitionListOraclev10g partitionListOraclev10g, IndexProxyOracle indexProxyOracle, boolean bl) {
        TableProxyOracle tableProxyOracle = (TableProxyOracle)indexProxyOracle.getTableProxy();
        StorageObjectCollection storageObjectCollection = tableProxyOracle.getPartitions();
        Iterator iterator = storageObjectCollection.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            ListPartitionOraclev10g listPartitionOraclev10g = (ListPartitionOraclev10g)iterator.next();
            if (bl2) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                bl2 = false;
            } else {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ',');
            }
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            LocalIndexProperties localIndexProperties = this.getPropsForIndex(indexProxyOracle, listPartitionOraclev10g);
            if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
            } else {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listPartitionOraclev10g.getName()));
            }
            if (localIndexProperties == null) continue;
            TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)localIndexProperties.getTableSpace();
            String string = localIndexProperties.getLogging();
            SegmentOraclev10g segmentOraclev10g = (SegmentOraclev10g)localIndexProperties.getSegment();
            if (segmentOraclev10g != null) {
                this.appendSegment(stringBuffer, segmentOraclev10g, bl, 2);
            }
            if (tableSpaceOraclev10g != null) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOraclev10g.getName()));
            } else if (segmentOraclev10g != null && segmentOraclev10g.getTableSpace() != null) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(segmentOraclev10g.getTableSpace().getName()));
            }
            if ("YES".equalsIgnoreCase(string)) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
            } else if ("NO".equalsIgnoreCase(string)) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
            }
            if (localIndexProperties.getKeyCompression() > 0) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
                this.appendStringWithSpace(stringBuffer, localIndexProperties.getKeyCompression());
            }
            if (partitionListOraclev10g.getSubpartitionType().equals("")) continue;
            String string2 = this.recreateIndexHashPTSSet(localIndexProperties.getHashSubPartitionsTableSpaces());
            this.appendIndexSubPartitions(stringBuffer, indexProxyOracle, partitionListOraclev10g, listPartitionOraclev10g, string2, bl);
        }
        if (!bl2) {
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendHashPartitions(StringBuffer stringBuffer, PartitionListOraclev10g partitionListOraclev10g, IndexProxyOracle indexProxyOracle, boolean bl) {
        if (partitionListOraclev10g.getPartitionType().equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
            TableProxyOracle tableProxyOracle = (TableProxyOracle)indexProxyOracle.getTableProxy();
            StorageObjectCollection storageObjectCollection = tableProxyOracle.getPartitions();
            Iterator iterator = storageObjectCollection.iterator();
            boolean bl2 = true;
            while (iterator.hasNext()) {
                HashPartitionOraclev10g hashPartitionOraclev10g = (HashPartitionOraclev10g)iterator.next();
                if (bl2) {
                    SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                    bl2 = false;
                } else {
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ',');
                }
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
                LocalIndexProperties localIndexProperties = this.getPropsForIndex(indexProxyOracle, hashPartitionOraclev10g);
                if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
                } else {
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev10g.getName()));
                }
                if (localIndexProperties == null) continue;
                TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)localIndexProperties.getTableSpace();
                if (tableSpaceOraclev10g != null) {
                    SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOraclev10g.getName()));
                }
                if (localIndexProperties.getKeyCompression() <= 0 || !(this.storageDesign instanceof StorageDesignOraclev11g)) continue;
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
                this.appendStringWithSpace(stringBuffer, localIndexProperties.getKeyCompression());
            }
            if (!bl2) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        } else {
            String string = indexProxyOracle.getAllHashSubPartitionsTableSpaces();
            if (!"".equals(string.trim())) {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(string));
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendPartitions(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, PartitionListOraclev10g partitionListOraclev10g, boolean bl, boolean bl2) {
        TableProxyOracle tableProxyOracle = (TableProxyOracle)indexProxyOracle.getTableProxy();
        StorageObjectCollection storageObjectCollection = tableProxyOracle.getPartitions();
        Iterator iterator = storageObjectCollection.iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            PartitionOraclev10g partitionOraclev10g = (PartitionOraclev10g)iterator.next();
            if (bl3) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl2, 1);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                bl3 = false;
            } else {
                stringBuffer.append(',');
            }
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl2, 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "PARTITION");
            LocalIndexProperties localIndexProperties = this.getPropsForIndex(indexProxyOracle, partitionOraclev10g);
            if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
            } else {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOraclev10g.getName()));
            }
            if (localIndexProperties == null) continue;
            TableSpaceOracle tableSpaceOracle = localIndexProperties.getTableSpace();
            String string = localIndexProperties.getLogging();
            SegmentOraclev10g segmentOraclev10g = (SegmentOraclev10g)localIndexProperties.getSegment();
            if (segmentOraclev10g != null) {
                this.appendSegment(stringBuffer, segmentOraclev10g, bl2, 2);
            }
            if (tableSpaceOracle != null) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            } else if (segmentOraclev10g != null && segmentOraclev10g.getTableSpace() != null) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(segmentOraclev10g.getTableSpace().getName()));
            }
            if ("YES".equalsIgnoreCase(string)) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "LOGGING");
            } else if ("NO".equalsIgnoreCase(string)) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOLOGGING");
            }
            if (localIndexProperties.getKeyCompression() > 0) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl2, 2);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
                this.appendStringWithSpace(stringBuffer, localIndexProperties.getKeyCompression());
            }
            if (!bl) continue;
            String string2 = this.recreateIndexHashPTSSet(localIndexProperties.getHashSubPartitionsTableSpaces());
            this.appendIndexSubPartitions(stringBuffer, indexProxyOracle, partitionListOraclev10g, partitionOraclev10g, string2, bl2);
        }
        if (!bl3) {
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl2, 1);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxyOracle, PartitionOracle partitionOracle) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(partitionOracle, indexProxyOracle);
    }

    private LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxyOracle, HashPartitionOraclev10g hashPartitionOraclev10g) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(hashPartitionOraclev10g, indexProxyOracle);
    }

    private LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxyOracle, ListPartitionOraclev10g listPartitionOraclev10g) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(listPartitionOraclev10g, indexProxyOracle);
    }

    private LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxyOracle, ListStorageTemplatePartitionOraclev10g listStorageTemplatePartitionOraclev10g) {
        return this.storageDesign.getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(listStorageTemplatePartitionOraclev10g, indexProxyOracle);
    }

    public static String getFirstToken(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = " ";
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
        }
        return string2.trim();
    }

    protected String recreateIndexHashPTSSet(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)this.storageDesign.getTableSpaceSet().getById(string2);
            if (tableSpaceOracle == null) continue;
            if (!bl) {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ',');
            } else {
                bl = false;
            }
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        }
        return stringBuffer.toString();
    }

    protected void appendIndexSubPartitions(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, PartitionListOraclev10g partitionListOraclev10g, AbstractStorageObjectOracle abstractStorageObjectOracle, String string, boolean bl) {
        String string2 = partitionListOraclev10g.getSubpartitionType();
        if (string2.equalsIgnoreCase("HASH")) {
            PartitionOraclev10g partitionOraclev10g;
            if (abstractStorageObjectOracle instanceof PartitionOraclev10g && !this.appendHashSubPartitions(stringBuffer, indexProxyOracle, (partitionOraclev10g = (PartitionOraclev10g)abstractStorageObjectOracle).getPartitions(), bl) && !"".equalsIgnoreCase(string.trim())) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "STORE IN");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(string));
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
            }
        } else if (string2.equalsIgnoreCase("LIST") && abstractStorageObjectOracle instanceof PartitionOraclev10g) {
            this.appendListSubPartitions(stringBuffer, indexProxyOracle, ((PartitionOraclev10g)abstractStorageObjectOracle).getListPartitions(), bl);
        }
    }

    protected void appendListSubPartitions(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, StorageObjectCollection storageObjectCollection, boolean bl) {
        boolean bl2 = true;
        Iterator iterator = storageObjectCollection.iterator();
        while (iterator.hasNext()) {
            ListStorageTemplatePartitionOraclev10g listStorageTemplatePartitionOraclev10g = (ListStorageTemplatePartitionOraclev10g)iterator.next();
            if (bl2) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                bl2 = false;
            } else {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ',');
            }
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            LocalIndexProperties localIndexProperties = this.getPropsForIndex(indexProxyOracle, listStorageTemplatePartitionOraclev10g);
            if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
            } else {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listStorageTemplatePartitionOraclev10g.getName()));
            }
            if (localIndexProperties == null) continue;
            TableSpaceOracle tableSpaceOracle = localIndexProperties.getTableSpace();
            if (tableSpaceOracle != null) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 3);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            }
            if (localIndexProperties.getKeyCompression() <= 0 || !(this.storageDesign instanceof StorageDesignOraclev11g)) continue;
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 3);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
            this.appendStringWithSpace(stringBuffer, localIndexProperties.getKeyCompression());
        }
        if (!bl2) {
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected boolean appendHashSubPartitions(StringBuffer stringBuffer, IndexProxyOracle indexProxyOracle, StorageObjectCollection storageObjectCollection, boolean bl) {
        boolean bl2 = false;
        Iterator iterator = storageObjectCollection.iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            HashPartitionOraclev10g hashPartitionOraclev10g = (HashPartitionOraclev10g)iterator.next();
            if (bl3) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
                bl3 = false;
                bl2 = true;
            } else {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ',');
            }
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 2);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            LocalIndexProperties localIndexProperties = this.getPropsForIndex(indexProxyOracle, hashPartitionOraclev10g);
            if (localIndexProperties != null && !"".equalsIgnoreCase(localIndexProperties.getPartitionName())) {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(localIndexProperties.getPartitionName()));
            } else {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev10g.getName()));
            }
            if (localIndexProperties == null) continue;
            TableSpaceOraclev10g tableSpaceOraclev10g = (TableSpaceOraclev10g)localIndexProperties.getTableSpace();
            if (tableSpaceOraclev10g != null) {
                SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 3);
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "TABLESPACE");
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOraclev10g.getName()));
            }
            if (localIndexProperties.getKeyCompression() <= 0 || !(this.storageDesign instanceof StorageDesignOraclev11g)) continue;
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 3);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "COMPRESS");
            this.appendStringWithSpace(stringBuffer, localIndexProperties.getKeyCompression());
        }
        if (!bl3) {
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            stringBuffer.append(')');
        }
        return bl2;
    }

    private void appendConstraintElementList(StringBuffer stringBuffer, Index index, IndexProxy indexProxy, boolean bl) {
        ColumnProxy columnProxy = null;
        ColumnProxy[] columnProxyArray = indexProxy.getColumnProxies();
        SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
        if (columnProxyArray.length < 1) {
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "-- No Columns");
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
        }
        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
        for (int i = 0; i < columnProxyArray.length; ++i) {
            if (i != 0) {
                SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ',');
            }
            columnProxy = columnProxyArray[i];
            SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOraclev10g.appendString(stringBuffer, ' ');
            String string = this.storageDesign.getFormatedName(columnProxy.getName());
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, string);
            SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, index.getColumnSortOrder(columnProxy));
        }
        SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
    }

    public void appendIndexForConstraint(StringBuffer stringBuffer, Index index, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        IndexProxy indexProxy = null;
        StorageDesignOraclev10g storageDesignOraclev10g = (StorageDesignOraclev10g)this.getStorageDesign(index);
        if ("Primary Constraint".equals(index.getIndexState())) {
            indexProxy = (IndexProxyOracle)storageDesignOraclev10g.getPKProxySet().getProxy(index.getObjectID());
        } else if ("Unique Constraint".equals(index.getIndexState())) {
            indexProxy = (IndexProxyOracle)storageDesignOraclev10g.getUniqueSet().getProxy(index.getObjectID());
        } else if (index.isFK()) {
            indexProxy = (FKProxyOracle)storageDesignOraclev10g.getFKProxySet().getProxy(index.getObjectID());
        }
        if (indexProxy != null && !index.isOidKey()) {
            this.storageDesign = (StorageDesignOraclev10g)indexProxy.getStorageDesign();
            if (indexProxy.isMarkedGenerate()) {
                if (index.getElements().length > 0) {
                    String string2;
                    int n;
                    if (indexProxy.isCommentChanged()) {
                        this.appendComment(stringBuffer, indexProxy);
                    } else {
                        this.appendComment(stringBuffer, index);
                    }
                    String string3 = indexProxy.getName();
                    String string4 = indexProxy instanceof IndexProxyOracle ? ((IndexProxyOracle)indexProxy).getUserNameAndName() : ((n = (string2 = indexProxy.getTableProxy().getLongName()).indexOf(46)) > -1 ? string2.substring(0, n + 1) + string3 : string3);
                    if (string3.length() < indexProxy.getMaxNameLength()) {
                        string4 = string4 + "X";
                    } else if (string3.length() > indexProxy.getMaxNameLength()) {
                        SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 0);
                        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer, "--  ERROR: Index name length exceeds maximum allowed length(" + indexProxy.getMaxNameLength() + ")");
                        SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer2, "CREATE");
                    if ("Primary Constraint".equals(index.getIndexState()) || "Unique Constraint".equals(index.getIndexState())) {
                        SSBIndexOraclev10g.appendStringWithSpace(stringBuffer2, "UNIQUE");
                    }
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer2, "INDEX");
                    SSBIndexOraclev10g.appendStringWithSpace(stringBuffer2, storageDesignOraclev10g.getFormatedName(string4));
                    string = stringBuffer2.toString();
                    this.appendTable(stringBuffer2, indexProxy);
                    this.appendConstraintElementList(stringBuffer2, index, indexProxy, true);
                    SSBIndexOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                    this.appendLineFinisher(stringBuffer2, bl);
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    DDLFileMaker.incrementCreateIndex();
                } else {
                    SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 0);
                    stringBuffer.append("-- Error - Index ");
                    stringBuffer.append(storageDesignOraclev10g.getFormatedName(index.getName()));
                    stringBuffer.append(" has no columns");
                    SSBIndexOraclev10g.appendNewLine(stringBuffer, bl, 0);
                    DDLFileMaker.incrementErrors();
                }
            }
        }
    }

    public StorageDesignOraclev10g getStorageDesign() {
        return this.storageDesign;
    }

    public void setStorageDesign(StorageDesignOraclev10g storageDesignOraclev10g) {
        this.storageDesign = storageDesignOraclev10g;
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof PartitionOraclev10g && object2 instanceof PartitionOraclev10g) {
                if (((PartitionOraclev10g)object).getPosition() > ((PartitionOraclev10g)object2).getPosition()) {
                    return 1;
                }
                if (((PartitionOraclev10g)object).getPosition() < ((PartitionOraclev10g)object2).getPosition()) {
                    return -1;
                }
            } else if (object instanceof ListPartitionOraclev10g && object2 instanceof ListPartitionOraclev10g) {
                if (((ListPartitionOraclev10g)object).getPosition() > ((ListPartitionOraclev10g)object2).getPosition()) {
                    return 1;
                }
                if (((ListPartitionOraclev10g)object).getPosition() < ((ListPartitionOraclev10g)object2).getPosition()) {
                    return -1;
                }
            } else {
                return 0;
            }
            return 0;
        }
    }
}

