/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DimensionOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDimensionOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        DimensionOraclev10g dimensionOraclev10g = (DimensionOraclev10g)object;
        this.storageDesign = dimensionOraclev10g.getStorageDesign();
        this.appendComment(stringBuffer2, dimensionOraclev10g);
        if (dimensionOraclev10g.getLevelSet().length > 0) {
            this.appendCreate(stringBuffer2, dimensionOraclev10g);
            string = stringBuffer2.toString();
            this.appendLevels(stringBuffer2, dimensionOraclev10g, bl);
            this.appendHierarchies(stringBuffer2, dimensionOraclev10g, bl);
            this.appendExtendedAttributes(stringBuffer2, dimensionOraclev10g, bl);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBDimensionOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            DDLFileMaker.incrementCreateDimension();
        } else {
            SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, "--  ERROR: Invalid Dimension without Levels: " + dimensionOraclev10g.getName());
            SSBDimensionOraclev10g.appendNewLine(stringBuffer, bl, 0);
            DDLFileMaker.incrementErrors();
        }
        SSBDimensionOraclev10g.appendNewLine(stringBuffer, bl, 0);
    }

    private void appendCreate(StringBuffer stringBuffer, DimensionOraclev10g dimensionOraclev10g) {
        String string;
        this.appendCreate(stringBuffer);
        SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, "DIMENSION");
        if (dimensionOraclev10g.getUser() != null && !"".equals(string = dimensionOraclev10g.getUser().getName())) {
            SSBDimensionOraclev10g.appendString(stringBuffer, this.storageDesign.getFormatedName(dimensionOraclev10g.getUser().getName()));
            SSBDimensionOraclev10g.appendString(stringBuffer, '.');
        }
        SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(dimensionOraclev10g.getName()));
    }

    private void appendLevels(StringBuffer stringBuffer, DimensionOraclev10g dimensionOraclev10g, boolean bl) {
        Object[] objectArray = dimensionOraclev10g.getLevelSet();
        for (int i = 0; i < objectArray.length; ++i) {
            LevelOracle levelOracle = (LevelOracle)objectArray[i];
            if (levelOracle.getColumnSet().size() <= 0) continue;
            SSBDimensionOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, "LEVEL");
            SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(levelOracle.getName()));
            SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, "IS");
            for (int j = 0; j < levelOracle.getColumnSet().size(); ++j) {
                ColumnProxyOracle columnProxyOracle;
                if (levelOracle.getColumnSet().size() > 1 && j == 0) {
                    SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, '(');
                }
                if ((columnProxyOracle = (ColumnProxyOracle)dimensionOraclev10g.getStorageDesignOracle().getColumnProxySet().getProxy((String)levelOracle.getColumnSet().elementAt(j))) == null) continue;
                if (j > 0) {
                    this.appendComma(stringBuffer);
                }
                SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOracle.getTableProxy().getLongName()) + '.' + this.storageDesign.getFormatedName(columnProxyOracle.getName()));
            }
            if (levelOracle.getColumnSet().size() <= 1) continue;
            SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendHierarchies(StringBuffer stringBuffer, DimensionOraclev10g dimensionOraclev10g, boolean bl) {
        Object[] objectArray = dimensionOraclev10g.getHierarchySet();
        for (int i = 0; i < objectArray.length; ++i) {
            int n;
            HierarchyOracle hierarchyOracle = (HierarchyOracle)objectArray[i];
            if (hierarchyOracle.getLevelSet().size() <= 0) continue;
            SSBDimensionOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, "HIERARCHY");
            SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hierarchyOracle.getName()));
            SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, '(');
            for (n = 0; n < hierarchyOracle.getLevelSet().size(); ++n) {
                LevelOracle levelOracle;
                if (n > 0) {
                    SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, " CHILD OF ");
                }
                if ((levelOracle = (LevelOracle)dimensionOraclev10g.getStorageDesignOracle().getLevelSet().getById((String)hierarchyOracle.getLevelSet().get(n))) == null) continue;
                SSBDimensionOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(levelOracle.getName()));
            }
            for (n = 0; n < hierarchyOracle.getJoinSet().size(); ++n) {
                SSBDimensionOraclev10g.appendNewLine(stringBuffer, bl, 2);
                this.appendStringWithSpace(stringBuffer, hierarchyOracle.getJoinSet().elementAt(n));
            }
            SSBDimensionOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendExtendedAttributes(StringBuffer stringBuffer, DimensionOraclev10g dimensionOraclev10g, boolean bl) {
        Object[] objectArray = dimensionOraclev10g.getAttributeSet();
        for (int i = 0; i < objectArray.length; ++i) {
            DimensionAttributeOracle dimensionAttributeOracle = (DimensionAttributeOracle)objectArray[i];
            if (dimensionAttributeOracle.getLevel() == null || dimensionAttributeOracle.getColumnSet().size() <= 0) continue;
            SSBDimensionOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, "ATTRIBUTE");
            if (!"".equals(dimensionAttributeOracle.getName())) {
                SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(dimensionAttributeOracle.getName()));
                SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, "LEVEL");
            }
            SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(dimensionAttributeOracle.getLevel().getName()));
            SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, "DETERMINES");
            for (int j = 0; j < dimensionAttributeOracle.getColumnSet().size(); ++j) {
                ColumnProxyOracle columnProxyOracle;
                if (dimensionAttributeOracle.getColumnSet().size() > 1 && j == 0) {
                    SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, '(');
                }
                if ((columnProxyOracle = (ColumnProxyOracle)dimensionOraclev10g.getStorageDesignOracle().getColumnProxySet().getProxy((String)dimensionAttributeOracle.getColumnSet().elementAt(j))) == null) continue;
                if (j > 0) {
                    this.appendComma(stringBuffer);
                }
                SSBDimensionOraclev10g.appendNewLine(stringBuffer, bl, 2);
                SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOracle.getName()));
            }
            if (dimensionAttributeOracle.getColumnSet().size() <= 1) continue;
            SSBDimensionOraclev10g.appendNewLine(stringBuffer, bl, 1);
            SSBDimensionOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DimensionOraclev10g && ((DimensionOraclev10g)object).isMarkedGenerate();
    }
}

