/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.CollectionTypeProxyOraclev10g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBCollectionTypeOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        if (object instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)object;
            SSBCollectionTypeOraclev10g.appendNewLine(stringBuffer, bl, 0);
            this.appendComment(stringBuffer, collectionType);
        } else if (object instanceof CollectionTypeProxyOraclev10g) {
            CollectionTypeProxyOraclev10g collectionTypeProxyOraclev10g = (CollectionTypeProxyOraclev10g)object;
            this.storageDesign = collectionTypeProxyOraclev10g.getStorageDesign();
            if (!collectionTypeProxyOraclev10g.getCollectionType().isPredefined()) {
                SSBCollectionTypeOraclev10g.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, collectionTypeProxyOraclev10g);
                this.appendFullDefinition(stringBuffer, collectionTypeProxyOraclev10g, bl);
                this.appendPermissions(stringBuffer, collectionTypeProxyOraclev10g);
                DDLFileMaker.incrementCreateCollectionType();
            }
        }
    }

    private void appendFullDefinition(StringBuffer stringBuffer, CollectionTypeProxyOraclev10g collectionTypeProxyOraclev10g, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        SSBCollectionTypeOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer2, "CREATE");
        SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer2, "OR");
        SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer2, "REPLACE");
        SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer2, "TYPE");
        if (collectionTypeProxyOraclev10g.getOwner() != null && !collectionTypeProxyOraclev10g.getOwner().getName().equalsIgnoreCase("MDSYS") && !collectionTypeProxyOraclev10g.getOwner().getName().equalsIgnoreCase("SYS")) {
            SSBCollectionTypeOraclev10g.appendString(stringBuffer2, this.storageDesign.getFormatedName(collectionTypeProxyOraclev10g.getOwner().getName()));
            SSBCollectionTypeOraclev10g.appendString(stringBuffer2, '.');
        }
        SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(collectionTypeProxyOraclev10g.getName()));
        string = stringBuffer2.toString();
        SSBCollectionTypeOraclev10g.appendNewLine(stringBuffer2, bl, 1);
        if (!"".equalsIgnoreCase(collectionTypeProxyOraclev10g.getGlobalOid().trim())) {
            SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer2, "OID");
            if (Token.hasString(collectionTypeProxyOraclev10g.getGlobalOid(), "'")) {
                SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer2, collectionTypeProxyOraclev10g.getGlobalOid());
            } else {
                SSBCollectionTypeOraclev10g.appendString(stringBuffer2, '\'');
                SSBCollectionTypeOraclev10g.appendString(stringBuffer2, collectionTypeProxyOraclev10g.getGlobalOid());
                SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer2, '\'');
            }
        }
        if (!"".equalsIgnoreCase(collectionTypeProxyOraclev10g.getType())) {
            SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer2, "IS");
            if (collectionTypeProxyOraclev10g.isArrayType(collectionTypeProxyOraclev10g.getType())) {
                SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer2, "VARRAY");
                SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer2, '(');
                this.appendStringWithSpace(stringBuffer2, collectionTypeProxyOraclev10g.getMaxElement());
                SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer2, ')');
            } else {
                SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
            }
        }
        SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer2, "OF");
        SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer2, collectionTypeProxyOraclev10g.getDataType(this.storageDesign.getRDBMSType().getName()));
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        SSBCollectionTypeOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisherWithSlash(stringBuffer2, bl);
        SSBCollectionTypeOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof CollectionTypeProxyOraclev10g && ((CollectionTypeProxyOraclev10g)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof CollectionType && ((CollectionType)object).isMarkedGenerate();
    }

    protected void appendPermissions(StringBuffer stringBuffer, CollectionTypeProxyOracle collectionTypeProxyOracle) {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)collectionTypeProxyOracle.getStorageDesign();
        StringBuffer stringBuffer2 = new StringBuffer();
        PermissionsSetOracle permissionsSetOracle = storageDesignOracle.getPermissionsSet();
        Iterator iterator = permissionsSetOracle.iterator();
        while (iterator.hasNext()) {
            PermissionsOracle permissionsOracle = (PermissionsOracle)iterator.next();
            if (!collectionTypeProxyOracle.equals(permissionsOracle.getCollectionTypeOracle()) || permissionsOracle.getUser() == null && permissionsOracle.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissionsOracle.getPrivileges())) {
                this.appendPrivileges(stringBuffer, stringBuffer2, permissionsOracle, collectionTypeProxyOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissionsOracle.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(stringBuffer, stringBuffer2, permissionsOracle, collectionTypeProxyOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer stringBuffer, StringBuffer stringBuffer2, PermissionsOracle permissionsOracle, CollectionTypeProxyOracle collectionTypeProxyOracle, StorageDesignOracle storageDesignOracle, boolean bl) {
        stringBuffer2.append(NEWLINE);
        this.appendComment(stringBuffer2, permissionsOracle);
        SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer2, "GRANT");
        if (bl) {
            stringBuffer2.append(permissionsOracle.getPrivilegesWithGrantOption());
        } else {
            stringBuffer2.append(permissionsOracle.getPrivileges());
        }
        this.appendObject(stringBuffer2, collectionTypeProxyOracle, storageDesignOracle);
        this.appendTo(stringBuffer2, permissionsOracle, storageDesignOracle);
        if (bl) {
            this.appendGrantOption(stringBuffer2, permissionsOracle);
        }
        String string = stringBuffer2.toString();
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(';');
        stringBuffer2.append(NEWLINE);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
    }

    private void appendObject(StringBuffer stringBuffer, CollectionTypeProxyOracle collectionTypeProxyOracle, StorageDesign storageDesign) {
        stringBuffer.append(NEWLINE);
        SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer, "ON");
        SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(collectionTypeProxyOracle.getLongName()));
    }

    private void appendTo(StringBuffer stringBuffer, PermissionsOracle permissionsOracle, StorageDesign storageDesign) {
        SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer, "TO");
        if ("YES".equalsIgnoreCase(permissionsOracle.getPublic())) {
            SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer, "PUBLIC");
        } else if (permissionsOracle.getUser() != null) {
            SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(permissionsOracle.getUser().getName()));
        } else if (permissionsOracle.getRole() != null) {
            SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(permissionsOracle.getRole().getName()));
        }
    }

    private void appendGrantOption(StringBuffer stringBuffer, PermissionsOracle permissionsOracle) {
        if (permissionsOracle.getRole() == null) {
            SSBCollectionTypeOraclev10g.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
        }
    }
}

