/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBArcFKOracle
extends AbstractSSBOracle {
    private StorageDesign storageDesign;
    int arc_index = 0;

    public SSBArcFKOracle(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof FKArc;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        FKArc fKArc = (FKArc)object;
        if (fKArc.isMarkedGenerate() && fKArc.getDesign().getAppView().getSettings().isGenerateFKArcTriggers()) {
            TableProxy tableProxy;
            Table table = fKArc.getTable();
            List list = this.getColumnsInArc(fKArc);
            if (table != null && fKArc.getFkeys().size() > 1 && list.size() > 0 && (tableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(table.getObjectID())) != null && tableProxy.isMarkedGenerate()) {
                this.arc_index = table.getArcs().indexOf(fKArc) + 1;
                this.appendComment(stringBuffer, fKArc);
                StringBuffer stringBuffer2 = new StringBuffer();
                String string = this.storageDesign.getFormatedName(tableProxy.getLongName());
                String string2 = "create Arc constraint INSERT trigger for table " + string;
                this.appendArcInsertTrigger(stringBuffer2, fKArc, tableProxy, list, true);
                this.appendBlockDefinitionToBuffer(stringBuffer, stringBuffer2, string2, "/");
                SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
                SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
                DDLFileMaker.incrementCreateTrigger();
                string2 = "create Arc constraint UPDATE trigger for table " + string;
                this.appendArcUpdateTrigger(stringBuffer2, fKArc, tableProxy, list, true);
                this.appendBlockDefinitionToBuffer(stringBuffer, stringBuffer2, string2, "/");
                SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
                SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
                DDLFileMaker.incrementCreateTrigger();
            }
        }
    }

    private List getColumnsInArc(FKArc fKArc) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (FKIndexAssociation fKIndexAssociation : fKArc.getFkeys()) {
            for (Column column : fKIndexAssociation.getLocalFKIndex().getElementsCollection()) {
                arrayList.add(column);
            }
        }
        return arrayList;
    }

    private void appendArcInsertTrigger(StringBuffer stringBuffer, FKArc fKArc, TableProxy tableProxy, List list, boolean bl) {
        String string = "ARCI" + this.arc_index + "_";
        string = this.storageDesign.getFormatedName(string + this.getStringWithMaxLength(tableProxy.getName(), 30 - string.length()));
        if (tableProxy.getUserSchema() != null) {
            string = this.storageDesign.getFormatedName(tableProxy.getUserSchema().getName()) + '.' + string;
        }
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, "CREATE OR REPLACE TRIGGER " + string);
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        String string2 = this.storageDesign.getFormatedName(tableProxy.getLongName());
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, "BEFORE INSERT ON " + string2);
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, "FOR EACH ROW");
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, " DECLARE i NUMBER;");
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, "BEGIN");
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, " i:=0;");
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        for (Column column : list) {
            SSBArcFKOracle.appendStringWithSpace(stringBuffer, " IF :new." + this.storageDesign.getFormatedName(column.getName()) + " IS NOT NULL THEN");
            SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
            SSBArcFKOracle.appendStringWithSpace(stringBuffer, "  i:= i+1;");
            SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
            SSBArcFKOracle.appendStringWithSpace(stringBuffer, " END IF;");
            SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        }
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, " IF (i>1) THEN");
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, "  raise_application_error(-20223,' Arc constraint on table " + string2 + " is violated - one value is permitted in FKs');");
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, " END IF;");
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        if (fKArc.isMandatory()) {
            SSBArcFKOracle.appendStringWithSpace(stringBuffer, " IF (i=0) THEN");
            SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
            SSBArcFKOracle.appendStringWithSpace(stringBuffer, "  raise_application_error(-20224,' Mandatory Arc constraint on table " + string2 + " is violated - one value should be set in FKs');");
            SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
            SSBArcFKOracle.appendStringWithSpace(stringBuffer, " END IF;");
            SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        }
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, "END;");
    }

    private void appendArcUpdateTrigger(StringBuffer stringBuffer, FKArc fKArc, TableProxy tableProxy, List list, boolean bl) {
        Object object2;
        String string = "ARCU" + this.arc_index + "_";
        string = this.storageDesign.getFormatedName(string + this.getStringWithMaxLength(tableProxy.getName(), 30 - string.length()));
        if (tableProxy.getUserSchema() != null) {
            string = this.storageDesign.getFormatedName(tableProxy.getUserSchema().getName()) + '.' + string;
        }
        String string2 = "";
        boolean bl2 = true;
        for (Object object2 : list) {
            if (bl2) {
                string2 = this.storageDesign.getFormatedName(((ContainedObject)object2).getName());
                bl2 = false;
                continue;
            }
            string2 = string2 + "," + this.storageDesign.getFormatedName(((ContainedObject)object2).getName());
        }
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, "CREATE OR REPLACE TRIGGER " + string);
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, "BEFORE UPDATE OF " + string2);
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        object2 = this.storageDesign.getFormatedName(tableProxy.getLongName());
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, "ON " + (String)object2);
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, "FOR EACH ROW");
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, " DECLARE i NUMBER;");
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, "BEGIN");
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, " i:=0;");
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        for (Column column : list) {
            SSBArcFKOracle.appendStringWithSpace(stringBuffer, " IF :new." + this.storageDesign.getFormatedName(column.getName()) + " IS NOT NULL THEN");
            SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
            SSBArcFKOracle.appendStringWithSpace(stringBuffer, "  i:= i+1;");
            SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
            SSBArcFKOracle.appendStringWithSpace(stringBuffer, " END IF;");
            SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        }
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, " IF (i>1) THEN");
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, "  raise_application_error(-20223,' Arc constraint on table " + (String)object2 + " is violated - one value is permitted in FKs');");
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, " END IF;");
        SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        if (fKArc.isMandatory()) {
            SSBArcFKOracle.appendStringWithSpace(stringBuffer, " IF (i=0) THEN");
            SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
            SSBArcFKOracle.appendStringWithSpace(stringBuffer, "  raise_application_error(-20224,' Mandatory Arc constraint on table " + (String)object2 + " is violated - one value should be set in FKs');");
            SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
            SSBArcFKOracle.appendStringWithSpace(stringBuffer, " END IF;");
            SSBArcFKOracle.appendNewLine(stringBuffer, bl, 0);
        }
        SSBArcFKOracle.appendStringWithSpace(stringBuffer, "END;");
    }
}

