/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableSpaceDB2v80
extends AbstractSSBDB2 {
    private AbstractStorageDesignDB2 storageDesign;
    private static final String DSSIZE = "DSSIZE";
    private static final String SEGSIZE = "SEGSIZE";
    private static final String NUMPARTS = "NUMPARTS";
    private static final String LOCKSIZE = "LOCKSIZE";
    private static final String LOCKMAX = "LOCKMAX";
    private static final String LOCKPART = "LOCKPART";
    private static final String MAXROWS = "MAXROWS";

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableSpaceDB2 && ((TableSpaceDB2)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        TableSpaceDB2 tableSpaceDB2 = (TableSpaceDB2)object;
        if (!tableSpaceDB2.isNullInstance() && tableSpaceDB2 != null) {
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(object);
            this.appendComment(stringBuffer, tableSpaceDB2);
            this.appendCreate(stringBuffer);
            this.appendLob(stringBuffer, tableSpaceDB2);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceDB2.getLongName()));
            this.appendDataBase(stringBuffer, tableSpaceDB2, bl);
            this.appendUsingBlock(stringBuffer, tableSpaceDB2.getStorageTemplate(), bl);
            this.appendFreeBlock(stringBuffer, tableSpaceDB2.getStorageTemplate(), tableSpaceDB2, bl);
            this.appendGbpCacheBlock(stringBuffer, tableSpaceDB2.getStorageTemplate(), bl);
            this.appendTrackMod(stringBuffer, tableSpaceDB2.getStorageTemplate(), bl);
            this.appendLog(stringBuffer, tableSpaceDB2, bl);
            this.appendDefine(stringBuffer, tableSpaceDB2.getStorageTemplate(), bl);
            this.appendDSSize(stringBuffer, tableSpaceDB2, bl);
            this.appendClusterOptions(stringBuffer, tableSpaceDB2, bl);
            this.appendBufferPool(stringBuffer, tableSpaceDB2, bl);
            this.appendLockSize(stringBuffer, tableSpaceDB2, bl);
            this.appendLockMax(stringBuffer, tableSpaceDB2, bl);
            this.appendClose(stringBuffer, tableSpaceDB2, bl);
            this.appendCompress(stringBuffer, tableSpaceDB2, bl);
            this.appendCcsid(stringBuffer, tableSpaceDB2, bl);
            this.appendMaxRows(stringBuffer, tableSpaceDB2, bl);
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            DDLFileMaker.incrementCreateTablespace();
            this.appendUsePrivileges(stringBuffer, tableSpaceDB2, bl);
        }
    }

    protected void appendLob(StringBuffer stringBuffer, TableSpaceDB2 tableSpaceDB2) {
        if (tableSpaceDB2.getType().equalsIgnoreCase("LOB")) {
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "LOB");
        }
    }

    protected void appendDataBase(StringBuffer stringBuffer, TableSpaceDB2 tableSpaceDB2, boolean bl) {
        DataBaseDB2 dataBaseDB2 = tableSpaceDB2.getDataBase();
        if (dataBaseDB2 != null) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "IN");
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(dataBaseDB2.getLongName()));
        }
    }

    protected void appendUsingBlock(StringBuffer stringBuffer, StorageTemplateDB2 storageTemplateDB2, boolean bl) {
        if (storageTemplateDB2 != null) {
            VCatDB2 vCatDB2 = storageTemplateDB2.getVCat();
            if (vCatDB2 != null) {
                SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 2);
                SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "USING");
                SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "VCAT");
                SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(vCatDB2.getName()));
            } else {
                StorageGroupDB2 storageGroupDB2 = storageTemplateDB2.getStorageGroup();
                if (storageGroupDB2 != null) {
                    SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 2);
                    SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "USING");
                    SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "STOGROUP");
                    SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(storageGroupDB2.getLongName()));
                    SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 2);
                    if (storageTemplateDB2.getSgPriqty() > 0) {
                        SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "PRIQTY");
                        this.appendStringWithSpace(stringBuffer, storageTemplateDB2.getSgPriqty());
                        SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 2);
                    }
                    if (storageTemplateDB2.getSgSeqty() > 0) {
                        SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "SECQTY");
                        this.appendStringWithSpace(stringBuffer, storageTemplateDB2.getSgSeqty());
                        SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 2);
                    }
                    SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "ERASE");
                    SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, storageTemplateDB2.isSgErase() ? "YES" : "NO");
                }
            }
        }
    }

    protected void appendFreeBlock(StringBuffer stringBuffer, StorageTemplateDB2 storageTemplateDB2, TableSpaceDB2 tableSpaceDB2, boolean bl) {
        if (storageTemplateDB2 != null) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 2);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "FREEPAGE");
            this.appendStringWithSpace(stringBuffer, storageTemplateDB2.getFreePage());
            String string = tableSpaceDB2.getType();
            if (!string.equalsIgnoreCase("LOB")) {
                DataBaseDB2 dataBaseDB2 = tableSpaceDB2.getDataBase();
                if (dataBaseDB2 == null) {
                    SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 2);
                    SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "PCTFREE");
                    this.appendStringWithSpace(stringBuffer, storageTemplateDB2.getPctFree());
                } else {
                    String string2 = dataBaseDB2.getType();
                    if (!string2.equalsIgnoreCase("WORKFILE") && !string2.equalsIgnoreCase("TEMP")) {
                        SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 2);
                        SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "PCTFREE");
                        this.appendStringWithSpace(stringBuffer, storageTemplateDB2.getPctFree());
                    }
                }
            }
        }
    }

    protected void appendGbpCacheBlock(StringBuffer stringBuffer, StorageTemplateDB2 storageTemplateDB2, boolean bl) {
        if (storageTemplateDB2 != null && !storageTemplateDB2.getGbCache().equalsIgnoreCase("") && !storageTemplateDB2.getGbCache().equalsIgnoreCase("CHANGED")) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 2);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "GBPCACHE");
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, storageTemplateDB2.getGbCache());
        }
    }

    protected void appendTrackMod(StringBuffer stringBuffer, StorageTemplateDB2 storageTemplateDB2, boolean bl) {
        if (storageTemplateDB2 != null && !storageTemplateDB2.isTrackMode()) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 2);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "TRACKMOD");
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, storageTemplateDB2.isTrackMode() ? "YES" : "NO");
        }
    }

    protected void appendLog(StringBuffer stringBuffer, TableSpaceDB2 tableSpaceDB2, boolean bl) {
        if (tableSpaceDB2.getType().equalsIgnoreCase("LOB") && !tableSpaceDB2.isLobLogging()) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 2);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "LOG");
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, tableSpaceDB2.isLobLogging() ? "YES" : "NO");
        }
    }

    protected void appendDefine(StringBuffer stringBuffer, StorageTemplateDB2 storageTemplateDB2, boolean bl) {
        if (storageTemplateDB2 != null && !storageTemplateDB2.isDefine()) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 2);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "DEFINE");
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, storageTemplateDB2.isDefine() ? "YES" : "NO");
        }
    }

    protected void appendDSSize(StringBuffer stringBuffer, TableSpaceDB2 tableSpaceDB2, boolean bl) {
        if (!tableSpaceDB2.getDsSize().equalsIgnoreCase("")) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 2);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, DSSIZE);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, tableSpaceDB2.getDsSize());
        }
    }

    protected void appendClusterOptions(StringBuffer stringBuffer, TableSpaceDB2 tableSpaceDB2, boolean bl) {
        if (tableSpaceDB2.getType().equalsIgnoreCase("PARTITIONED")) {
            this.appendPartitions(stringBuffer, tableSpaceDB2, bl);
        } else if (Integer.parseInt(tableSpaceDB2.getSegSize()) > 0) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 2);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, SEGSIZE);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, tableSpaceDB2.getSegSize());
        }
        if ("YES".equalsIgnoreCase(tableSpaceDB2.getClustered())) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "MEMBER");
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "CLUSTER");
        }
    }

    protected void appendPartitions(StringBuffer stringBuffer, TableSpaceDB2 tableSpaceDB2, boolean bl) {
        PartitionDB2[] partitionDB2Array = tableSpaceDB2.getPartitions();
        if (partitionDB2Array.length > 0) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, NUMPARTS);
            this.appendStringWithSpace(stringBuffer, partitionDB2Array.length);
            if (partitionDB2Array.length > 0) {
                SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, '(');
                for (int i = 0; i < partitionDB2Array.length; ++i) {
                    PartitionDB2 partitionDB2 = partitionDB2Array[i];
                    SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
                    SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "PART");
                    this.appendStringWithSpace(stringBuffer, partitionDB2.getPartNumber());
                    this.appendUsingBlock(stringBuffer, partitionDB2.getStorageTemplate(), bl);
                    this.appendFreeBlock(stringBuffer, partitionDB2.getStorageTemplate(), tableSpaceDB2, bl);
                    this.appendGbpCacheBlock(stringBuffer, partitionDB2.getStorageTemplate(), bl);
                    this.appendTrackMod(stringBuffer, partitionDB2.getStorageTemplate(), bl);
                    this.appendPartitionCompress(stringBuffer, partitionDB2, bl);
                    if (i >= partitionDB2Array.length - 1) continue;
                    this.appendComma(stringBuffer);
                }
                SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    protected void appendPartitionCompress(StringBuffer stringBuffer, PartitionDB2 partitionDB2, boolean bl) {
        if (partitionDB2 != null && partitionDB2.isCompress()) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 2);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "COMPRESS");
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, partitionDB2.isCompress() ? "YES" : "NO");
        }
    }

    protected void appendBufferPool(StringBuffer stringBuffer, TableSpaceDB2 tableSpaceDB2, boolean bl) {
        BufferPoolDB2 bufferPoolDB2 = tableSpaceDB2.getBufferPool();
        if (bufferPoolDB2 != null) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "BUFFERPOOL");
            this.appendStringWithSpace(stringBuffer, tableSpaceDB2.getBufferPool());
        }
    }

    protected void appendLockSize(StringBuffer stringBuffer, TableSpaceDB2 tableSpaceDB2, boolean bl) {
        SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
        SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, LOCKSIZE);
        SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, tableSpaceDB2.getLockSize());
    }

    protected void appendLockMax(StringBuffer stringBuffer, TableSpaceDB2 tableSpaceDB2, boolean bl) {
        int n = tableSpaceDB2.getLockMax();
        String string = tableSpaceDB2.getLockSize();
        if ("ANY".equalsIgnoreCase(string)) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, LOCKMAX);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "SYSTEM");
        } else if ("PAGE".equalsIgnoreCase(string) || "ROW".equalsIgnoreCase(string) || "LOB".equalsIgnoreCase(string)) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, LOCKMAX);
            if (n == -1) {
                SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "SYSTEM");
            } else {
                this.appendStringWithSpace(stringBuffer, n);
            }
        }
    }

    protected void appendClose(StringBuffer stringBuffer, TableSpaceDB2 tableSpaceDB2, boolean bl) {
        if (!tableSpaceDB2.isClose()) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "CLOSE");
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, tableSpaceDB2.isClose() ? "YES" : "NO");
        }
    }

    protected void appendCompress(StringBuffer stringBuffer, TableSpaceDB2 tableSpaceDB2, boolean bl) {
        if (tableSpaceDB2.isCompress()) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "COMPRESS");
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, tableSpaceDB2.isCompress() ? "YES" : "NO");
        }
    }

    protected void appendCcsid(StringBuffer stringBuffer, TableSpaceDB2 tableSpaceDB2, boolean bl) {
        if (!tableSpaceDB2.getCcsid().equalsIgnoreCase("")) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "CCSID");
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, tableSpaceDB2.getCcsid());
        }
    }

    protected void appendLockPart(StringBuffer stringBuffer, TableSpaceDB2 tableSpaceDB2, boolean bl) {
        if (!tableSpaceDB2.isLockPart()) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, LOCKPART);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, tableSpaceDB2.isLockPart() ? "YES" : "NO");
        }
    }

    protected void appendMaxRows(StringBuffer stringBuffer, TableSpaceDB2 tableSpaceDB2, boolean bl) {
        if (!tableSpaceDB2.getType().equalsIgnoreCase("LOB")) {
            DataBaseDB2 dataBaseDB2 = tableSpaceDB2.getDataBase();
            if (dataBaseDB2 != null) {
                if (!dataBaseDB2.getType().equalsIgnoreCase("WORKFILE") && tableSpaceDB2.getMaxRows() > 0 && tableSpaceDB2.getMaxRows() != 255) {
                    SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
                    SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, MAXROWS);
                    this.appendStringWithSpace(stringBuffer, tableSpaceDB2.getMaxRows());
                }
            } else if (tableSpaceDB2.getMaxRows() > 0 && tableSpaceDB2.getMaxRows() != 255) {
                SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, MAXROWS);
                this.appendStringWithSpace(stringBuffer, tableSpaceDB2.getMaxRows());
            }
        }
    }

    private void appendUsePrivileges(StringBuffer stringBuffer, TableSpaceDB2 tableSpaceDB2, boolean bl) {
        if (!tableSpaceDB2.getUsers().equalsIgnoreCase("")) {
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 0);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "GRANT");
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "USE");
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "OF");
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceDB2.getName()));
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "TO");
            if (!tableSpaceDB2.getUsers().equalsIgnoreCase("")) {
                SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, tableSpaceDB2.getUsers());
            }
            if ("YES".equalsIgnoreCase(tableSpaceDB2.getGrantOption())) {
                SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBTableSpaceDB2v80.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
            }
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            SSBTableSpaceDB2v80.appendNewLine(stringBuffer, bl, 0);
        }
    }
}

