/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import java.util.ArrayList;
import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.FKProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.IndexProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexDB2v80
extends AbstractSSBDB2 {
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof IndexProxy && !(object instanceof FKProxyDB2v80) && ((IndexProxy)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Index index = null;
        IndexProxyDB2v80 indexProxyDB2v80 = null;
        if (object instanceof Index) {
            index = (Index)object;
            this.storageDesign = (StorageDesignDB2v80)this.getStorageDesign(object);
            indexProxyDB2v80 = (IndexProxyDB2v80)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxyDB2) {
            indexProxyDB2v80 = (IndexProxyDB2v80)object;
            index = (Index)indexProxyDB2v80.getObject();
            this.storageDesign = (StorageDesignDB2v80)this.getStorageDesign(object);
        }
        if (index != null && indexProxyDB2v80 != null) {
            if (index.isFK()) {
                this.appendFKDefinition(stringBuffer, index, indexProxyDB2v80, bl);
            } else if (indexProxyDB2v80.isMarkedGenerate()) {
                if (indexProxyDB2v80.isCommentChanged()) {
                    this.appendComment(stringBuffer, indexProxyDB2v80);
                } else {
                    this.appendComment(stringBuffer, index);
                }
                this.appendCreate(stringBuffer);
                this.appendUnique(stringBuffer, indexProxyDB2v80);
                this.appendNotNull(stringBuffer, indexProxyDB2v80);
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "INDEX");
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyDB2v80.getLongName()));
                this.appendTable(stringBuffer, index, bl);
                this.appendElementList(stringBuffer, index, indexProxyDB2v80, true);
                this.appendCluster(stringBuffer, indexProxyDB2v80, bl);
                this.appendPadded(stringBuffer, indexProxyDB2v80, bl);
                this.appendUsingBlock(stringBuffer, indexProxyDB2v80.getStorageTemplate(), bl);
                this.appendFreeBlock(stringBuffer, indexProxyDB2v80.getStorageTemplate(), bl);
                this.appendGbpCacheBlock(stringBuffer, indexProxyDB2v80.getStorageTemplate(), bl);
                this.appendDefine(stringBuffer, indexProxyDB2v80.getStorageTemplate(), bl);
                this.appendBufferPool(stringBuffer, indexProxyDB2v80, bl);
                this.appendClose(stringBuffer, indexProxyDB2v80, bl);
                this.appendDefer(stringBuffer, indexProxyDB2v80, bl);
                this.appendPieceSize(stringBuffer, indexProxyDB2v80, bl);
                this.appendCopy(stringBuffer, indexProxyDB2v80, bl);
                SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
                DDLFileMaker.incrementCreateIndex();
                if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendIndexComment(stringBuffer, index, indexProxyDB2v80, bl);
                }
            } else if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendIndexComment(stringBuffer, index, indexProxyDB2v80, bl);
            }
        } else if (index != null) {
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("-- Error - Index ");
            stringBuffer.append(this.storageDesign.getFormatedName(index.getContainerWithKeyObject().getName()) + "." + this.storageDesign.getFormatedName(index.getName()));
            stringBuffer.append(" has no columns");
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendIndexComment(StringBuffer stringBuffer, Index index, IndexProxyDB2v80 indexProxyDB2v80, boolean bl) {
        if (indexProxyDB2v80 != null && indexProxyDB2v80.isCommentInRDBMSChanged()) {
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 0);
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "COMMENT ON");
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "INDEX");
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyDB2v80.getLongName()));
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "IS");
            SSBIndexDB2v80.appendString(stringBuffer, '\'');
            SSBIndexDB2v80.appendString(stringBuffer, indexProxyDB2v80.getCommentInRDBMS());
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
        } else if (index != null && !"".equalsIgnoreCase(index.getCommentInRDBMS().trim())) {
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 0);
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "COMMENT ON");
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "INDEX");
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(index.getLongName()));
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "IS");
            SSBIndexDB2v80.appendString(stringBuffer, '\'');
            SSBIndexDB2v80.appendString(stringBuffer, index.getCommentInRDBMS());
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
        }
    }

    protected void appendTable(StringBuffer stringBuffer, Index index, boolean bl) {
        Table table = (Table)index.getTopLevelContainer();
        TableProxy tableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
        if (tableProxy != null) {
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "ON");
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
        }
    }

    protected void appendElementList(StringBuffer stringBuffer, Index index, IndexProxyDB2v80 indexProxyDB2v80, boolean bl) {
        if (index.hasIndexExpression()) {
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, '(');
            SSBIndexDB2v80.appendString(stringBuffer, index.getIndexExpression());
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, ')');
        } else {
            ColumnProxy[] columnProxyArray = indexProxyDB2v80.getColumnProxies();
            ColumnProxy columnProxy = null;
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, '(');
            for (int i = 0; i < columnProxyArray.length; ++i) {
                columnProxy = columnProxyArray[i];
                SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBIndexDB2v80.appendString(stringBuffer, ' ');
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxy.getName()));
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, index.getColumnSortOrder(columnProxy));
                if (i >= columnProxyArray.length - 1) continue;
                this.appendComma(stringBuffer);
            }
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendUnique(StringBuffer stringBuffer, IndexProxyDB2v80 indexProxyDB2v80) {
        if (indexProxyDB2v80.isUnique()) {
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "UNIQUE");
        }
    }

    protected void appendNotNull(StringBuffer stringBuffer, IndexProxyDB2 indexProxyDB2) {
        if (indexProxyDB2.isUniquePlainIndex() && indexProxyDB2.isWhereNotNull()) {
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "WHERE NOT NULL");
        }
    }

    protected void appendUsingBlock(StringBuffer stringBuffer, StorageTemplateDB2 storageTemplateDB2, boolean bl) {
        if (storageTemplateDB2 != null) {
            VCatDB2 vCatDB2 = storageTemplateDB2.getVCat();
            if (vCatDB2 != null) {
                SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 2);
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "USING");
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "VCAT");
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(vCatDB2.getName()));
            } else {
                StorageGroupDB2 storageGroupDB2 = storageTemplateDB2.getStorageGroup();
                if (storageGroupDB2 != null) {
                    SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 2);
                    SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "USING");
                    SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "STOGROUP");
                    SSBIndexDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(storageGroupDB2.getLongName()));
                    SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 2);
                    SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "PRIQTY");
                    this.appendStringWithSpace(stringBuffer, storageTemplateDB2.getSgPriqty());
                    SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 2);
                    SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "SECQTY");
                    this.appendStringWithSpace(stringBuffer, storageTemplateDB2.getSgSeqty());
                    SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 2);
                    SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "ERASE");
                    SSBIndexDB2v80.appendStringWithSpace(stringBuffer, storageTemplateDB2.isSgErase() ? "YES" : "NO");
                }
            }
        }
    }

    protected void appendFreeBlock(StringBuffer stringBuffer, StorageTemplateDB2 storageTemplateDB2, boolean bl) {
        if (storageTemplateDB2 != null) {
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 2);
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "FREEPAGE");
            this.appendStringWithSpace(stringBuffer, storageTemplateDB2.getFreePage());
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 2);
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "PCTFREE");
            this.appendStringWithSpace(stringBuffer, storageTemplateDB2.getPctFree());
        }
    }

    protected void appendGbpCacheBlock(StringBuffer stringBuffer, StorageTemplateDB2 storageTemplateDB2, boolean bl) {
        if (storageTemplateDB2 != null && !"".equalsIgnoreCase(storageTemplateDB2.getGbCache())) {
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 2);
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "GBPCACHE");
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, storageTemplateDB2.getGbCache());
        }
    }

    protected void appendDefine(StringBuffer stringBuffer, StorageTemplateDB2 storageTemplateDB2, boolean bl) {
        if (storageTemplateDB2 != null && !storageTemplateDB2.isDefine()) {
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 2);
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "DEFINE");
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, storageTemplateDB2.isDefine() ? "YES" : "NO");
        }
    }

    protected void appendCluster(StringBuffer stringBuffer, IndexProxyDB2v80 indexProxyDB2v80, boolean bl) {
        if (!indexProxyDB2v80.getClusteredDB2().equalsIgnoreCase("NO")) {
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "CLUSTER");
        }
    }

    protected void appendPadded(StringBuffer stringBuffer, IndexProxyDB2v80 indexProxyDB2v80, boolean bl) {
        if (!indexProxyDB2v80.getPadded().equalsIgnoreCase("NO")) {
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "PADDED");
        }
    }

    protected void appendBufferPool(StringBuffer stringBuffer, IndexProxyDB2v80 indexProxyDB2v80, boolean bl) {
        BufferPoolDB2 bufferPoolDB2 = indexProxyDB2v80.getBufferPool();
        if (bufferPoolDB2 != null) {
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "BUFFERPOOL");
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(bufferPoolDB2.getLongName()));
        }
    }

    protected void appendClose(StringBuffer stringBuffer, IndexProxyDB2v80 indexProxyDB2v80, boolean bl) {
        if (!indexProxyDB2v80.isClose()) {
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "CLOSE");
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, indexProxyDB2v80.isClose() ? "YES" : "NO");
        }
    }

    protected void appendDefer(StringBuffer stringBuffer, IndexProxyDB2v80 indexProxyDB2v80, boolean bl) {
        SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
        SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "DEFER");
        SSBIndexDB2v80.appendStringWithSpace(stringBuffer, indexProxyDB2v80.isDefer() ? "YES" : "NO");
    }

    protected void appendCopy(StringBuffer stringBuffer, IndexProxyDB2v80 indexProxyDB2v80, boolean bl) {
        if (indexProxyDB2v80.isCopy()) {
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "COPY");
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, indexProxyDB2v80.isCopy() ? "YES" : "NO");
        }
    }

    protected void appendPieceSize(StringBuffer stringBuffer, IndexProxyDB2v80 indexProxyDB2v80, boolean bl) {
        if (!indexProxyDB2v80.getPieceSize().equalsIgnoreCase(" ")) {
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "PIECESIZE");
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, indexProxyDB2v80.getPieceSize());
        }
    }

    private void appendFKDefinition(StringBuffer stringBuffer, Index index, IndexProxyDB2v80 indexProxyDB2v80, boolean bl) {
        TableProxyDB2 tableProxyDB2 = (TableProxyDB2)indexProxyDB2v80.getTableProxy();
        FKIndexAssociation fKIndexAssociation = index.getFKAssociation();
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        if (index2 != null) {
            Column[] columnArray = (Column[])index2.getElements();
            ColumnProxy columnProxy = null;
            if (columnArray != null && columnArray.length > 0) {
                SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 0);
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "ALTER");
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "TABLE");
                if (tableProxyDB2 != null) {
                    SSBIndexDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyDB2.getLongName()));
                }
                SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "ADD");
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fKIndexAssociation.getName()));
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "FOREIGN KEY");
                SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, '(');
                if (tableProxyDB2 != null) {
                    for (int i = 0; i < columnArray.length; ++i) {
                        columnProxy = tableProxyDB2.getColumnProxy(columnArray[i].getObjectID());
                        SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
                        SSBIndexDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxy.getName()));
                        if (i >= columnArray.length - 1) continue;
                        this.appendComma(stringBuffer);
                    }
                }
                SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, ')');
                SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "REFERENCES");
                TableProxy tableProxy = (TableProxy)indexProxyDB2v80.getStorageDesign().getTableProxySet().getProxy(fKIndexAssociation.getOriginalContainer().getObjectID());
                if (tableProxy != null) {
                    SSBIndexDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
                }
                String string = fKIndexAssociation.getDeleteRule();
                String[] stringArray = fKIndexAssociation.getDeleteRuleChoices();
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "ON");
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "DELETE");
                if (string.equalsIgnoreCase(stringArray[0])) {
                    SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "NO ACTION");
                } else if (string.equalsIgnoreCase(stringArray[1])) {
                    SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "CASCADE");
                } else if (string.equalsIgnoreCase(stringArray[2])) {
                    SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "SET NULL");
                } else if (string.equalsIgnoreCase(stringArray[3])) {
                    SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "RESTRICT");
                }
                SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
                this.appendLineFinisher(stringBuffer, bl);
                DDLFileMaker.incrementAlterTable();
            }
        }
    }

    public void appendIndexForConstraint(StringBuffer stringBuffer, Index index, TableProxy tableProxy, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        Index index2 = null;
        IndexProxy indexProxy = null;
        index2 = index;
        StorageDesignDB2v80 storageDesignDB2v80 = (StorageDesignDB2v80)this.getStorageDesign(index);
        if (index2.isFK()) {
            indexProxy = (IndexProxy)storageDesignDB2v80.getFKProxySet().getProxy(index2.getObjectID());
        }
        if (index2 != null && !index2.isOidKey() && (indexProxy != null && indexProxy.isMarkedGenerate() || indexProxy == null && index2.isMarkedGenerate())) {
            this.storageDesign = (AbstractStorageDesignDB2)tableProxy.getStorageDesign();
            if (index2.getElements().length > 0) {
                String string2;
                if (indexProxy != null && indexProxy.isCommentChanged()) {
                    this.appendComment(stringBuffer, indexProxy);
                } else {
                    this.appendComment(stringBuffer, index2);
                }
                String string3 = string2 = index2.getName();
                if (indexProxy != null) {
                    string3 = indexProxy.getLongName();
                }
                if (string2.length() < 18) {
                    string2 = string2 + "X";
                    string3 = string3 + "X";
                }
                if (string2.length() > 18) {
                    SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 0);
                    SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "--  ERROR: Index name length exceeds maximum allowed length(18)");
                    SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 0);
                    DDLFileMaker.incrementErrors();
                }
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer2, "CREATE");
                if ("Primary Constraint".equals(index2.getIndexState()) || "Unique Constraint".equals(index2.getIndexState())) {
                    SSBIndexDB2v80.appendStringWithSpace(stringBuffer2, "UNIQUE");
                }
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer2, "INDEX");
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer2, storageDesignDB2v80.getFormatedName(string3));
                string = stringBuffer2.toString();
                this.appendTable(stringBuffer2, index2, true);
                this.appendConstraintElementList(stringBuffer2, index2, tableProxy, true);
                SSBIndexDB2v80.appendNewLine(stringBuffer2, bl, 0);
                this.appendLineFinisher(stringBuffer2, bl);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                DDLFileMaker.incrementCreateIndex();
            } else {
                SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 0);
                stringBuffer.append("-- Error - Index ");
                stringBuffer.append(storageDesignDB2v80.getFormatedName(index2.getName()));
                stringBuffer.append(" has no columns");
                SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 0);
                DDLFileMaker.incrementErrors();
            }
        }
    }

    private void appendConstraintElementList(StringBuffer stringBuffer, Index index, TableProxy tableProxy, boolean bl) {
        Object object2;
        ColumnProxy columnProxy = null;
        ArrayList<ColumnProxy> arrayList = new ArrayList<ColumnProxy>();
        for (Object object2 : index.getElementsCollectionImmutable()) {
            ColumnProxy columnProxy2 = tableProxy.getColumnProxy(((ModelIDObject)object2).getObjectID());
            if (columnProxy2 == null) continue;
            arrayList.add(columnProxy2);
        }
        object2 = arrayList.toArray();
        SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
        if (((Object)object2).length < 1) {
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, "-- No Columns");
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
        }
        SSBIndexDB2v80.appendStringWithSpace(stringBuffer, '(');
        for (int i = 0; i < ((Object)object2).length; ++i) {
            if (i != 0) {
                SSBIndexDB2v80.appendStringWithSpace(stringBuffer, ',');
            }
            columnProxy = (ColumnProxy)object2[i];
            SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v80.appendString(stringBuffer, ' ');
            String string = this.storageDesign.getFormatedName(columnProxy.getName());
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, string);
            SSBIndexDB2v80.appendStringWithSpace(stringBuffer, index.getColumnSortOrder(columnProxy));
        }
        SSBIndexDB2v80.appendNewLine(stringBuffer, bl, 1);
        SSBIndexDB2v80.appendStringWithSpace(stringBuffer, ')');
    }
}

