/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.FKProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.FKProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBFKeyDB2v80
extends AbstractSSBDB2 {
    private StorageDesignDB2v80 storageDesign;

    private StorageObject getOwner(Table table) {
        TableProxyDB2 tableProxyDB2 = null;
        tableProxyDB2 = (TableProxyDB2)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxyDB2 != null && tableProxyDB2.getOwner() != null && !tableProxyDB2.getOwner().getName().equalsIgnoreCase("[Implicit]")) {
            return tableProxyDB2.getOwner();
        }
        return null;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        FKProxyDB2 fKProxyDB2;
        ModelIDObject modelIDObject;
        if (object instanceof FKIndexAssociation) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)object;
            modelIDObject = (RelationalDesign)fKIndexAssociation.getDesignPart();
            this.storageDesign = (StorageDesignDB2v80)((RelationalDesign)modelIDObject).getStorageDesign(((RelationalDesign)modelIDObject).getSelectedRDBMSSite());
            fKProxyDB2 = (FKProxyDB2)this.storageDesign.getFKProxySet().getProxy(fKIndexAssociation.getObjectID());
            if (fKProxyDB2 == null && (fKProxyDB2 = (FKProxyDB2)this.storageDesign.getFKProxySet().getProxy(fKIndexAssociation.getLocalFKIndex().getObjectID())) == null) {
                return;
            }
        } else {
            fKProxyDB2 = (FKProxyDB2)object;
            this.storageDesign = (StorageDesignDB2v80)fKProxyDB2.getStorageDesign();
        }
        if (fKProxyDB2.getColumnProxies().length > 0) {
            this.appendBeforeAlterScript(stringBuffer, bl, fKProxyDB2.getTable());
            SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, "ALTER");
            SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, "TABLE");
            modelIDObject = this.getOwner(fKProxyDB2.getTable());
            if (modelIDObject != null) {
                SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(((StorageObject)modelIDObject).getName()) + '.' + this.storageDesign.getFormatedName(fKProxyDB2.getTable().getName()));
            } else {
                SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fKProxyDB2.getTable().getName()));
            }
            SSBFKeyDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, "ADD");
            SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fKProxyDB2.getName()));
            SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, "FOREIGN KEY");
            this.appendColumns(stringBuffer, fKProxyDB2, bl);
            this.appendReferences(stringBuffer, fKProxyDB2, bl);
            this.appendOnDelete(stringBuffer, fKProxyDB2, bl);
            this.appendEnforced(stringBuffer, fKProxyDB2, bl);
            SSBFKeyDB2v80.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            SSBFKeyDB2v80.appendNewLine(stringBuffer, bl, 0);
            DDLFileMaker.incrementAlterTable();
            this.appendAfterAlterScript(stringBuffer, bl, fKProxyDB2.getTable());
        } else {
            SSBFKeyDB2v80.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("-- Error - Foreign Key ");
            stringBuffer.append(this.storageDesign.getFormatedName(fKProxyDB2.getTableName()) + "." + this.storageDesign.getFormatedName(fKProxyDB2.getName()));
            stringBuffer.append(" has no columns");
            SSBFKeyDB2v80.appendNewLine(stringBuffer, bl, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendColumns(StringBuffer stringBuffer, FKProxyDB2 fKProxyDB2, boolean bl) {
        ColumnProxy[] columnProxyArray = fKProxyDB2.getColumnProxies();
        if (columnProxyArray.length > 0) {
            SSBFKeyDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, '(');
            SSBFKeyDB2v80.appendNewLine(stringBuffer, bl, 1);
            for (int i = 0; i < columnProxyArray.length; ++i) {
                SSBFKeyDB2v80.appendString(stringBuffer, ' ');
                SSBFKeyDB2v80.appendString(stringBuffer, this.storageDesign.getFormatedName(columnProxyArray[i].getName()));
                if (i != columnProxyArray.length - 1) {
                    this.appendComma(stringBuffer);
                }
                SSBFKeyDB2v80.appendNewLine(stringBuffer, bl, 1);
            }
            SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, ')');
            SSBFKeyDB2v80.appendNewLine(stringBuffer, bl, 1);
        }
    }

    private void appendReferences(StringBuffer stringBuffer, FKProxyDB2 fKProxyDB2, boolean bl) {
        SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, "REFERENCES");
        StorageObject storageObject = this.getOwner(fKProxyDB2.getRemoteTable());
        if (storageObject != null) {
            SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(storageObject.getName()) + '.' + this.storageDesign.getFormatedName(fKProxyDB2.getRemoteTable().getName()));
        } else {
            SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fKProxyDB2.getRemoteTable().getName()));
        }
        Column[] columnArray = fKProxyDB2.getRefColumns();
        SSBFKeyDB2v80.appendNewLine(stringBuffer, bl, 1);
        SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, '(');
        SSBFKeyDB2v80.appendNewLine(stringBuffer, bl, 1);
        for (int i = 0; i < columnArray.length; ++i) {
            SSBFKeyDB2v80.appendString(stringBuffer, ' ');
            SSBFKeyDB2v80.appendString(stringBuffer, this.storageDesign.getFormatedName(columnArray[i].getName()));
            if (i != columnArray.length - 1) {
                this.appendComma(stringBuffer);
            }
            SSBFKeyDB2v80.appendNewLine(stringBuffer, bl, 1);
        }
        SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, ')');
    }

    private void appendOnDelete(StringBuffer stringBuffer, FKProxyDB2 fKProxyDB2, boolean bl) {
        FKIndexAssociation fKIndexAssociation = ((Index)fKProxyDB2.getObject()).getFKAssociation();
        String string = fKIndexAssociation.getDeleteRule();
        if (string.equalsIgnoreCase("SET DEFAULT")) {
            string = fKIndexAssociation.isMandatory() ? "RESTRICT" : "SET NULL";
        }
        SSBFKeyDB2v80.appendNewLine(stringBuffer, bl, 1);
        SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, "ON");
        SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, "DELETE");
        SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, string);
    }

    private void appendEnforced(StringBuffer stringBuffer, FKProxyDB2 fKProxyDB2, boolean bl) {
        if (fKProxyDB2.getEnforced().equalsIgnoreCase("NO")) {
            SSBFKeyDB2v80.appendNewLine(stringBuffer, bl, 1);
            SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, "NOT");
            SSBFKeyDB2v80.appendStringWithSpace(stringBuffer, "ENFORCED");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof RelationalObjectProxy && !((RelationalObjectProxy)object).getStorageDesign().isOpen()) {
            if (object instanceof FKProxyDB2v80) {
                return ((RelationalObjectProxy)object).getObject().isMarkedGenerate();
            }
        } else if (object instanceof FKIndexAssociation) {
            return ((FKIndexAssociation)object).isMarkedGenerate();
        }
        return object instanceof FKProxyDB2v80 && ((FKProxyDB2v80)object).isMarkedGenerate();
    }
}

