/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v70;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.exports.ddl.db2.v70.SSBIndexDB2v70;
import oracle.dbtools.crest.exports.ddl.oracle.SSBArcFK_CheckConstr;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnIdentityDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeDB2;
import oracle.dbtools.crest.model.design.storage.db2.InstanceDescriptorColumnDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.ColumnProxyDB2v70;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableDB2v70
extends AbstractSSBDB2 {
    private SSBIndexDB2v70 ssbIndex = new SSBIndexDB2v70();
    private AbstractStorageDesignDB2 storageDesign;
    private SSBArcFK_CheckConstr arcConstrHandler;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableProxy;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Table table = null;
        TableProxyDB2 tableProxyDB2 = null;
        if (object == null) {
            return;
        }
        if (object instanceof Table) {
            table = (Table)object;
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(table);
            tableProxyDB2 = (TableProxyDB2)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object instanceof TableProxyDB2) {
            tableProxyDB2 = (TableProxyDB2)object;
            table = (Table)tableProxyDB2.getObject();
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(tableProxyDB2);
        }
        if (tableProxyDB2 != null && !tableProxyDB2.isMarkedGenerate()) {
            this.appendIndexes(stringBuffer, tableProxyDB2, bl);
            return;
        }
        if (table != null && table.getElementsCollection().size() > 0) {
            ColumnProxy[] columnProxyArray;
            if (tableProxyDB2 != null) {
                this.appendSetCurrentRules(stringBuffer, tableProxyDB2, bl);
            }
            if (tableProxyDB2 != null && tableProxyDB2.isCommentChanged()) {
                this.appendComment(stringBuffer, tableProxyDB2);
            } else {
                this.appendComment(stringBuffer, table);
            }
            if (tableProxyDB2 != null && tableProxyDB2.getName().length() > tableProxyDB2.getMaxNameLength()) {
                SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "--  ERROR: Table name length exceeds maximum allowed length(" + tableProxyDB2.getMaxNameLength() + ")");
                SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
                DDLFileMaker.incrementErrors();
            }
            this.appendBeforeCreateScript(stringBuffer, bl, table);
            this.appendCreate(stringBuffer);
            if (tableProxyDB2 == null) {
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "TABLE");
                columnProxyArray = this.storageDesign.getFormatedName(table.getLongName());
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, (String)columnProxyArray);
                this.appendElementList(stringBuffer, table, null, bl);
            } else {
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "TABLE");
                columnProxyArray = this.storageDesign.getFormatedName(tableProxyDB2.getLongName());
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, (String)columnProxyArray);
                this.appendElementList(stringBuffer, table, tableProxyDB2, bl);
                this.appendInDb(stringBuffer, tableProxyDB2, bl);
                this.appendEditProc(stringBuffer, tableProxyDB2, bl);
                this.appendValidProc(stringBuffer, tableProxyDB2, bl);
                this.appendAudit(stringBuffer, tableProxyDB2, bl);
                this.appendObid(stringBuffer, tableProxyDB2, bl);
                this.appendDataCapture(stringBuffer, tableProxyDB2, bl);
                this.appendWithRestrict(stringBuffer, tableProxyDB2, bl);
                this.appendCcid(stringBuffer, tableProxyDB2, bl);
            }
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            DDLFileMaker.incrementCreateTable();
            this.appendAfterCreateScript(stringBuffer, bl, table);
            if (tableProxyDB2 != null) {
                this.appendLabelOn(stringBuffer, tableProxyDB2, bl);
                columnProxyArray = tableProxyDB2.getColumnProxies();
                for (int i = 0; i < columnProxyArray.length; ++i) {
                    this.appendLabelOnColumn(stringBuffer, (ColumnProxyDB2v70)columnProxyArray[i], bl);
                }
            }
            this.appendColumnCheckConstraints(stringBuffer, tableProxyDB2, bl);
            if (this.getArcConstrHandler() != null) {
                this.getArcConstrHandler().appendArcConstraints(stringBuffer, tableProxyDB2, bl);
            }
            if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendTableCommentOn(stringBuffer, table, tableProxyDB2, bl);
            }
            if (tableProxyDB2 != null) {
                this.appendIndexes(stringBuffer, tableProxyDB2, bl);
            }
        } else if (table != null) {
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("-- Error - Table ");
            stringBuffer.append(this.storageDesign.getFormatedName(table.getName()));
            stringBuffer.append(" has no columns");
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendIndexes(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        Iterator iterator = tableProxyDB2.getIndexes().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.ssbIndex.canHandle(e)) continue;
            this.ssbIndex.doAppend(stringBuffer, e, bl);
        }
        this.appendIndexesForConstraints(stringBuffer, (Table)tableProxyDB2.getObject(), tableProxyDB2);
    }

    private void appendSetCurrentRules(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        boolean bl2 = this.hasAUXTables(tableProxyDB2);
        SSBTableDB2v70.appendStringWithSpace(stringBuffer, "SET CURRENT RULES");
        SSBTableDB2v70.appendStringWithSpace(stringBuffer, '=');
        SSBTableDB2v70.appendString(stringBuffer, '\'');
        SSBTableDB2v70.appendString(stringBuffer, bl2 ? "DB2" : "STD");
        SSBTableDB2v70.appendStringWithSpace(stringBuffer, '\'');
        this.appendLineFinisher(stringBuffer, bl);
    }

    private void appendElementList(StringBuffer stringBuffer, Table table, TableProxyDB2 tableProxyDB2, boolean bl) {
        List list = table.getAllNestedElements();
        Column column = null;
        ColumnProxyDB2 columnProxyDB2 = null;
        Object[] objectArray = null;
        if (tableProxyDB2 != null) {
            objectArray = tableProxyDB2.getInstDescriptorCols().toArray();
        }
        SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
        if (list.size() == 0 && (objectArray == null || objectArray.length == 0)) {
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "-- No columns");
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
        } else {
            for (int i = 0; i < list.size(); ++i) {
                if (i == 0) {
                    SSBTableDB2v70.appendStringWithSpace(stringBuffer, '(');
                } else {
                    this.appendComma(stringBuffer);
                }
                SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
                column = (Column)list.get(i);
                if (tableProxyDB2 == null) continue;
                columnProxyDB2 = (ColumnProxyDB2)tableProxyDB2.getColumnProxy(column.getObjectID());
                if (this.storageDesign.getFormatedName(columnProxyDB2.getName()).length() > columnProxyDB2.getMaxNameLength()) {
                    SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
                    SSBTableDB2v70.appendStringWithSpace(stringBuffer, "--  ERROR: Column name length exceeds maximum allowed length(" + columnProxyDB2.getMaxNameLength() + ")");
                    SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
                    DDLFileMaker.incrementErrors();
                }
                if (columnProxyDB2.isCommentChanged() && !"".equalsIgnoreCase(columnProxyDB2.getComment())) {
                    this.appendComment(stringBuffer, columnProxyDB2);
                } else if (!"".equalsIgnoreCase(columnProxyDB2.getObject().getComment())) {
                    this.appendComment(stringBuffer, columnProxyDB2.getObject());
                }
                this.appendColumnDefinition(stringBuffer, columnProxyDB2, bl);
            }
            InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = null;
            for (int i = 0; i < objectArray.length; ++i) {
                instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)objectArray[i];
                if (list.size() == 0 && i == 0) {
                    SSBTableDB2v70.appendString(stringBuffer, '(');
                } else {
                    stringBuffer.append(", ");
                }
                SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(instanceDescriptorColumnDB2.getName()));
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, instanceDescriptorColumnDB2.getDataType());
            }
            this.appendPKDefinition(stringBuffer, table, tableProxyDB2, bl);
            this.appendTableConstraintsDefinition(stringBuffer, table, bl);
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendColumnDefinition(StringBuffer stringBuffer, ColumnProxyDB2 columnProxyDB2, boolean bl) {
        SSBTableDB2v70.appendString(stringBuffer, ' ');
        SSBTableDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyDB2.getName()));
        DistinctTypeDB2 distinctTypeDB2 = columnProxyDB2.getDistinctType();
        if (distinctTypeDB2 != null) {
            this.appendStringWithSpace(stringBuffer, distinctTypeDB2);
        } else {
            String string = columnProxyDB2.getDatatypeString();
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, string);
            if (string.equalsIgnoreCase("unknown")) {
                SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "--  ERROR: Datatype UNKNOWN is not allowed");
                SSBTableDB2v70.appendNewLine(stringBuffer, bl, 5);
                DDLFileMaker.incrementErrors();
            }
        }
        this.appendBitDataDefinition(stringBuffer, columnProxyDB2);
        this.appendNotNullDefinition(stringBuffer, columnProxyDB2);
        this.appendWithDefaultDefinition(stringBuffer, columnProxyDB2);
        this.appendIdentityDefinition(stringBuffer, columnProxyDB2, bl);
        this.appendColumnConstraints(stringBuffer, columnProxyDB2.getColumn(), columnProxyDB2);
        this.appendFieldProcDefinition(stringBuffer, columnProxyDB2);
    }

    protected void appendLabelOnColumn(StringBuffer stringBuffer, ColumnProxyDB2 columnProxyDB2, boolean bl) {
        if (!columnProxyDB2.getLabel().equalsIgnoreCase("")) {
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "LABEL");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "ON");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "COLUMN");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyDB2.getLongName()));
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "IS");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "'" + columnProxyDB2.getLabel() + "'");
            this.appendLineFinisher(stringBuffer, bl);
        }
    }

    protected void appendBitDataDefinition(StringBuffer stringBuffer, ColumnProxyDB2 columnProxyDB2) {
        String string = columnProxyDB2.getBitData();
        if (!"".equalsIgnoreCase(string)) {
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "FOR");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, string);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "DATA");
        }
    }

    protected void appendNotNullDefinition(StringBuffer stringBuffer, ColumnProxyDB2 columnProxyDB2) {
        if (!columnProxyDB2.getColumn().getNullsAllowed()) {
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "NOT NULL");
        }
    }

    private void appendWithDefaultDefinition(StringBuffer stringBuffer, ColumnProxyDB2 columnProxyDB2) {
        String string = columnProxyDB2.getDefaultValueConstant();
        boolean bl = columnProxyDB2.getStorageDesign().isOpen();
        String string2 = "";
        Column column = columnProxyDB2.getColumn();
        boolean bl2 = columnProxyDB2.getDefault();
        if (!bl) {
            string2 = column.getDefaultValue();
            bl2 = column.getUsesDefaultValue();
        } else {
            string2 = columnProxyDB2.getDefaultValue();
        }
        if (bl2) {
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "WITH");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "DEFAULT");
            if (!"".equalsIgnoreCase(string2)) {
                if (string2.equalsIgnoreCase(ColumnProxyDB2.getDefaultValueChoices()[1])) {
                    if (!"".equalsIgnoreCase(string)) {
                        String string3 = columnProxyDB2.getColumn().getDatatypeString("DB2/390 7");
                        String string4 = this.addQuotesToDefault(string3, string);
                        SSBTableDB2v70.appendStringWithSpace(stringBuffer, string4);
                    }
                } else if (string2.equalsIgnoreCase(ColumnProxyDB2.getDefaultValueChoices()[4])) {
                    SSBTableDB2v70.appendStringWithSpace(stringBuffer, string);
                } else {
                    String string5 = columnProxyDB2.getColumn().getDatatypeString("DB2/390 7");
                    String string6 = this.addQuotesToDefault(string5, string2);
                    SSBTableDB2v70.appendStringWithSpace(stringBuffer, string6);
                }
            }
        }
    }

    protected void appendIdentityDefinition(StringBuffer stringBuffer, ColumnProxyDB2 columnProxyDB2, boolean bl) {
        ColumnIdentityDB2 columnIdentityDB2;
        Column column = columnProxyDB2.getColumn();
        if (column.isIdentityColumn() && columnProxyDB2.isUseIdentity() && (columnIdentityDB2 = columnProxyDB2.getColumnIdentity()) != null) {
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "GENERATED");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, columnIdentityDB2.getGenerate());
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "AS");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "IDENTITY");
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 2);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, '(');
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 2);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "START");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "WITH");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, columnIdentityDB2.getStartWith());
            this.appendComma(stringBuffer);
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 2);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "INCREMENT");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "BY");
            this.appendStringWithSpace(stringBuffer, columnIdentityDB2.getIncrementBy());
            this.appendComma(stringBuffer);
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 2);
            if (columnIdentityDB2.getCache() == 0) {
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "NO");
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "CACHE");
            } else {
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "CACHE");
                this.appendStringWithSpace(stringBuffer, columnIdentityDB2.getCache());
            }
            this.appendComma(stringBuffer);
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 2);
            if (columnIdentityDB2.isCycle()) {
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "CYCLE");
            } else {
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "NO");
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "CYCLE");
            }
            if (!"".equalsIgnoreCase(columnIdentityDB2.getMaxValue().trim())) {
                this.appendComma(stringBuffer);
                SSBTableDB2v70.appendNewLine(stringBuffer, bl, 2);
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "MAXVALUE");
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, columnIdentityDB2.getMaxValue());
            }
            if (!"".equalsIgnoreCase(columnIdentityDB2.getMinValue().trim())) {
                this.appendComma(stringBuffer);
                SSBTableDB2v70.appendNewLine(stringBuffer, bl, 2);
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "MINVALUE");
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, columnIdentityDB2.getMinValue());
            }
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 2);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendFieldProcDefinition(StringBuffer stringBuffer, ColumnProxyDB2 columnProxyDB2) {
        String string;
        if (!(columnProxyDB2.getDefault() || (string = columnProxyDB2.getProgram()) == null || string.trim().equals("") || string.trim().equalsIgnoreCase("NULL"))) {
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "FIELDPROC");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, string);
            String string2 = columnProxyDB2.getConstant();
            if (string2 != null && !string2.trim().equals("") && !string2.trim().equalsIgnoreCase("NULL")) {
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, '(');
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, string2);
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendColumnConstraints(StringBuffer stringBuffer, Column column, ColumnProxyDB2 columnProxyDB2) {
        String string;
        if (column.hasConstraintsDefined() && !"".equals(string = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxyDB2.getName())))) {
            String string2 = column.getConstraintName();
            if (!string2.equals("") && string2.length() <= 18 || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "CHECK");
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, '(');
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, string);
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, ')');
            }
            if ("".equals(string2) || !"".equals(string2) && string2.length() > 18 || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "CHECK");
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, '(');
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, string);
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendPKDefinition(StringBuffer stringBuffer, Table table, TableProxyDB2 tableProxyDB2, boolean bl) {
        int n;
        DesignObject[] designObjectArray;
        KeyObject keyObject = table.getPK();
        if (keyObject != null && keyObject.isMarkedGenerate()) {
            designObjectArray = (Column[])keyObject.getElements();
            if (designObjectArray.length > 0) {
                this.appendComma(stringBuffer);
                SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
                if (tableProxyDB2 != null) {
                    SSBTableDB2v70.appendString(stringBuffer, ' ');
                    SSBTableDB2v70.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                    SSBTableDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(keyObject.getName()));
                    SSBTableDB2v70.appendStringWithSpace(stringBuffer, "PRIMARY KEY");
                    SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
                    SSBTableDB2v70.appendString(stringBuffer, '(');
                    for (n = 0; n < designObjectArray.length; ++n) {
                        if (n != 0) {
                            this.appendComma(stringBuffer);
                        }
                        SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
                        SSBTableDB2v70.appendString(stringBuffer, " " + this.storageDesign.getFormatedName(((ContainedObject)designObjectArray[n]).getName()));
                    }
                    SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
                    SSBTableDB2v70.appendString(stringBuffer, ')');
                }
            } else {
                SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
                stringBuffer.append("-- Error - Primary Key ");
                stringBuffer.append(this.storageDesign.getFormatedName(keyObject.getName()));
                stringBuffer.append(" has no columns");
                DDLFileMaker.incrementErrors();
            }
        }
        if ((designObjectArray = (Index[])table.getKeys()).length > 0) {
            for (n = 0; n < designObjectArray.length; ++n) {
                Column[] columnArray;
                DesignObject designObject = designObjectArray[n];
                if (!((Index)designObject).getIndexState().equalsIgnoreCase("Unique Constraint") || !designObject.isMarkedGenerate() || (columnArray = (Column[])((ContainerObject)designObject).getElements()).length <= 0) continue;
                this.appendComma(stringBuffer);
                SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(designObject.getName()));
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "UNIQUE");
                SSBTableDB2v70.appendString(stringBuffer, '(');
                for (int i = 0; i < columnArray.length; ++i) {
                    if (i != 0) {
                        this.appendComma(stringBuffer);
                    }
                    stringBuffer.append(this.storageDesign.getFormatedName(columnArray[i].getName()));
                }
                SSBTableDB2v70.appendString(stringBuffer, ')');
            }
        }
    }

    private void appendTableConstraintsDefinition(StringBuffer stringBuffer, Table table, boolean bl) {
        for (TableLevelConstraint tableLevelConstraint : table.getCheckConstraints()) {
            this.appendComma(stringBuffer);
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v70.appendString(stringBuffer, ' ');
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableLevelConstraint.getName()));
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "CHECK");
            SSBTableDB2v70.appendString(stringBuffer, '(');
            SSBTableDB2v70.appendString(stringBuffer, tableLevelConstraint.getRule());
            SSBTableDB2v70.appendString(stringBuffer, ')');
        }
    }

    private void appendInDb(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        DataBaseDB2 dataBaseDB2 = tableProxyDB2.getDataBase();
        TableSpaceDB2 tableSpaceDB2 = tableProxyDB2.getTableSpace();
        if (tableSpaceDB2 != null) {
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "IN");
            if (dataBaseDB2 != null) {
                SSBTableDB2v70.appendString(stringBuffer, this.storageDesign.getFormatedName(dataBaseDB2.getLongName()));
                SSBTableDB2v70.appendString(stringBuffer, '.');
            }
            SSBTableDB2v70.appendString(stringBuffer, this.storageDesign.getFormatedName(tableSpaceDB2.getLongName()));
        } else if (dataBaseDB2 != null) {
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "IN");
            SSBTableDB2v70.appendString(stringBuffer, this.storageDesign.getFormatedName(dataBaseDB2.getLongName()));
        }
    }

    private void appendEditProc(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        if (!tableProxyDB2.getEditProc().equalsIgnoreCase("")) {
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "EDITPROC");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, tableProxyDB2.getEditProc());
        }
    }

    private void appendValidProc(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        if (!tableProxyDB2.getValidProc().equalsIgnoreCase("")) {
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "VALIDPROC");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, tableProxyDB2.getValidProc());
        }
    }

    private void appendAudit(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        if (!tableProxyDB2.getAudit().equalsIgnoreCase("NONE")) {
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "AUDIT");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, tableProxyDB2.getAudit());
        }
    }

    private void appendObid(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        if (tableProxyDB2.getObid() > 0) {
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "OBID");
            this.appendStringWithSpace(stringBuffer, tableProxyDB2.getObid());
        }
    }

    private void appendDataCapture(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        if (tableProxyDB2.getDataCapture()) {
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "DATA CAPTURE");
            if (tableProxyDB2.getDataCapture()) {
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "CHANGES");
            }
        }
    }

    private void appendWithRestrict(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        if (tableProxyDB2.getDropRestrict()) {
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "WITH RESTRICT ON DROP");
        }
    }

    private void appendCcid(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        if (!tableProxyDB2.getCcsid().equalsIgnoreCase("")) {
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "CCSID");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, tableProxyDB2.getCcsid());
        }
    }

    private void appendLabelOn(StringBuffer stringBuffer, TableProxyDB2 tableProxyDB2, boolean bl) {
        if (!tableProxyDB2.getLabel().equalsIgnoreCase("")) {
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "LABEL");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "ON");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "TABLE");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyDB2.getLongName()));
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "IS");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "'" + tableProxyDB2.getLabel() + "'");
            this.appendLineFinisher(stringBuffer, bl);
        }
    }

    private void appendColumnCheckConstraints(StringBuffer stringBuffer, TableProxy tableProxy, boolean bl) {
        ColumnProxy[] columnProxyArray = tableProxy.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            Column column = columnProxy.getColumn();
            if (!column.hasConstraintsDefined()) continue;
            String string = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy.getName()));
            String string2 = column.getConstraintName();
            if ("".equals(string) || "".equals(string2) || string2.length() >= 19) continue;
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "ALTER");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "TABLE");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "ADD");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, "CHECK");
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, '(');
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, string);
            SSBTableDB2v70.appendStringWithSpace(stringBuffer, ')');
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
        }
    }

    protected void appendTableCommentOn(StringBuffer stringBuffer, Table table, TableProxyDB2 tableProxyDB2, boolean bl) {
        block6: {
            block5: {
                if (tableProxyDB2 == null) break block5;
                this.appendCommentOn(stringBuffer, tableProxyDB2, bl);
                ColumnProxy[] columnProxyArray = tableProxyDB2.getColumnProxies();
                ColumnProxy columnProxy = null;
                for (int i = 0; i < columnProxyArray.length; ++i) {
                    String string;
                    columnProxy = columnProxyArray[i];
                    String string2 = "";
                    if (columnProxy.getCommentInRDBMS() != null && columnProxy.isCommentInRDBMSChanged()) {
                        string2 = columnProxy.getCommentInRDBMS();
                        string = columnProxy.getLongName();
                    } else {
                        string2 = columnProxy.getObject().getCommentInRDBMS();
                        string = ((Column)columnProxy.getObject()).getLongName();
                    }
                    if (string2.equalsIgnoreCase("")) continue;
                    SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
                    SSBTableDB2v70.appendStringWithSpace(stringBuffer, "COMMENT ON");
                    SSBTableDB2v70.appendStringWithSpace(stringBuffer, "COLUMN");
                    SSBTableDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
                    SSBTableDB2v70.appendStringWithSpace(stringBuffer, "IS");
                    SSBTableDB2v70.appendString(stringBuffer, '\'');
                    SSBTableDB2v70.appendString(stringBuffer, string2);
                    SSBTableDB2v70.appendStringWithSpace(stringBuffer, '\'');
                    SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
                    this.appendLineFinisher(stringBuffer, bl);
                }
                break block6;
            }
            if (table == null) break block6;
            if (table.getCommentInRDBMS() != null && !"".equalsIgnoreCase(table.getCommentInRDBMS())) {
                SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "COMMENT ON");
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "TABLE");
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(table.getLongName()));
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "IS");
                SSBTableDB2v70.appendString(stringBuffer, '\'');
                SSBTableDB2v70.appendString(stringBuffer, table.getCommentInRDBMS());
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, '\'');
                SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
            }
            ContainedObject[] containedObjectArray = table.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Column column = (Column)containedObjectArray[i];
                if (column.getCommentInRDBMS() == null || "".equalsIgnoreCase(column.getCommentInRDBMS())) continue;
                SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "COMMENT ON");
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "COLUMN");
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(column.getLongName()));
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, "IS");
                SSBTableDB2v70.appendString(stringBuffer, '\'');
                SSBTableDB2v70.appendString(stringBuffer, column.getCommentInRDBMS());
                SSBTableDB2v70.appendStringWithSpace(stringBuffer, '\'');
                SSBTableDB2v70.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
            }
        }
    }

    private boolean hasAUXTables(TableProxyDB2 tableProxyDB2) {
        try {
            Iterator iterator = ((AbstractStorageDesignDB2)tableProxyDB2.getStorageDesign()).getAUXTableSet().iterator();
            while (iterator.hasNext()) {
                AUXTableDB2 aUXTableDB2 = (AUXTableDB2)iterator.next();
                if (!tableProxyDB2.getName().trim().equalsIgnoreCase(aUXTableDB2.getTable().getName())) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void appendIndexesForConstraints(StringBuffer stringBuffer, Table table, TableProxy tableProxy) {
        KeyObject[] keyObjectArray = table.getKeys();
        boolean bl = table.getDesign().getDLSettings().isAutomaticPKGeneration();
        boolean bl2 = table.getDesign().getDLSettings().isAutomaticUKGeneration();
        boolean bl3 = table.getDesign().getDLSettings().isAutomaticFKGeneration();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            Index index;
            ContainedObject[] containedObjectArray;
            Index index2 = (Index)keyObjectArray[i];
            if (!(bl && "Primary Constraint".equals(index2.getIndexState()) || bl2 && "Unique Constraint".equals(index2.getIndexState())) && (!index2.isFK() || !bl3) || (containedObjectArray = index2.getElements()).length <= 0 || (index = this.getIndexForColumns(table, index2, containedObjectArray, false)) != null) continue;
            this.ssbIndex.appendIndexForConstraint(stringBuffer, index2, tableProxy, true);
        }
    }

    private Index getIndexForColumns(Table table, Index index, ContainedObject[] containedObjectArray, boolean bl) {
        Object[] objectArray = table.getIndexes().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignObjectPlaceHolder designObjectPlaceHolder = (DesignObjectPlaceHolder)objectArray[i];
            Index index2 = (Index)designObjectPlaceHolder.getDesignObject();
            ContainedObject[] containedObjectArray2 = index2.getElements();
            if (containedObjectArray.length != containedObjectArray2.length) continue;
            boolean bl2 = false;
            for (int j = 0; j < containedObjectArray.length; ++j) {
                String string;
                if (containedObjectArray[j] != containedObjectArray2[j]) {
                    bl2 = true;
                    break;
                }
                if (!bl || "ASC".equalsIgnoreCase(string = index2.getColumnSortOrder(containedObjectArray2[j]).trim()) || "".equalsIgnoreCase(string)) continue;
                bl2 = true;
                break;
            }
            if (bl2 || index2 == index) continue;
            return index2;
        }
        return null;
    }

    public SSBArcFK_CheckConstr getArcConstrHandler() {
        if (this.arcConstrHandler == null && this.storageDesign != null) {
            this.arcConstrHandler = new SSBArcFK_CheckConstr(this.storageDesign);
        }
        return this.arcConstrHandler;
    }
}

