/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v70;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBStoredProcedureDB2v70
extends AbstractSSBDB2 {
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StoredProcedureDB2 storedProcedureDB2 = (StoredProcedureDB2)object;
        this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(storedProcedureDB2);
        this.appendComment(stringBuffer, storedProcedureDB2);
        this.appendCreate(stringBuffer, storedProcedureDB2);
        this.appendBody(stringBuffer, storedProcedureDB2, bl);
        SSBStoredProcedureDB2v70.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
        if (storedProcedureDB2.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(stringBuffer, storedProcedureDB2, bl);
        }
        DDLFileMaker.incrementCreateProc();
        this.appendExecutePrivileges(stringBuffer, storedProcedureDB2, bl);
    }

    private void appendCommentOn(StringBuffer stringBuffer, StoredProcedureDB2 storedProcedureDB2, boolean bl) {
        SSBStoredProcedureDB2v70.appendNewLine(stringBuffer, bl, 0);
        SSBStoredProcedureDB2v70.appendStringWithSpace(stringBuffer, "COMMENT ON");
        SSBStoredProcedureDB2v70.appendStringWithSpace(stringBuffer, "PROCEDURE");
        SSBStoredProcedureDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(storedProcedureDB2.getLongName()));
        SSBStoredProcedureDB2v70.appendStringWithSpace(stringBuffer, "IS");
        SSBStoredProcedureDB2v70.appendString(stringBuffer, '\'');
        SSBStoredProcedureDB2v70.appendString(stringBuffer, storedProcedureDB2.getCommentInRDBMS());
        SSBStoredProcedureDB2v70.appendStringWithSpace(stringBuffer, '\'');
        SSBStoredProcedureDB2v70.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
    }

    private void appendCreate(StringBuffer stringBuffer, StoredProcedureDB2 storedProcedureDB2) {
        this.appendCreate(stringBuffer);
        SSBStoredProcedureDB2v70.appendStringWithSpace(stringBuffer, "PROCEDURE");
        if (storedProcedureDB2.getOwner() != null) {
            SSBStoredProcedureDB2v70.appendString(stringBuffer, this.storageDesign.getFormatedName(storedProcedureDB2.getOwner().getName()));
            SSBStoredProcedureDB2v70.appendString(stringBuffer, ".");
        }
        SSBStoredProcedureDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(storedProcedureDB2.getName()));
    }

    private void appendBody(StringBuffer stringBuffer, StoredProcedureDB2 storedProcedureDB2, boolean bl) {
        SSBStoredProcedureDB2v70.appendNewLine(stringBuffer, bl, 1);
        if (!storedProcedureDB2.getBody().trim().equalsIgnoreCase("")) {
            SSBStoredProcedureDB2v70.appendStringWithSpace(stringBuffer, storedProcedureDB2.getBody());
        } else {
            SSBStoredProcedureDB2v70.appendStringWithSpace(stringBuffer, " -- Empty body");
        }
    }

    private void appendExecutePrivileges(StringBuffer stringBuffer, StoredProcedureDB2 storedProcedureDB2, boolean bl) {
        if (!storedProcedureDB2.getUsers().equalsIgnoreCase("")) {
            SSBStoredProcedureDB2v70.appendNewLine(stringBuffer, bl, 0);
            SSBStoredProcedureDB2v70.appendStringWithSpace(stringBuffer, "GRANT");
            SSBStoredProcedureDB2v70.appendStringWithSpace(stringBuffer, "EXECUTE");
            SSBStoredProcedureDB2v70.appendStringWithSpace(stringBuffer, "ON");
            SSBStoredProcedureDB2v70.appendStringWithSpace(stringBuffer, "PROCEDURE");
            SSBStoredProcedureDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(storedProcedureDB2.getName()));
            SSBStoredProcedureDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBStoredProcedureDB2v70.appendStringWithSpace(stringBuffer, "TO");
            SSBStoredProcedureDB2v70.appendStringWithSpace(stringBuffer, storedProcedureDB2.getUsers());
            if ("YES".equalsIgnoreCase(storedProcedureDB2.getGrantOption())) {
                SSBStoredProcedureDB2v70.appendNewLine(stringBuffer, bl, 1);
                SSBStoredProcedureDB2v70.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
            }
            SSBStoredProcedureDB2v70.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            SSBStoredProcedureDB2v70.appendNewLine(stringBuffer, bl, 0);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof StoredProcedureDB2 && ((StoredProcedureDB2)object).isMarkedGenerate();
    }
}

