/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v70;

import java.util.ArrayList;
import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexDB2v70
extends AbstractSSBDB2 {
    AbstractStorageDesignDB2 storageDesign;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && !((Index)object).isFK() && ((Index)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof IndexProxy && ((IndexProxy)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Index index = null;
        IndexProxyDB2 indexProxyDB2 = null;
        if (object instanceof Index) {
            index = (Index)object;
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(index);
            indexProxyDB2 = (IndexProxyDB2)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxyDB2) {
            indexProxyDB2 = (IndexProxyDB2)object;
            index = (Index)indexProxyDB2.getObject();
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(indexProxyDB2);
        }
        if (index != null && indexProxyDB2 != null && index.getElementsCollection().size() > 0) {
            if (indexProxyDB2.isMarkedGenerate()) {
                if (indexProxyDB2.isCommentChanged()) {
                    this.appendComment(stringBuffer, indexProxyDB2);
                } else {
                    this.appendComment(stringBuffer, index);
                }
                this.appendCreate(stringBuffer);
                this.appendUnique(stringBuffer, indexProxyDB2);
                this.appendNotNull(stringBuffer, indexProxyDB2);
                SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "INDEX");
                SSBIndexDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyDB2.getLongName()));
                this.appendTable(stringBuffer, index, bl);
                this.appendElementList(stringBuffer, index, indexProxyDB2, true);
                this.appendUsingBlock(stringBuffer, indexProxyDB2.getStorageTemplate(), bl);
                this.appendFreeBlock(stringBuffer, indexProxyDB2.getStorageTemplate(), bl);
                this.appendGbpCacheBlock(stringBuffer, indexProxyDB2.getStorageTemplate(), bl);
                this.appendDefine(stringBuffer, indexProxyDB2.getStorageTemplate(), bl);
                this.appendCluster(stringBuffer, indexProxyDB2, bl);
                this.appendBufferPool(stringBuffer, indexProxyDB2, bl);
                this.appendClose(stringBuffer, indexProxyDB2, bl);
                this.appendDefer(stringBuffer, indexProxyDB2, bl);
                this.appendCopy(stringBuffer, indexProxyDB2, bl);
                this.appendPieceSize(stringBuffer, indexProxyDB2, bl);
                SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
                DDLFileMaker.incrementCreateIndex();
                if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendIndexComment(stringBuffer, index, indexProxyDB2, bl);
                }
            } else if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendIndexComment(stringBuffer, index, indexProxyDB2, bl);
            }
        } else if (index != null) {
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("-- Error - Index ");
            stringBuffer.append(this.storageDesign.getFormatedName(index.getContainerWithKeyObject().getName()) + "." + this.storageDesign.getFormatedName(index.getName()));
            stringBuffer.append(" has no columns");
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendIndexComment(StringBuffer stringBuffer, Index index, IndexProxyDB2 indexProxyDB2, boolean bl) {
        if (indexProxyDB2 != null && indexProxyDB2.isCommentInRDBMSChanged()) {
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 0);
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "COMMENT ON");
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "INDEX");
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyDB2.getLongName()));
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "IS");
            SSBIndexDB2v70.appendString(stringBuffer, '\'');
            SSBIndexDB2v70.appendString(stringBuffer, indexProxyDB2.getCommentInRDBMS());
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
        } else if (index != null && !"".equalsIgnoreCase(index.getCommentInRDBMS().trim())) {
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 0);
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "COMMENT ON");
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "INDEX");
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(index.getLongName()));
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "IS");
            SSBIndexDB2v70.appendString(stringBuffer, '\'');
            SSBIndexDB2v70.appendString(stringBuffer, index.getCommentInRDBMS());
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
        }
    }

    protected void appendTable(StringBuffer stringBuffer, Index index, boolean bl) {
        Table table = (Table)index.getTopLevelContainer();
        TableProxy tableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 1);
        if (tableProxy != null) {
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "ON");
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
        }
    }

    protected void appendElementList(StringBuffer stringBuffer, Index index, IndexProxyDB2 indexProxyDB2, boolean bl) {
        if (index.hasIndexExpression()) {
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, '(');
            SSBIndexDB2v70.appendString(stringBuffer, index.getIndexExpression());
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, ')');
        } else {
            ColumnProxy[] columnProxyArray = indexProxyDB2.getColumnProxies();
            ColumnProxy columnProxy = null;
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, '(');
            for (int i = 0; i < columnProxyArray.length; ++i) {
                columnProxy = columnProxyArray[i];
                SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 1);
                SSBIndexDB2v70.appendString(stringBuffer, ' ');
                SSBIndexDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxy.getName()));
                SSBIndexDB2v70.appendStringWithSpace(stringBuffer, index.getColumnSortOrder(columnProxy));
                if (i >= columnProxyArray.length - 1) continue;
                this.appendComma(stringBuffer);
            }
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendUnique(StringBuffer stringBuffer, IndexProxyDB2 indexProxyDB2) {
        if (indexProxyDB2.isUnique()) {
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "UNIQUE");
        }
    }

    protected void appendNotNull(StringBuffer stringBuffer, IndexProxyDB2 indexProxyDB2) {
        if (indexProxyDB2.isUniquePlainIndex() && indexProxyDB2.isWhereNotNull()) {
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "WHERE NOT NULL");
        }
    }

    protected void appendUsingBlock(StringBuffer stringBuffer, StorageTemplateDB2 storageTemplateDB2, boolean bl) {
        if (storageTemplateDB2 != null) {
            VCatDB2 vCatDB2 = storageTemplateDB2.getVCat();
            if (vCatDB2 != null) {
                SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 2);
                SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "USING");
                SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "VCAT");
                SSBIndexDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(vCatDB2.getName()));
            } else {
                StorageGroupDB2 storageGroupDB2 = storageTemplateDB2.getStorageGroup();
                if (storageGroupDB2 != null) {
                    SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 2);
                    SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "USING");
                    SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "STOGROUP");
                    SSBIndexDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(storageGroupDB2.getLongName()));
                    SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 2);
                    SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "PRIQTY");
                    this.appendStringWithSpace(stringBuffer, storageTemplateDB2.getSgPriqty());
                    SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 2);
                    SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "SECQTY");
                    this.appendStringWithSpace(stringBuffer, storageTemplateDB2.getSgSeqty());
                    SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 2);
                    SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "ERASE");
                    SSBIndexDB2v70.appendStringWithSpace(stringBuffer, storageTemplateDB2.isSgErase() ? "YES" : "NO");
                }
            }
        }
    }

    protected void appendFreeBlock(StringBuffer stringBuffer, StorageTemplateDB2 storageTemplateDB2, boolean bl) {
        if (storageTemplateDB2 != null) {
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 2);
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "FREEPAGE");
            this.appendStringWithSpace(stringBuffer, storageTemplateDB2.getFreePage());
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 2);
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "PCTFREE");
            this.appendStringWithSpace(stringBuffer, storageTemplateDB2.getPctFree());
        }
    }

    protected void appendGbpCacheBlock(StringBuffer stringBuffer, StorageTemplateDB2 storageTemplateDB2, boolean bl) {
        if (storageTemplateDB2 != null && !"".equalsIgnoreCase(storageTemplateDB2.getGbCache())) {
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 2);
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "GBPCACHE");
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, storageTemplateDB2.getGbCache());
        }
    }

    protected void appendDefine(StringBuffer stringBuffer, StorageTemplateDB2 storageTemplateDB2, boolean bl) {
        if (storageTemplateDB2 != null && !storageTemplateDB2.isDefine()) {
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 2);
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "DEFINE");
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, storageTemplateDB2.isDefine() ? "YES" : "NO");
        }
    }

    protected void appendCluster(StringBuffer stringBuffer, IndexProxyDB2 indexProxyDB2, boolean bl) {
        if (!indexProxyDB2.getClusterType().equalsIgnoreCase("NONE")) {
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "CLUSTER");
            if (indexProxyDB2.getClusterType().equalsIgnoreCase(IndexProxyDB2.CLUSTER_TYPES[2]) && indexProxyDB2.getNumParts() > 0) {
                this.appendPartitions(stringBuffer, indexProxyDB2, bl);
            }
        }
    }

    protected void appendPartitions(StringBuffer stringBuffer, IndexProxyDB2 indexProxyDB2, boolean bl) {
        IndexPartitionDB2[] indexPartitionDB2Array = indexProxyDB2.getPartitions();
        SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 1);
        SSBIndexDB2v70.appendStringWithSpace(stringBuffer, '(');
        for (int i = 0; i < indexPartitionDB2Array.length; ++i) {
            IndexPartitionDB2 indexPartitionDB2 = indexPartitionDB2Array[i];
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "PART");
            this.appendStringWithSpace(stringBuffer, indexPartitionDB2.getPartNumber());
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "VALUES");
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, '(');
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, indexPartitionDB2.getPartConstants());
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, ')');
            this.appendUsingBlock(stringBuffer, indexPartitionDB2.getStorageTemplate(), bl);
            this.appendFreeBlock(stringBuffer, indexPartitionDB2.getStorageTemplate(), bl);
            this.appendGbpCacheBlock(stringBuffer, indexPartitionDB2.getStorageTemplate(), bl);
            if (i >= indexPartitionDB2Array.length - 1) continue;
            this.appendComma(stringBuffer);
        }
        SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 1);
        SSBIndexDB2v70.appendStringWithSpace(stringBuffer, ')');
    }

    protected void appendBufferPool(StringBuffer stringBuffer, IndexProxyDB2 indexProxyDB2, boolean bl) {
        BufferPoolDB2 bufferPoolDB2 = indexProxyDB2.getBufferPool();
        if (bufferPoolDB2 != null) {
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "BUFFERPOOL");
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(bufferPoolDB2.getLongName()));
        }
    }

    protected void appendClose(StringBuffer stringBuffer, IndexProxyDB2 indexProxyDB2, boolean bl) {
        if (!indexProxyDB2.isClose()) {
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "CLOSE");
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, indexProxyDB2.isClose() ? "YES" : "NO");
        }
    }

    protected void appendDefer(StringBuffer stringBuffer, IndexProxyDB2 indexProxyDB2, boolean bl) {
        SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 1);
        SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "DEFER");
        SSBIndexDB2v70.appendStringWithSpace(stringBuffer, indexProxyDB2.isDefer() ? "YES" : "NO");
    }

    protected void appendCopy(StringBuffer stringBuffer, IndexProxyDB2 indexProxyDB2, boolean bl) {
        if (indexProxyDB2.isCopy()) {
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "COPY");
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, indexProxyDB2.isCopy() ? "YES" : "NO");
        }
    }

    protected void appendPieceSize(StringBuffer stringBuffer, IndexProxyDB2 indexProxyDB2, boolean bl) {
        if (!indexProxyDB2.getPieceSize().equalsIgnoreCase(" ")) {
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "PIECESIZE");
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, indexProxyDB2.getPieceSize());
        }
    }

    public void appendIndexForConstraint(StringBuffer stringBuffer, Index index, TableProxy tableProxy, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        Index index2 = null;
        index2 = index;
        StorageDesign storageDesign = this.getStorageDesign(index2);
        if (index2 != null && !index2.isOidKey()) {
            this.storageDesign = (AbstractStorageDesignDB2)tableProxy.getStorageDesign();
            if (index2.isMarkedGenerate()) {
                if (index2.getElements().length > 0) {
                    String string2 = index2.getName();
                    if (string2.length() < 18) {
                        string2 = string2 + "X";
                    }
                    if (string2.length() > 18) {
                        SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 0);
                        SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "--  ERROR: Index name length exceeds maximum allowed length(18)");
                        SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    SSBIndexDB2v70.appendStringWithSpace(stringBuffer2, "CREATE");
                    if ("Primary Constraint".equals(index2.getIndexState()) || "Unique Constraint".equals(index2.getIndexState())) {
                        SSBIndexDB2v70.appendStringWithSpace(stringBuffer2, "UNIQUE");
                    }
                    SSBIndexDB2v70.appendStringWithSpace(stringBuffer2, "INDEX");
                    SSBIndexDB2v70.appendStringWithSpace(stringBuffer2, storageDesign.getFormatedName(string2));
                    string = stringBuffer2.toString();
                    this.appendTable(stringBuffer2, index2, true);
                    this.appendConstraintElementList(stringBuffer2, index2, tableProxy, true);
                    SSBIndexDB2v70.appendNewLine(stringBuffer2, bl, 0);
                    this.appendLineFinisher(stringBuffer2, bl);
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    DDLFileMaker.incrementCreateIndex();
                } else {
                    SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 0);
                    stringBuffer.append("-- Error - Index ");
                    stringBuffer.append(storageDesign.getFormatedName(index2.getName()));
                    stringBuffer.append(" has no columns");
                    SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 0);
                    DDLFileMaker.incrementErrors();
                }
            }
        }
    }

    private void appendConstraintElementList(StringBuffer stringBuffer, Index index, TableProxy tableProxy, boolean bl) {
        Object object2;
        ColumnProxy columnProxy = null;
        ArrayList<ColumnProxy> arrayList = new ArrayList<ColumnProxy>();
        for (Object object2 : index.getElementsCollectionImmutable()) {
            ColumnProxy columnProxy2 = tableProxy.getColumnProxy(((ModelIDObject)object2).getObjectID());
            if (columnProxy2 == null) continue;
            arrayList.add(columnProxy2);
        }
        object2 = arrayList.toArray();
        SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 1);
        if (((Object)object2).length < 1) {
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, "-- No Columns");
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 1);
        }
        SSBIndexDB2v70.appendStringWithSpace(stringBuffer, '(');
        for (int i = 0; i < ((Object)object2).length; ++i) {
            if (i != 0) {
                SSBIndexDB2v70.appendStringWithSpace(stringBuffer, ',');
            }
            columnProxy = (ColumnProxy)object2[i];
            SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 1);
            SSBIndexDB2v70.appendString(stringBuffer, ' ');
            String string = this.storageDesign.getFormatedName(columnProxy.getName());
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, string);
            SSBIndexDB2v70.appendStringWithSpace(stringBuffer, index.getColumnSortOrder(columnProxy));
        }
        SSBIndexDB2v70.appendNewLine(stringBuffer, bl, 1);
        SSBIndexDB2v70.appendStringWithSpace(stringBuffer, ')');
    }
}

