/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v70;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBFKeyDB2v70
extends AbstractSSBDB2 {
    AbstractStorageDesignDB2 storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Index index = object instanceof FKIndexAssociation ? ((FKIndexAssociation)object).getLocalFKIndex() : (Index)object;
        this.storageDesign = (AbstractStorageDesignDB2)((RelationalDesign)index.getDesignPart()).getStorageDesign();
        this.appendFKDefinition(stringBuffer, index, bl);
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isFK()) {
            FKIndexAssociation fKIndexAssociation = ((Index)object).getFKAssociation();
            if (fKIndexAssociation.isMarkedGenerate()) {
                return true;
            }
        } else if (object instanceof FKIndexAssociation) {
            return ((FKIndexAssociation)object).isMarkedGenerate();
        }
        return false;
    }

    private StorageObject getOwner(Table table) {
        TableProxyDB2 tableProxyDB2 = null;
        tableProxyDB2 = (TableProxyDB2)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxyDB2 != null && tableProxyDB2.getOwner() != null && !tableProxyDB2.getOwner().getName().equalsIgnoreCase("[Implicit]")) {
            return tableProxyDB2.getOwner();
        }
        return null;
    }

    private void appendFKDefinition(StringBuffer stringBuffer, Index index, boolean bl) {
        FKIndexAssociation fKIndexAssociation = index.getFKAssociation();
        Index index2 = fKIndexAssociation.getLocalFKIndex();
        if (index2 != null) {
            Column[] columnArray = (Column[])index2.getElements();
            if (columnArray != null && columnArray.length > 0) {
                SSBFKeyDB2v70.appendNewLine(stringBuffer, bl, 0);
                this.appendBeforeAlterScript(stringBuffer, bl, fKIndexAssociation.getTable());
                SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, "ALTER");
                SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, "TABLE");
                StorageObject storageObject = this.getOwner(fKIndexAssociation.getTable());
                if (storageObject != null) {
                    SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(storageObject.getName()) + '.' + this.storageDesign.getFormatedName(fKIndexAssociation.getTable().getName()));
                } else {
                    SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fKIndexAssociation.getTable().getName()));
                }
                SSBFKeyDB2v70.appendNewLine(stringBuffer, bl, 1);
                SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, "ADD");
                SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fKIndexAssociation.getName()));
                SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, "FOREIGN KEY");
                SSBFKeyDB2v70.appendNewLine(stringBuffer, bl, 1);
                SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, '(');
                for (int i = 0; i < columnArray.length; ++i) {
                    SSBFKeyDB2v70.appendNewLine(stringBuffer, bl, 1);
                    SSBFKeyDB2v70.appendString(stringBuffer, ' ');
                    SSBFKeyDB2v70.appendString(stringBuffer, this.storageDesign.getFormatedName(columnArray[i].getName()));
                    if (i >= columnArray.length - 1) continue;
                    this.appendComma(stringBuffer);
                }
                SSBFKeyDB2v70.appendNewLine(stringBuffer, bl, 1);
                SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, ')');
                SSBFKeyDB2v70.appendNewLine(stringBuffer, bl, 1);
                SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, "REFERENCES");
                storageObject = this.getOwner(fKIndexAssociation.getRemoteTable());
                if (storageObject != null) {
                    SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(storageObject.getName()) + '.' + this.storageDesign.getFormatedName(fKIndexAssociation.getRemoteTable().getName()));
                } else {
                    SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fKIndexAssociation.getRemoteTable().getName()));
                }
                Index index3 = fKIndexAssociation.getRemoteIndex();
                Column[] columnArray2 = (Column[])index3.getElements();
                SSBFKeyDB2v70.appendNewLine(stringBuffer, bl, 1);
                SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, '(');
                SSBFKeyDB2v70.appendNewLine(stringBuffer, bl, 1);
                for (int i = 0; i < columnArray2.length; ++i) {
                    SSBFKeyDB2v70.appendString(stringBuffer, ' ');
                    SSBFKeyDB2v70.appendString(stringBuffer, this.storageDesign.getFormatedName(columnArray2[i].getName()));
                    if (i != columnArray2.length - 1) {
                        this.appendComma(stringBuffer);
                    }
                    SSBFKeyDB2v70.appendNewLine(stringBuffer, bl, 1);
                }
                SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, ')');
                this.appendOnDelete(stringBuffer, fKIndexAssociation, bl);
                SSBFKeyDB2v70.appendNewLine(stringBuffer, bl, 0);
                this.appendLineFinisher(stringBuffer, bl);
                SSBFKeyDB2v70.appendNewLine(stringBuffer, bl, 0);
                DDLFileMaker.incrementAlterTable();
                this.appendAfterAlterScript(stringBuffer, bl, fKIndexAssociation.getTable());
            } else {
                SSBFKeyDB2v70.appendNewLine(stringBuffer, bl, 0);
                stringBuffer.append("-- Error - Foreign Key ");
                stringBuffer.append(this.storageDesign.getFormatedName(fKIndexAssociation.getContainerWithKeyObject().getName()) + "." + this.storageDesign.getFormatedName(fKIndexAssociation.getName()));
                stringBuffer.append(" has no columns");
                SSBFKeyDB2v70.appendNewLine(stringBuffer, bl, 0);
                DDLFileMaker.incrementErrors();
            }
        }
    }

    private void appendOnDelete(StringBuffer stringBuffer, FKIndexAssociation fKIndexAssociation, boolean bl) {
        String string = fKIndexAssociation.getDeleteRule();
        if (string.equalsIgnoreCase("SET DEFAULT")) {
            string = fKIndexAssociation.isMandatory() ? "RESTRICT" : "SET NULL";
        }
        SSBFKeyDB2v70.appendNewLine(stringBuffer, bl, 1);
        SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, "ON");
        SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, "DELETE");
        SSBFKeyDB2v70.appendStringWithSpace(stringBuffer, string);
    }
}

