/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;

public class SSBDropFK
extends SQLStatementBuilder {
    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isFK()) {
            FKIndexAssociation fKIndexAssociation = ((Index)object).getFKAssociation();
            return fKIndexAssociation.isDropEnabled() && !fKIndexAssociation.shouldBeDroppedIndirectly();
        }
        if (object instanceof IndexProxy && ((IndexProxy)object).getIndex().isFK()) {
            FKIndexAssociation fKIndexAssociation = ((IndexProxy)object).getIndex().getFKAssociation();
            return fKIndexAssociation.isDropEnabled() && !fKIndexAssociation.shouldBeDroppedIndirectly();
        }
        return false;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        if (object == null) {
            return;
        }
        if (object instanceof Index) {
            FKIndexAssociation fKIndexAssociation = ((Index)object).getFKAssociation();
            SSBDropFK.appendStringWithSpace(stringBuffer2, "ALTER");
            SSBDropFK.appendStringWithSpace(stringBuffer2, "TABLE");
            this.appendStringWithSpace(stringBuffer2, fKIndexAssociation.getTable());
            SSBDropFK.appendNewLine(stringBuffer2, bl, 1);
            this.appendDrop(stringBuffer2);
            SSBDropFK.appendStringWithSpace(stringBuffer2, "FOREIGN KEY");
            SSBDropFK.appendStringWithSpace(stringBuffer2, fKIndexAssociation.getName());
            this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
            SSBDropFK.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        } else if (object instanceof IndexProxy) {
            IndexProxy indexProxy = (IndexProxy)object;
            SSBDropFK.appendStringWithSpace(stringBuffer2, "ALTER");
            SSBDropFK.appendStringWithSpace(stringBuffer2, "TABLE");
            SSBDropFK.appendStringWithSpace(stringBuffer2, indexProxy.getTableProxy().getLongName());
            SSBDropFK.appendNewLine(stringBuffer2, bl, 1);
            this.appendDrop(stringBuffer2);
            SSBDropFK.appendStringWithSpace(stringBuffer2, "FOREIGN KEY");
            SSBDropFK.appendStringWithSpace(stringBuffer2, indexProxy.getName());
            this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
            SSBDropFK.appendNewLine(stringBuffer2, bl, 0);
            if (object instanceof IndexProxyDB2 || object instanceof IndexProxyUDB) {
                AbstractSSBDB2.appendLineFinisherUDB(stringBuffer2, bl);
            } else {
                this.appendLineFinisher(stringBuffer2, bl);
            }
            this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        }
    }
}

