/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.DDLConstants;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.SSBErrorHandler;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLGenerationOptions;

public abstract class SQLStatementBuilder
implements DDLConstants {
    public static String NEWLINE = System.getProperty("line.separator");
    public static final String TAB = "    ";
    public static final char FINISH_STATEMENT = ';';
    public static final int LINE_SIZE = 80;
    protected static final SQLStatementBuilder LAST_ERROR_HANDLER = SSBErrorHandler.getInstance();
    private SQLStatementBuilder successor = LAST_ERROR_HANDLER;
    private DDLGenerator ddlGenerator = null;

    public void append(SQLStatementBuilder sQLStatementBuilder) {
        if (this.isLast()) {
            this.setSuccessor(sQLStatementBuilder);
        } else {
            this.getSuccessor().append(sQLStatementBuilder);
        }
    }

    public boolean isLast() {
        return this.successor == LAST_ERROR_HANDLER;
    }

    public StorageDesign getStorageDesign(Object object) {
        if (object instanceof StorageObject) {
            return ((StorageObject)object).getStorageDesign();
        }
        if (object instanceof ModelObject) {
            ModelObject modelObject = (ModelObject)object;
            return modelObject.getDesign().getStorageDesign(modelObject.getSelectedRDBMSSite());
        }
        return null;
    }

    public final void appendTo(StringBuffer stringBuffer, Object object, boolean bl) {
        if (this.canHandle(object)) {
            this.doAppend(stringBuffer, object, bl);
        } else {
            this.getSuccessor().appendTo(stringBuffer, object, bl);
        }
    }

    protected abstract void doAppend(StringBuffer var1, Object var2, boolean var3);

    public void setSuccessor(SQLStatementBuilder sQLStatementBuilder) {
        this.successor = sQLStatementBuilder;
    }

    public SQLStatementBuilder getSuccessor() {
        return this.successor;
    }

    public DDLGenerator getDDLGenerator() {
        return this.ddlGenerator;
    }

    public void setDDLGenerator(DDLGenerator dDLGenerator) {
        this.ddlGenerator = dDLGenerator;
    }

    public abstract boolean canHandle(Object var1);

    protected void appendComment(StringBuffer stringBuffer, ModelIDObject modelIDObject) {
        if (DDLGenerationOptions.isIncludeComments() && !"".equals(modelIDObject.getComment())) {
            StringTokenizer stringTokenizer = new StringTokenizer(modelIDObject.getComment(), "\n");
            if (!this.endsWithNewline(stringBuffer)) {
                stringBuffer.append(NEWLINE);
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                while (string.length() > 76) {
                    int n = 76;
                    if (string.indexOf(76) != 32 && string.indexOf(76) != 9 && string.indexOf(76) != 10) {
                        n = string.substring(0, 76).lastIndexOf(32);
                        int n2 = string.substring(0, 76).lastIndexOf(9);
                        int n3 = string.substring(0, 76).lastIndexOf(10);
                        if (n2 > n) {
                            n = n2;
                        }
                        if (n3 > n) {
                            n = n3;
                        }
                        if (n == -1) {
                            n = 76;
                        }
                    }
                    stringBuffer.append("--  ").append(string.substring(0, n)).append(NEWLINE);
                    string = string.substring(n + 1);
                }
                stringBuffer.append("--  ").append(string).append(NEWLINE);
            }
        }
    }

    protected boolean endsWithNewline(StringBuffer stringBuffer) {
        return stringBuffer.lastIndexOf(NEWLINE) + NEWLINE.length() == stringBuffer.length();
    }

    protected boolean isNotEmpty(String string) {
        return string != null && !"".equals(string) && !"".equals(string.trim());
    }

    protected void appendUnaltered(StringBuffer stringBuffer, StorageObject storageObject) {
        stringBuffer.append("-- ").append(storageObject.getObjectTypeName().toUpperCase()).append(": ").append(storageObject.getLongName()).append(" IS UNALTERED");
    }

    public static void appendNewLine(StringBuffer stringBuffer, boolean bl, int n) {
        if (bl) {
            stringBuffer.append(NEWLINE);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(TAB);
            }
        } else {
            stringBuffer.append(' ');
        }
    }

    public static void appendSpace(StringBuffer stringBuffer) {
        stringBuffer.append(' ');
    }

    public void appendComma(StringBuffer stringBuffer) {
        stringBuffer.append(',');
        SQLStatementBuilder.appendSpace(stringBuffer);
    }

    public String addQuotes(String string, boolean bl) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = string2 = bl ? "'" : "\"";
        if (!string.startsWith(string2)) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(string);
        if (!string.endsWith(string2)) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public void appendLineFinisher(StringBuffer stringBuffer, boolean bl) {
        stringBuffer.append(';');
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 0);
    }

    public void appendCreate(StringBuffer stringBuffer) {
        stringBuffer.append("CREATE");
        SQLStatementBuilder.appendSpace(stringBuffer);
    }

    public void appendDrop(StringBuffer stringBuffer) {
        stringBuffer.append("DROP");
        SQLStatementBuilder.appendSpace(stringBuffer);
    }

    public void appendCreateOrReplace(StringBuffer stringBuffer) {
        stringBuffer.append("CREATE");
        SQLStatementBuilder.appendSpace(stringBuffer);
        stringBuffer.append("OR");
        SQLStatementBuilder.appendSpace(stringBuffer);
        stringBuffer.append("REPLACE");
        SQLStatementBuilder.appendSpace(stringBuffer);
    }

    public void appendCreateOrReplace(StringBuffer stringBuffer, StorageObject storageObject) {
        this.appendCreateOrReplace(stringBuffer);
        SQLStatementBuilder.appendStringWithSpace(stringBuffer, storageObject.getObjectTypeName());
        SQLStatementBuilder.appendStringWithSpace(stringBuffer, storageObject.getStorageDesign().getFormatedName(storageObject.getLongName()));
    }

    public void appendName(StringBuffer stringBuffer, ModelIDObject modelIDObject) {
        if (modelIDObject instanceof StorageObject) {
            StorageDesign storageDesign = ((StorageObject)modelIDObject).getStorageDesign();
            String string = ((StorageObject)modelIDObject).getLongName();
            SQLStatementBuilder.appendStringWithSpace(stringBuffer, storageDesign.getFormatedName(string));
        } else {
            this.appendName(stringBuffer, modelIDObject.getName());
            SQLStatementBuilder.appendSpace(stringBuffer);
        }
    }

    public void appendString(StringBuffer stringBuffer, Object object) {
        stringBuffer.append(object.toString());
    }

    public static void appendString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string);
    }

    public static void appendString(StringBuffer stringBuffer, char c) {
        String string = String.valueOf(c);
        stringBuffer.append(string);
    }

    public void appendString(StringBuffer stringBuffer, int n) {
        String string = String.valueOf(n);
        stringBuffer.append(string);
    }

    public void appendString(StringBuffer stringBuffer, long l) {
        String string = String.valueOf(l);
        stringBuffer.append(string);
    }

    public void appendString(StringBuffer stringBuffer, float f) {
        String string = String.valueOf(f);
        stringBuffer.append(string);
    }

    public static void appendStringWithSpace(StringBuffer stringBuffer, String string) {
        SQLStatementBuilder.appendString(stringBuffer, string);
        SQLStatementBuilder.appendSpace(stringBuffer);
    }

    public void appendStringWithSpace(StringBuffer stringBuffer, Object object) {
        this.appendString(stringBuffer, object);
        SQLStatementBuilder.appendSpace(stringBuffer);
    }

    public static void appendStringWithSpace(StringBuffer stringBuffer, char c) {
        SQLStatementBuilder.appendString(stringBuffer, c);
        SQLStatementBuilder.appendSpace(stringBuffer);
    }

    public void appendStringWithSpace(StringBuffer stringBuffer, int n) {
        this.appendString(stringBuffer, n);
        SQLStatementBuilder.appendSpace(stringBuffer);
    }

    public void appendStringWithSpace(StringBuffer stringBuffer, long l) {
        this.appendString(stringBuffer, l);
        SQLStatementBuilder.appendSpace(stringBuffer);
    }

    public void appendStringWithSpace(StringBuffer stringBuffer, float f) {
        this.appendString(stringBuffer, f);
        SQLStatementBuilder.appendSpace(stringBuffer);
    }

    public void appendOnOffWithSpace(StringBuffer stringBuffer, boolean bl) {
        if (bl) {
            SQLStatementBuilder.appendString(stringBuffer, "ON");
        } else {
            SQLStatementBuilder.appendString(stringBuffer, "OFF");
        }
        SQLStatementBuilder.appendSpace(stringBuffer);
    }

    public void appendYesNoWithSpace(StringBuffer stringBuffer, boolean bl) {
        if (bl) {
            SQLStatementBuilder.appendString(stringBuffer, "YES");
        } else {
            SQLStatementBuilder.appendString(stringBuffer, "NO");
        }
        SQLStatementBuilder.appendSpace(stringBuffer);
    }

    public void appendAllowDisallowWithSpace(StringBuffer stringBuffer, boolean bl) {
        if (bl) {
            SQLStatementBuilder.appendString(stringBuffer, "ALLOW");
        } else {
            SQLStatementBuilder.appendString(stringBuffer, "DISALLOW");
        }
        SQLStatementBuilder.appendSpace(stringBuffer);
    }

    public void appendNotWithSpace(StringBuffer stringBuffer, boolean bl) {
        if (!bl) {
            SQLStatementBuilder.appendString(stringBuffer, "NOT");
            SQLStatementBuilder.appendSpace(stringBuffer);
        }
    }

    public void appendTab(StringBuffer stringBuffer, boolean bl, int n) {
        if (bl) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(TAB);
            }
        }
    }

    public boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public String getName(String string) {
        if (string.indexOf(32) > -1) {
            return "\"" + string + "\"";
        }
        return string;
    }

    private String getLongName(String string) {
        if (string.indexOf(32) > -1) {
            if (string.indexOf(46) > -1) {
                String string2 = string.substring(0, string.lastIndexOf(46));
                String string3 = string.substring(string.lastIndexOf(46) + 1);
                return this.getName(string2) + "." + this.getName(string3);
            }
            return this.getName(string);
        }
        return string;
    }

    private String getLongName(String string, String string2) {
        if (string.indexOf(32) > -1) {
            if (string.indexOf(46) > -1) {
                String string3 = string.substring(0, string.lastIndexOf(46));
                String string4 = string.substring(string.lastIndexOf(46) + 1);
                return string3 + '.' + this.getName(string2 + string4);
            }
            return this.getName(string2 + string);
        }
        if (string.indexOf(46) > -1) {
            String string5 = string.substring(0, string.lastIndexOf(46));
            String string6 = string.substring(string.lastIndexOf(46) + 1);
            return string5 + '.' + string2 + string6;
        }
        return this.getName(string2 + string);
    }

    public void appendName(StringBuffer stringBuffer, String string) {
        stringBuffer.append(this.getName(string));
    }

    public void appendLongName(StringBuffer stringBuffer, String string) {
        stringBuffer.append(this.getLongName(string)).append(' ');
    }

    public void appendLongName(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(this.getLongName(string, string2)).append(' ');
    }

    protected void appendBeforeDropScript(StringBuffer stringBuffer, boolean bl, ContainerObject containerObject) {
        if (containerObject.getShouldGenerateScript() && this.isNotEmpty(containerObject.getBeforeDrop())) {
            this.appendScript(stringBuffer, containerObject.getBeforeDrop(), bl);
        }
    }

    protected void appendBeforeCreateScript(StringBuffer stringBuffer, boolean bl, ContainerObject containerObject) {
        if (containerObject.getShouldGenerateScript() && this.isNotEmpty(containerObject.getBeforeCreate())) {
            SQLStatementBuilder.appendNewLine(stringBuffer, bl, 0);
            this.appendScript(stringBuffer, containerObject.getBeforeCreate(), bl);
        }
    }

    private void appendScript(StringBuffer stringBuffer, String string, boolean bl) {
        String string2 = string.trim();
        boolean bl2 = false;
        if (string2.endsWith("*/")) {
            bl2 = true;
        } else {
            int n = string2.lastIndexOf(13);
            int n2 = string2.lastIndexOf(10);
            if (n2 < n) {
                n2 = n;
            }
            if (string2.indexOf("--", n2 + 1) > -1) {
                bl2 = true;
            }
        }
        if (string2.endsWith(";") && !bl2) {
            string2 = string2.substring(0, string2.length() - 1).trim();
        }
        if (this.isNotEmpty(string2)) {
            StringBuffer stringBuffer2 = new StringBuffer();
            SQLStatementBuilder.appendString(stringBuffer2, string2);
            String string3 = string2;
            if (string3.length() > 80) {
                string3 = string3.substring(0, 80);
            }
            this.appendToBuffer(stringBuffer, stringBuffer2, string3);
            SQLStatementBuilder.appendNewLine(stringBuffer2, bl, 0);
            if (!bl2) {
                this.appendLineFinisher(stringBuffer2, bl);
            }
            this.appendToBuffer(stringBuffer, stringBuffer2, string3);
        }
    }

    protected void appendAfterCreateScript(StringBuffer stringBuffer, boolean bl, ContainerObject containerObject) {
        if (containerObject.getShouldGenerateScript() && this.isNotEmpty(containerObject.getAfterCreate())) {
            this.appendScript(stringBuffer, containerObject.getAfterCreate(), bl);
        }
    }

    protected void appendBeforeAlterScript(StringBuffer stringBuffer, boolean bl, ContainerObject containerObject) {
    }

    protected void appendAfterAlterScript(StringBuffer stringBuffer, boolean bl, ContainerObject containerObject) {
    }

    protected void appendEndScript(StringBuffer stringBuffer, boolean bl, ContainerObject containerObject) {
        if (containerObject.getShouldGenerateScript() && this.isNotEmpty(containerObject.getEndOfScript())) {
            this.appendScript(stringBuffer, containerObject.getEndOfScript(), bl);
        }
    }

    protected void appendToBuffer(StringBuffer stringBuffer, StringBuffer stringBuffer2, String string) {
        this.appendToBuffer(stringBuffer, stringBuffer2, string, false);
    }

    protected void appendToBuffer(StringBuffer stringBuffer, StringBuffer stringBuffer2, String string, boolean bl) {
        if (this.canAppendBuffer(stringBuffer2)) {
            if (DDLFileMaker.getddlAdvancedGenenerator() != null) {
                if (this.isNotLineFinisher(stringBuffer2.toString()) || bl) {
                    stringBuffer.append("-- Step").append(DDLFileMaker.getAdvancedStep());
                    this.appendFormatedBuffer(stringBuffer, stringBuffer2, string, DDLFileMaker.getAdvancedStep(), true);
                    DDLFileMaker.incrementAdvancedStep();
                }
            } else {
                stringBuffer.append(stringBuffer2);
            }
            stringBuffer2.setLength(0);
        }
    }

    protected void appendBlockDefinitionToBuffer(StringBuffer stringBuffer, StringBuffer stringBuffer2, String string, String string2) {
        if (this.canAppendBuffer(stringBuffer2)) {
            if (DDLFileMaker.getddlAdvancedGenenerator() != null) {
                stringBuffer.append("-- Step").append(DDLFileMaker.getAdvancedStep());
                this.appendFormatedBuffer(stringBuffer, stringBuffer2, string, DDLFileMaker.getAdvancedStep(), true);
                DDLFileMaker.incrementAdvancedStep();
            } else {
                stringBuffer.append(stringBuffer2);
                SQLStatementBuilder.appendNewLine(stringBuffer, true, 0);
                stringBuffer.append(string2);
            }
            stringBuffer2.setLength(0);
        }
    }

    protected boolean canAppendBuffer(StringBuffer stringBuffer) {
        return stringBuffer.length() > 0 && !stringBuffer.toString().equals(NEWLINE);
    }

    protected void appendFormatedBuffer(StringBuffer stringBuffer, StringBuffer stringBuffer2, String string, int n, boolean bl) {
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 0);
        SQLStatementBuilder.appendString(stringBuffer, "declare");
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 1);
        SQLStatementBuilder.appendString(stringBuffer, "statement varchar2(32000);");
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 1);
        SQLStatementBuilder.appendString(stringBuffer, "comments varchar2(200);");
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 0);
        SQLStatementBuilder.appendString(stringBuffer, "begin");
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 0);
        SQLStatementBuilder.appendString(stringBuffer, "statement :=");
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 1);
        SQLStatementBuilder.appendString(stringBuffer, '\'');
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 1);
        stringBuffer.append(this.replaceSingleQuote(stringBuffer2.toString()));
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 1);
        SQLStatementBuilder.appendString(stringBuffer, '\'');
        SQLStatementBuilder.appendString(stringBuffer, ';');
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 0);
        SQLStatementBuilder.appendString(stringBuffer, "comments := ");
        SQLStatementBuilder.appendString(stringBuffer, '\'');
        if (string.length() > 80) {
            string = string.substring(0, 80);
        }
        SQLStatementBuilder.appendString(stringBuffer, this.replaceSingleQuote(string));
        SQLStatementBuilder.appendString(stringBuffer, '\'');
        SQLStatementBuilder.appendString(stringBuffer, ';');
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 0);
        SQLStatementBuilder.appendString(stringBuffer, "adv_scripting.EXEC_STATEMENT(");
        this.appendString(stringBuffer, n);
        SQLStatementBuilder.appendString(stringBuffer, ",statement,comments);");
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 0);
        SQLStatementBuilder.appendString(stringBuffer, "end;");
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 0);
        SQLStatementBuilder.appendString(stringBuffer, "/");
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 0);
        SQLStatementBuilder.appendString(stringBuffer, "-- end Step");
        this.appendString(stringBuffer, n);
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 0);
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 0);
    }

    public String replaceSingleQuote(String string) {
        return string.replaceAll("\\'", "\\'\\'");
    }

    protected boolean isNotLineFinisher(String string) {
        return !string.trim().equals(";");
    }

    protected boolean hasToBeBackup() {
        return false;
    }

    public void appendLineFinisherWithSlash(StringBuffer stringBuffer, boolean bl) {
        stringBuffer.append(';').append(NEWLINE).append("/");
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 0);
        SQLStatementBuilder.appendNewLine(stringBuffer, bl, 0);
    }

    public String getStringWithMaxLength(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public List getColumnsWithOneRestrictedSubType(Table table) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (Column column : table.getElementsCollection()) {
            if (!(column.getDataType() instanceof StructuredType) || column.isReference() || !column.isAllowSubtypeSubstitution() || !column.isRestrictedTypeSubstitution() || column.getPermittedSubTypes().size() != 1) continue;
            arrayList.add(column);
        }
        return arrayList;
    }

    public List getColumnsWithManyRestrictedSubType(Table table) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (Column column : table.getElementsCollection()) {
            if (!(column.getDataType() instanceof StructuredType) || !column.isAllowSubtypeSubstitution() || !column.isRestrictedTypeSubstitution() || column.getPermittedSubTypes().size() <= 1 && (!column.isReference() || column.getPermittedSubTypes().size() != 1)) continue;
            arrayList.add(column);
        }
        return arrayList;
    }

    public List getColumnsWithRestrictedSubType(Table table) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (Column column : table.getElementsCollection()) {
            if (!(column.getDataType() instanceof StructuredType) || column.isReference() && column.getScope() == null) continue;
            if (column.isAllowSubtypeSubstitution() && column.isRestrictedTypeSubstitution()) {
                if (column.getPermittedSubTypes().size() <= 0) continue;
                arrayList.add(column);
                continue;
            }
            if (column.isAllowSubtypeSubstitution()) continue;
            arrayList.add(column);
        }
        return arrayList;
    }

    protected String addQuotesToDefault(String string, String string2) {
        String string3 = string2.trim();
        if (!(string.toUpperCase().indexOf("CHAR") <= -1 && string.toUpperCase().indexOf("DATE") <= -1 && string.toUpperCase().indexOf("TIME") <= -1 || Token.hasCloseAndOpenBrackets(string2))) {
            if (string3.endsWith("'") && string3.length() > 1 && (string3.startsWith("'") || string3.toUpperCase().startsWith("N'") || string3.toUpperCase().startsWith("Q'") || string3.toUpperCase().startsWith("NQ'"))) {
                return string3;
            }
            if (string3.indexOf(39) > -1) {
                string3 = string3.replaceAll("'", "''");
            }
            string3 = "'" + string3 + "'";
        }
        return string3;
    }

    public void clearTemporaryObjects() {
    }

    private String replaceSpecialChars(String string) {
        return string.replaceAll("\\$", "\\\\\\$");
    }

    protected String appendOwner(String string, String string2, String string3) {
        string2 = this.replaceSpecialChars(string2);
        string3 = this.replaceSpecialChars(string3);
        return string.replaceFirst(string2, string3 + '.' + string2);
    }

    protected String replaceName(String string, String string2, String string3) {
        string2 = this.replaceSpecialChars(string2);
        string3 = this.replaceSpecialChars(string3);
        return string.replaceFirst(string2, string3);
    }

    protected void appendCommentOn(StringBuffer stringBuffer, StorageObject storageObject, boolean bl) {
        Object object;
        Object object2;
        String string = "";
        if (storageObject instanceof TableProxy) {
            object2 = (TableProxy)storageObject;
            if (((TableProxy)object2).isCommentInRDBMSChanged()) {
                string = ((ModelIDObject)object2).getCommentInRDBMS();
            } else {
                object = (Table)((RelationalObjectProxy)object2).getObject();
                string = ((ModelIDObject)object).getCommentInRDBMS();
            }
        } else if (storageObject instanceof TableViewProxy) {
            object2 = (TableViewProxy)storageObject;
            if (((RelationalObjectProxy)object2).isCommentInRDBMSChanged()) {
                string = ((ModelIDObject)object2).getCommentInRDBMS();
            } else {
                object = (TableView)((RelationalObjectProxy)object2).getObject();
                string = ((ModelIDObject)object).getCommentInRDBMS();
            }
        } else if (storageObject instanceof SnapshotOracle) {
            string = storageObject.getCommentInRDBMS();
        }
        if (this.isNotEmpty(string)) {
            if (bl) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append(NEWLINE);
            }
            object2 = new StringBuffer();
            SQLStatementBuilder.appendStringWithSpace((StringBuffer)object2, "COMMENT ON");
            if (storageObject instanceof SnapshotOracle) {
                SQLStatementBuilder.appendStringWithSpace((StringBuffer)object2, "MATERIALIZED");
                SQLStatementBuilder.appendStringWithSpace((StringBuffer)object2, "VIEW");
            } else {
                SQLStatementBuilder.appendStringWithSpace((StringBuffer)object2, "TABLE");
            }
            SQLStatementBuilder.appendStringWithSpace((StringBuffer)object2, storageObject.getStorageDesign().getFormatedName(storageObject.getLongName()));
            object = ((StringBuffer)object2).toString();
            SQLStatementBuilder.appendStringWithSpace((StringBuffer)object2, "IS");
            SQLStatementBuilder.appendString((StringBuffer)object2, '\'');
            SQLStatementBuilder.appendString((StringBuffer)object2, this.replaceSingleQuote(string));
            SQLStatementBuilder.appendString((StringBuffer)object2, '\'');
            this.appendToBuffer(stringBuffer, (StringBuffer)object2, (String)object);
            SQLStatementBuilder.appendNewLine((StringBuffer)object2, bl, 0);
            this.appendLineFinisher((StringBuffer)object2, bl);
            this.appendToBuffer(stringBuffer, (StringBuffer)object2, (String)object);
        }
        stringBuffer.append(NEWLINE);
    }

    protected void appendViewCommentOn(StorageDesign storageDesign, StringBuffer stringBuffer, TableView tableView, TableViewProxy tableViewProxy, boolean bl) {
        Object object;
        ContainedObject[] containedObjectArray;
        if (tableViewProxy != null) {
            this.appendCommentOn(stringBuffer, tableViewProxy, bl);
            if (tableView == null) {
                tableView = (TableView)tableViewProxy.getObject();
            }
        } else if (tableView != null && (containedObjectArray = tableView.getCommentInRDBMS()) != null && !"".equalsIgnoreCase((String)containedObjectArray)) {
            SQLStatementBuilder.appendNewLine(stringBuffer, bl, 0);
            object = new StringBuffer();
            SQLStatementBuilder.appendStringWithSpace((StringBuffer)object, "COMMENT ON");
            SQLStatementBuilder.appendStringWithSpace((StringBuffer)object, "TABLE");
            SQLStatementBuilder.appendStringWithSpace((StringBuffer)object, storageDesign.getFormatedName(tableView.getLongName()));
            String string = ((StringBuffer)object).toString();
            SQLStatementBuilder.appendStringWithSpace((StringBuffer)object, "IS");
            SQLStatementBuilder.appendString((StringBuffer)object, '\'');
            SQLStatementBuilder.appendString((StringBuffer)object, this.replaceSingleQuote((String)containedObjectArray));
            SQLStatementBuilder.appendStringWithSpace((StringBuffer)object, '\'');
            this.appendToBuffer(stringBuffer, (StringBuffer)object, string);
            SQLStatementBuilder.appendNewLine((StringBuffer)object, bl, 0);
            this.appendLineFinisher((StringBuffer)object, bl);
            this.appendToBuffer(stringBuffer, (StringBuffer)object, string);
            SQLStatementBuilder.appendNewLine((StringBuffer)object, bl, 0);
        }
        if (tableView != null) {
            containedObjectArray = tableView.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                object = containedObjectArray[i];
                String string = ((ModelIDObject)object).getCommentInRDBMS();
                if (string == null || "".equalsIgnoreCase(string)) continue;
                SQLStatementBuilder.appendNewLine(stringBuffer, bl, 0);
                StringBuffer stringBuffer2 = new StringBuffer();
                SQLStatementBuilder.appendStringWithSpace(stringBuffer2, "COMMENT ON");
                SQLStatementBuilder.appendStringWithSpace(stringBuffer2, "COLUMN");
                SQLStatementBuilder.appendStringWithSpace(stringBuffer2, storageDesign.getFormatedName(((ContainedObject)object).getLongName()));
                String string2 = stringBuffer2.toString();
                SQLStatementBuilder.appendStringWithSpace(stringBuffer2, "IS");
                SQLStatementBuilder.appendString(stringBuffer2, '\'');
                SQLStatementBuilder.appendString(stringBuffer2, this.replaceSingleQuote(string));
                SQLStatementBuilder.appendStringWithSpace(stringBuffer2, '\'');
                this.appendToBuffer(stringBuffer, stringBuffer2, string2);
                SQLStatementBuilder.appendNewLine(stringBuffer2, bl, 0);
                this.appendLineFinisher(stringBuffer2, bl);
                this.appendToBuffer(stringBuffer, stringBuffer2, string2);
            }
        }
    }
}

