/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectCSVExportDialog
extends CustomDialog {
    private JDialog dialog;
    private Design design;
    private JPanel generalPanel;
    private boolean cancelled = false;
    private List expObjects = new ArrayList();
    private JTable expTable;

    public SelectCSVExportDialog(ApplicationView applicationView) {
        super(applicationView);
        this.design = applicationView.getCurrentDesign();
        this.generalPanel = new JPanel(new BorderLayout());
        this.init();
        this.add((Component)this.generalPanel, "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    private void init() {
        this.buildExpLists();
        this.expTable = new JTable(new ExportModel());
        this.expTable.setDefaultRenderer(Object.class, new ExportRenderer());
        TableColumn tableColumn = this.expTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(50);
        tableColumn.setMaxWidth(60);
        tableColumn.setMinWidth(50);
        tableColumn = this.expTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(90);
        tableColumn.setMaxWidth(100);
        tableColumn.setMinWidth(50);
        JScrollPane jScrollPane = new JScrollPane(this.expTable);
        jScrollPane.setPreferredSize(new Dimension(400, 210));
        this.generalPanel.add(jScrollPane);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectCSVExportDialog.ExportDesignToCSV"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.setResizable(true);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(Messages.getString("SelectCSVExportDialog.OK"));
        jButton.setMnemonic(79);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectCSVExportDialog.this.cancelled = false;
                SelectCSVExportDialog.this.close();
            }
        });
        JButton jButton2 = new JButton(Messages.getString("SelectCSVExportDialog.Cancel"));
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectCSVExportDialog.this.cancelled = true;
                SelectCSVExportDialog.this.close();
            }
        });
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return !this.cancelled;
    }

    private void buildExpLists() {
        this.expObjects.clear();
        ExpObject expObject = new ExpObject(this.design.getLogicalDesign());
        this.expObjects.add(expObject);
        Iterator iterator = this.design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            expObject = new ExpObject(relationalDesign);
            this.expObjects.add(expObject);
        }
    }

    public List getDesignPartObjects() {
        return this.expObjects;
    }

    public class ExportRenderer
    extends DefaultTableCellRenderer {
        Color color = new Color(204, 255, 255);

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color;
            Color color2;
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 2) {
                color2 = Color.LIGHT_GRAY;
                color = Color.WHITE;
            } else {
                color2 = Color.WHITE;
                color = Color.BLACK;
            }
            component.setBackground(color2);
            component.setForeground(color);
            return component;
        }
    }

    public class ExpObject {
        private boolean selected = false;
        private ModelIDObject object;

        ExpObject(ModelIDObject modelIDObject) {
            this.object = modelIDObject;
        }

        String getDesignPartType(ModelIDObject modelIDObject) {
            if (modelIDObject instanceof LogicalDesign) {
                return Messages.getString("SelectCSVExportDialog.Logical");
            }
            if (modelIDObject instanceof RelationalDesign) {
                return Messages.getString("SelectCSVExportDialog.Relational");
            }
            if (modelIDObject instanceof DataTypesDesign) {
                return Messages.getString("SelectCSVExportDialog.DataTypes");
            }
            return " ";
        }

        String getType() {
            return this.getDesignPartType(this.object);
        }

        public String toString() {
            return this.object.getName();
        }

        public ModelIDObject getObject() {
            return this.object;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public void setObject(ModelIDObject modelIDObject) {
            this.object = modelIDObject;
        }
    }

    private class ExportModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SelectCSVExportDialog.Selected"), Messages.getString("SelectCSVExportDialog.ModelType"), Messages.getString("SelectCSVExportDialog.ModelName")};

        private ExportModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return SelectCSVExportDialog.this.expObjects.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 <= 0;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                ExpObject expObject = (ExpObject)SelectCSVExportDialog.this.expObjects.get(n);
                if (object instanceof Boolean) {
                    expObject.setSelected((Boolean)object);
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ExpObject expObject = (ExpObject)SelectCSVExportDialog.this.expObjects.get(n);
            if (n2 == 0) {
                return expObject.isSelected();
            }
            if (n2 == 1) {
                return expObject.getType();
            }
            if (n2 == 2) {
                return expObject.getObject().getName();
            }
            return new Integer(n * n2);
        }
    }
}

