/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;

public class EHTableConstraints
extends ExportHandler {
    public EHTableConstraints(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ObjectID").append(",");
        stringBuffer.append("NumOID").append(",");
        stringBuffer.append("Sequence").append(",");
        stringBuffer.append("Constraint_Name").append(",");
        stringBuffer.append("Text").append(",");
        stringBuffer.append("Table_Name");
        arrayList.add(stringBuffer.toString());
        Iterator iterator = this.getDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (!this.getCsvExporter().isModelSelected(relationalDesign)) continue;
            Iterator iterator2 = relationalDesign.getTableSet().iterator();
            while (iterator2.hasNext()) {
                Table table = (Table)iterator2.next();
                Iterator iterator3 = table.getCheckConstraints().iterator();
                int n = 0;
                while (iterator3.hasNext()) {
                    ++n;
                    TableLevelConstraint tableLevelConstraint = (TableLevelConstraint)iterator3.next();
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(table.getObjectID()).append(",");
                    stringBuffer.append(table.getNumID()).append(",");
                    stringBuffer.append(n).append(",");
                    stringBuffer.append(tableLevelConstraint.getName()).append(",");
                    stringBuffer.append(this.replaceAndQuoteString(tableLevelConstraint.getRule())).append(",");
                    stringBuffer.append(table.getName()).append(",");
                    arrayList.add(stringBuffer.toString());
                }
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Table_Constraints.csv";
    }
}

