/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;

public class EHSpatialDimension
extends ExportHandler {
    public EHSpatialDimension(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Definition_ID").append(",");
        stringBuffer.append("Definition_Name").append(",");
        stringBuffer.append("Low_Boundary").append(",");
        stringBuffer.append("Upper_Boundary").append(",");
        stringBuffer.append("Tolerance");
        arrayList.add(stringBuffer.toString());
        Iterator iterator = this.getDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (!this.getCsvExporter().isModelSelected(relationalDesign)) continue;
            Iterator iterator2 = relationalDesign.getTableSet().iterator();
            while (iterator2.hasNext()) {
                Table table = (Table)iterator2.next();
                for (SpatialColumnDefObject spatialColumnDefObject : table.getSpatialDefinitions()) {
                    for (SpatialColumnDefObject.TableDimension tableDimension : spatialColumnDefObject.getTableDimensions()) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append(spatialColumnDefObject.getId()).append(",");
                        stringBuffer.append(tableDimension.getName()).append(",");
                        stringBuffer.append(tableDimension.getLowBoundary()).append(",");
                        stringBuffer.append(tableDimension.getUpperBoundary()).append(",");
                        stringBuffer.append(tableDimension.getTolerance()).append(",");
                        arrayList.add(stringBuffer.toString());
                    }
                }
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Spatial_Dimensions.csv";
    }
}

