/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;

public class EHRelation
extends ExportHandler {
    public EHRelation(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Relation_Name").append(",");
        stringBuffer.append("ModelID").append(",");
        stringBuffer.append("Num_ModelID").append(",");
        stringBuffer.append("ObjectID").append(",");
        stringBuffer.append("NumOID").append(",");
        stringBuffer.append("ImportID").append(",");
        stringBuffer.append("Source_Entity_Name").append(",");
        stringBuffer.append("Target_Entity_Name").append(",");
        stringBuffer.append("Source_Label").append(",");
        stringBuffer.append("Target_Label").append(",");
        stringBuffer.append("SourceTo_Target_Cardinality").append(",");
        stringBuffer.append("TargetTo_Source_Cardinality").append(",");
        stringBuffer.append("Source_Optional").append(",");
        stringBuffer.append("Target_Optional").append(",");
        stringBuffer.append("Dominant_Role").append(",");
        stringBuffer.append("Identifying").append(",");
        stringBuffer.append("Source_ID").append(",");
        stringBuffer.append("Num_Source_ID").append(",");
        stringBuffer.append("Target_ID").append(",");
        stringBuffer.append("Num_Target_ID").append(",");
        stringBuffer.append("Number_Of_Attributes");
        arrayList.add(stringBuffer.toString());
        LogicalDesign logicalDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logicalDesign)) {
            Iterator iterator = logicalDesign.getRelationSet().iterator();
            while (iterator.hasNext()) {
                Relation relation = (Relation)iterator.next();
                stringBuffer = new StringBuffer();
                stringBuffer.append(relation.getName()).append(",");
                stringBuffer.append(logicalDesign.getObjectID()).append(",");
                stringBuffer.append(logicalDesign.getNumID()).append(",");
                stringBuffer.append(relation.getObjectID()).append(",");
                stringBuffer.append(relation.getNumID()).append(",");
                stringBuffer.append(relation.getImportedId() != null ? relation.getImportedId() : "").append(",");
                stringBuffer.append(relation.getSourceEntity().getName()).append(",");
                stringBuffer.append(relation.getTargetEntity().getName()).append(",");
                stringBuffer.append(relation.getNameOnSource() != null ? relation.getNameOnSource() : "").append(",");
                stringBuffer.append(relation.getNameOnTarget() != null ? relation.getNameOnTarget() : "").append(",");
                stringBuffer.append(this.quotedString(relation.getTargetCardinality().toString())).append(",");
                stringBuffer.append(this.quotedString(relation.getSourceCardinality().toString())).append(",");
                stringBuffer.append(relation.isOptionalSource() ? "Y" : "N").append(",");
                stringBuffer.append(relation.isOptionalTarget() ? "Y" : "N").append(",");
                stringBuffer.append(relation.getDominantRole().getName()).append(",");
                stringBuffer.append(relation.isIdentifying() ? "Y" : "N").append(",");
                stringBuffer.append(relation.getSourceEntity().getObjectID()).append(",");
                stringBuffer.append(relation.getSourceEntity().getNumID()).append(",");
                stringBuffer.append(relation.getTargetEntity().getObjectID()).append(",");
                stringBuffer.append(relation.getTargetEntity().getNumID()).append(",");
                int[] nArray = relation.getPKProviderEndPoint();
                if (nArray.length > 0) {
                    int n = relation.getOtherEndPoint(nArray[0]);
                    stringBuffer.append(relation.getFKAttributes(n).length).append(",");
                } else {
                    stringBuffer.append("").append(",");
                }
                arrayList.add(stringBuffer.toString());
                this.getCsvExporter().addNote(relation.getObjectID(), relation.getNumID(), "Relation", relation.getNotes());
                this.getCsvExporter().addComment(relation.getObjectID(), relation.getNumID(), "Relation", relation.getComment());
                this.getCsvExporter().addCommentRDBMS(relation.getObjectID(), relation.getNumID(), "Relation", relation.getCommentInRDBMS());
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Relations.csv";
    }
}

