/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;

public class EHProcessAttributes
extends ExportHandler {
    public EHProcessAttributes(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Process_ID").append(",");
        stringBuffer.append("Num_Process_ID").append(",");
        stringBuffer.append("Entity_ID").append(",");
        stringBuffer.append("Num_Entity_ID").append(",");
        stringBuffer.append("Flow_ID").append(",");
        stringBuffer.append("Num_Flow_ID").append(",");
        stringBuffer.append("DFD_ID").append(",");
        stringBuffer.append("Num_DFD_ID").append(",");
        stringBuffer.append("Process_Name").append(",");
        stringBuffer.append("Entity_Name").append(",");
        stringBuffer.append("Flow_Name").append(",");
        stringBuffer.append("DFD_Name").append(",");
        stringBuffer.append("OP_Read").append(",");
        stringBuffer.append("OP_Create").append(",");
        stringBuffer.append("OP_Update").append(",");
        stringBuffer.append("OP_Delete").append(",");
        stringBuffer.append("CRUD_Code").append(",");
        stringBuffer.append("Flow_Direction").append(",");
        stringBuffer.append("AttributeID").append(",");
        stringBuffer.append("Num_AttributeID").append(",");
        stringBuffer.append("Attribute_Name");
        arrayList.add(stringBuffer.toString());
        ProcessModel processModel = this.getDesign().getProcessModel();
        Iterator iterator = processModel.getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
            String string = dataFlowDesign.getTopLevelDataFlowDesign().getName();
            Iterator iterator2 = dataFlowDesign.getProcessSet().iterator();
            while (iterator2.hasNext()) {
                Process process = (Process)iterator2.next();
                if (process.getType() != 0) continue;
                for (Process.ProcessedObject processedObject : process.getProcessedAttributesAndFlows(false)) {
                    Attribute attribute = (Attribute)processedObject.getObject();
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(process.getObjectID()).append(",");
                    stringBuffer.append(process.getNumID()).append(",");
                    stringBuffer.append(attribute.getContainer().getObjectID()).append(",");
                    stringBuffer.append(attribute.getContainer().getNumID()).append(",");
                    stringBuffer.append(processedObject.getFlow().getObjectID()).append(",");
                    stringBuffer.append(processedObject.getFlow().getNumID()).append(",");
                    stringBuffer.append(dataFlowDesign.getObjectID()).append(",");
                    stringBuffer.append(dataFlowDesign.getNumID()).append(",");
                    stringBuffer.append(process.getName()).append(",");
                    stringBuffer.append(attribute.getContainer().getName()).append(",");
                    stringBuffer.append(processedObject.getFlow().getName()).append(",");
                    stringBuffer.append(string).append(",");
                    stringBuffer.append(processedObject.isOpRead() ? "Y" : "N").append(",");
                    stringBuffer.append(processedObject.isOpCreate() ? "Y" : "N").append(",");
                    stringBuffer.append(processedObject.isOpUpdate() ? "Y" : "N").append(",");
                    stringBuffer.append(processedObject.isOpDelete() ? "Y" : "N").append(",");
                    if (processedObject.isOpRead()) {
                        stringBuffer.append("R").append(",");
                    } else {
                        String string2 = "";
                        if (processedObject.isOpCreate()) {
                            string2 = "C";
                        }
                        if (processedObject.isOpUpdate()) {
                            string2 = string2 + "U";
                        }
                        if (processedObject.isOpDelete()) {
                            string2 = string2 + "D";
                        }
                        stringBuffer.append(string2).append(",");
                    }
                    stringBuffer.append(processedObject.isInbound() ? "In" : "Out").append(",");
                    stringBuffer.append(attribute.getObjectID()).append(",");
                    stringBuffer.append(attribute.getNumID()).append(",");
                    stringBuffer.append(attribute.getName()).append(",");
                    arrayList.add(stringBuffer.toString());
                }
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Process_Attributes.csv";
    }
}

