/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.storage.RDBMSType;

public class EHNativeToLogical
extends ExportHandler {
    public EHNativeToLogical(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RDBMS_Type").append(",");
        stringBuffer.append("RDBMS_Version").append(",");
        stringBuffer.append("Native_Type").append(",");
        stringBuffer.append("LT_Name").append(",");
        stringBuffer.append("Logical_Type_ID");
        arrayList.add(stringBuffer.toString());
        Iterator iterator = this.getDesign().getDefaultRDBMSTypeSet().iterator();
        while (iterator.hasNext()) {
            RDBMSType rDBMSType = (RDBMSType)iterator.next();
            String[] stringArray = StandardDatatypeNames.getAllPossibleDatatypes(rDBMSType);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.equalsIgnoreCase("UNKNOWN")) continue;
                String string2 = StandardDatatypeNames.getUsedDatatypeName(string);
                if (!string.equals(string2 = StandardDatatypeNames.getTransformedDatatypeName(string2, rDBMSType))) continue;
                LogicalDatatype logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(rDBMSType, string2);
                if (logicalDatatype == null) {
                    logicalDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(rDBMSType, string);
                }
                if (logicalDatatype == null) continue;
                stringBuffer = new StringBuffer();
                stringBuffer.append(rDBMSType.getProductName()).append(",");
                stringBuffer.append(rDBMSType.getVersionName()).append(",");
                stringBuffer.append(string).append(",");
                stringBuffer.append(logicalDatatype.getName()).append(",");
                stringBuffer.append(logicalDatatype.getObjectID()).append(",");
                arrayList.add(stringBuffer.toString());
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Native_To_Logical.csv";
    }
}

