/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;

public class EHModel
extends ExportHandler {
    public EHModel(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        DesignPart designPart;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ModelID").append(",");
        stringBuffer.append("Num_ModelID").append(",");
        stringBuffer.append("Model_Name").append(",");
        stringBuffer.append("Model_Type").append(",");
        stringBuffer.append("RDBMS_Type");
        arrayList.add(stringBuffer.toString());
        LogicalDesign logicalDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logicalDesign)) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(logicalDesign.getObjectID()).append(",");
            stringBuffer.append(logicalDesign.getNumID()).append(",");
            stringBuffer.append(logicalDesign.getName()).append(",");
            stringBuffer.append("Logical").append(",");
            stringBuffer.append("").append(",");
            arrayList.add(stringBuffer.toString());
            this.getCsvExporter().addNote(logicalDesign.getObjectID(), logicalDesign.getNumID(), "Model", logicalDesign.getNotes());
            this.getCsvExporter().addComment(logicalDesign.getObjectID(), logicalDesign.getNumID(), "Model", logicalDesign.getNotes());
            this.getCsvExporter().addCommentRDBMS(logicalDesign.getObjectID(), logicalDesign.getNumID(), "Model", logicalDesign.getNotes());
        }
        Iterator iterator = this.getDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            designPart = (RelationalDesign)iterator.next();
            if (!this.getCsvExporter().isModelSelected(designPart)) continue;
            stringBuffer = new StringBuffer();
            stringBuffer.append(designPart.getObjectID()).append(",");
            stringBuffer.append(designPart.getNumID()).append(",");
            stringBuffer.append(((RelationalDesign)designPart).getName()).append(",");
            stringBuffer.append("Relational").append(",");
            stringBuffer.append(designPart.getSelectedRDBMSType().getTypeName()).append(",");
            arrayList.add(stringBuffer.toString());
            this.getCsvExporter().addNote(designPart.getObjectID(), designPart.getNumID(), "Model", designPart.getNotes());
            this.getCsvExporter().addComment(designPart.getObjectID(), designPart.getNumID(), "Model", designPart.getNotes());
            this.getCsvExporter().addCommentRDBMS(designPart.getObjectID(), designPart.getNumID(), "Model", designPart.getNotes());
        }
        designPart = this.getDesign().getDataTypesDesign();
        if (this.getCsvExporter().isModelSelected(designPart)) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(designPart.getObjectID()).append(",");
            stringBuffer.append(designPart.getNumID()).append(",");
            stringBuffer.append(((DataTypesDesign)designPart).getName()).append(",");
            stringBuffer.append("Data Types").append(",");
            stringBuffer.append("").append(",");
            arrayList.add(stringBuffer.toString());
            this.getCsvExporter().addNote(designPart.getObjectID(), designPart.getNumID(), "Model", designPart.getNotes());
            this.getCsvExporter().addComment(designPart.getObjectID(), designPart.getNumID(), "Model", designPart.getComment());
            this.getCsvExporter().addCommentRDBMS(designPart.getObjectID(), designPart.getNumID(), "Model", designPart.getCommentInRDBMS());
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Models.csv";
    }
}

