/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.storage.RDBMSType;

public class EHLogicalToNative
extends ExportHandler {
    public EHLogicalToNative(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Logical_Type_ID").append(",");
        stringBuffer.append("LT_Name").append(",");
        stringBuffer.append("Native_Type").append(",");
        stringBuffer.append("RDBMS_Type").append(",");
        stringBuffer.append("RDBMS_Version").append(",");
        stringBuffer.append("Has_Size").append(",");
        stringBuffer.append("Has_Precision").append(",");
        stringBuffer.append("Has_Scale");
        arrayList.add(stringBuffer.toString());
        Iterator iterator = this.getDesign().getLogicalDatatypeSet().iterator();
        while (iterator.hasNext()) {
            LogicalDatatype logicalDatatype = (LogicalDatatype)iterator.next();
            Map map = logicalDatatype.getToPhysical();
            Iterator iterator2 = this.getDesign().getDefaultRDBMSTypeSet().iterator();
            while (iterator2.hasNext()) {
                RDBMSType rDBMSType = (RDBMSType)iterator2.next();
                MDDataType mDDataType = logicalDatatype.createDataType(rDBMSType.getName(), map);
                if (mDDataType == null) continue;
                stringBuffer = new StringBuffer();
                stringBuffer.append(logicalDatatype.getObjectID()).append(",");
                stringBuffer.append(logicalDatatype.getName()).append(",");
                stringBuffer.append(mDDataType.getName()).append(",");
                stringBuffer.append(rDBMSType.getProductName()).append(",");
                stringBuffer.append(rDBMSType.getVersionName()).append(",");
                stringBuffer.append(mDDataType.hasSize() && this.hasSize(mDDataType.getSize()) ? "Y" : "N").append(",");
                stringBuffer.append(mDDataType.hasPrecision() && mDDataType.getPrecision() > 0 ? "Y" : "N").append(",");
                stringBuffer.append(mDDataType.hasScale() && mDDataType.getScale() > 0 ? "Y" : "N").append(",");
                arrayList.add(stringBuffer.toString());
            }
        }
        this.saveToFile(arrayList);
    }

    private boolean hasSize(String string) {
        if (string != null && !"".equalsIgnoreCase(string)) {
            return !"0".equalsIgnoreCase(string);
        }
        return false;
    }

    @Override
    public String getFileName() {
        return "DM_Logical_To_Native.csv";
    }
}

