/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;

public class EHKeyAttributes
extends ExportHandler {
    public EHKeyAttributes(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Key_ID").append(",");
        stringBuffer.append("Num_Key_ID").append(",");
        stringBuffer.append("AttributeID").append(",");
        stringBuffer.append("Num_AttributeID").append(",");
        stringBuffer.append("Entity_ID").append(",");
        stringBuffer.append("Num_Entity_ID").append(",");
        stringBuffer.append("Key_Name").append(",");
        stringBuffer.append("Entity_Name").append(",");
        stringBuffer.append("Attribute_Name");
        arrayList.add(stringBuffer.toString());
        LogicalDesign logicalDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logicalDesign)) {
            Iterator iterator = logicalDesign.getGlobalCandidateKeySet().iterator();
            while (iterator.hasNext()) {
                CandidateKey candidateKey = (CandidateKey)iterator.next();
                ContainedObject[] containedObjectArray = candidateKey.getElements();
                for (int i = 0; i < containedObjectArray.length; ++i) {
                    ContainedObject containedObject = containedObjectArray[i];
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(candidateKey.getObjectID()).append(",");
                    stringBuffer.append(candidateKey.getNumID()).append(",");
                    stringBuffer.append(containedObject.getObjectID()).append(",");
                    stringBuffer.append(containedObject.getNumID()).append(",");
                    stringBuffer.append(containedObject.getContainer().getObjectID()).append(",");
                    stringBuffer.append(containedObject.getContainer().getNumID()).append(",");
                    stringBuffer.append(candidateKey.getName()).append(",");
                    stringBuffer.append(containedObject.getContainer().getName()).append(",");
                    stringBuffer.append(containedObject.getName()).append(",");
                    arrayList.add(stringBuffer.toString());
                }
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Key_Attributes.csv";
    }
}

