/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;

public class EHIndex
extends ExportHandler {
    public EHIndex(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Index_Name").append(",");
        stringBuffer.append("ObjectID").append(",");
        stringBuffer.append("NumOID").append(",");
        stringBuffer.append("ImportID").append(",");
        stringBuffer.append("ContainerID").append(",");
        stringBuffer.append("Num_ContainerID").append(",");
        stringBuffer.append("State Type").append(",");
        stringBuffer.append("Functional").append(",");
        stringBuffer.append("Expression").append(",");
        stringBuffer.append("Engineer").append(",");
        stringBuffer.append("Table_Name").append(",");
        stringBuffer.append("Spatial_Index").append(",");
        stringBuffer.append("Spatial_Layer_Type").append(",");
        stringBuffer.append("Geodetic_Index").append(",");
        stringBuffer.append("Number_Of_Dimensions");
        arrayList.add(stringBuffer.toString());
        Iterator iterator = this.getDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (!this.getCsvExporter().isModelSelected(relationalDesign)) continue;
            Iterator iterator2 = relationalDesign.getGlobalIndexSet().iterator();
            while (iterator2.hasNext()) {
                Index index = (Index)iterator2.next();
                stringBuffer = new StringBuffer();
                stringBuffer.append(index.getName()).append(",");
                stringBuffer.append(index.getObjectID()).append(",");
                stringBuffer.append(index.getNumID()).append(",");
                stringBuffer.append(index.getImportedId() != null ? index.getImportedId() : "").append(",");
                stringBuffer.append(index.getContainerObject().getObjectID()).append(",");
                stringBuffer.append(index.getContainerObject().getNumID()).append(",");
                stringBuffer.append(index.getIndexState()).append(",");
                stringBuffer.append(this.replaceAndQuoteString(index.getIndexExpression())).append(",");
                stringBuffer.append(index.hasIndexExpression() ? "Y" : "N").append(",");
                stringBuffer.append(index.getShouldEngineer() ? "Y" : "N").append(",");
                stringBuffer.append(index.getContainerObject().getName()).append(",");
                stringBuffer.append(index.isSpatialIndex() ? "Y" : "N").append(",");
                if (index.isSpatialIndex()) {
                    stringBuffer.append(index.getLayerType() != null ? index.getLayerType() : "").append(",");
                    stringBuffer.append(index.getGeodetic().charAt(0)).append(",");
                    stringBuffer.append(index.getDimensionsNumber()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                arrayList.add(stringBuffer.toString());
                this.getCsvExporter().addNote(index.getObjectID(), index.getNumID(), "Index", index.getNotes());
                this.getCsvExporter().addComment(index.getObjectID(), index.getNumID(), "Index", index.getComment());
                this.getCsvExporter().addCommentRDBMS(index.getObjectID(), index.getNumID(), "Index", index.getCommentInRDBMS());
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Indexes.csv";
    }
}

