/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;

public class EHEntity
extends ExportHandler {
    public EHEntity(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Entity_Name").append(",");
        stringBuffer.append("ObjectID").append(",");
        stringBuffer.append("NumOID").append(",");
        stringBuffer.append("ImportID").append(",");
        stringBuffer.append("ModelID").append(",");
        stringBuffer.append("Num_ModelID").append(",");
        stringBuffer.append("Structured_Type_ID").append(",");
        stringBuffer.append("Num_Structured_Type_ID").append(",");
        stringBuffer.append("Structured_Type_Name").append(",");
        stringBuffer.append("Number_Data_Elements").append(",");
        stringBuffer.append("Classification_Type").append(",");
        stringBuffer.append("Allow_Type_Substitution").append(",");
        stringBuffer.append("Min_Volume").append(",");
        stringBuffer.append("Expected_Volume").append(",");
        stringBuffer.append("Max_Volume").append(",");
        stringBuffer.append("Growth_Rate_Percents").append(",");
        stringBuffer.append("Growth_Rate_Interval").append(",");
        stringBuffer.append("Normal_Form").append(",");
        stringBuffer.append("Temporary_Object_Scope").append(",");
        stringBuffer.append("Adequately_Normalized").append(",");
        stringBuffer.append("Substitution_Parent").append(",");
        stringBuffer.append("Num_Substitution_Parent").append(",");
        stringBuffer.append("Synonyms").append(",");
        stringBuffer.append("Synonym_To_Display").append(",");
        stringBuffer.append("Preferred_Abbreviation").append(",");
        stringBuffer.append("SuperTypeEntity_ID").append(",");
        stringBuffer.append("Num_SuperTypeEntity_ID").append(",");
        stringBuffer.append("Engineering_Strategy").append(",");
        stringBuffer.append("Owner").append(",");
        stringBuffer.append("Entity_Source");
        arrayList.add(stringBuffer.toString());
        LogicalDesign logicalDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logicalDesign)) {
            Iterator iterator = logicalDesign.getEntitySet().iterator();
            while (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                stringBuffer = new StringBuffer();
                stringBuffer.append(entity.getName()).append(",");
                stringBuffer.append(entity.getObjectID()).append(",");
                stringBuffer.append(entity.getNumID()).append(",");
                stringBuffer.append(entity.getImportedId() != null ? entity.getImportedId() : "").append(",");
                stringBuffer.append(logicalDesign.getObjectID()).append(",");
                stringBuffer.append(logicalDesign.getNumID()).append(",");
                if (entity.isBST()) {
                    stringBuffer.append(entity.getBasedOnStructuredType().getObjectID()).append(",");
                    stringBuffer.append(entity.getBasedOnStructuredType().getNumID()).append(",");
                    stringBuffer.append(entity.getBasedOnStructuredType().getName()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                stringBuffer.append(entity.getElements().length).append(",");
                stringBuffer.append(entity.getTypeID()).append(",");
                stringBuffer.append(entity.isAllowTypeSubstitution() ? "Y" : "N").append(",");
                stringBuffer.append(entity.getMinVolumes()).append(",");
                stringBuffer.append(entity.getExpectedVolumes()).append(",");
                stringBuffer.append(entity.getMaxVolumes()).append(",");
                stringBuffer.append(entity.getGrowthPercent()).append(",");
                stringBuffer.append(entity.getGrowthType()).append(",");
                stringBuffer.append(entity.getNormalForm()).append(",");
                stringBuffer.append(entity.getScope()).append(",");
                stringBuffer.append(entity.getAdequatelyNormalized().charAt(0)).append(",");
                if (entity.getTypeSubstitution() != null) {
                    stringBuffer.append(entity.getTypeSubstitution().getObjectID()).append(",");
                    stringBuffer.append(entity.getTypeSubstitution().getNumID()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                stringBuffer.append(this.quotedString(entity.getSynonym())).append(",");
                stringBuffer.append(entity.getSynonymToDisplay()).append(",");
                stringBuffer.append(entity.getPreferredAbbreviation()).append(",");
                if (entity.getHierarchicalParent() != null) {
                    stringBuffer.append(entity.getHierarchicalParent().getObjectID()).append(",");
                    stringBuffer.append(entity.getHierarchicalParent().getNumID()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                if (entity.isHierarchicalEntityType()) {
                    stringBuffer.append(entity.getFwdEngineeringStrategyName()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                }
                stringBuffer.append(entity.getOwner()).append(",");
                stringBuffer.append(entity.getSource()).append(",");
                arrayList.add(stringBuffer.toString());
                this.getCsvExporter().addNote(entity.getObjectID(), entity.getNumID(), "Entity", entity.getNotes());
                this.getCsvExporter().addComment(entity.getObjectID(), entity.getNumID(), "Entity", entity.getComment());
                this.getCsvExporter().addCommentRDBMS(entity.getObjectID(), entity.getNumID(), "Entity", entity.getCommentInRDBMS());
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Entities.csv";
    }
}

