/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.constraint.AVT;

public class EHDomainValueRanges
extends ExportHandler {
    public EHDomainValueRanges(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Domain_ID").append(",");
        stringBuffer.append("Num_Domain_ID").append(",");
        stringBuffer.append("Sequence").append(",");
        stringBuffer.append("Begin_Value").append(",");
        stringBuffer.append("End_Value").append(",");
        stringBuffer.append("Short_Description").append(",");
        stringBuffer.append("Domain_Name");
        arrayList.add(stringBuffer.toString());
        Iterator iterator = this.getDesign().getDomainSet().iterator();
        while (iterator.hasNext()) {
            Domain domain = (Domain)iterator.next();
            Iterator iterator2 = domain.getAVTs().iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                ++n;
                AVT aVT = (AVT)iterator2.next();
                stringBuffer = new StringBuffer();
                stringBuffer.append(domain.getObjectID()).append(",");
                stringBuffer.append(domain.getNumID()).append(",");
                stringBuffer.append(n).append(",");
                stringBuffer.append(this.quotedIfHasSpatias(aVT.getBeginValue())).append(",");
                stringBuffer.append(this.quotedIfHasSpatias(aVT.getEndValue())).append(",");
                stringBuffer.append(this.replaceAndQuoteString(aVT.getDescription())).append(",");
                stringBuffer.append(domain.getName()).append(",");
                arrayList.add(stringBuffer.toString());
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Domain_Value_Ranges.csv";
    }
}

