/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;

public class EHConstrIndexColumns
extends ExportHandler {
    public EHConstrIndexColumns(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Index_ID").append(",");
        stringBuffer.append("Num_Index_ID").append(",");
        stringBuffer.append("ColumnID").append(",");
        stringBuffer.append("Num_ColumnID").append(",");
        stringBuffer.append("Table_ID").append(",");
        stringBuffer.append("Num_Table_ID").append(",");
        stringBuffer.append("Index_Name").append(",");
        stringBuffer.append("Table_Name").append(",");
        stringBuffer.append("Column_Name").append(",");
        stringBuffer.append("Sequence").append(",");
        stringBuffer.append("Sort_Order");
        arrayList.add(stringBuffer.toString());
        Iterator iterator = this.getDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (!this.getCsvExporter().isModelSelected(relationalDesign)) continue;
            Iterator iterator2 = relationalDesign.getGlobalIndexSet().iterator();
            while (iterator2.hasNext()) {
                Index index = (Index)iterator2.next();
                ContainedObject[] containedObjectArray = index.getElements();
                for (int i = 0; i < containedObjectArray.length; ++i) {
                    ContainedObject containedObject = containedObjectArray[i];
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(index.getObjectID()).append(",");
                    stringBuffer.append(index.getNumID()).append(",");
                    stringBuffer.append(containedObject.getObjectID()).append(",");
                    stringBuffer.append(containedObject.getNumID()).append(",");
                    stringBuffer.append(index.getContainerObject().getObjectID()).append(",");
                    stringBuffer.append(index.getContainerObject().getNumID()).append(",");
                    stringBuffer.append(index.getName()).append(",");
                    stringBuffer.append(index.getContainerObject().getName()).append(",");
                    stringBuffer.append(containedObject.getName()).append(",");
                    stringBuffer.append(i + 1).append(",");
                    stringBuffer.append(index.getColumnSortOrder(containedObject)).append(",");
                    arrayList.add(stringBuffer.toString());
                }
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Constr_Index_Columns.csv";
    }
}

