/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;

public class EHAttribute
extends ExportHandler {
    public EHAttribute(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Attribute_Name").append(",");
        stringBuffer.append("ObjectID").append(",");
        stringBuffer.append("NumOID").append(",");
        stringBuffer.append("ImportID").append(",");
        stringBuffer.append("ContainerID").append(",");
        stringBuffer.append("Num_ContainerID").append(",");
        stringBuffer.append("Mandatory").append(",");
        stringBuffer.append("DataType_Kind").append(",");
        stringBuffer.append("Value_Type").append(",");
        stringBuffer.append("Formula").append(",");
        stringBuffer.append("ScopeEntityID").append(",");
        stringBuffer.append("Num_ScopeEntityID").append(",");
        stringBuffer.append("Domain_ID").append(",");
        stringBuffer.append("Num_Domain_ID").append(",");
        stringBuffer.append("Logical_Type_ID").append(",");
        stringBuffer.append("Num_Logical_Type_ID").append(",");
        stringBuffer.append("Distinct_Type_ID").append(",");
        stringBuffer.append("Num_Distinct_Type_ID").append(",");
        stringBuffer.append("Structured_Type_ID").append(",");
        stringBuffer.append("Num_Structured_Type_ID").append(",");
        stringBuffer.append("Collection_Type_ID").append(",");
        stringBuffer.append("Num_Collection_Type_ID").append(",");
        stringBuffer.append("Check_Constraint_Name").append(",");
        stringBuffer.append("Default_Value").append(",");
        stringBuffer.append("Use_Domain_Constraint").append(",");
        stringBuffer.append("Domain_Name").append(",");
        stringBuffer.append("Logical_Type_Name").append(",");
        stringBuffer.append("Structured_Type_Name").append(",");
        stringBuffer.append("Distinct_Type_Name").append(",");
        stringBuffer.append("Collection_Type_Name").append(",");
        stringBuffer.append("Synonyms").append(",");
        stringBuffer.append("Preferred_Abbreviation").append(",");
        stringBuffer.append("Relation_ID").append(",");
        stringBuffer.append("Num_Relation_ID").append(",");
        stringBuffer.append("Entity_Name").append(",");
        stringBuffer.append("PK_Flag").append(",");
        stringBuffer.append("FK_Flag").append(",");
        stringBuffer.append("Relation_Name").append(",");
        stringBuffer.append("Sequence").append(",");
        stringBuffer.append("T_Size").append(",");
        stringBuffer.append("T_Precision").append(",");
        stringBuffer.append("T_Scale").append(",");
        stringBuffer.append("Data_Source");
        arrayList.add(stringBuffer.toString());
        LogicalDesign logicalDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logicalDesign)) {
            Iterator iterator = logicalDesign.getAttributeSet().iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                stringBuffer = new StringBuffer();
                stringBuffer.append(attribute.getName()).append(",");
                stringBuffer.append(attribute.getObjectID()).append(",");
                stringBuffer.append(attribute.getNumID()).append(",");
                stringBuffer.append(attribute.getImportedId() != null ? attribute.getImportedId() : "").append(",");
                stringBuffer.append(attribute.getContainer().getObjectID()).append(",");
                stringBuffer.append(attribute.getContainer().getNumID()).append(",");
                stringBuffer.append(attribute.getNullsAllowed() ? "N" : "Y").append(",");
                switch (attribute.getUse()) {
                    case 0: {
                        stringBuffer.append("Domain").append(",");
                        break;
                    }
                    case 1: {
                        stringBuffer.append("Logical Type").append(",");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("Distinct Type").append(",");
                        break;
                    }
                    case 3: {
                        if (attribute.isReference()) {
                            stringBuffer.append("Ref Struct Type").append(",");
                            break;
                        }
                        stringBuffer.append("Structured Type").append(",");
                        break;
                    }
                    case 4: {
                        stringBuffer.append("Collection Type").append(",");
                    }
                }
                stringBuffer.append(attribute.getSourceType()).append(",");
                stringBuffer.append(attribute.getFormulaDesc()).append(",");
                if (attribute.getScope() != null) {
                    stringBuffer.append(attribute.getScope().getObjectID()).append(",");
                    stringBuffer.append(attribute.getScope().getNumID()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                stringBuffer.append(attribute.getDomain().getObjectID()).append(",");
                stringBuffer.append(attribute.getDomain().getNumID()).append(",");
                stringBuffer.append(attribute.getLogicalDatatype().getObjectID()).append(",");
                stringBuffer.append(attribute.getLogicalDatatype().getNumID()).append(",");
                if (attribute.getDistinctType() != null) {
                    stringBuffer.append(attribute.getDistinctType().getObjectID()).append(",");
                    stringBuffer.append(attribute.getDistinctType().getNumID()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                if (attribute.getStructuredType() != null) {
                    stringBuffer.append(attribute.getStructuredType().getObjectID()).append(",");
                    stringBuffer.append(attribute.getStructuredType().getNumID()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                if (attribute.getCollectionType() != null) {
                    stringBuffer.append(attribute.getCollectionType().getObjectID()).append(",");
                    stringBuffer.append(attribute.getCollectionType().getNumID()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                stringBuffer.append(attribute.getConstraintName()).append(",");
                stringBuffer.append(attribute.getDefaultValue()).append(",");
                stringBuffer.append(attribute.getUseDomainConstraints() ? "Y" : "N").append(",");
                if (attribute.getUse() == 0) {
                    stringBuffer.append(attribute.getDomain().getName()).append(",");
                    stringBuffer.append(attribute.getDomain().getLogicalDatatype().getName()).append(",");
                } else if (attribute.getUse() == 1) {
                    stringBuffer.append("").append(",");
                    stringBuffer.append(attribute.getLogicalDatatype().getName()).append(",");
                } else if (attribute.getUse() == 2) {
                    stringBuffer.append("").append(",");
                    stringBuffer.append(attribute.getDistinctType().getLogicalDataType().getName()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                if (attribute.getStructuredType() != null) {
                    stringBuffer.append(attribute.getStructuredType().getName()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                }
                if (attribute.getDistinctType() != null) {
                    stringBuffer.append(attribute.getDistinctType().getName()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                }
                if (attribute.getCollectionType() != null) {
                    stringBuffer.append(attribute.getCollectionType().getName()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                }
                stringBuffer.append(this.quotedString(attribute.getSynonym())).append(",");
                stringBuffer.append(attribute.getPreferredAbbreviation()).append(",");
                if (attribute.isFKAttribute()) {
                    DesignObject designObject = attribute.getGenerator();
                    stringBuffer.append(designObject.getObjectID()).append(",");
                    stringBuffer.append(designObject.getNumID()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                stringBuffer.append(attribute.getContainer().getName()).append(",");
                if (attribute.isPKElement()) {
                    stringBuffer.append("P").append(",");
                } else {
                    stringBuffer.append("").append(",");
                }
                if (attribute.isFKAttribute()) {
                    stringBuffer.append("F").append(",");
                } else {
                    stringBuffer.append("").append(",");
                }
                if (attribute.isFKAttribute()) {
                    stringBuffer.append(attribute.getGenerator().getName()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                }
                stringBuffer.append(attribute.getContainer().getIndexOf(attribute) + 1).append(",");
                if (attribute.getUse() == 0) {
                    stringBuffer.append(attribute.getDomain().getSize()).append(",");
                    stringBuffer.append(attribute.getDomain().getPrecision()).append(",");
                    stringBuffer.append(attribute.getDomain().getScale()).append(",");
                } else if (attribute.getUse() == 1) {
                    stringBuffer.append(attribute.getSize()).append(",");
                    stringBuffer.append(attribute.getPrecision()).append(",");
                    stringBuffer.append(attribute.getScale()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                stringBuffer.append(attribute.getSource()).append(",");
                arrayList.add(stringBuffer.toString());
                this.getCsvExporter().addNote(attribute.getObjectID(), attribute.getNumID(), "Attribute", attribute.getNotes());
                this.getCsvExporter().addComment(attribute.getObjectID(), attribute.getNumID(), "Attribute", attribute.getComment());
                this.getCsvExporter().addCommentRDBMS(attribute.getObjectID(), attribute.getNumID(), "Attribute", attribute.getCommentInRDBMS());
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Attributes.csv";
    }
}

