/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.awt.Cursor;
import java.awt.Dimension;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.csv.EHAVT;
import oracle.dbtools.crest.exports.csv.EHAttribute;
import oracle.dbtools.crest.exports.csv.EHCheckConstraint;
import oracle.dbtools.crest.exports.csv.EHClassificationType;
import oracle.dbtools.crest.exports.csv.EHColumn;
import oracle.dbtools.crest.exports.csv.EHComments;
import oracle.dbtools.crest.exports.csv.EHCommentsRDBMS;
import oracle.dbtools.crest.exports.csv.EHConstrIndexColumns;
import oracle.dbtools.crest.exports.csv.EHDomain;
import oracle.dbtools.crest.exports.csv.EHDomainAVT;
import oracle.dbtools.crest.exports.csv.EHDomainCheckConstraint;
import oracle.dbtools.crest.exports.csv.EHDomainValueRanges;
import oracle.dbtools.crest.exports.csv.EHEntity;
import oracle.dbtools.crest.exports.csv.EHEntityView;
import oracle.dbtools.crest.exports.csv.EHForeignKey;
import oracle.dbtools.crest.exports.csv.EHIndex;
import oracle.dbtools.crest.exports.csv.EHKey;
import oracle.dbtools.crest.exports.csv.EHKeyAttributes;
import oracle.dbtools.crest.exports.csv.EHLogicalToNative;
import oracle.dbtools.crest.exports.csv.EHLogicalType;
import oracle.dbtools.crest.exports.csv.EHMappings;
import oracle.dbtools.crest.exports.csv.EHModel;
import oracle.dbtools.crest.exports.csv.EHNativeToLogical;
import oracle.dbtools.crest.exports.csv.EHNotes;
import oracle.dbtools.crest.exports.csv.EHPKOidColumns;
import oracle.dbtools.crest.exports.csv.EHProcessAttributes;
import oracle.dbtools.crest.exports.csv.EHProcessEntities;
import oracle.dbtools.crest.exports.csv.EHRDBMSSites;
import oracle.dbtools.crest.exports.csv.EHRelation;
import oracle.dbtools.crest.exports.csv.EHSpatialColumnDefinition;
import oracle.dbtools.crest.exports.csv.EHSpatialDimension;
import oracle.dbtools.crest.exports.csv.EHTable;
import oracle.dbtools.crest.exports.csv.EHTableConstraints;
import oracle.dbtools.crest.exports.csv.EHTableIncludeScripts;
import oracle.dbtools.crest.exports.csv.EHTableView;
import oracle.dbtools.crest.exports.csv.EHValueRanges;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.exports.csv.SelectCSVExportDialog;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.ExportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class CSVExporter {
    private ApplicationView appView;
    private ProgressDialog monitor;
    private ExportLogger exportLog;
    private String exportFolder;
    private List ehList;
    private List designPartObjects = null;
    private List notes = new ArrayList();
    private List comments = new ArrayList();
    private List commentsRDBMS = new ArrayList();
    private Design design;
    private static final Logger LOGGER = new Logger(CSVExporter.class);

    public CSVExporter(ApplicationView applicationView) {
        this.appView = applicationView;
        this.design = this.appView.getCurrentDesign();
        this.exportLog = new ExportLogger("CSV");
    }

    protected boolean isModelSelected(DesignPart designPart) {
        if (this.designPartObjects != null) {
            for (SelectCSVExportDialog.ExpObject expObject : this.designPartObjects) {
                if (expObject.getObject() != designPart) continue;
                return expObject.isSelected();
            }
        }
        return false;
    }

    private void initExportHandlers() {
        this.ehList = new ArrayList();
        this.ehList.add(new EHModel(this));
        this.ehList.add(new EHDomain(this));
        this.ehList.add(new EHDomainCheckConstraint(this));
        this.ehList.add(new EHDomainValueRanges(this));
        this.ehList.add(new EHDomainAVT(this));
        this.ehList.add(new EHClassificationType(this));
        this.ehList.add(new EHEntity(this));
        this.ehList.add(new EHAttribute(this));
        this.ehList.add(new EHKey(this));
        this.ehList.add(new EHKeyAttributes(this));
        this.ehList.add(new EHRelation(this));
        this.ehList.add(new EHEntityView(this));
        this.ehList.add(new EHTable(this));
        this.ehList.add(new EHColumn(this));
        this.ehList.add(new EHIndex(this));
        this.ehList.add(new EHForeignKey(this));
        this.ehList.add(new EHTableView(this));
        this.ehList.add(new EHPKOidColumns(this));
        this.ehList.add(new EHConstrIndexColumns(this));
        this.ehList.add(new EHSpatialColumnDefinition(this));
        this.ehList.add(new EHSpatialDimension(this));
        this.ehList.add(new EHTableIncludeScripts(this));
        this.ehList.add(new EHTableConstraints(this));
        this.ehList.add(new EHCheckConstraint(this));
        this.ehList.add(new EHValueRanges(this));
        this.ehList.add(new EHAVT(this));
        this.ehList.add(new EHMappings(this));
        this.ehList.add(new EHRDBMSSites(this));
        this.ehList.add(new EHLogicalType(this));
        this.ehList.add(new EHLogicalToNative(this));
        this.ehList.add(new EHNativeToLogical(this));
        this.ehList.add(new EHProcessEntities(this));
        this.ehList.add(new EHProcessAttributes(this));
        this.ehList.add(new EHNotes(this));
        this.ehList.add(new EHComments(this));
        this.ehList.add(new EHCommentsRDBMS(this));
    }

    private void initNumIDs() {
        ModelIDObject modelIDObject;
        DesignPart designPart;
        Object object;
        ModelIDObject modelIDObject2;
        int n = 1;
        Iterator iterator = this.design.getDomainSet().iterator();
        while (iterator.hasNext()) {
            modelIDObject2 = (ModelIDObject)iterator.next();
            modelIDObject2.setNumID(n);
            ++n;
        }
        iterator = this.design.getLogicalDatatypeSet().iterator();
        while (iterator.hasNext()) {
            modelIDObject2 = (ModelIDObject)iterator.next();
            modelIDObject2.setNumID(n);
            ++n;
        }
        modelIDObject2 = this.design.getLogicalDesign();
        if (this.isModelSelected((DesignPart)modelIDObject2)) {
            modelIDObject2.setNumID(n);
            ++n;
            iterator = ((LogicalDesign)modelIDObject2).getEntitySet().iterator();
            while (iterator.hasNext()) {
                object = (ModelIDObject)iterator.next();
                ((ModelIDObject)object).setNumID(n);
                ++n;
            }
            iterator = ((LogicalDesign)modelIDObject2).getAttributeSet().iterator();
            while (iterator.hasNext()) {
                object = (ModelIDObject)iterator.next();
                ((ModelIDObject)object).setNumID(n);
                ++n;
            }
            iterator = ((LogicalDesign)modelIDObject2).getGlobalCandidateKeySet().iterator();
            while (iterator.hasNext()) {
                object = (ModelIDObject)iterator.next();
                ((ModelIDObject)object).setNumID(n);
                ++n;
            }
            iterator = ((LogicalDesign)modelIDObject2).getRelationSet().iterator();
            while (iterator.hasNext()) {
                object = (ModelIDObject)iterator.next();
                ((ModelIDObject)object).setNumID(n);
                ++n;
            }
            iterator = ((LogicalDesign)modelIDObject2).getEntityViewSet().iterator();
            while (iterator.hasNext()) {
                object = (ModelIDObject)iterator.next();
                ((ModelIDObject)object).setNumID(n);
                ++n;
            }
            iterator = ((LogicalDesign)modelIDObject2).getAttributeViewSet().iterator();
            while (iterator.hasNext()) {
                object = (ModelIDObject)iterator.next();
                ((ModelIDObject)object).setNumID(n);
                ++n;
            }
        }
        object = this.design.getRelationalDesigns().iterator();
        while (object.hasNext()) {
            designPart = (RelationalDesign)object.next();
            if (!this.isModelSelected(designPart)) continue;
            designPart.setNumID(n);
            ++n;
            iterator = ((RelationalDesign)designPart).getTableSet().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (ModelIDObject)iterator.next();
                modelIDObject.setNumID(n);
                ++n;
            }
            iterator = ((RelationalDesign)designPart).getColumnSet().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (ModelIDObject)iterator.next();
                modelIDObject.setNumID(n);
                ++n;
            }
            iterator = ((RelationalDesign)designPart).getGlobalIndexSet().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (ModelIDObject)iterator.next();
                modelIDObject.setNumID(n);
                ++n;
            }
            iterator = ((RelationalDesign)designPart).getFKIndexAssociationSet().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (ModelIDObject)iterator.next();
                modelIDObject.setNumID(n);
                ++n;
            }
            iterator = ((RelationalDesign)designPart).getTableViewSet().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (ModelIDObject)iterator.next();
                modelIDObject.setNumID(n);
                ++n;
            }
            iterator = ((RelationalDesign)designPart).getColumnViewSet().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (ModelIDObject)iterator.next();
                modelIDObject.setNumID(n);
                ++n;
            }
        }
        designPart = this.design.getDataTypesDesign();
        if (this.isModelSelected(designPart)) {
            designPart.setNumID(n);
            ++n;
            iterator = ((DataTypesDesign)designPart).getStructuredTypeSet().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (ModelIDObject)iterator.next();
                modelIDObject.setNumID(n);
                ++n;
            }
            iterator = ((DataTypesDesign)designPart).getCollectionTypeSet().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (ModelIDObject)iterator.next();
                modelIDObject.setNumID(n);
                ++n;
            }
            iterator = ((DataTypesDesign)designPart).getDistinctTypeSet().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (ModelIDObject)iterator.next();
                modelIDObject.setNumID(n);
                ++n;
            }
        }
        modelIDObject = this.design.getProcessModel();
        iterator = ((ProcessModel)modelIDObject).getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            AbstractProcessObject abstractProcessObject;
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
            dataFlowDesign.setNumID(++n);
            Iterator iterator2 = dataFlowDesign.getProcessSet().iterator();
            while (iterator2.hasNext()) {
                abstractProcessObject = (Process)iterator2.next();
                abstractProcessObject.setNumID(++n);
            }
            iterator2 = dataFlowDesign.getFlowSet().iterator();
            while (iterator2.hasNext()) {
                abstractProcessObject = (Flow)iterator2.next();
                abstractProcessObject.setNumID(++n);
            }
        }
    }

    private void deleteDB() {
        File file = new File(this.exportFolder, "csvDB");
        if (file.exists() && !this.deleteDir(file)) {
            MessageDialogs.showWarningMessage(MessageFormat.format(Messages.getString("CSVExporter.InternalDatabaseFolderCanNotBeDeleted"), file.getAbsoluteFile()));
        }
    }

    public boolean deleteDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = this.deleteDir(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public void execute() {
        new Thread(new Runner()).start();
    }

    public String getExportFolder() {
        return this.exportFolder;
    }

    public void setExportFolder(String string) {
        this.exportFolder = string;
    }

    public Design getDesign() {
        return this.design;
    }

    public void setDesignPartObjects(List list) {
        this.designPartObjects = list;
    }

    public List getNotes() {
        return this.notes;
    }

    public List getComments() {
        return this.comments;
    }

    public List getCommentsRDBMS() {
        return this.commentsRDBMS;
    }

    public void addNote(String string, int n, String string2, String string3) {
        this.notes.add(new ObjDesc(string, n, string2, string3));
    }

    public void addComment(String string, int n, String string2, String string3) {
        this.comments.add(new ObjDesc(string, n, string2, string3));
    }

    public void addCommentRDBMS(String string, int n, String string2, String string3) {
        this.commentsRDBMS.add(new ObjDesc(string, n, string2, string3));
    }

    public ApplicationView getAppView() {
        return this.appView;
    }

    class ObjDesc {
        String objectID;
        int numOID;
        String type;
        String text;

        public ObjDesc(String string, int n, String string2, String string3) {
            this.objectID = string;
            this.numOID = n;
            this.type = string2;
            this.text = string3;
        }

        public String getObjectID() {
            return this.objectID;
        }

        public int getNumOID() {
            return this.numOID;
        }

        public String getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
            try {
                CSVExporter.this.monitor = new ProgressDialog(CSVExporter.this.appView, "", 0, 100);
                try {
                    CSVExporter.this.deleteDB();
                    CSVExporter.this.monitor.setNote(Messages.getString("CSVExporter.Initializing"));
                    CSVExporter.this.monitor.setProgress(1);
                    CSVExporter.this.initExportHandlers();
                    CSVExporter.this.initNumIDs();
                    CSVExporter.this.monitor.setNote(Messages.getString("CSVExporter.Export"));
                    CSVExporter.this.monitor.setProgress(10);
                    double d = 10.0;
                    int n = CSVExporter.this.ehList.size();
                    Iterator iterator = CSVExporter.this.ehList.iterator();
                    while (iterator.hasNext()) {
                        CSVExporter.this.monitor.setProgress((int)(d += 90.0 / (double)n));
                        ExportHandler exportHandler = (ExportHandler)iterator.next();
                        exportHandler.Export();
                    }
                }
                finally {
                    CSVExporter.this.monitor.close();
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error Exporting to CSV: ", exception);
                CSVExporter.this.exportLog.addError(exception.toString());
            }
            finally {
                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                LogReport logReport = new LogReport(CSVExporter.this.appView);
                logReport.setLog(CSVExporter.this.exportLog.generateReport(CSVExporter.this.appView));
                logReport.showDialog(new Dimension(750, 550));
            }
        }
    }
}

