/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.tools;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.tools.StandaloneXmlContext;
import oracle.bali.xml.util.DefaultPrefixLookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class MetadataUpgrader {
    private static final String _MD_NS = "http://xmlns.oracle.com/bali/xml/metadata";
    private static final Map _MAPPINGS = Collections.unmodifiableMap(MetadataUpgrader._createMappings());

    public static void main(String[] args) throws Exception {
        File file = new File(args[0]);
        MetadataUpgrader.upgradeFile(file);
    }

    public static void upgradeFile(File file) throws Exception {
        System.out.println("Upgrading file " + file.getName());
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                MetadataUpgrader.upgradeFile(files[i]);
            }
        } else {
            URL url = file.toURL();
            MetadataUpgrader.upgradeURL(url);
        }
    }

    public static void upgradeURL(URL url) throws Exception {
        StandaloneXmlContext context = new StandaloneXmlContext(url);
        MetadataUpgrader._doUpgrade(context);
        context.save(url);
    }

    public static void upgrade(InputStream in, OutputStream out) throws Exception {
        StandaloneXmlContext context = new StandaloneXmlContext(in);
        MetadataUpgrader._doUpgrade(context);
        context.save(out);
    }

    public static Map getMappings() {
        return _MAPPINGS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _doUpgrade(XmlContext context) throws Exception {
        XmlModel model = context.getSourceModel();
        Map metadataChanges = MetadataUpgrader.getMappings();
        boolean success = false;
        model.startTransaction("upgrade metadata");
        try {
            Node next;
            Document doc = model.getDocument();
            DocumentTraversal t = (DocumentTraversal)((Object)doc);
            NodeIterator iter = t.createNodeIterator(doc.getDocumentElement(), 1, null, false);
            while ((next = iter.nextNode()) != null) {
                String replacement;
                LinkedList<Node> nodesToReplace = new LinkedList<Node>();
                if (_MD_NS.equals(next.getNamespaceURI()) && (replacement = (String)metadataChanges.get(next.getLocalName())) != null) {
                    nodesToReplace.add(next);
                }
                for (Node nodeToReplace : nodesToReplace) {
                    String replacement2 = (String)metadataChanges.get(nodeToReplace.getLocalName());
                    Node parent = nodeToReplace.getParentNode();
                    Element replacementElement = doc.createElementNS(_MD_NS, replacement2);
                    String oldValue = nodeToReplace.getFirstChild().getNodeValue().trim();
                    Text newValue = doc.createTextNode("${md:getTranslatedString(\"" + oldValue + "\")}");
                    replacementElement.appendChild(newValue);
                    model.fixPrefixes(parent, replacementElement, new MdPrefixLookup());
                    System.out.println("replacing " + nodeToReplace.getLocalName() + " with " + replacementElement.getLocalName());
                    parent.replaceChild(replacementElement, nodeToReplace);
                }
            }
            model.commitTransaction(true);
            success = true;
        }
        finally {
            if (!success) {
                model.rollbackTransaction();
            }
        }
    }

    private static Map _createMappings() {
        HashMap<String, String> metadataChanges = new HashMap<String, String>();
        metadataChanges.put("shortDescriptionKey", "shortDescription");
        metadataChanges.put("palettePageKey", "group");
        metadataChanges.put("displayNameKey", "shortDisplayName");
        metadataChanges.put("groupKey", "group");
        return metadataChanges;
    }

    private static class MdPrefixLookup
    implements DefaultPrefixLookup {
        private MdPrefixLookup() {
        }

        @Override
        public String getDefaultPrefix(String ns) {
            if (MetadataUpgrader._MD_NS.equals(ns)) {
                return "md";
            }
            return null;
        }
    }
}

