/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.misc;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.SimpleCollapseWhitespaceHandler;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ConstrainingFacet;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.model.XmlModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GrammarBasedWhitespaceHandler
extends WhitespaceHandler {
    private final WeakReference<XmlModel> _model;
    private final ThreadLocal _elementToElementDefCache = new ThreadLocal();
    private final ThreadLocal _namespaceToGrammar = new ThreadLocal();
    private static final Map _sTypeToModeCache = Collections.synchronizedMap(new WeakHashMap());
    private static final Logger _LOGGER = Logger.getLogger(GrammarBasedWhitespaceHandler.class.getName());
    private static final WhitespaceHandler _BASE = SimpleCollapseWhitespaceHandler.getSimpleCollapseWhitespaceHandler();
    private static final Object _UNSET_VALUE = new Object();

    public GrammarBasedWhitespaceHandler(XmlModel model) {
        this._model = new WeakReference<XmlModel>(model);
    }

    @Override
    public void beginCacheablePeriod() {
        this._elementToElementDefCache.set(new HashMap(27));
        this._namespaceToGrammar.set(new HashMap(10));
    }

    @Override
    public void endCacheablePeriod() {
        this._elementToElementDefCache.set(null);
        this._namespaceToGrammar.set(null);
    }

    @Override
    public WhitespaceMode getAttributeContentWhitespaceMode(TreeTraversal traversal, Element owningElement, String attrNamespace, String attrLocalName) {
        Grammar grammar;
        AttributeDef attrDef = null;
        ElementDef elemDef = this._getElementDef(traversal, owningElement);
        if (elemDef != null) {
            attrDef = elemDef.getAttributeDefByName(attrNamespace, attrLocalName);
        }
        if (attrDef == null && (grammar = this._getGrammarForNamespace(attrNamespace)) != null) {
            attrDef = grammar.getAttributeDefByName(attrLocalName);
        }
        if (attrDef != null) {
            SimpleType type = attrDef.getType();
            WhitespaceMode mode = this._getMode((Type)type);
            GrammarBasedWhitespaceHandler._log(owningElement, (Type)type, mode);
            if (mode != null) {
                return mode;
            }
        }
        return _BASE.getAttributeContentWhitespaceMode(traversal, owningElement, attrNamespace, attrLocalName);
    }

    @Override
    protected WhitespaceMode getElementContentWhitespaceModeImpl(TreeTraversal traversal, Element element, WhitespaceMode specifiedMode) {
        if (specifiedMode != null) {
            return specifiedMode;
        }
        ElementDef elemDef = this._getElementDef(traversal, element);
        if (elemDef != null) {
            Type type = elemDef.getType();
            WhitespaceMode mode = this._getMode(type);
            GrammarBasedWhitespaceHandler._log(element, type, mode);
            if (mode != null) {
                return mode;
            }
            if (type instanceof SimpleType) {
                return this.getDefaultModeForSimpleTypeElements();
            }
            if (type instanceof ComplexType) {
                return this.getDefaultModeForComplexTypeElements();
            }
        }
        return _BASE.getElementContentWhitespaceMode(traversal, element);
    }

    protected WhitespaceMode getDefaultModeForSimpleTypeElements() {
        return WhitespaceMode.MODE_COLLAPSE;
    }

    protected WhitespaceMode getDefaultModeForComplexTypeElements() {
        return WhitespaceMode.MODE_COLLAPSE;
    }

    private ElementDef _getElementDef(TreeTraversal traversal, Element element) {
        ElementDef elemDef;
        String namespace = element.getNamespaceURI();
        Grammar grammar = this._getGrammarForNamespace(namespace);
        if (grammar == null) {
            return null;
        }
        Map cacheMap = this._getElementToElementDefCache();
        Object cached = cacheMap.get(element);
        if (cached == null) {
            elemDef = this._getElementDefDirectly(traversal, grammar, element);
            if (cacheMap != Collections.EMPTY_MAP) {
                if (elemDef == null) {
                    cacheMap.put(element, _UNSET_VALUE);
                } else {
                    cacheMap.put(element, elemDef);
                }
            }
        } else {
            elemDef = cached == _UNSET_VALUE ? null : (ElementDef)cached;
        }
        return elemDef;
    }

    private ElementDef _getElementDefDirectly(TreeTraversal traversal, Grammar grammarForElemNs, Element element) {
        ElementDef ourDef;
        ElementDef parentDef;
        String elemNS = element.getNamespaceURI();
        String elemLocalName = DomUtils.getLocalName((Node)element);
        Node parent = traversal.getParentNode((Node)element);
        if (DomUtils.isElement((Node)parent) && (parentDef = this._getElementDef(traversal, (Element)parent)) != null && (ourDef = parentDef.getElementDefByName(elemNS, elemLocalName)) != null) {
            return ourDef;
        }
        if (grammarForElemNs != null) {
            return grammarForElemNs.getElementDefByName(elemLocalName);
        }
        return null;
    }

    private Map _getElementToElementDefCache() {
        Object got = this._elementToElementDefCache.get();
        if (got == null) {
            return Collections.EMPTY_MAP;
        }
        return (Map)got;
    }

    private Grammar _getGrammarForNamespace(String namespace) {
        Object cache = this._namespaceToGrammar.get();
        GrammarProvider grammarProvider = this._provider();
        if (cache == null) {
            return grammarProvider != null ? grammarProvider.getGrammarForNamespace(namespace) : null;
        }
        Map map = (Map)cache;
        Object fromCache = map.get(namespace);
        if (fromCache == null) {
            Grammar grammar;
            Grammar grammar2 = grammar = grammarProvider != null ? grammarProvider.getGrammarForNamespace(namespace) : null;
            if (grammar == null) {
                map.put(namespace, _UNSET_VALUE);
            } else {
                map.put(namespace, grammar);
            }
            return grammar;
        }
        if (fromCache == _UNSET_VALUE) {
            return null;
        }
        return (Grammar)fromCache;
    }

    private GrammarProvider _provider() {
        XmlModel model = (XmlModel)this._model.get();
        return model == null ? null : model.getContext().getGrammarProvider();
    }

    private WhitespaceMode _getMode(Type type) {
        Object cached = _sTypeToModeCache.get(type);
        if (cached == _UNSET_VALUE) {
            return null;
        }
        if (cached != null) {
            return (WhitespaceMode)cached;
        }
        WhitespaceMode mode = this._getModeDirectly(type);
        if (mode == null) {
            _sTypeToModeCache.put(type, _UNSET_VALUE);
        } else {
            _sTypeToModeCache.put(type, mode);
        }
        return mode;
    }

    private WhitespaceMode _getModeDirectly(Type type) {
        if (type instanceof SimpleType) {
            SimpleType simple = (SimpleType)type;
            ConstrainingFacet whitespaceFacet = TypeUtils.findFacet((SimpleType)simple, (int)12);
            if (whitespaceFacet != null) {
                String facetVal = whitespaceFacet.getConstraintValue();
                if ("preserve".equals(facetVal)) {
                    return WhitespaceMode.MODE_PRESERVE;
                }
                if ("replace".equals(facetVal)) {
                    return WhitespaceMode.MODE_REPLACE;
                }
                if ("collapse".equals(facetVal)) {
                    return WhitespaceMode.MODE_COLLAPSE;
                }
            }
        } else if (type instanceof ComplexType) {
            switch (type.getVariety()) {
                case 3: 
                case 6: {
                    return WhitespaceMode.MODE_COLLAPSE;
                }
                case 5: {
                    SimpleType simple = TypeUtils.getSimpleTypeAncestor((Type)type);
                    if (simple == null) break;
                    return this._getMode((Type)simple);
                }
            }
        }
        return null;
    }

    private static void _log(Element elem, Type type, WhitespaceMode mode) {
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "Grammar-based whitespace handler: mode={0} type={1} elem={2}", new Object[]{mode, type.getName(), elem.getNodeName()});
        }
    }
}

