/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.message;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Action;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.message.MessageCategory;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.javatools.status.Issue;
import oracle.javatools.status.Severity;
import org.w3c.dom.Node;

public abstract class XmlModelMessage
implements Issue {
    public static final Level ERROR = Level.SEVERE;
    public static final Level WARNING = Level.WARNING;
    public static final Level INFO = Level.INFO;
    public static final String XML_MODEL_MESSAGE_TYPE_UNKNOWN = "XML-MODEL-MESSAGE-TYPE-UNKNOWN";
    private final XmlModel _model;

    public abstract Level getLevel();

    public abstract String getShortDescription();

    public abstract MessageCategory getCategory();

    public int getTextStartOffset() {
        return this._textOffset(this.getRelatedNode(), true);
    }

    public int getTextEndOffset() {
        return this._textOffset(this.getRelatedNode(), false);
    }

    public Node getRelatedNode() {
        return null;
    }

    public String getLongDescription() {
        return this.getShortDescription();
    }

    public Object getCause() {
        return null;
    }

    public final boolean isAtLeastLevel(Level level) {
        return this.getLevel().intValue() >= level.intValue();
    }

    public final boolean isExactLevel(Level level) {
        return this.getLevel().intValue() == level.intValue();
    }

    public final boolean isError() {
        return this.isAtLeastLevel(ERROR);
    }

    public final boolean isWarning() {
        return this.isExactLevel(WARNING);
    }

    public final boolean isAtLeastWarning() {
        return this.isAtLeastLevel(WARNING);
    }

    public final boolean isAtLeastInfo() {
        return this.isAtLeastLevel(INFO);
    }

    public String toString() {
        String hasNodeFmt = "{0}: {1} [ node = {2} ]";
        String noNodeFmt = "{0}: {1}";
        Node node = this.getRelatedNode();
        if (node == null) {
            return FastMessageFormat.formatMessage(noNodeFmt, this.getLevel().getLocalizedName(), this.getLongDescription());
        }
        return FastMessageFormat.formatMessage(hasNodeFmt, this.getLevel().getLocalizedName(), this.getLongDescription(), node.getNodeName());
    }

    public final XmlModel getModel() {
        return this._model;
    }

    public String getMessage() {
        return this.getShortDescription();
    }

    public final String getMessageType() {
        String msgType = this.getMessageTypeImpl();
        if (msgType != null) {
            return msgType;
        }
        return XML_MODEL_MESSAGE_TYPE_UNKNOWN;
    }

    public String getMessageTypeImpl() {
        return null;
    }

    public Map<String, Object> getParameters() {
        return Collections.emptyMap();
    }

    public String getHtmlMessage() {
        return this.getShortDescription();
    }

    public Severity getSeverity() {
        if (ERROR.equals(this.getLevel())) {
            return Severity.ERROR;
        }
        if (WARNING.equals(this.getLevel())) {
            return Severity.WARNING;
        }
        if (INFO.equals(this.getLevel())) {
            return Severity.ADVISORY;
        }
        return Severity.UNKNOWN;
    }

    public int getOffset() {
        return this.getTextStartOffset();
    }

    public int getLength() {
        return this.getTextEndOffset() - this.getTextStartOffset();
    }

    public Object getConstruct() {
        return this.getRelatedNode();
    }

    public boolean hasTransforms() {
        return false;
    }

    public List<? extends Action> getTransforms() {
        return Collections.emptyList();
    }

    protected XmlModelMessage(XmlModel model) {
        this._model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _textOffset(Node node, boolean isBefore) {
        if (node != null) {
            this._model.acquireReadLock();
            try {
                DomPosition pos = null;
                switch (node.getNodeType()) {
                    case 9: {
                        break;
                    }
                    case 2: {
                        if (isBefore) {
                            pos = DomPositionFactory.createInsideOrBeforePosition((Node)node);
                            break;
                        }
                        pos = DomPositionFactory.createInsideOrAfterPosition((Node)node);
                        break;
                    }
                    default: {
                        int relative = isBefore ? 1 : 2;
                        pos = DomPositionFactory.createDomPosition((Node)node, (int)relative);
                    }
                }
                if (pos != null) {
                    int n = this._model.getTextOffset(pos);
                    return n;
                }
            }
            finally {
                this._model.releaseReadLock();
            }
        }
        return -1;
    }
}

