/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.listenerImpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.listenerImpl.EventDeliveryTask;
import oracle.bali.xml.model.listenerImpl.ListenerSetChangedTask;
import oracle.javatools.buffer.ReadWriteLock;

public final class XmlModelListenerManager {
    private static final List<XmlModelListener> _EMPTY_LISTENER_LIST = Collections.emptyList();
    private final ReadWriteLock _listenerArrayLock;
    private static Map<XmlModel, ReadWriteLock> _sModelToLockMap = Collections.synchronizedMap(new WeakHashMap(15));
    private final ArrayList<XmlModelListener> _attachedListeners = new ArrayList();
    private final List<XmlModelListener> _unmodifiableAttachedListeners = Collections.unmodifiableList(this._attachedListeners);
    private final ArrayList<XmlModelListener> _pendingAddListeners = new ArrayList();
    private final List<XmlModelListener> _unmodifiablePendingAddListeners = Collections.unmodifiableList(this._pendingAddListeners);
    private final ArrayList<XmlModelListener> _pendingRemoveListeners = new ArrayList();
    private final List<XmlModelListener> _unmodifiablePendingRemoveListeners = Collections.unmodifiableList(this._pendingRemoveListeners);
    private final AbstractModel _model;
    private final XmlModelEvent _emptyEvent;
    private final ListenerSetChangedTask _listenerSetChangedTask;
    private volatile int _eventDeliveryNesting = 0;

    public XmlModelListenerManager(AbstractModel model, ListenerSetChangedTask listenerSetChangedTask) {
        this._model = model;
        this._listenerSetChangedTask = listenerSetChangedTask;
        this._emptyEvent = new XmlModelEvent(model);
        this._emptyEvent.prepareForDelivery();
        ReadWriteLock baseModelListenerLock = _sModelToLockMap.get(model.getBaseModel());
        if (baseModelListenerLock == null) {
            baseModelListenerLock = new ReadWriteLock();
            _sModelToLockMap.put(model.getBaseModel(), baseModelListenerLock);
        }
        this._listenerArrayLock = baseModelListenerLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addModelListener(XmlModelListener changeListener) {
        if (changeListener == null) {
            throw new IllegalArgumentException("XmlModelListenerManager: Null changeListener passed to addModelListener");
        }
        boolean shouldAcquireModelLock = this._model.isFullyInstantiated();
        if (shouldAcquireModelLock) {
            this._model.acquireReadLock();
        }
        try {
            this._listenerArrayLock.writeLock();
            try {
                boolean throwDuplicateAdd = this._pendingAddListeners.contains(changeListener);
                if (!throwDuplicateAdd && this._attachedListeners.contains(changeListener)) {
                    boolean contained = this._pendingRemoveListeners.remove(changeListener);
                    if (contained) {
                        return;
                    }
                    throwDuplicateAdd = true;
                }
                if (throwDuplicateAdd) {
                    throw new IllegalStateException("XmlModelListenerManager: Illegal attempt to add duplicate listener");
                }
                if (this.isDeliveringEvents()) {
                    boolean inRemoveListeners = this._pendingRemoveListeners.remove(changeListener);
                    if (!inRemoveListeners) {
                        this._pendingAddListeners.add(changeListener);
                    }
                } else {
                    this._attachedListeners.add(changeListener);
                    this._executeListenerSetChangedTask(Collections.singletonList(changeListener), _EMPTY_LISTENER_LIST);
                }
            }
            finally {
                this._listenerArrayLock.writeUnlock();
            }
        }
        finally {
            if (shouldAcquireModelLock) {
                this._model.releaseReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeModelListener(XmlModelListener changeListener) {
        if (changeListener == null) {
            throw new IllegalArgumentException("XmlModelListenerManager: Null changeListener passed to removeModelListener");
        }
        boolean shouldAcquireModelLock = this._model.isFullyInstantiated();
        if (shouldAcquireModelLock) {
            this._model.acquireReadLock();
        }
        try {
            this._listenerArrayLock.writeLock();
            try {
                boolean removed = this._pendingAddListeners.remove(changeListener);
                if (!removed) {
                    if (this.isDeliveringEvents()) {
                        removed = this._attachedListeners.contains(changeListener);
                        if (removed) {
                            this._pendingRemoveListeners.add(changeListener);
                        }
                    } else {
                        removed = this._attachedListeners.remove(changeListener);
                        if (removed) {
                            this._executeListenerSetChangedTask(_EMPTY_LISTENER_LIST, Collections.singletonList(changeListener));
                        }
                    }
                    if (!removed) {
                        throw new IllegalStateException("Listener " + changeListener + " was never registered on " + this);
                    }
                }
            }
            finally {
                this._listenerArrayLock.writeUnlock();
            }
        }
        finally {
            if (shouldAcquireModelLock) {
                this._model.releaseReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeEventDeliveryTask(EventDeliveryTask task) {
        this._model.acquireReadLock();
        try {
            this._listenerArrayLock.writeLock();
            try {
                ++this._eventDeliveryNesting;
                try {
                    task.execute(this._unmodifiableAttachedListeners, this._unmodifiablePendingAddListeners, this._unmodifiablePendingRemoveListeners);
                }
                finally {
                    --this._eventDeliveryNesting;
                }
                if (this._eventDeliveryNesting == 0) {
                    this._processPendingListenerChanges();
                }
            }
            finally {
                this._listenerArrayLock.writeUnlock();
            }
        }
        finally {
            this._model.releaseReadLock();
        }
    }

    public final boolean isDeliveringEvents() {
        return this._eventDeliveryNesting > 0;
    }

    public XmlModelEvent getEmptyEvent() {
        return this._emptyEvent;
    }

    private void _processPendingListenerChanges() {
        if (this._pendingAddListeners.isEmpty() && this._pendingRemoveListeners.isEmpty()) {
            return;
        }
        ArrayList<XmlModelListener> newlyAttachedListeners = new ArrayList<XmlModelListener>(this._pendingAddListeners);
        this._pendingAddListeners.clear();
        this._attachedListeners.addAll(newlyAttachedListeners);
        ArrayList<XmlModelListener> newlyDetachedListeners = new ArrayList<XmlModelListener>(this._pendingRemoveListeners);
        this._pendingRemoveListeners.clear();
        this._attachedListeners.removeAll(newlyDetachedListeners);
        this._executeListenerSetChangedTask(newlyAttachedListeners, newlyDetachedListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _executeListenerSetChangedTask(List<XmlModelListener> newlyAttachedListeners, List<XmlModelListener> newlyDetachedListeners) {
        ++this._eventDeliveryNesting;
        try {
            this._listenerSetChangedTask.execute(newlyAttachedListeners, newlyDetachedListeners);
        }
        finally {
            --this._eventDeliveryNesting;
        }
        if (this._eventDeliveryNesting == 0) {
            this._processPendingListenerChanges();
        }
    }
}

