/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.dependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;

public class ResultIssueList
implements IssueList {
    ArrayList<Issue> _issues = new ArrayList();

    public void addIssue(Issue issue) {
        this._issues.add(issue);
    }

    public int size() {
        return this._issues.size();
    }

    public Issue getIssueAt(int index) {
        return this._issues.get(index);
    }

    public Severity getSeverity() {
        Severity current = Severity.OK;
        Iterator<Issue> i$ = this.iterator();
        while (i$.hasNext()) {
            Issue i = i$.next();
            Severity is = i.getSeverity();
            if (Severity.ERROR.equals((Object)is)) {
                return Severity.ERROR;
            }
            if (Severity.WARNING.equals((Object)is)) {
                current = Severity.WARNING;
                continue;
            }
            if (Severity.ADVISORY.equals((Object)current) && Severity.INCOMPLETE.equals((Object)is)) {
                current = is;
                continue;
            }
            if (Severity.UNKNOWN.equals((Object)current) && (Severity.INCOMPLETE.equals((Object)is) || Severity.ADVISORY.equals((Object)is))) {
                current = is;
                continue;
            }
            if (Severity.OK.equals((Object)is)) continue;
            current = is;
        }
        return current;
    }

    public boolean isStale() {
        return false;
    }

    public int getErrorCount() {
        int count = 0;
        Iterator<Issue> i$ = this.iterator();
        while (i$.hasNext()) {
            Issue i = i$.next();
            if (!Severity.ERROR.equals((Object)i.getSeverity())) continue;
            ++count;
        }
        return count;
    }

    public int getWarningCount() {
        int count = 0;
        Iterator<Issue> i$ = this.iterator();
        while (i$.hasNext()) {
            Issue i = i$.next();
            if (!Severity.WARNING.equals((Object)i.getSeverity())) continue;
            ++count;
        }
        return count;
    }

    public int getIncompleteCount() {
        int count = 0;
        Iterator<Issue> i$ = this.iterator();
        while (i$.hasNext()) {
            Issue i = i$.next();
            if (!Severity.INCOMPLETE.equals((Object)i.getSeverity())) continue;
            ++count;
        }
        return count;
    }

    public int getAdvisoryCount() {
        int count = 0;
        Iterator<Issue> i$ = this.iterator();
        while (i$.hasNext()) {
            Issue i = i$.next();
            if (!Severity.ADVISORY.equals((Object)i.getSeverity())) continue;
            ++count;
        }
        return count;
    }

    public Collection<Issue> getOptionalAnalyses() {
        return Collections.emptySet();
    }

    public Iterator<Issue> iterator() {
        return this._issues.iterator();
    }
}

