/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.dependency;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.Declaration;
import oracle.bali.xml.model.dependency.DeclarationFactory;
import oracle.bali.xml.model.dependency.DeclarationFactoryBase;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.Reference;
import oracle.bali.xml.model.dependency.ReferenceFactory;
import oracle.bali.xml.model.dependency.XmlDeclaration;
import oracle.bali.xml.model.dependency.XmlReference;
import oracle.bali.xml.model.traversal.MutableTraversalData;
import oracle.bali.xml.model.traversal.TraversalHandler;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DependencyUtils {
    private static final String ENABLE_XDF_KEY = "xdf.enablexdf";
    public static final boolean DISABLE_XDF = DependencyUtils.getDisableXDF();
    private static final Logger _LOGGER = Logger.getLogger(DependencyUtils.class.getName());

    public static ReferenceFactory createWholeValueReferenceFactory(Class<? extends Reference> clazz) {
        if (TraversalHandler.class.isAssignableFrom(clazz)) {
            return new TraversalReferenceFactory(clazz);
        }
        return new NonTraversalReferenceFactory(clazz);
    }

    public static ReferenceFactory createListReferenceFactory(Class<? extends Reference> clazz) {
        if (TraversalHandler.class.isAssignableFrom(clazz)) {
            return new TraversalListReferenceFactory(clazz);
        }
        return new NonTraversalListReferenceFactory(clazz);
    }

    public static DeclarationFactory createWholeValueDeclarationFactory(Class<? extends Declaration> clazz) {
        if (TraversalHandler.class.isAssignableFrom(clazz)) {
            return new TraversalDeclarationFactory(clazz);
        }
        return new NonTraversalDeclarationFactory(clazz);
    }

    public static DeclarationFactory createListDeclarationFactory(Class<? extends Declaration> clazz) {
        if (TraversalHandler.class.isAssignableFrom(clazz)) {
            return new TraversalListDeclarationFactory(clazz);
        }
        return new NonTraversalListDeclarationFactory(clazz);
    }

    private static Object __createClass(Class clazz, XmlContext context, Node node, int start, int end) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class[] argTypes = new Class[]{XmlContext.class, Node.class, Integer.TYPE, Integer.TYPE};
        Constructor constructor = clazz.getConstructor(argTypes);
        Object[] args = new Object[]{context, node, start, end};
        return constructor.newInstance(args);
    }

    public static String createNodePathString(Node node) {
        int[] pathInts = DomUtils.getPathToNode((Node)node);
        StringBuffer buf = new StringBuffer(pathInts.length * 3);
        for (int i = 0; i < pathInts.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(String.valueOf(pathInts[i]));
        }
        return buf.toString();
    }

    public static Node getNodefromPath(Document document, String nodePath) {
        if (nodePath != null) {
            String[] indicesStr = nodePath.split(",");
            int[] indices = new int[indicesStr.length];
            try {
                for (int i = 0; i < indicesStr.length; ++i) {
                    indices[i] = Integer.parseInt(indicesStr[i]);
                }
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            Node node = DomUtils.getNodeFromPath((Document)document, (int[])indices);
            if (node == null) {
                return null;
            }
            return node;
        }
        return null;
    }

    public static Node getNodeFromInfo(XmlContext xmlContext, String nodePath, String attributeNS, String attribute) {
        XmlModel xmlModel = xmlContext.getModel();
        Node node = DependencyUtils.getNodefromPath(xmlModel.getDocument(), nodePath);
        if (node != null && attribute != null && !"".equals(attribute)) {
            NamedNodeMap attrs = node.getAttributes();
            node = attrs.getNamedItemNS(attributeNS, attribute);
        }
        return node;
    }

    public static boolean hasReference(XmlContext xmlContext, DomPosition pos) {
        if (pos == null) {
            return false;
        }
        Node node = pos.getTargetNode();
        if (node instanceof CharacterData && !(node instanceof Comment)) {
            node = node.getParentNode();
        } else if (pos.hasAttributeQName()) {
            node = DomUtils.getAttribute((Element)((Element)node), (QualifiedName)pos.getAttributeQName());
        }
        return !DependencyUtils.getReferences(xmlContext, node).isEmpty();
    }

    public static Collection<Reference> getReferences(XmlContext xmlContext, Node node) {
        Collection<Reference> infos;
        String text;
        XmlModel model = xmlContext.getModel();
        ReferenceFactory factory = model.getXmlMetadataResolver().getReferenceFactory(node);
        if (factory != null && ModelUtil.hasLength((String)(text = DependencyUtils.getTextContent(node))) && (infos = factory.getReferences(xmlContext, node, text)) != null) {
            return Collections.unmodifiableCollection(infos);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Reference> getReferences(XmlContext xmlContext) {
        ArrayList<Reference> allRefs = new ArrayList<Reference>();
        XmlModel model = xmlContext.getModel();
        model.acquireReadLock();
        try {
            TreeTraversal traversal = model.getTreeTraversal();
            for (Node domNode : traversal.allNodes((Node)model.getDocument())) {
                allRefs.addAll(DependencyUtils.getReferences(xmlContext, domNode));
                NamedNodeMap attrs = domNode.getAttributes();
                if (attrs == null) continue;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node attr = attrs.item(i);
                    allRefs.addAll(DependencyUtils.getReferences(xmlContext, attr));
                }
            }
        }
        finally {
            model.releaseReadLock();
        }
        return allRefs;
    }

    public static Collection<Declaration> getDeclarations(XmlContext xmlContext, Node node) {
        String text;
        Collection<Declaration> infos;
        XmlModel model = xmlContext.getModel();
        DeclarationFactory factory = model.getXmlMetadataResolver().getDeclarationFactory(node);
        if (factory != null && (infos = factory.getDeclarations(xmlContext, node, text = DependencyUtils.getTextContent(node))) != null) {
            return Collections.unmodifiableCollection(infos);
        }
        return Collections.emptyList();
    }

    public static XmlReference findReferenceContainingPosition(DependencyContext dc, XmlContext context, DomPosition pos) {
        Collection<Reference> infos;
        String text;
        Node node = pos.getTargetNode();
        if (node instanceof CharacterData && !(node instanceof Comment)) {
            node = node.getParentNode();
        } else if (pos.hasAttributeQName()) {
            node = DomUtils.getAttribute((Element)((Element)node), (QualifiedName)pos.getAttributeQName());
        }
        XmlModel model = context.getModel();
        ReferenceFactory factory = model.getXmlMetadataResolver().getReferenceFactory(node);
        if (factory != null && ModelUtil.hasLength((String)(text = DependencyUtils.getTextContent(node))) && (infos = factory.getReferences(context, node, text)) != null) {
            for (Reference ref : infos) {
                XmlReference xmlRef;
                if (!(ref instanceof XmlReference) || (xmlRef = (XmlReference)ref).getDomRange(dc).compareTo((TreeTraversal)DocumentTreeTraversal.INSTANCE, pos, true) != 0) continue;
                return xmlRef;
            }
        }
        return null;
    }

    public static XmlReference findReferenceIncludingAttributes(XmlContext context, DomPosition pos) {
        XmlReference xmlRef = null;
        Node node = pos.getTargetNode();
        if (node instanceof CharacterData) {
            node = node.getParentNode();
        } else if (pos.hasAttributeQName()) {
            return null;
        }
        Collection<Reference> refs = DependencyUtils.getReferences(context, node);
        for (Reference ref : refs) {
            if (!(ref instanceof XmlReference)) continue;
            if (xmlRef != null) {
                return null;
            }
            xmlRef = (XmlReference)ref;
        }
        if (xmlRef != null) {
            return xmlRef;
        }
        if (DomUtils.isElement((Node)node)) {
            NamedNodeMap attrs = node.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr a = (Attr)attrs.item(i);
                refs = DependencyUtils.getReferences(context, a);
                for (Reference ref : refs) {
                    if (!(ref instanceof XmlReference)) continue;
                    if (xmlRef != null) {
                        return null;
                    }
                    xmlRef = (XmlReference)ref;
                }
            }
        }
        return xmlRef;
    }

    public static XmlDeclaration findDeclarationContainingPosition(DependencyContext dc, XmlContext context, DomPosition pos) {
        String text;
        Collection<Declaration> infos;
        Node node = pos.getTargetNode();
        if (node instanceof CharacterData) {
            node = node.getParentNode();
        } else if (pos.hasAttributeQName()) {
            node = DomUtils.getAttribute((Element)((Element)node), (QualifiedName)pos.getAttributeQName());
        }
        XmlModel model = context.getModel();
        DeclarationFactory factory = model.getXmlMetadataResolver().getDeclarationFactory(node);
        if (factory != null && (infos = factory.getDeclarations(context, node, text = DependencyUtils.getTextContent(node))) != null) {
            for (Declaration decl : infos) {
                XmlDeclaration xmlDecl;
                if (!(decl instanceof XmlDeclaration) || (xmlDecl = (XmlDeclaration)decl).getDomRange(dc).compareTo((TreeTraversal)DocumentTreeTraversal.INSTANCE, pos, true) != 0) continue;
                return xmlDecl;
            }
        }
        return null;
    }

    public static XmlDeclaration findDeclarationIncludingAttributes(XmlContext context, DomPosition pos) {
        XmlDeclaration xmlDecl = null;
        Node node = pos.getTargetNode();
        if (node instanceof CharacterData) {
            node = node.getParentNode();
        } else if (pos.hasAttributeQName()) {
            return null;
        }
        Collection<Declaration> decls = DependencyUtils.getDeclarations(context, node);
        for (Declaration decl : decls) {
            if (!(decl instanceof XmlDeclaration)) continue;
            if (xmlDecl != null) {
                return null;
            }
            xmlDecl = (XmlDeclaration)decl;
        }
        if (xmlDecl != null) {
            return xmlDecl;
        }
        if (DomUtils.isElement((Node)node)) {
            NamedNodeMap attrs = node.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr a = (Attr)attrs.item(i);
                decls = DependencyUtils.getDeclarations(context, a);
                for (Declaration decl : decls) {
                    if (!(decl instanceof XmlDeclaration)) continue;
                    if (xmlDecl != null) {
                        return null;
                    }
                    xmlDecl = (XmlDeclaration)decl;
                }
            }
        }
        return xmlDecl;
    }

    public static String getTextContent(Node node) {
        if (DomUtils.isAttribute((Node)node)) {
            return node.getNodeValue();
        }
        if (DomUtils.isElement((Node)node)) {
            String first = null;
            StringBuilder sb = null;
            block3: for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                switch (child.getNodeType()) {
                    case 3: 
                    case 4: {
                        String curValue = child.getNodeValue();
                        if (sb != null) {
                            sb.append(curValue);
                            continue block3;
                        }
                        if (first == null) {
                            first = curValue;
                            continue block3;
                        }
                        sb = new StringBuilder(first.length() + curValue.length());
                        sb.append(first);
                        sb.append(curValue);
                        first = null;
                    }
                }
            }
            if (sb != null) {
                return sb.toString();
            }
            if (first != null) {
                return first;
            }
            return null;
        }
        if (node.getNodeType() == 8) {
            return ((Comment)node).getData();
        }
        return null;
    }

    static DomPosition __getDomPosition(Node node, int textContentIndex) {
        if (DomUtils.isAttribute((Node)node)) {
            return DomPositionFactory.createAttributePosition((Attr)((Attr)node), (int)textContentIndex);
        }
        if (DomUtils.isElement((Node)node)) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                switch (child.getNodeType()) {
                    case 3: 
                    case 4: {
                        CharacterData cd = (CharacterData)child;
                        int cdLen = cd.getLength();
                        if (cdLen >= textContentIndex) {
                            return DomPositionFactory.createTextPosition((CharacterData)cd, (int)textContentIndex);
                        }
                        textContentIndex -= cdLen;
                    }
                }
            }
            throw new IllegalArgumentException("index " + textContentIndex + " not found in " + node);
        }
        if (node.getNodeType() == 8) {
            return DomPositionFactory.createTextPosition((CharacterData)((Comment)node), (int)textContentIndex);
        }
        throw new IllegalArgumentException("invalid node type passed to __getDomPosition: " + node);
    }

    private static boolean getDisableXDF() {
        String enableXDF = System.getProperty(ENABLE_XDF_KEY);
        return "false".equalsIgnoreCase(enableXDF);
    }

    public static class TraversalListDeclarationFactory
    extends NonTraversalListDeclarationFactory
    implements TraversalHandler {
        public TraversalListDeclarationFactory(Class<? extends Declaration> clazz) {
            super(clazz);
        }

        @Override
        public void handleStartNode(XmlModel model, Node node, MutableTraversalData data) {
            Collection<Declaration> decls = this.getDeclarations(model.getContext(), node, DependencyUtils.getTextContent(node));
            for (Declaration decl : decls) {
                if (!(decl instanceof TraversalHandler)) continue;
                TraversalHandler handler = (TraversalHandler)((Object)decl);
                handler.handleStartNode(model, node, data);
            }
        }

        @Override
        public void handleEndNode(XmlModel model, Node node, MutableTraversalData data) {
            Collection<Declaration> decls = this.getDeclarations(model.getContext(), node, DependencyUtils.getTextContent(node));
            for (Declaration decl : decls) {
                if (!(decl instanceof TraversalHandler)) continue;
                TraversalHandler handler = (TraversalHandler)((Object)decl);
                handler.handleEndNode(model, node, data);
            }
        }
    }

    public static class NonTraversalListDeclarationFactory
    extends DeclarationFactoryBase {
        private Class<? extends Declaration> clazz;

        public NonTraversalListDeclarationFactory(Class<? extends Declaration> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Collection<Declaration> getDeclarationsImpl(XmlContext context, Node node, String value) {
            List<int[]> bounds = WhitespaceUtils.getTokenBoundaries(value);
            ArrayList<Declaration> ret = new ArrayList<Declaration>(bounds.size());
            for (int[] bound : bounds) {
                Declaration declaration = null;
                int s = bound[0];
                int e = bound[1];
                try {
                    declaration = (Declaration)DependencyUtils.__createClass(this.clazz, context, node, s, e);
                }
                catch (Exception ex) {
                    _LOGGER.log(Level.WARNING, "Error creating declaration for " + this.clazz, ex);
                }
                if (declaration == null) continue;
                ret.add(declaration);
            }
            return ret;
        }
    }

    public static class TraversalListReferenceFactory
    extends NonTraversalListReferenceFactory
    implements TraversalHandler {
        public TraversalListReferenceFactory(Class<? extends Reference> clazz) {
            super(clazz);
        }

        @Override
        public void handleStartNode(XmlModel model, Node node, MutableTraversalData data) {
            Collection<Reference> refs = this.getReferences(model.getContext(), node, DependencyUtils.getTextContent(node));
            for (Reference ref : refs) {
                if (!(ref instanceof TraversalHandler)) continue;
                TraversalHandler handler = (TraversalHandler)((Object)ref);
                handler.handleStartNode(model, node, data);
            }
        }

        @Override
        public void handleEndNode(XmlModel model, Node node, MutableTraversalData data) {
            Collection<Reference> refs = this.getReferences(model.getContext(), node, DependencyUtils.getTextContent(node));
            for (Reference ref : refs) {
                if (!(ref instanceof TraversalHandler)) continue;
                TraversalHandler handler = (TraversalHandler)((Object)ref);
                handler.handleEndNode(model, node, data);
            }
        }
    }

    public static class NonTraversalListReferenceFactory
    extends ReferenceFactory {
        private Class<? extends Reference> clazz;

        public NonTraversalListReferenceFactory(Class<? extends Reference> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Collection<Reference> getReferences(XmlContext context, Node node, String value) {
            if (value == null) {
                try {
                    Reference reference = (Reference)DependencyUtils.__createClass(this.clazz, context, node, 0, 0);
                    return Collections.singletonList(reference);
                }
                catch (Exception ex) {
                    _LOGGER.log(Level.WARNING, "Error creating reference for " + this.clazz, ex);
                }
            }
            List<int[]> bounds = WhitespaceUtils.getTokenBoundaries(value);
            ArrayList<Reference> ret = new ArrayList<Reference>(bounds.size());
            for (int[] bound : bounds) {
                Reference reference = null;
                int s = bound[0];
                int e = bound[1];
                try {
                    reference = (Reference)DependencyUtils.__createClass(this.clazz, context, node, s, e);
                }
                catch (Exception ex) {
                    _LOGGER.log(Level.WARNING, "Error creating reference for " + this.clazz, ex);
                }
                if (reference == null) continue;
                ret.add(reference);
            }
            return ret;
        }
    }

    public static class TraversalDeclarationFactory
    extends NonTraversalDeclarationFactory
    implements TraversalHandler {
        public TraversalDeclarationFactory(Class<? extends Declaration> clazz) {
            super(clazz);
        }

        @Override
        public void handleStartNode(XmlModel model, Node node, MutableTraversalData data) {
            Collection<Declaration> decls = this.getDeclarations(model.getContext(), node, DependencyUtils.getTextContent(node));
            for (Declaration decl : decls) {
                if (!(decl instanceof TraversalHandler)) continue;
                TraversalHandler handler = (TraversalHandler)((Object)decl);
                handler.handleStartNode(model, node, data);
            }
        }

        @Override
        public void handleEndNode(XmlModel model, Node node, MutableTraversalData data) {
            Collection<Declaration> decls = this.getDeclarations(model.getContext(), node, DependencyUtils.getTextContent(node));
            for (Declaration decl : decls) {
                if (!(decl instanceof TraversalHandler)) continue;
                TraversalHandler handler = (TraversalHandler)((Object)decl);
                handler.handleEndNode(model, node, data);
            }
        }
    }

    public static class NonTraversalDeclarationFactory
    extends DeclarationFactoryBase {
        private Class<? extends Declaration> clazz;

        public NonTraversalDeclarationFactory(Class<? extends Declaration> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Collection<Declaration> getDeclarationsImpl(XmlContext context, Node node, String value) {
            Declaration declaration = null;
            try {
                declaration = (Declaration)DependencyUtils.__createClass(this.clazz, context, node, 0, value.length());
            }
            catch (Exception e) {
                _LOGGER.log(Level.WARNING, "Error creating declaration for " + this.clazz, e);
            }
            if (declaration == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(declaration);
        }
    }

    public static class TraversalReferenceFactory
    extends NonTraversalReferenceFactory
    implements TraversalHandler {
        public TraversalReferenceFactory(Class<? extends Reference> clazz) {
            super(clazz);
        }

        @Override
        public void handleStartNode(XmlModel model, Node node, MutableTraversalData data) {
            Collection<Reference> refs = this.getReferences(model.getContext(), node, DependencyUtils.getTextContent(node));
            for (Reference ref : refs) {
                if (!(ref instanceof TraversalHandler)) continue;
                TraversalHandler handler = (TraversalHandler)((Object)ref);
                handler.handleStartNode(model, node, data);
            }
        }

        @Override
        public void handleEndNode(XmlModel model, Node node, MutableTraversalData data) {
            Collection<Reference> refs = this.getReferences(model.getContext(), node, DependencyUtils.getTextContent(node));
            for (Reference ref : refs) {
                if (!(ref instanceof TraversalHandler)) continue;
                TraversalHandler handler = (TraversalHandler)((Object)ref);
                handler.handleEndNode(model, node, data);
            }
        }
    }

    public static class NonTraversalReferenceFactory
    extends ReferenceFactory {
        private Class<? extends Reference> clazz;

        public NonTraversalReferenceFactory(Class<? extends Reference> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Collection<Reference> getReferences(XmlContext context, Node node, String value) {
            Reference reference = null;
            try {
                int end = 0;
                if (value != null) {
                    end = value.length();
                }
                reference = (Reference)DependencyUtils.__createClass(this.clazz, context, node, 0, end);
            }
            catch (Exception e) {
                _LOGGER.log(Level.WARNING, "Error creating reference for " + this.clazz, e);
            }
            if (reference == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(reference);
        }
    }
}

