/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyEditor;
import java.beans.VetoableChangeListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.FixedAttributeElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.SubstitutionGroup;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.resolver.GrammarResolverAdapter;
import oracle.bali.xml.grammar.resolver.GrammarResolverEvent;
import oracle.bali.xml.grammar.resolver.GrammarResolverListener;
import oracle.bali.xml.grammar.util.JavaTypeManager;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.gui.base.inspector.PropertyFormLayoutGenerator;
import oracle.bali.xml.gui.base.inspector.PropertyRowOwner;
import oracle.bali.xml.metadata.DerivedXmlKey;
import oracle.bali.xml.metadata.GlobalNodeTypeKey;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.XmlMetadataMethods;
import oracle.bali.xml.metadata.textlanguage.TextLanguage;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.ModelValidationContext;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlPreferences;
import oracle.bali.xml.model.annotation.AnnotationMetadataResolver;
import oracle.bali.xml.model.annotation.AnnotationProvider;
import oracle.bali.xml.model.category.CategoryDefinition;
import oracle.bali.xml.model.category.CategoryDefinitionFactory;
import oracle.bali.xml.model.contract.ContractDefinition;
import oracle.bali.xml.model.contract.ContractDefinitionFactory;
import oracle.bali.xml.model.contract.ContractIdentifier;
import oracle.bali.xml.model.convert.ConvertPlugin;
import oracle.bali.xml.model.convert.ConvertPluginFactory;
import oracle.bali.xml.model.dependency.Declaration;
import oracle.bali.xml.model.dependency.DeclarationFactory;
import oracle.bali.xml.model.dependency.DependencyUtils;
import oracle.bali.xml.model.dependency.Reference;
import oracle.bali.xml.model.dependency.ReferenceFactory;
import oracle.bali.xml.model.dependency.id.IdDeclaration;
import oracle.bali.xml.model.dependency.id.IdReference;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.bali.xml.model.metadata.XmlMetadataResolverEvent;
import oracle.bali.xml.model.metadata.XmlMetadataResolverListener;
import oracle.bali.xml.model.metadata.XmlModelMetadataMethods;
import oracle.bali.xml.model.metadata.refinfo.RefInfo;
import oracle.bali.xml.model.metadata.translation.TranslationInfoProvider;
import oracle.bali.xml.model.traversal.TraversalHandler;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.share.ImmutableFilteredCollection;
import oracle.bali.xml.share.MultiCollection;
import oracle.bali.xml.share.UnmodifiableArrayList;
import oracle.bali.xml.util.AttributeSetter;
import oracle.bali.xml.util.AttributeValueItemProvider;
import oracle.bali.xml.util.CollectionUtils;
import oracle.bali.xml.util.ContextualActionProvider;
import oracle.bali.xml.util.ContextualAttributeValueItemProvider;
import oracle.bali.xml.util.ContextualPropertyChangeEvent;
import oracle.bali.xml.util.DatabindingHandler;
import oracle.bali.xml.util.NodeCreator;
import oracle.bali.xml.util.NodeCustomizer;
import oracle.bali.xml.validator.BaseValidatorCallback;
import oracle.bali.xml.validator.PerValidationState;
import oracle.bali.xml.validator.ValidationContext;
import oracle.bali.xml.validator.ValidatorCallback;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;

public class XmlMetadataResolver {
    private AbstractModel _model;
    private ListenerManager _listeners = new ListenerManager();
    private final Map<XmlKey, XmlKey> _favoriteProperties = new HashMap<XmlKey, XmlKey>();
    private final Map<String, List<XmlKey>> _nsToTopLevelKeyList = new HashMap<String, List<XmlKey>>();
    private final Map<XmlKey, List<XmlKey>> _availableAttributeKeys = XmlMetadataResolver._sCreateCacheMap(100);
    private final Map<XmlKey, Set<XmlKey>> _requiredAttributeKeys = XmlMetadataResolver._sCreateCacheMap(100);
    private final Map<XmlKey, Set<XmlKey>> _requiredChildElementKeys = XmlMetadataResolver._sCreateCacheMap(100);
    private final Map<XmlKey, Set<XmlKey>> _cachedVirtualAttrKeys = XmlMetadataResolver._sCreateCacheMap(100);
    private final Map<XmlKey, Collection<XmlKey>> _creatableKeys = XmlMetadataResolver._sCreateCacheMap(100);
    private List<ConvertPlugin> _convertPlugins = null;
    private Map<String, CategoryDefinition> _categoryDefinitionMap = null;
    private Map<ContractIdentifier, ContractDefinition> _globalContractDefinitionCache = null;
    private final Map<XmlKey, Object> _elementKeyToIdAttributeQName = XmlMetadataResolver._sCreateCacheMap(100);
    private Map<String, String> _prefixToNamespaceMap = null;
    private Map<XmlKey, URI> _piLayoutUris = new WeakHashMap<XmlKey, URI>(100);
    private Map<XmlKey, URI> _creatorLayoutUris = new WeakHashMap<XmlKey, URI>(100);
    private String _dataPropertyName;
    private String _commentPropertyName;
    private String _textPropertyName;
    private String _generalGroupName;
    private String _otherGroupName;
    private String _xmlLangName;
    private String _cdataDescription;
    private String _commentDescription;
    private String _processingInstructionDescription;
    private String _textNodeDescription;
    private MetadataEvaluator _evaluator;
    private static final int _WARNING_MD_NODE_DEPRECATED = 120;
    private static final int _WARNING_MD_NODE_UNTRANSLATED = 121;
    private static final String _ANCESTOR_SATISFIED_CONTRACT_CACHE = "ancestorSatisfiedContractCache";
    private final HashMap _keyToWarnableAttrKeys = new HashMap();
    private static final Map<XmlKey, Class<? extends PropertyEditor>> _sAttributeValueProviders = new HashMap<XmlKey, Class<? extends PropertyEditor>>();
    private static List<XmlKey> _sCreatableGlobalKeys = new UnmodifiableArrayList<XmlKey>(GlobalNodeTypeKey.CDATA_SECTION_KEY, GlobalNodeTypeKey.COMMENT_KEY, GlobalNodeTypeKey.PROCESSING_INSTRUCTION_KEY, GlobalNodeTypeKey.TEXT_KEY);
    private static List<XmlKey> _sCommentAndPiKeys = new UnmodifiableArrayList<XmlKey>(GlobalNodeTypeKey.COMMENT_KEY, GlobalNodeTypeKey.PROCESSING_INSTRUCTION_KEY);
    private static final Object _UNSET_VALUE = new Object();
    private static final Map<String, Icon> _sUrlIconMap = XmlMetadataResolver._sCreateCacheMap(100);
    private static final Pattern _WHITESPACE_PATTERN = Pattern.compile("[\\s]+");
    private static final int _FAV_PROP_MAX_LENGTH = 500;
    private static final String _DEFAULT_NODE_ICON_LOCATION = "/oracle/bali/xml/metadata/icons/element.png";
    private static final String _DEFAULT_TEXT_ICON_LOCATION = "/oracle/bali/xml/metadata/icons/text.png";
    private static final String _DEFAULT_COMMENT_ICON_LOCATION = "/oracle/bali/xml/metadata/icons/comment.png";
    private static final ReferenceFactory _IDREF_REFERENCE_FACTORY = DependencyUtils.createWholeValueReferenceFactory(IdReference.class);
    private static final ReferenceFactory _IDREFS_REFERENCE_FACTORY = DependencyUtils.createListReferenceFactory(IdReference.class);
    private static final XmlKey _UNSET_XMLKEY = new XmlKey(){

        public List getElementQNamePath() {
            throw new UnsupportedOperationException("trying to interact with sential xmlkey");
        }

        public QualifiedName getAttributeQName() {
            throw new UnsupportedOperationException("trying to interact with sential xmlkey");
        }
    };
    private static final Icon _UNSET_ICON = new Icon(){

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 0;
        }
    };
    private static final Logger _LOGGER = Logger.getLogger(XmlMetadataResolver.class.getName());
    private static final String EXPRCHARS = "#{}";

    public XmlMetadataResolver(MetadataEvaluator evaluator, AbstractModel model) {
        if (evaluator == null) {
            throw new IllegalArgumentException("evaluator must be non null");
        }
        this._evaluator = evaluator;
        if (model != null) {
            this._model = model;
            Listener listener = new Listener();
            model.addModelListener(listener);
            this._dataPropertyName = model.getTranslatedString("RESOLVER.DATA_PROPERTY_NAME");
            this._commentPropertyName = model.getTranslatedString("RESOLVER.COMMENT_PROPERTY_NAME");
            this._textPropertyName = model.getTranslatedString("RESOLVER.TEXT_PROPERTY_NAME");
            this._generalGroupName = model.getTranslatedString("General");
            this._otherGroupName = model.getTranslatedString("OtherGroup");
            this._xmlLangName = model.getTranslatedString("XML");
            this._model.getContext().getGrammarResolver().addGrammarResolverListener((GrammarResolverListener)new GrammarListener());
        }
    }

    public final AbstractModel getModel() {
        return this._model;
    }

    public final XmlContext getContext() {
        return this._model.getContext();
    }

    public final Locale getLocale() {
        return this.getContext().getLocale();
    }

    public final MetadataEvaluator getMetadataEvaluator() {
        return this._evaluator;
    }

    public void addMetadataResolverListener(XmlMetadataResolverListener listener) {
        this._listeners.addListener((EventListener)listener);
    }

    public void removeMetadataResolverListener(XmlMetadataResolverListener listener) {
        this._listeners.removeListener((EventListener)listener);
    }

    public final void performAdditionalValidation(ModelValidationContext validationContext, PerValidationState validationState, Document document, XmlKey documentKey) {
        ErrorHandler errorHandler = validationContext.getErrorHandler();
        ValidatorCallback callback = this._getAttachedValidatorCallback(document, documentKey);
        if (callback != null) {
            try {
                callback.validateDocument(document, errorHandler);
            }
            catch (RuntimeException e) {
                _LOGGER.log(Level.WARNING, "Unexpected Exception encountered from ValidatorCallback", e);
            }
        }
        this.performAdditionalValidationImpl(validationContext, validationState, document, documentKey);
    }

    public final void performAdditionalValidation(ModelValidationContext validationContext, PerValidationState validationState, Element element, ElementDef elementDef, XmlKey elementKey, int processingRule, boolean deep) {
        this._checkDeprecation((ValidationContext)validationContext, validationState, element, elementKey);
        this._checkRequiredAndProhibitedContracts((ValidationContext)validationContext, validationState, element, elementKey);
        Collection attrKeysToCheck = (Collection)this._keyToWarnableAttrKeys.get(elementKey);
        if (attrKeysToCheck == null) {
            ArrayList<XmlKey> checkKeys = null;
            List<XmlKey> l = this.getAttributeKeys(elementKey);
            for (XmlKey attrKey : l) {
                if (!this.isWarnIfNotSpecified(attrKey)) continue;
                if (checkKeys == null) {
                    checkKeys = new ArrayList<XmlKey>();
                }
                checkKeys.add(attrKey);
            }
            attrKeysToCheck = checkKeys != null ? checkKeys : Collections.EMPTY_LIST;
            this._keyToWarnableAttrKeys.put(elementKey, attrKeysToCheck);
        }
        for (XmlKey attrKey : attrKeysToCheck) {
            QualifiedName attrQName = attrKey.getAttributeQName();
            if (element.hasAttributeNS(attrQName.getNamespace(), attrQName.getName())) continue;
            validationContext.reportWarning(validationState, 36, "Attribute " + attrQName.getName() + " is missing.", element, attrQName);
        }
        ErrorHandler errorHandler = validationContext.getErrorHandler();
        ValidatorCallback callback = this._getAttachedValidatorCallback(element, elementKey);
        if (callback != null) {
            try {
                callback.validateElement(element, errorHandler);
            }
            catch (RuntimeException e) {
                _LOGGER.log(Level.WARNING, "Unexpected Exception encountered from ValidatorCallback", e);
            }
        }
        this.performAdditionalValidationImpl(validationContext, validationState, element, elementDef, elementKey, processingRule, deep);
    }

    public final void performAdditionalValidation(ModelValidationContext validationContext, PerValidationState validationState, Attr attribute, AttributeDef attributeDef, XmlKey attributeKey, int processingRule) {
        TranslationInfoProvider trProv;
        this._checkDeprecation((ValidationContext)validationContext, validationState, attribute, attributeKey);
        if (this.getContext().supportsFeature("XMLEF_FEATURE.TRANSLATION_VALIDATION") && this.isTranslatable(attribute, attributeKey) && (trProv = this.getTranslationInfoProvider(attribute, attributeKey)) != null && !trProv.isTranslated(this.getModel(), attribute, attributeKey)) {
            validationContext.reportWarning(validationState, 121, "Attribute " + DomUtils.getLocalName((Node)attribute) + "not from a translatable resource.", attribute, null);
        }
        ErrorHandler errorHandler = validationContext.getErrorHandler();
        ValidatorCallback callback = this._getAttachedValidatorCallback(attribute, attributeKey);
        if (callback != null) {
            try {
                callback.validateAttribute(attribute, errorHandler);
            }
            catch (RuntimeException e) {
                _LOGGER.log(Level.WARNING, "Unexpected Exception encountered from ValidatorCallback", e);
            }
        }
        this.performAdditionalValidationImpl(validationContext, validationState, attribute, attributeDef, attributeKey, processingRule);
    }

    public final XmlMetadataResolver cloneWithEvaluator(MetadataEvaluator evaluator, AbstractModel model) {
        if (evaluator == null) {
            throw new IllegalArgumentException("provider must be non null");
        }
        if (evaluator.equals(this._evaluator)) {
            return this;
        }
        return this.createResolver(evaluator, model);
    }

    public final XmlKey getNodeXmlKey(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("null node passed to getNodeXmlKey!");
        }
        return this._model.getNodeXmlKey(node);
    }

    public final GrammarComponent getGrammarComponent(Node node) {
        XmlKey key = this.getNodeXmlKey(node);
        return this.getGrammarComponent(key);
    }

    public final GrammarComponent getGrammarComponent(XmlKey key) {
        return this.getModel().getBaseModel().getGrammarComponent(key);
    }

    public final boolean areAttributePropertiesIndependent(XmlKey key) {
        return this.areAttributePropertiesIndependentImpl(null, key);
    }

    public final AttributeSetter getAttributeSetter(XmlKey key) {
        return this.getAttributeSetterImpl(null, key);
    }

    public final AttributeValueItemProvider getAttributeValueProvider(XmlKey key) {
        return this.getAttributeValueProviderImpl(null, key);
    }

    public final ContextualAttributeValueItemProvider getContextualAttributeValueItemProvider(XmlKey key) {
        return this.getContextualAttributeValueItemProviderImpl(null, key);
    }

    public final NodeCreator getCreationWizard(XmlKey key) {
        return this.getCreationWizardImpl(null, key);
    }

    public final NodeCustomizer getCustomizer(XmlKey key) {
        return this.getCustomizerImpl(null, key);
    }

    public final ResourceBundle getDefaultBundle(XmlKey key) {
        return this._getDefaultBundle(null, key);
    }

    public final ResourceBundle getDefaultBundle(Node node) {
        return this._getDefaultBundle(node, this.getNodeXmlKey(node));
    }

    public final String getDefaultBundleName(XmlKey key) {
        return this.getDefaultBundleNameImpl(null, key);
    }

    public final String getDefaultBundleName(Node node) {
        return this.getDefaultBundleNameImpl(node, this.getNodeXmlKey(node));
    }

    public final String getDefaultValue(Node node) {
        return this.getDefaultValueImpl(node, this.getNodeXmlKey(node));
    }

    public final String getDefaultValue(XmlKey key) {
        return this.getDefaultValueImpl(null, key);
    }

    public final String getDefaultValue(PropertyRowOwner owner, Node node, XmlKey key) {
        return this.getDefaultValueImpl(owner, node, key);
    }

    public final String getDeprecated(XmlKey key) {
        return this.getDeprecatedImpl(null, key);
    }

    public final int getDisplayOrder(XmlKey key) {
        return this.getDisplayOrderImpl(null, key);
    }

    public final String getDisplayValue(XmlKey key) {
        return null;
    }

    public final boolean isExpert(XmlKey key) {
        return this.isExpertImpl(null, key);
    }

    public final PropertyModel getExtraPropertyModel(XmlKey key) {
        return this.getExtraPropertyModelImpl(null, key);
    }

    public final XmlKey getFavoriteProperty(XmlKey key) {
        return this.getFavoritePropertyImpl(null, key);
    }

    public final String getGroup(XmlKey key) {
        return this.getGroupImpl(null, key);
    }

    public final String getHelpTopic(XmlKey key) {
        return this.getHelpTopicImpl(null, key);
    }

    public final boolean isHidden(XmlKey key) {
        return this.isHiddenImpl(null, key);
    }

    public final String getInitialValue(XmlKey key) {
        return this.getInitialValueImpl(null, key);
    }

    public final Class getJavaType(XmlKey key) {
        return this.getJavaTypeImpl(null, key);
    }

    public final String getLongDisplayName(XmlKey key) {
        return this.getLongDisplayNameImpl(null, key);
    }

    public final String getMediumDisplayName(XmlKey key) {
        return this.getMediumDisplayNameImpl(null, key);
    }

    public final boolean isPreferred(XmlKey key) {
        return this.isPreferredImpl(null, key);
    }

    public final List getPreferredChildren(XmlKey key) {
        return this.getPreferredChildrenImpl(null, key);
    }

    public final String getPreferredPrefix(XmlKey key) {
        return this.getPreferredPrefixImpl(null, key);
    }

    public final String getPropertyEditor(XmlKey key) {
        return this.getPropertyEditorImpl(null, key);
    }

    public final List<URI> getPropertyFormLayout(PropertyModel propertyModel, XmlKey key, Node node) {
        return this.getPropertyFormLayoutImpl(propertyModel, key, node);
    }

    public final Set<ContractIdentifier> getProhibitedAncestorContracts(XmlKey key) {
        return this.getProhibitedAncestorContractsImpl(null, key);
    }

    public final Set<ContractIdentifier> getRequiredAncestorContracts(XmlKey key) {
        return this.getRequiredAncestorContractsImpl(null, key);
    }

    public final Set<ContractIdentifier> getSatisfiedContracts(XmlKey key) {
        return this.getSatisfiedContractsImpl(null, key);
    }

    public final String getShortDescription(XmlKey key) {
        return this.getShortDescriptionImpl(null, key);
    }

    public final String getShortDisplayName(XmlKey key) {
        return this.getShortDisplayNameImpl(null, key);
    }

    public Icon getSmallIcon(XmlKey key) {
        return this.getSmallIconImpl(null, key);
    }

    public final String getSmallIconLocation(XmlKey key) {
        return this.getSmallIconLocationImpl(null, key);
    }

    public final List getTechnologyKeys(XmlKey key) {
        return this.getTechnologyKeysImpl(null, key);
    }

    public final boolean isTranslatable(XmlKey key) {
        return this.isTranslatableImpl(null, key);
    }

    public final boolean isWarnIfNotSpecified(XmlKey key) {
        return this.isWarnIfNotSpecifiedImpl(null, key);
    }

    public final boolean isTextDisplayedAsAttribute(XmlKey key) {
        return this.isTextDisplayedAsAttributeImpl(null, key);
    }

    public final VetoableChangeListener getValidator(XmlKey key) {
        return this.getValidatorImpl(null, key);
    }

    public final String getVirtualAttributeDataSource(XmlKey key) {
        return this.getVirtualAttributeDataSourceImpl(null, key);
    }

    public final boolean isWritable(XmlKey key) {
        return this.isWritableImpl(null, key);
    }

    public final boolean isPreferNamespaceDeclarations(XmlKey key) {
        return this.isPreferNamespaceDeclarationsImpl(null, key);
    }

    public final Comparator getInsertionComparator(XmlKey key) {
        return this.getInsertionComparatorImpl(null, key);
    }

    @Deprecated
    public final RefInfo getRefInfo(XmlKey key) {
        return this.getRefInfoImpl(null, key);
    }

    public final DeclarationFactory getDeclarationFactory(Node node) {
        return this.getDeclarationFactoryImpl(node, this.getNodeXmlKey(node));
    }

    public final DeclarationFactory getDeclarationFactory(XmlKey key) {
        return this.getDeclarationFactoryImpl(null, key);
    }

    public final ReferenceFactory getReferenceFactory(Node node) {
        return this.getReferenceFactoryImpl(node, this.getNodeXmlKey(node));
    }

    public final ReferenceFactory getReferenceFactory(XmlKey key) {
        return this.getReferenceFactoryImpl(null, key);
    }

    public final List<TraversalHandler> getTraversalHandlers(Node node) {
        return this.getTraversalHandlersImpl(node, this.getNodeXmlKey(node));
    }

    public final boolean areAttributePropertiesIndependent(Node node) {
        return this.areAttributePropertiesIndependentImpl(node, this.getNodeXmlKey(node));
    }

    public final AttributeSetter getAttributeSetter(Node node) {
        return this.getAttributeSetterImpl(node, this.getNodeXmlKey(node));
    }

    public final AttributeValueItemProvider getAttributeValueProvider(Node node) {
        return this.getAttributeValueProviderImpl(node, this.getNodeXmlKey(node));
    }

    public final ContextualActionProvider getContextualActionProvider(Node node) {
        return this.getContextualActionProviderImpl(node, this.getNodeXmlKey(node));
    }

    public final NodeCreator getCreationWizard(Node node) {
        return this.getCreationWizardImpl(node, this.getNodeXmlKey(node));
    }

    public final NodeCustomizer getCustomizer(Node node) {
        return this.getCustomizerImpl(node, this.getNodeXmlKey(node));
    }

    public final String getDeprecated(Node node) {
        return this.getDeprecatedImpl(node, this.getNodeXmlKey(node));
    }

    public final int getDisplayOrder(Node node) {
        return this.getDisplayOrderImpl(node, this.getNodeXmlKey(node));
    }

    public final String getDisplayValue(Node node) {
        return null;
    }

    public final boolean isExpert(Node node) {
        return this.isExpertImpl(node, this.getNodeXmlKey(node));
    }

    public final PropertyModel getExtraPropertyModel(Node node) {
        return this.getExtraPropertyModelImpl(node, this.getNodeXmlKey(node));
    }

    public final XmlKey getFavoriteProperty(Node node) {
        return this.getFavoritePropertyImpl(node, this.getNodeXmlKey(node));
    }

    public final String getGroup(Node node) {
        return this.getGroupImpl(node, this.getNodeXmlKey(node));
    }

    public final String getHelpTopic(Node node) {
        return this.getHelpTopicImpl(node, this.getNodeXmlKey(node));
    }

    public final boolean isHidden(Node node) {
        return this.isHiddenImpl(node, this.getNodeXmlKey(node));
    }

    public final String getInitialValue(Node node) {
        return this.getInitialValueImpl(node, this.getNodeXmlKey(node));
    }

    public final Class getJavaType(Node node) {
        return this.getJavaTypeImpl(node, this.getNodeXmlKey(node));
    }

    public final String getLongDisplayName(Node node) {
        return this.getLongDisplayNameImpl(node, this.getNodeXmlKey(node));
    }

    public final String getMediumDisplayName(Node node) {
        return this.getMediumDisplayNameImpl(node, this.getNodeXmlKey(node));
    }

    public final boolean isPreferred(Node node) {
        return this.isPreferredImpl(node, this.getNodeXmlKey(node));
    }

    public final List getPreferredChildren(Node node) {
        return this.getPreferredChildrenImpl(node, this.getNodeXmlKey(node));
    }

    public final String getPreferredPrefix(Node node) {
        return this.getPreferredPrefixImpl(node, this.getNodeXmlKey(node));
    }

    public final String getPropertyEditor(Node node) {
        return this.getPropertyEditorImpl(node, this.getNodeXmlKey(node));
    }

    public final Set<ContractIdentifier> getProhibitedAncestorContracts(Node node) {
        return this.getProhibitedAncestorContractsImpl(node, this.getNodeXmlKey(node));
    }

    public final Set<ContractIdentifier> getProhibitedAncestorContracts(Node node, XmlKey key) {
        return this.getProhibitedAncestorContractsImpl(node, key);
    }

    public final Set<ContractIdentifier> getRequiredAncestorContracts(Node node) {
        return this.getRequiredAncestorContractsImpl(node, this.getNodeXmlKey(node));
    }

    public final Set<ContractIdentifier> getRequiredAncestorContracts(Node node, XmlKey key) {
        return this.getRequiredAncestorContractsImpl(node, key);
    }

    public final Set<ContractIdentifier> getSatisfiedContracts(Node node) {
        return this.getSatisfiedContractsImpl(node, this.getNodeXmlKey(node));
    }

    public final String getShortDescription(Node node) {
        return this.getShortDescriptionImpl(node, this.getNodeXmlKey(node));
    }

    public final String getShortDisplayName(Node node) {
        return this.getShortDisplayNameImpl(node, this.getNodeXmlKey(node));
    }

    public Icon getSmallIcon(Node node) {
        XmlKey key = this.getNodeXmlKey(node);
        return this.getSmallIconImpl(node, key);
    }

    public final List getTechnologyKeys(Node node) {
        return this.getTechnologyKeysImpl(node, this.getNodeXmlKey(node));
    }

    public final boolean isTextDisplayedAsAttribute(Node node) {
        return this.isTextDisplayedAsAttributeImpl(node, this.getNodeXmlKey(node));
    }

    public final boolean isTranslatable(Node node) {
        return this.isTranslatableImpl(node, this.getNodeXmlKey(node));
    }

    public final boolean isTranslatable(Node node, XmlKey xmlKey) {
        return this.isTranslatableImpl(node, xmlKey);
    }

    public final VetoableChangeListener getValidator(Node node) {
        return this.getValidatorImpl(node, this.getNodeXmlKey(node));
    }

    public final TranslationInfoProvider getTranslationInfoProvider(Node n) {
        return this.getTranslationInfoProviderImpl(n, this.getNodeXmlKey(n));
    }

    public final TranslationInfoProvider getTranslationInfoProvider(XmlKey key) {
        return this.getTranslationInfoProviderImpl(null, key);
    }

    public final TranslationInfoProvider getTranslationInfoProvider(Node n, XmlKey key) {
        return this.getTranslationInfoProviderImpl(n, key);
    }

    public final ValidatorCallback getValidatorCallback(Node n) {
        return this.getValidatorCallbackImpl(n, this.getNodeXmlKey(n));
    }

    public final ValidatorCallback getValidatorCallback(Node n, XmlKey xmlKey) {
        return this.getValidatorCallbackImpl(n, xmlKey);
    }

    public final String getVirtualAttributeDataSource(Node n) {
        return this.getVirtualAttributeDataSourceImpl(n, this.getNodeXmlKey(n));
    }

    public final boolean isWritable(Node node) {
        return this.isWritableImpl(node, this.getNodeXmlKey(node));
    }

    public final boolean isPreferNamespaceDeclarations(Node node) {
        return this.isPreferNamespaceDeclarationsImpl(node, this.getNodeXmlKey(node));
    }

    public final Comparator getInsertionComparator(Node node) {
        return this.getInsertionComparatorImpl(node, this.getNodeXmlKey(node));
    }

    @Deprecated
    public final RefInfo getRefInfo(Node node) {
        return this.getRefInfoImpl(node, this.getNodeXmlKey(node));
    }

    public final TextLanguage getTextLanguage(Node node) {
        return this.getTextLanguageImpl(node, this.getNodeXmlKey(node));
    }

    public final TextLanguage getTextLanguage(XmlKey key) {
        return this.getTextLanguageImpl(null, key);
    }

    public boolean isHiddenInPropertiesDialog(XmlKey key, Node node) {
        return false;
    }

    public String getNamespaceURIFromPrefix(String prefix) {
        return (String)this._getPrefixToNamespaceMap().get(prefix);
    }

    public final String getStringRepresentation(XmlKey key, Object value) throws GrammarException {
        return this.getStringRepresentationImpl(key, value);
    }

    public final boolean inlineEditingDisabled(Node node) {
        return this.inlineEditingDisabled(node, this.getNodeXmlKey(node));
    }

    public final boolean inlineEditingDisabled(Node node, XmlKey key) {
        return this.isTranslatable(node, key) && this._translatableInlineEditingDisabled();
    }

    public final String getBundleNameForLayoutFile(Node node, XmlKey key, URI layoutFile) {
        AnnotationMetadataResolver annResolver;
        AnnotationProvider provider;
        String bundleName = null;
        List<URI> annotationLayouts = this._getAnnotationLayoutFile(node);
        if (annotationLayouts.contains(layoutFile) && (provider = this.getContext().getAnnotationModel().getAnnotationProvider(node)) != null && (bundleName = (annResolver = this.getContext().getAnnotationMetadataResolver()).getBundleNameForLayoutFile(provider, node, layoutFile)) != null) {
            return bundleName;
        }
        return this.getBundleNameForLayoutFileImpl(node, key, layoutFile);
    }

    public final String getDefaultGroup(Node node, XmlKey key) {
        return this.getDefaultGroupImpl(node, key);
    }

    public final boolean isTextValueRequired(XmlKey key) {
        return this.isTextValueRequiredImpl(key);
    }

    protected void fireXmlMetadataResolverEvent() {
        this.fireXmlMetadataResolverEvent(new XmlMetadataResolverEvent(this));
    }

    protected void fireXmlMetadataResolverEvent(GrammarResolverEvent grammarChange) {
        this.fireXmlMetadataResolverEvent(new XmlMetadataResolverEvent(this, grammarChange));
    }

    protected void fireXmlMetadataResolverEvent(XmlMetadataResolverEvent event) {
        Enumeration iter = this._listeners.getListeners();
        if (iter != null) {
            while (iter.hasMoreElements()) {
                XmlMetadataResolverListener l = (XmlMetadataResolverListener)iter.nextElement();
                l.metadataResolverChanged(event);
            }
        }
    }

    protected void performAdditionalValidationImpl(ModelValidationContext validationContext, PerValidationState validationState, Document document, XmlKey documentKey) {
    }

    protected void performAdditionalValidationImpl(ModelValidationContext validationContext, PerValidationState validationState, Element element, ElementDef elementDef, XmlKey elementKey, int processingRule, boolean deep) {
    }

    protected void performAdditionalValidationImpl(ModelValidationContext validationContext, PerValidationState validationState, Attr attribute, AttributeDef attributeDef, XmlKey attributeKey, int processingRule) {
    }

    protected boolean areAttributePropertiesIndependentImpl(Node node, XmlKey key) {
        return this._booleanValue(XmlMetadataMethods.isAttributePropertiesIndependent((MetadataEvaluator)this._evaluator, (Object)key, (Node)node), true);
    }

    protected AttributeSetter getAttributeSetterImpl(Node node, XmlKey key) {
        Object o = XmlMetadataMethods.getAttributeSetter((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        return o instanceof AttributeSetter ? (AttributeSetter)o : null;
    }

    protected ContextualActionProvider getContextualActionProviderImpl(Node node, XmlKey key) {
        Object o = XmlMetadataMethods.getContextualActionProvider((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        return o instanceof ContextualActionProvider ? (ContextualActionProvider)o : null;
    }

    protected NodeCreator getCreationWizardImpl(Node node, XmlKey key) {
        NodeCreator ret = (NodeCreator)XmlMetadataMethods.getCreationWizard((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        if (ret == null && key.getNodeType() != 1) {
            ret = this.getContext().getDefaultNodeCreator(key);
        }
        return ret;
    }

    protected NodeCustomizer getCustomizerImpl(Node node, XmlKey key) {
        return (NodeCustomizer)XmlMetadataMethods.getCustomizer((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
    }

    protected String getDefaultBundleNameImpl(Node node, XmlKey key) {
        return XmlMetadataMethods.getDefaultBundle((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
    }

    protected String getDefaultValueImpl(Node node, XmlKey key) {
        String ret = XmlMetadataMethods.getDefaultValue((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        if (ret == null) {
            ElementDef ed;
            GrammarComponent def = this.getGrammarComponent(key);
            if (def instanceof AttributeDef) {
                AttributeDef ad = (AttributeDef)def;
                ret = ad.getDefaultValue();
                if (ret == null) {
                    ret = ad.getFixedValue();
                }
            } else if (def instanceof ElementDef && (ret = (ed = (ElementDef)def).getDefaultValue()) == null) {
                ret = ed.getFixedValue();
            }
        }
        return ret;
    }

    protected String getDefaultValueImpl(PropertyRowOwner owner, Node node, XmlKey key) {
        return this.getDefaultValueImpl(node, key);
    }

    protected String getDeprecatedImpl(Node node, XmlKey key) {
        return XmlMetadataMethods.getDeprecated((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
    }

    protected int getDisplayOrderImpl(Node node, XmlKey key) {
        return this._intValue(XmlMetadataMethods.getDisplayOrder((MetadataEvaluator)this._evaluator, (Object)key, (Node)node), -1);
    }

    protected boolean isExpertImpl(Node node, XmlKey key) {
        boolean isExpert = this._booleanValue(XmlMetadataMethods.isExpert((MetadataEvaluator)this._evaluator, (Object)key, (Node)node), false);
        if (isExpert) {
            // empty if block
        }
        return isExpert;
    }

    protected PropertyModel getExtraPropertyModelImpl(Node node, XmlKey key) {
        return (PropertyModel)XmlMetadataMethods.getExtraPropertyModel((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
    }

    protected XmlKey getFavoritePropertyImpl(Node node, XmlKey nodeKey) {
        XmlKey favoriteProperty = this._favoriteProperties.get(nodeKey);
        if (favoriteProperty == _UNSET_XMLKEY) {
            return null;
        }
        if (favoriteProperty == null) {
            short nodeType = nodeKey.getNodeType();
            switch (nodeType) {
                case 1: {
                    XmlKey childKey;
                    ElementDef ed;
                    String attrName = XmlMetadataMethods.getFavoriteProperty((MetadataEvaluator)this._evaluator, (Object)nodeKey, (Node)node);
                    if (attrName == null || (ed = (ElementDef)this.getGrammarComponent(nodeKey)) == null) break;
                    if (ed.getAttributeDefByName(attrName) == null && ed.getElementDefByName(attrName) != null && (this.isTextDisplayedAsAttribute(childKey = DerivedXmlKey.createElementKey((GrammarResolver)this.getContext().getGrammarResolver(), (XmlKey)nodeKey, (ElementDef)ed.getElementDefByName(attrName))) || this.getVirtualAttributeKeys(nodeKey).contains(childKey))) {
                        favoriteProperty = childKey;
                    }
                    if (favoriteProperty != null) break;
                    favoriteProperty = DerivedXmlKey.createAttributeKey((GrammarResolver)this.getContext().getGrammarResolver(), (XmlKey)nodeKey, (String)attrName).intern();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    favoriteProperty = nodeKey;
                    break;
                }
                default: {
                    favoriteProperty = null;
                }
            }
            if (favoriteProperty != null) {
                this._favoriteProperties.put(nodeKey, favoriteProperty);
            } else {
                this._favoriteProperties.put(nodeKey, _UNSET_XMLKEY);
            }
        }
        return favoriteProperty;
    }

    protected String getGroupImpl(Node node, XmlKey key) {
        String ret = XmlMetadataMethods.getGroup((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        if (ret == null) {
            if (key.getNodeType() == 1) {
                ret = this.getShortDisplayName(ImmutableXmlKey.createNamespaceKey((String)key.getTargetNamespace()));
                if (ret == null || ret.equals("")) {
                    ret = this._otherGroupName;
                }
            } else if (key.getNodeType() == 2) {
                ret = this._generalGroupName;
            } else if (key.getNodeType() == 8 || key.getNodeType() == 3 || key.getNodeType() == 7 || key.getNodeType() == 4) {
                ret = this._xmlLangName;
            }
            if (ret == null) {
                ret = "";
            }
        }
        return ret;
    }

    protected String getHelpTopicImpl(Node node, XmlKey key) {
        String ret = XmlMetadataMethods.getHelpTopic((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        if (ret == null && key.getNodeType() == 2) {
            if (node != null) {
                Element parentNode = ((Attr)node).getOwnerElement();
                if (parentNode != null) {
                    ret = this.getHelpTopic(parentNode);
                }
            } else {
                List elementQNamePath = key.getElementQNamePath();
                if (elementQNamePath != null && elementQNamePath.size() > 0) {
                    XmlKey parent = ImmutableXmlKey.createElementKey((List)elementQNamePath);
                    ret = this.getHelpTopic(parent);
                }
            }
        }
        return ret;
    }

    protected boolean isHiddenImpl(Node node, XmlKey key) {
        return this._booleanValue(XmlMetadataMethods.isHidden((MetadataEvaluator)this._evaluator, (Object)key, (Node)node), false);
    }

    protected String getInitialValueImpl(Node node, XmlKey key) {
        return XmlMetadataMethods.getInitialValue((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
    }

    protected Class getJavaTypeImpl(Node node, XmlKey key) {
        return XmlMetadataMethods.getJavaType((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
    }

    protected AttributeValueItemProvider getAttributeValueProviderImpl(Node node, XmlKey key) {
        Object o = XmlMetadataMethods.getAttributeValueProvider((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        return o instanceof AttributeValueItemProvider ? (AttributeValueItemProvider)o : null;
    }

    protected ContextualAttributeValueItemProvider getContextualAttributeValueItemProviderImpl(Node node, XmlKey key) {
        Object o = XmlMetadataMethods.getAttributeValueProvider((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        return o instanceof ContextualAttributeValueItemProvider ? (ContextualAttributeValueItemProvider)o : null;
    }

    protected String getLongDisplayNameImpl(Node node, XmlKey key) {
        String ret = XmlMetadataMethods.getLongDisplayName((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        if (ret == null) {
            ret = node != null ? this._getNameAndFavoriteProperty(node) : this.getMediumDisplayName(key);
        }
        return ret;
    }

    protected String getMediumDisplayNameImpl(Node node, XmlKey key) {
        String ret = XmlMetadataMethods.getMediumDisplayName((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        if (ret == null) {
            ret = node != null ? this._getNameAndFavoriteProperty(node) : this.getShortDisplayName(key);
        }
        return ret;
    }

    protected boolean isPreferredImpl(Node node, XmlKey key) {
        return this._booleanValue(XmlMetadataMethods.isPreferred((MetadataEvaluator)this._evaluator, (Object)key, (Node)node), false);
    }

    protected List getPreferredChildrenImpl(Node node, XmlKey key) {
        return XmlMetadataMethods.getPreferredChildren((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
    }

    protected String getPreferredPrefixImpl(Node node, XmlKey key) {
        String ret = XmlMetadataMethods.getPreferredPrefix((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        if (ret == null && "http://www.w3.org/XML/1998/namespace".equals(key.getNamespace())) {
            ret = "xml";
        }
        return ret;
    }

    protected String getPropertyEditorImpl(Node node, XmlKey key) {
        return XmlMetadataMethods.getPropertyEditor((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
    }

    protected final Set<ContractIdentifier> getProhibitedAncestorContractsImpl(Node node, XmlKey key) {
        List contractNames = XmlMetadataMethods.getProhibitedAncestorContracts((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        return this._getContractIdentifiers(key, contractNames);
    }

    protected final Set<ContractIdentifier> getRequiredAncestorContractsImpl(Node node, XmlKey key) {
        List contractNames = XmlMetadataMethods.getRequiredAncestorContracts((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        return this._getContractIdentifiers(key, contractNames);
    }

    protected final Set<ContractIdentifier> getSatisfiedContractsImpl(Node node, XmlKey key) {
        List contractNames = XmlMetadataMethods.getSatisfiedContracts((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        return this._getContractIdentifiers(key, contractNames);
    }

    protected String getShortDescriptionImpl(Node node, XmlKey key) {
        String ret = XmlMetadataMethods.getShortDescription((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        if (ret == null) {
            switch (key.getNodeType()) {
                case 4: {
                    if (this._cdataDescription == null) {
                        this._cdataDescription = this._model.getTranslatedString("RESOLVER.CDATA_SECTION_DESCRIPTION");
                    }
                    ret = this._cdataDescription;
                    break;
                }
                case 8: {
                    if (this._commentDescription == null) {
                        this._commentDescription = this._model.getTranslatedString("RESOLVER.COMMENT_DESCRIPTION");
                    }
                    ret = this._commentDescription;
                    break;
                }
                case 7: {
                    if (this._processingInstructionDescription == null) {
                        this._processingInstructionDescription = this._model.getTranslatedString("RESOLVER.PROCESSING_INSTRUCTION_DESCRIPTION");
                    }
                    ret = this._processingInstructionDescription;
                    break;
                }
                case 3: {
                    if (this._textNodeDescription == null) {
                        this._textNodeDescription = this._model.getTranslatedString("RESOLVER.TEXT_NODE_DESCRIPTION");
                    }
                    ret = this._textNodeDescription;
                }
            }
        }
        return ret;
    }

    protected String getShortDisplayNameImpl(Node node, XmlKey key) {
        String ret = XmlMetadataMethods.getShortDisplayName((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        if (ret == null) {
            switch (key.getNodeType()) {
                case 0: {
                    GrammarComponent grammarComponent = this.getGrammarComponent(key);
                    if (grammarComponent != null) {
                        ret = grammarComponent.getName();
                    }
                    if (ret != null && !ret.equals("")) break;
                    ret = key.getTargetNamespace();
                    break;
                }
                case 1: {
                    ret = this._getDefaultShortDisplayName((Element)node, key);
                    break;
                }
                case 2: {
                    ret = key.getLocalName();
                    break;
                }
                case 4: {
                    ret = "#cdata-section";
                    break;
                }
                case 8: {
                    ret = "#comment";
                    break;
                }
                case 11: {
                    ret = "#document-fragment";
                    break;
                }
                case 9: {
                    ret = "#document";
                    break;
                }
                case 10: {
                    ret = "#document-type";
                    break;
                }
                case 6: {
                    ret = "#entity";
                    break;
                }
                case 5: {
                    ret = "#entity-reference";
                    break;
                }
                case 12: {
                    ret = "#notation";
                    break;
                }
                case 7: {
                    ret = "#processing-instruction";
                    break;
                }
                case 3: {
                    ret = "#text";
                }
            }
            if (ret == null) {
                ret = "";
            }
        }
        return ret;
    }

    protected String getSmallIconLocationImpl(Node node, XmlKey key) {
        String ret = XmlMetadataMethods.getSmallIcon((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        if (ret == null) {
            switch (key.getNodeType()) {
                case 8: {
                    ret = _DEFAULT_COMMENT_ICON_LOCATION;
                    break;
                }
                case 3: {
                    ret = _DEFAULT_TEXT_ICON_LOCATION;
                    break;
                }
                default: {
                    ret = _DEFAULT_NODE_ICON_LOCATION;
                }
            }
        }
        return ret;
    }

    protected Image getImageResource(XmlKey key, String imageLocation) {
        String namespace = key.getTargetNamespace();
        XmlContext context = this.getModel().getContext();
        GrammarProvider provider = context.getGrammarProvider();
        Grammar grammar = provider.getGrammarForNamespace(namespace);
        Class<?> resourceClass = grammar != null ? grammar.getClass() : this.getClass();
        return ImageUtils.getImageResource(resourceClass, (String)imageLocation);
    }

    protected Icon getSmallIconImpl(Node node, XmlKey key) {
        Icon iconToCache;
        ImageIcon outIcon;
        String imageLocation = this.getSmallIconLocationImpl(node, key);
        if (imageLocation == null) {
            return null;
        }
        Icon cachedIcon = _sUrlIconMap.get(imageLocation);
        if (cachedIcon != null) {
            if (cachedIcon == _UNSET_ICON) {
                return null;
            }
            return cachedIcon;
        }
        Image image = null;
        URL url = null;
        try {
            url = new URL(imageLocation);
            image = Toolkit.getDefaultToolkit().getImage(url);
        }
        catch (MalformedURLException murle) {
            // empty catch block
        }
        if (image == null && (image = this.getImageResource(key, imageLocation)) == ImageUtils.getNotLoadedImage()) {
            image = ImageUtils.getImageResource(this.getClass(), (String)_DEFAULT_NODE_ICON_LOCATION);
        }
        if (image != null) {
            outIcon = new ImageIcon(image);
            iconToCache = outIcon;
        } else {
            outIcon = null;
            iconToCache = _UNSET_ICON;
        }
        _sUrlIconMap.put(imageLocation, iconToCache);
        return outIcon;
    }

    protected List getTechnologyKeysImpl(Node node, XmlKey key) {
        return XmlMetadataMethods.getTechnologyKeys((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
    }

    protected boolean isTranslatableImpl(Node node, XmlKey key) {
        return this._booleanValue(XmlMetadataMethods.isTranslatable((MetadataEvaluator)this._evaluator, (Object)key, (Node)node), false);
    }

    protected boolean isWarnIfNotSpecifiedImpl(Node node, XmlKey key) {
        return this._booleanValue(XmlMetadataMethods.isWarnIfNotSpecified((MetadataEvaluator)this._evaluator, (Object)key, (Node)node), false);
    }

    protected boolean isTextDisplayedAsAttributeImpl(Node node, XmlKey key) {
        Boolean ret = XmlMetadataMethods.isTextDisplayedAsAttribute((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        if (ret == null) {
            GrammarComponent gc = this.getGrammarComponent(key);
            if (gc != null) {
                return TypeUtils.isSimpleTypeOrComplexTextOnlyElement((GrammarComponent)gc);
            }
            if (node != null && node.getNodeType() == 1) {
                NodeList children = node.getChildNodes();
                boolean foundText = false;
                for (int i = 0; i < children.getLength(); ++i) {
                    Node n = children.item(i);
                    if (n.getNodeType() == 1) {
                        return false;
                    }
                    if (n.getNodeType() != 3) continue;
                    foundText = true;
                }
                ret = foundText;
            }
        }
        return this._booleanValue(ret, false);
    }

    protected VetoableChangeListener getValidatorImpl(Node node, XmlKey key) {
        return (VetoableChangeListener)XmlMetadataMethods.getValidator((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
    }

    protected TranslationInfoProvider getTranslationInfoProviderImpl(Node n, XmlKey key) {
        return (TranslationInfoProvider)XmlModelMetadataMethods.getTranslationInfoProvider(this._evaluator, key, n);
    }

    protected ValidatorCallback getValidatorCallbackImpl(Node n, XmlKey key) {
        return (ValidatorCallback)XmlMetadataMethods.getValidatorCallback((MetadataEvaluator)this._evaluator, (Object)key, (Node)n);
    }

    protected String getVirtualAttributeDataSourceImpl(Node n, XmlKey key) {
        return XmlMetadataMethods.getVirtualAttributeDataSource((MetadataEvaluator)this._evaluator, (Object)key, (Node)n);
    }

    protected boolean isWritableImpl(Node node, XmlKey key) {
        return this._booleanValue(XmlMetadataMethods.isWritable((MetadataEvaluator)this._evaluator, (Object)key, (Node)node), true);
    }

    protected boolean isPreferNamespaceDeclarationsImpl(Node node, XmlKey key) {
        return this._booleanValue(XmlMetadataMethods.isPreferNamespaceDeclarations((MetadataEvaluator)this._evaluator, (Object)key, (Node)node), false);
    }

    protected Comparator getInsertionComparatorImpl(Node node, XmlKey key) {
        return (Comparator)XmlMetadataMethods.getInsertionComparator((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
    }

    @Deprecated
    protected RefInfo getRefInfoImpl(Node node, XmlKey key) {
        return (RefInfo)XmlModelMetadataMethods.getRefInfo(this._evaluator, key, node);
    }

    protected TextLanguage getTextLanguageImpl(Node node, XmlKey key) {
        Object md = XmlMetadataMethods.getTextLanguage((MetadataEvaluator)this.getMetadataEvaluator(), (Object)key, (Node)node);
        if (md instanceof TextLanguage) {
            return (TextLanguage)md;
        }
        return null;
    }

    protected ReferenceFactory getReferenceFactoryImpl(Node node, XmlKey key) {
        QualifiedName qN;
        GrammarComponent gc;
        Object md = XmlModelMetadataMethods.getReference(this._evaluator, key, null);
        if (md instanceof ReferenceFactory) {
            return (ReferenceFactory)md;
        }
        if (md instanceof Class) {
            Class clazz = (Class)md;
            if (ReferenceFactory.class.isAssignableFrom(clazz)) {
                return XmlMetadataResolver._instantiate(clazz.asSubclass(ReferenceFactory.class));
            }
            if (Reference.class.isAssignableFrom(clazz)) {
                return DependencyUtils.createWholeValueReferenceFactory(clazz.asSubclass(Reference.class));
            }
        }
        if ((gc = this.getGrammarComponent(key)) instanceof AttributeDef) {
            SimpleType type = ((AttributeDef)gc).getType();
            if (TypeUtils.isIdRefType((SimpleType)type)) {
                return _IDREF_REFERENCE_FACTORY;
            }
            if (TypeUtils.isIdRefsType((SimpleType)type)) {
                return _IDREFS_REFERENCE_FACTORY;
            }
        }
        if ((qN = key.getAttributeQName()) != null) {
            if (qN.equals((Object)QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema-instance", (String)"noNamespaceSchemaLocation"))) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = loader.loadClass("oracle.bali.xml.gui.jdev.dependency.url.UrlReferenceFactory");
                    return XmlMetadataResolver._instantiate(clazz.asSubclass(ReferenceFactory.class));
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            if (qN.equals((Object)QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema-instance", (String)"schemaLocation"))) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = loader.loadClass("oracle.bali.xml.gui.jdev.dependency.url.SchemaLocReferenceFactory");
                    return XmlMetadataResolver._instantiate(clazz.asSubclass(ReferenceFactory.class));
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
        }
        return null;
    }

    protected DeclarationFactory getDeclarationFactoryImpl(Node node, XmlKey key) {
        List elementQNamePath;
        Object md = XmlModelMetadataMethods.getDeclaration(this._evaluator, key, null);
        if (md instanceof DeclarationFactory) {
            return (DeclarationFactory)md;
        }
        if (md instanceof Class) {
            Class clazz = (Class)md;
            if (DeclarationFactory.class.isAssignableFrom(clazz)) {
                return XmlMetadataResolver._instantiate(clazz.asSubclass(DeclarationFactory.class));
            }
            if (Declaration.class.isAssignableFrom(clazz)) {
                return DependencyUtils.createWholeValueDeclarationFactory(clazz.asSubclass(Declaration.class));
            }
        }
        if (key.getNodeType() == 2 && (elementQNamePath = key.getElementQNamePath()) != null && !elementQNamePath.isEmpty()) {
            XmlKey elemKey = ImmutableXmlKey.createElementKey((List)elementQNamePath);
            QualifiedName idAttr = this._getIdAttributeName(elemKey);
            if (key.getAttributeQName().equals((Object)idAttr)) {
                return DependencyUtils.createWholeValueDeclarationFactory(IdDeclaration.class);
            }
        }
        return null;
    }

    protected List<TraversalHandler> getTraversalHandlersImpl(Node node, XmlKey key) {
        Class clazz;
        Object md = XmlModelMetadataMethods.getTraversalHandler(this._evaluator, key, null);
        ArrayList<TraversalHandler> handlers = new ArrayList<TraversalHandler>();
        if (md instanceof TraversalHandler) {
            handlers.add((TraversalHandler)md);
        } else if (md instanceof Class && TraversalHandler.class.isAssignableFrom(clazz = (Class)md)) {
            handlers.add(XmlMetadataResolver._instantiate(clazz.asSubclass(TraversalHandler.class)));
        }
        if (!DependencyUtils.DISABLE_XDF) {
            DeclarationFactory declFactory;
            ReferenceFactory refFactory;
            String value = DependencyUtils.getTextContent(node);
            if (ModelUtil.hasLength((String)value) && (refFactory = this.getReferenceFactory(key)) != null && refFactory instanceof TraversalHandler) {
                handlers.add((TraversalHandler)((Object)refFactory));
            }
            if ((declFactory = this.getDeclarationFactory(key)) != null) {
                Collection<Declaration> decls = declFactory.getDeclarations(this._model.getContext(), node, value);
                for (Declaration decl : decls) {
                    if (!(decl instanceof TraversalHandler)) continue;
                    handlers.add((TraversalHandler)((Object)decl));
                }
            }
        }
        return handlers.isEmpty() ? null : handlers;
    }

    protected String getDefaultGroupImpl(Node node, XmlKey key) {
        return XmlMetadataMethods.getDefaultGroup((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
    }

    public final boolean isDeprecated(XmlKey key) {
        String deprecatedString = this.getDeprecated(key);
        return deprecatedString != null && deprecatedString.length() > 0;
    }

    public boolean isXmlKeyCreatableInPalette(XmlKey key) {
        return key.getAttributeQName() == null && !this.isDeprecated(key) && !this.isHidden(key);
    }

    public boolean isXmlKeyCreatableInMenu(Node parent, XmlKey parentKey, XmlKey childKey) {
        List grammarKeys;
        Set currentTechKeys;
        boolean creatable = this.isXmlKeyCreatableInPalette(childKey);
        if (creatable) {
            boolean showExpert = Boolean.TRUE.equals(this.getContext().getPreferenceValue(XmlPreferences.SHOW_EXPERT_ITEMS));
            boolean isExpert = this.isExpert(childKey);
            creatable &= showExpert || !showExpert && !isExpert;
        }
        if (creatable && (currentTechKeys = this.getContext().getCurrentTechnologyKeys()) != null && !currentTechKeys.isEmpty() && (grammarKeys = this.getTechnologyKeys(childKey)) != null) {
            creatable &= currentTechKeys.containsAll(grammarKeys);
        }
        return creatable;
    }

    public final DatabindingHandler getDatabindingHandler(Node node) {
        return this.getDatabindingHandlerImpl(node, this.getNodeXmlKey(node));
    }

    public final DatabindingHandler getDatabindingHandler(XmlKey key) {
        return this.getDatabindingHandlerImpl(null, key);
    }

    public final boolean getSupportsDatabinding(Node node) {
        return this.getSupportsDatabindingImpl(node, this.getNodeXmlKey(node));
    }

    public final boolean getSupportsDatabinding(XmlKey key) {
        return this.getSupportsDatabindingImpl(null, key);
    }

    public final boolean isDatabindingSupported() {
        return this.isDatabindingSupportedImpl();
    }

    public final boolean allowsChildren(Node node) {
        return this.allowsChildrenImpl(this.getNodeXmlKey(node), node);
    }

    public final boolean allowsChildren(XmlKey key) {
        return this.allowsChildrenImpl(key, null);
    }

    public final boolean isImmutable(Node node) {
        return this.isImmutableImpl(this.getNodeXmlKey(node), node);
    }

    public final boolean isImmutable(XmlKey key) {
        return this.isImmutableImpl(key, null);
    }

    @Deprecated
    public final boolean canAddChild(Node node) {
        if (this.allowsChildren(node)) {
            return this.canAddChild(DomPositionFactory.inside((Node)node));
        }
        return false;
    }

    public final boolean canAddChild(DomPosition position) {
        return this.canAddChildImpl(position);
    }

    public final boolean isValueModifable(Node node) {
        Node ownerNode = node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : node;
        XmlKey ownerKey = this.getNodeXmlKey(ownerNode);
        return this.isValueModifableImpl(this.getNodeXmlKey(node), node, ownerKey, ownerNode, ownerKey, ownerNode);
    }

    public final boolean isValueModifable(XmlKey key, Node ownerNode) {
        XmlKey ownerKey = this.getNodeXmlKey(ownerNode);
        return this.isValueModifableImpl(key, null, ownerKey, ownerNode, ownerKey, ownerNode);
    }

    public final boolean isValueModifable(XmlKey key, Node node, XmlKey ownerKey, Node ownerNode, XmlKey nearestAncestorInDomKey, Node nearestAncestorInDomNode) {
        return this.isValueModifableImpl(key, node, ownerKey, ownerNode, nearestAncestorInDomKey, nearestAncestorInDomNode);
    }

    public final String getPropertyName(XmlKey nodeKey) {
        return this.getPropertyNameImpl(null, nodeKey);
    }

    public final String getPropertyName(Node node) {
        return this.getPropertyNameImpl(node, this.getNodeXmlKey(node));
    }

    @Deprecated
    public static final void registerAttributeValueProvider(XmlKey key, Class<? extends PropertyEditor> c) {
        if (!PropertyEditor.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("class " + c + " must be a PropertyEditor");
        }
        _sAttributeValueProviders.put(key, c);
    }

    @Deprecated
    public static final void unregisterAttributeValueProvider(XmlKey key) {
        _sAttributeValueProviders.remove(key);
    }

    @Deprecated
    public static final PropertyEditor getGlobalAttributeValueProvider(XmlKey key) {
        Class<? extends PropertyEditor> c = _sAttributeValueProviders.get(key);
        if (c == null) {
            return null;
        }
        return XmlMetadataResolver._instantiate(c);
    }

    public final Class getJavaType(XmlKey key, Object value) {
        return this.getJavaTypeImpl(null, key, value);
    }

    public final ContractDefinition getContractDefinition(ContractIdentifier identifier) {
        return this.getContractDefinitionImpl(identifier);
    }

    public boolean isSelectionTransferable() {
        return this._isSelectionTransferableOrDeletable(true);
    }

    public boolean isSelectionDeletable() {
        return this._isSelectionTransferableOrDeletable(false);
    }

    public final List<XmlKey> getAttributeKeys(Element element) {
        return this.getAttributeKeys(this.getNodeXmlKey(element));
    }

    public final List<XmlKey> getAttributeKeys(XmlKey elementKey) {
        List<XmlKey> attributeKeys = this._availableAttributeKeys.get(elementKey);
        if (attributeKeys == null) {
            attributeKeys = this.createAttributeKeys(elementKey);
            attributeKeys = CollectionUtils.createUnmodifiableList(attributeKeys);
            this._availableAttributeKeys.put(elementKey, attributeKeys);
        }
        return attributeKeys;
    }

    public final Set<XmlKey> getVirtualAttributeKeys(XmlKey elementKey) {
        Set<XmlKey> virtualAttrKeys = this._cachedVirtualAttrKeys.get(elementKey);
        if (virtualAttrKeys == null) {
            virtualAttrKeys = this.createVirtualAttributeKeys(elementKey);
            virtualAttrKeys = CollectionUtils.createUnmodifiableSet(virtualAttrKeys);
            this._cachedVirtualAttrKeys.put(elementKey, virtualAttrKeys);
        }
        return virtualAttrKeys;
    }

    public List filterProperties(XmlKey targetNodeKey, List inPropertyRows, Map qNameIndexMap) {
        return inPropertyRows;
    }

    public boolean isValidInsertion(XmlKey parentKey, Node child) {
        return this.isValidInsertionImpl(null, parentKey, child, this.getNodeXmlKey(child), 0);
    }

    public boolean isValidInsertion(DomPosition insertionPosition, NodeList potentialChildren) {
        int potentialChildCount = potentialChildren.getLength();
        if (potentialChildCount == 0) {
            return false;
        }
        XmlKey parentKey = this.getPotentialParentXmlKey(insertionPosition, potentialChildren, null);
        if (parentKey == null) {
            return false;
        }
        GrammarComponent parentGrammar = this.getGrammarComponent(parentKey);
        boolean textOK = true;
        boolean elementsOK = true;
        Node containerNode = insertionPosition.getContainerNode();
        if (parentGrammar != null) {
            if (!(parentGrammar instanceof ElementDef)) {
                return false;
            }
            ElementDef parentDef = (ElementDef)parentGrammar;
            Type parentType = parentDef.getType();
            int typeVariety = parentType.getVariety();
            switch (typeVariety) {
                case 0: 
                case 1: 
                case 2: {
                    return false;
                }
                case 6: {
                    textOK = false;
                    elementsOK = false;
                    break;
                }
                case 3: {
                    textOK = false;
                    break;
                }
                case 5: {
                    elementsOK = false;
                    break;
                }
            }
        }
        int relativePosition = insertionPosition.getRelativePosition();
        for (int i = 0; i < potentialChildCount; ++i) {
            Node potentialChild = potentialChildren.item(i);
            boolean isElement = false;
            switch (potentialChild.getNodeType()) {
                case 3: 
                case 4: {
                    if (textOK) break;
                    return false;
                }
                case 1: {
                    isElement = true;
                    if (elementsOK) break;
                    return false;
                }
            }
            if (this.isValidInsertionImpl(containerNode, parentKey, potentialChild, this.getNodeXmlKey(potentialChild), relativePosition)) continue;
            return false;
        }
        return true;
    }

    public boolean isValidInsertion(DomPosition insertionPosition, List potentialChildren) {
        if (insertionPosition.getTargetNode() == this.getModel().getDocument() && !insertionPosition.isInside()) {
            return false;
        }
        int potentialChildCount = potentialChildren.size();
        if (potentialChildCount == 0) {
            return false;
        }
        Node containerNode = insertionPosition.getContainerNode();
        int relativePosition = insertionPosition.getRelativePosition();
        XmlKey parentKey = this.getPotentialParentXmlKey(insertionPosition, null, potentialChildren);
        if (parentKey == null) {
            return false;
        }
        boolean textOK = true;
        boolean elementsOK = true;
        GrammarComponent parentGrammar = this.getGrammarComponent(parentKey);
        if (parentGrammar != null) {
            if (!(parentGrammar instanceof ElementDef)) {
                return false;
            }
            ElementDef parentDef = (ElementDef)parentGrammar;
            Type parentType = parentDef.getType();
            int typeVariety = parentType.getVariety();
            switch (typeVariety) {
                case 0: 
                case 1: 
                case 2: {
                    return false;
                }
                case 6: {
                    textOK = false;
                    elementsOK = false;
                    break;
                }
                case 3: {
                    textOK = false;
                    break;
                }
                case 5: {
                    elementsOK = false;
                    break;
                }
            }
        }
        for (Object child : potentialChildren) {
            if (child != null) {
                XmlKey childKey = (XmlKey)child;
                boolean isElement = false;
                switch (childKey.getNodeType()) {
                    case 3: 
                    case 4: {
                        if (textOK) break;
                        return false;
                    }
                    case 1: {
                        isElement = true;
                        if (elementsOK) break;
                        return false;
                    }
                }
                if (this.isValidInsertionImpl(containerNode, parentKey, null, childKey, relativePosition)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public List<ConvertPlugin> getConvertPlugins(Node nodeToConvert) {
        ArrayList<ConvertPlugin> nodePlugins = new ArrayList<ConvertPlugin>();
        XmlKey key = this.getNodeXmlKey(nodeToConvert);
        List<ConvertPlugin> plugins = this._getConvertPlugins();
        for (ConvertPlugin plugin : plugins) {
            nodePlugins.add(plugin);
        }
        return nodePlugins;
    }

    public boolean isSurroundable(Node[] nodesToSurround) {
        if (nodesToSurround != null && nodesToSurround.length > 0) {
            Node parent = nodesToSurround[0].getParentNode();
            if (parent == null) {
                return false;
            }
            for (int i = 1; i < nodesToSurround.length; ++i) {
                if (parent != nodesToSurround[i].getParentNode()) {
                    return false;
                }
                if (this.isDeletable(nodesToSurround[i])) continue;
                return false;
            }
            if (!this.canAddChild(DomPositionFactory.inside((Node)parent))) {
                return false;
            }
            XmlKey parentKey = this.getNodeXmlKey(parent);
            for (XmlKey potentialSurroundingKey : this.getCreateableChildrenXmlKeys(null, parentKey)) {
                if (potentialSurroundingKey.getNodeType() != 1) continue;
                boolean foundSurroundingKey = true;
                for (int i = 0; i < nodesToSurround.length && foundSurroundingKey; ++i) {
                    foundSurroundingKey = foundSurroundingKey && this.isValidInsertion(potentialSurroundingKey, nodesToSurround[i]);
                }
                if (!foundSurroundingKey) continue;
                return true;
            }
        }
        return false;
    }

    public XmlKey getPotentialParentXmlKey(DomPosition insertionPosition, NodeList nodes, List keys) {
        Node containerNode = insertionPosition.getContainerNode();
        return this.getNodeXmlKey(containerNode);
    }

    public Collection getPotentialInsertionPositions(DomPosition position) {
        boolean isRoot;
        Node targetNode = position.getTargetNode();
        boolean bl = isRoot = targetNode.getParentNode() == targetNode.getOwnerDocument();
        if (!isRoot) {
            DomPosition afterTarget;
            DomPosition insideTarget;
            DomPosition beforeTarget;
            Node parent = this.getModel().getTreeTraversal().getParentNode(targetNode);
            List<Object> list = new ArrayList<DomPosition>(3);
            if (parent != null && this.canAddChild(beforeTarget = DomPositionFactory.before((Node)targetNode))) {
                list.add(beforeTarget);
            }
            if (this.allowsChildren(targetNode) && this.canAddChild(insideTarget = DomPositionFactory.inside((Node)targetNode))) {
                list.add(insideTarget);
            }
            if (parent != null && this.canAddChild(afterTarget = DomPositionFactory.after((Node)targetNode))) {
                list.add(afterTarget);
            }
            if (list.isEmpty()) {
                list = Collections.emptyList();
            }
            return list;
        }
        return Collections.singleton(position);
    }

    public final SimpleType getModifiedSimpleType(Attr attrNode) {
        return this.getModifiedSimpleType(attrNode, this.getNodeXmlKey(attrNode), attrNode.getValue());
    }

    public final SimpleType getModifiedSimpleType(XmlKey attrKey, Object attributeValue) {
        return this.getModifiedSimpleType(null, attrKey, attributeValue);
    }

    public SimpleType getModifiedSimpleType(Node node, XmlKey attrKey, Object attributeValue) {
        GrammarComponent gc = this.getGrammarComponent(attrKey);
        if (gc != null) {
            if (gc instanceof AttributeDef) {
                return ((AttributeDef)gc).getType();
            }
            if (gc instanceof ElementDef && TypeUtils.isSimpleTypeOrComplexTextOnlyElement((GrammarComponent)gc)) {
                Type t = ((ElementDef)gc).getType();
                return TypeUtils.getSimpleTypeAncestor((Type)t);
            }
        }
        return null;
    }

    public final void setNodeToDefault(Node n) {
        this.setNodeToDefaultImpl(n);
    }

    public final void setNodeToDefault(XmlKey key, Node ownerNode) {
        this.setNodeToDefaultImpl(key, ownerNode);
    }

    public final boolean setAttributeEmptyString(Attr attribute, Object newValue) {
        return this.setAttributeEmptyStringImpl(attribute, newValue);
    }

    public final boolean setNodeEmptyString(Node node, Object newValue) {
        return this.setNodeEmptyStringImpl(node, newValue);
    }

    public final void validateValue(Node node, Object newValue) throws Exception {
        this.validateValueImpl(node, this.getNodeXmlKey(node), node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : node, newValue);
    }

    public final void validateValue(XmlKey nodeKey, Node ownerNode, Object newValue) throws Exception {
        this.validateValueImpl(null, nodeKey, ownerNode, newValue);
    }

    public final boolean isSet(Node node, XmlKey key, Node owner) {
        if (key == null) {
            key = node == null ? null : this.getNodeXmlKey(node);
        }
        return this.isSetImpl(node, key, owner);
    }

    public final Object getDisplayValue(Node node, Object value, boolean isDefault) {
        XmlKey key = this.getNodeXmlKey(node);
        return this.getDisplayValueImpl(node, key, node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : node.getParentNode(), value, isDefault);
    }

    public final Object getDisplayValue(XmlKey nodeKey, Node ownerNode, Object value, boolean isDefault) {
        return this.getDisplayValueImpl(null, nodeKey, ownerNode, value, isDefault);
    }

    public final String getFavoritePropertyValue(Node node) {
        return this.getFavoritePropertyValueImpl(node, this.getNodeXmlKey(node));
    }

    public final boolean isFavoriteProperty(Attr attrNode) {
        Element attrOwner = attrNode.getOwnerElement();
        return this.isFavoritePropertyImpl(attrNode, this.getNodeXmlKey(attrOwner), this.getNodeXmlKey(attrNode));
    }

    public final boolean isFavoriteProperty(Element ownerElement, XmlKey attrKey) {
        return this.isFavoritePropertyImpl(null, this.getNodeXmlKey(ownerElement), attrKey);
    }

    public final boolean isFavoriteProperty(XmlKey ownerKey, XmlKey attrKey) {
        return this.isFavoritePropertyImpl(null, ownerKey, attrKey);
    }

    public final boolean isFavoriteProperty(Element ownerNode, XmlKey ownerKey, Node propertyNode, XmlKey propertyKey) {
        if (ownerKey == null) {
            if (ownerNode == null) {
                throw new IllegalArgumentException("null ownerKey & null ownerNode");
            }
            ownerKey = this.getNodeXmlKey(ownerNode);
        }
        if (propertyKey == null) {
            if (propertyNode == null) {
                throw new IllegalArgumentException("null key & node for property");
            }
            QualifiedName propertyName = DomUtils.getQualifiedName((Node)propertyNode);
            propertyKey = DomUtils.isAttribute((Node)propertyNode) ? DerivedXmlKey.createAttributeKey((GrammarResolver)this.getContext().getGrammarResolver(), (XmlKey)ownerKey, (QualifiedName)propertyName) : (DomUtils.isElement((Node)propertyNode) ? DerivedXmlKey.createElementKey((GrammarResolver)this.getContext().getGrammarResolver(), (XmlKey)ownerKey, (QualifiedName)propertyName) : this.getNodeXmlKey(propertyNode));
        }
        Attr attrNode = propertyNode instanceof Attr ? (Attr)propertyNode : null;
        return this.isFavoritePropertyImpl(attrNode, ownerKey, propertyKey);
    }

    public final boolean isFavoritePropertyFixedAttribute(XmlKey key) {
        return this.isFavoritePropertyFixedAttributeImpl(key);
    }

    public final boolean isFavoritePropertyFixedAttribute(Node node) {
        return this.isFavoritePropertyFixedAttributeImpl(this.getNodeXmlKey(node));
    }

    public final String getPropertyDisplayName(Node node, XmlKey key, Node ownerNode, XmlKey ownerKey) {
        return this.getPropertyDisplayNameImpl(node, key, ownerNode, ownerKey);
    }

    public final String getPropertyDisplayName(XmlKey xmlKey, Node ownerNode, XmlKey ownerKey) {
        return this.getPropertyDisplayNameImpl(null, xmlKey, ownerNode, ownerKey);
    }

    public final List<String> getCategoryId(XmlKey key) {
        return this.getCategoryIdImpl(null, key);
    }

    public final List<String> getCategoryId(Node node) {
        return this.getCategoryIdImpl(node, this.getNodeXmlKey(node));
    }

    public final List<CategoryDefinition> getCategoryDefinition(List<String> categoryId) {
        return this.getCategoryDefinitionImpl(categoryId);
    }

    public final List<CategoryDefinition> getCategoryDefinition(XmlKey key) {
        return this.getCategoryDefinitionImpl(null, key);
    }

    public final List<CategoryDefinition> getCategoryDefinition(Node node) {
        return this.getCategoryDefinitionImpl(node, this.getNodeXmlKey(node));
    }

    public final Collection<XmlKey> getCreateableChildrenXmlKeys(DomPosition position) {
        return this.getCreateableChildrenXmlKeysImpl(position, this.getNodeXmlKey(position.getContainerNode()));
    }

    public final Collection<XmlKey> getCreateableChildrenXmlKeys(DomPosition position, XmlKey parentKey) {
        return this.getCreateableChildrenXmlKeysImpl(position, parentKey);
    }

    public final List getCreatablePreferredXmlKeys(DomPosition position, XmlKey parentKey) {
        return this.getCreatablePreferredXmlKeysImpl(position, parentKey);
    }

    public final List getCreatablePreferredXmlKeys(DomPosition position) {
        return this.getCreatablePreferredXmlKeysImpl(position, this.getNodeXmlKey(position.getContainerNode()));
    }

    public final List<XmlKey> getPreferredChildrenXmlKeys(Node parentNode) {
        return this.getPreferredChildrenXmlKeysImpl(parentNode, null);
    }

    public final List<XmlKey> getPreferredChildrenXmlKeys(XmlKey parentKey) {
        return this.getPreferredChildrenXmlKeysImpl(null, parentKey);
    }

    public final boolean isPaletteDisplayedForGrammar(Grammar g) {
        return this.isPaletteDisplayedForGrammarImpl(g);
    }

    public final boolean isAllPalettePageDisplayedForGrammar(Grammar g) {
        return this.isAllPalettePageDisplayedForGrammarImpl(g);
    }

    public final boolean isPreferredPalettePageEnabled() {
        return this.isPreferredPalettePageEnabledImpl();
    }

    public final boolean isTransferable(Node node) {
        return this.isTransferableImpl(this.getNodeXmlKey(node), node);
    }

    public final boolean isDeletable(Node node) {
        return this.isDeletableImpl(this.getNodeXmlKey(node), node);
    }

    public final void syncNode(Node oldNode, Node newNode, XmlKey key, XmlKey hint) {
        this.syncNodeImpl(oldNode, newNode, key, hint);
    }

    protected XmlMetadataResolver createResolver(MetadataEvaluator evaluator, AbstractModel model) {
        return new XmlMetadataResolver(evaluator, model);
    }

    protected boolean allowsChildrenImpl(XmlKey key, Node node) {
        short nodeType = key.getNodeType();
        return nodeType == 1 || nodeType == 9 || nodeType == 11;
    }

    protected List<XmlKey> createAttributeKeys(XmlKey elementKey) {
        Collection attributeDefs;
        int attrCount;
        List<XmlKey> attributeKeys = Collections.emptyList();
        ElementDef schemaElement = (ElementDef)this.getGrammarComponent(elementKey);
        if (schemaElement != null && (attrCount = (attributeDefs = schemaElement.getAttributeDefs()).size()) > 0) {
            attributeKeys = new ArrayList<XmlKey>(attrCount);
            GrammarResolver grammarSource = this.getContext().getGrammarResolver();
            for (AttributeDef currDef : attributeDefs) {
                XmlKey attrKey = DerivedXmlKey.createAttributeKey((GrammarResolver)grammarSource, (XmlKey)elementKey, (QualifiedName)currDef.getQualifiedName()).intern();
                if (this.isDeprecated(attrKey)) continue;
                attributeKeys.add(attrKey);
            }
        }
        return attributeKeys;
    }

    protected Set<XmlKey> createVirtualAttributeKeys(XmlKey elementKey) {
        ComplexType complexType;
        ContentGroup group;
        ElementDef parentDef;
        Type type;
        Set<XmlKey> virtualAttrKeys = Collections.emptySet();
        GrammarComponent grammarComponent = this.getGrammarComponent(elementKey);
        if (grammarComponent instanceof ElementDef && (type = (parentDef = (ElementDef)grammarComponent).getType()) instanceof ComplexType && (group = (complexType = (ComplexType)type).getContentGroup()) != null) {
            virtualAttrKeys = new HashSet<XmlKey>();
            LinkedHashMap virtualAttrDefMap = new LinkedHashMap();
            this._addVirtualAttributesInGroup(group, virtualAttrDefMap);
            for (List list : virtualAttrDefMap.values()) {
                if (list.size() != 1) continue;
                ElementDef vaDef = (ElementDef)list.get(0);
                XmlKey vaKey = DerivedXmlKey.createElementKey((GrammarResolver)this.getContext().getGrammarResolver(), (XmlKey)elementKey, (ElementDef)vaDef);
                virtualAttrKeys.add(vaKey);
            }
            this._addVirtualAttrKeysFromMetadata(elementKey, parentDef, virtualAttrKeys);
        }
        return virtualAttrKeys;
    }

    private void _addVirtualAttributesInGroup(ContentGroup group, LinkedHashMap virtualAttrDefMap) {
        if (group != null && group.getMaxOccurs() == 1 && group.getVariety() != 8) {
            Collection particles = group.getComponents();
            for (Object p : particles) {
                if (p instanceof ElementDef) {
                    SubstitutionGroup substGroup;
                    ElementDef pDef = (ElementDef)p;
                    if (!TypeUtils.isSimpleTypeElement((GrammarComponent)pDef) || pDef.getMaxOccurs() != 1 || (substGroup = pDef.getSubstitutionGroup()) != null && !substGroup.isEmpty()) continue;
                    QualifiedName qName = pDef.getQualifiedName();
                    ArrayList<ElementDef> list = (ArrayList<ElementDef>)virtualAttrDefMap.get(qName);
                    if (list == null) {
                        list = new ArrayList<ElementDef>(1);
                        virtualAttrDefMap.put(qName, list);
                    }
                    list.add(pDef);
                    continue;
                }
                if (!(p instanceof ContentGroup)) continue;
                this._addVirtualAttributesInGroup((ContentGroup)p, virtualAttrDefMap);
            }
        }
    }

    private void _addVirtualAttrKeysFromMetadata(XmlKey elementKey, ElementDef elementDef, Set<XmlKey> virtualAttrKeys) {
        Collection possibleChildDefs = elementDef.getElementDefs();
        for (ElementDef childDef : possibleChildDefs) {
            XmlKey childKey = DerivedXmlKey.createElementKey((GrammarResolver)this.getContext().getGrammarResolver(), (XmlKey)elementKey, (ElementDef)childDef);
            this._checkKeyForVirtualAttrMetadata(childKey, virtualAttrKeys);
            this._checkFixedAttrsForVirtualAttrMetadata(childKey, childDef, virtualAttrKeys);
        }
    }

    private void _checkKeyForVirtualAttrMetadata(XmlKey childKey, Set virtualAttrKeys) {
        Boolean ret = XmlMetadataMethods.isTextTreatedAsVirtualAttribute((MetadataEvaluator)this._evaluator, (Object)childKey, null);
        if (ret != null) {
            if (ret.booleanValue()) {
                virtualAttrKeys.add(childKey);
            } else {
                virtualAttrKeys.remove(childKey);
            }
        } else {
            String vaSource = XmlMetadataMethods.getVirtualAttributeDataSource((MetadataEvaluator)this._evaluator, (Object)childKey, null);
            if (vaSource != null) {
                virtualAttrKeys.add(childKey);
            }
        }
    }

    private void _checkFixedAttrsForVirtualAttrMetadata(XmlKey childKey, ElementDef childDef, Set virtualAttrKeys) {
        GrammarResolver resolver = this.getContext().getGrammarResolver();
        if (resolver.hasFixedAttributeElementDefs(childDef)) {
            Collection c = resolver.getFixedAttributeElementDefs(childDef);
            for (FixedAttributeElementDef faed : c) {
                QualifiedName feName = faed.getQualifiedName();
                ArrayList<QualifiedName> elementQNamePath = new ArrayList<QualifiedName>(childKey.getElementQNamePath());
                elementQNamePath.set(elementQNamePath.size() - 1, feName);
                XmlKey faXmlKey = ImmutableXmlKey.createElementKey(elementQNamePath);
                this._checkKeyForVirtualAttrMetadata(faXmlKey, virtualAttrKeys);
            }
        }
    }

    protected boolean isTransferableImpl(XmlKey key, Node node) {
        switch (key.getNodeType()) {
            case 9: 
            case 10: {
                return false;
            }
        }
        return true;
    }

    protected boolean isDeletableImpl(XmlKey key, Node node) {
        boolean canDelete = true;
        if (this.isImmutableImpl(key, node)) {
            canDelete = false;
        } else if (node != null) {
            AbstractModel model = this.getModel();
            canDelete = model.isDeletable(node);
        }
        return canDelete;
    }

    protected boolean isValidInsertionImpl(Node containerNode, XmlKey parentKey, Node child, XmlKey childKey, int relativePosition) {
        GrammarComponent parentComponent;
        short childType = this.getNodeType(childKey, child);
        Document doc = this.getModel().getDocument();
        if (containerNode == doc) {
            switch (childType) {
                case 1: {
                    if (doc.getDocumentElement() == null) break;
                    return false;
                }
                case 7: 
                case 8: {
                    return true;
                }
                default: {
                    return false;
                }
            }
            if (doc.getDocumentElement() != null && childType == 1) {
                return false;
            }
        }
        if (containerNode == null && parentKey == null || child == null && childKey == null) {
            return true;
        }
        if (child != null && containerNode != null) {
            if (child == containerNode) {
                return false;
            }
            if (DomUtils.isDescendant((Node)containerNode, (Node)child)) {
                return false;
            }
        }
        GrammarComponent grammarComponent = parentComponent = parentKey != null ? this.getGrammarComponent(parentKey) : this.getGrammarComponent(containerNode);
        if (parentComponent == null) {
            return true;
        }
        if (parentComponent instanceof ElementDef) {
            ElementDef parentElement = (ElementDef)parentComponent;
            switch (childType) {
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    return true;
                }
                case 1: {
                    List wildcards;
                    Wildcard matchingWildcard;
                    QualifiedName childQName = childKey != null ? childKey.getElementQName() : DomUtils.getQualifiedName((Node)child);
                    String currNamespace = childQName.getNamespace();
                    String currLocalName = childQName.getName();
                    int childProcessingRule = 0;
                    ElementDef currDef = parentElement.getElementDefByName(childQName);
                    if (currDef == null && (matchingWildcard = TypeUtils.getMatchingWildcard((List)(wildcards = TypeUtils.getElementWildcards((ElementDef)parentElement)), (String)currNamespace)) != null) {
                        childProcessingRule = matchingWildcard.getProcessingRule();
                        GrammarProvider provider = this.getContext().getGrammarProvider();
                        Grammar g = provider.getGrammarForNamespace(currNamespace);
                        if (g != null) {
                            currDef = g.getElementDefByName(currLocalName);
                        }
                    }
                    if (currDef != null || childProcessingRule != 0) {
                        if (containerNode != null) {
                            Set<ContractIdentifier> requiredContracts = this.getRequiredAncestorContracts(child, childKey);
                            Set<ContractIdentifier> prohibitedContracts = this.getProhibitedAncestorContracts(child, childKey);
                            if (!requiredContracts.isEmpty() || !prohibitedContracts.isEmpty()) {
                                Set<ContractIdentifier> ancestorContracts = this.getContractsSatisfiedByNodeAndAncestors(containerNode, null);
                                for (ContractIdentifier prohibitedContract : prohibitedContracts) {
                                    if (!ancestorContracts.contains(prohibitedContract)) continue;
                                    return false;
                                }
                                for (ContractIdentifier requiredContract : requiredContracts) {
                                    if (ancestorContracts.contains(requiredContract)) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    protected boolean isImmutableImpl(XmlKey key, Node node) {
        if (key.getNodeType() == 10) {
            return true;
        }
        return this.getModel().isImmutable(node);
    }

    protected boolean canAddChildImpl(DomPosition position) {
        if (position.hasTextOffset()) {
            Node textNode = position.getTargetNode();
            DomPosition afterTextNode = DomPositionFactory.after((Node)textNode);
            return this.canAddChild(afterTextNode);
        }
        Node container = position.getContainerNode(this.getModel().getTreeTraversal());
        if (this.isImmutable(container) || !this.allowsChildren(container)) {
            return false;
        }
        return this.getModel().canAddChild(position);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isValueModifableImpl(XmlKey key, Node node, XmlKey ownerKey, Node ownerNode, XmlKey nearestAncestorInDomKey, Node nearestAncestorInDomNode) {
        if ("http://www.w3.org/2000/xmlns/".equals(key.getNamespace())) {
            return false;
        }
        if (node == null) {
            if (ownerNode != null && key.getNodeType() == 2) {
                if (!DomUtils.isElement((Node)ownerNode)) return false;
                Element parentElement = (Element)ownerNode;
                if (this.isImmutableImpl(ownerKey, parentElement)) return false;
                if (this.getModel().canAddAttribute(parentElement, key)) return this.isWritable(key);
                return false;
            }
            if (this.canAddChild(DomPositionFactory.inside((Node)nearestAncestorInDomNode))) return this.isWritable(key);
            return false;
        }
        if (this.isImmutableImpl(key, node)) return false;
        if (!this.getModel().isValueModifiable(node)) {
            return false;
        }
        if (!this.isRequiredImpl(node, key, ownerNode, ownerKey)) return this.isWritable(key);
        GrammarComponent gc = this.getGrammarComponent(key);
        String fixedValue = null;
        if (gc instanceof AttributeDef) {
            fixedValue = ((AttributeDef)gc).getFixedValue();
        } else if (gc instanceof ElementDef) {
            fixedValue = ((ElementDef)gc).getFixedValue();
        }
        if (fixedValue == null) return this.isWritable(key);
        String value = node.getNodeValue();
        if (fixedValue.equals(value)) return false;
        return true;
    }

    protected Class getJavaTypeImpl(Node node, XmlKey nodeKey, Object value) {
        Class type = this.getJavaTypeImpl(node, nodeKey);
        if (type != null) {
            return type;
        }
        try {
            SimpleType simpleType = this.getModifiedSimpleType(node, nodeKey, value);
            type = JavaTypeManager.getInstance().getJavaClass(simpleType);
        }
        catch (GrammarException ge) {
            // empty catch block
        }
        if (type == null) {
            type = String.class;
        }
        return type;
    }

    protected void setNodeToDefaultImpl(Node n) {
        if (n.getNodeType() == 2) {
            Attr attr = (Attr)n;
            Element owner = attr.getOwnerElement();
            XmlKey key = this.getNodeXmlKey(n);
            AttributeSetter as = this.getAttributeSetter(key);
            if (as != null) {
                as.setAttribute(this.getContext(), key, attr, owner, null);
            } else {
                owner.removeAttributeNode(attr);
            }
        } else if (n.getNodeType() == 1) {
            if (n.getParentNode() != null) {
                n.getParentNode().removeChild(n);
            }
        } else {
            this._tryRemoveGlobalNodeTypeImpl(n);
        }
    }

    protected void setNodeToDefaultImpl(XmlKey key, Node ownerNode) {
        if (key.getNodeType() == 2) {
            Element owner;
            AttributeSetter as = this.getAttributeSetter(key);
            if (as != null) {
                as.setAttribute(this.getContext(), key, null, ownerNode, null);
            } else if (ownerNode.getNodeType() == 1 && (owner = (Element)ownerNode).hasAttributeNS(key.getNamespace(), key.getLocalName())) {
                owner.removeAttributeNS(key.getNamespace(), key.getLocalName());
            }
        }
    }

    private void _tryRemoveGlobalNodeTypeImpl(Node n) {
        switch (n.getNodeType()) {
            case 3: 
            case 4: 
            case 8: {
                n.getParentNode().removeChild(n);
                break;
            }
            case 7: {
                n.setNodeValue("");
            }
        }
    }

    protected DatabindingHandler getDatabindingHandlerImpl(Node node, XmlKey key) {
        return (DatabindingHandler)XmlMetadataMethods.getDatabindingHandler((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
    }

    protected boolean getSupportsDatabindingImpl(Node node, XmlKey key) {
        XmlKey nsKey;
        DatabindingHandler handler;
        Boolean ret = XmlMetadataMethods.isSupportsDatabinding((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        if (ret == null && key.getNodeType() == 2 && this.isDatabindingSupported() && key.getTargetNamespace() != null && (ret = Boolean.valueOf((handler = this.getDatabindingHandler(nsKey = ImmutableXmlKey.createNamespaceKey((String)key.getTargetNamespace()))) != null)).booleanValue()) {
            SimpleType type = this.getModifiedSimpleType(node, key, EXPRCHARS);
            if (type == null) {
                return false;
            }
            try {
                type.validateValue(EXPRCHARS);
            }
            catch (Exception e) {
                return false;
            }
        }
        return this._booleanValue(ret, false);
    }

    protected boolean isDatabindingSupportedImpl() {
        return false;
    }

    protected String getPropertyNameImpl(Node node, XmlKey nodeKey) {
        QualifiedName attrQName = nodeKey.getAttributeQName();
        if (attrQName != null) {
            return attrQName.getQualifiedName();
        }
        switch (nodeKey.getNodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return "data";
            }
            case 1: {
                return nodeKey.getElementQName().getName();
            }
        }
        return null;
    }

    protected boolean isSetImpl(Node node, XmlKey key, Node ownerNode) {
        String value = node == null ? null : node.getNodeValue();
        return value != null;
    }

    protected Object getDisplayValueImpl(Node node, XmlKey key, Node ownerNode, Object value, boolean isDefault) {
        if (value == null) {
            return null;
        }
        String strValue = value.toString();
        try {
            strValue = this.getStringRepresentation(key, value);
        }
        catch (GrammarException ge) {
            this.getModel().getLogger().log(Level.FINER, "Could not get a string representation for value. Instead using: " + strValue, ge);
        }
        return strValue;
    }

    protected String getFavoritePropertyValueImpl(Node node, XmlKey key) {
        if (node == null) {
            return null;
        }
        short type = key.getNodeType();
        switch (type) {
            case 1: {
                XmlKey favoriteProperty = this.getFavoritePropertyImpl(node, key);
                if (favoriteProperty == null) break;
                if (favoriteProperty.getNodeType() == 2) {
                    return DomUtils.getAttributeNS((Node)node, (String)favoriteProperty.getNamespace(), (String)favoriteProperty.getLocalName());
                }
                if (favoriteProperty.getNodeType() != 1) break;
                Node n = DomUtils.getNamedChild((Node)node, (String)node.getNamespaceURI(), (String)favoriteProperty.getLocalName());
                return n == null ? null : DomUtils.getTextNodeValue((Node)n);
            }
            case 10: {
                return null;
            }
            default: {
                return node.getNodeValue();
            }
        }
        return null;
    }

    protected String getPropertyDisplayNameImpl(Node node, XmlKey key, Node ownerNode, XmlKey ownerKey) {
        short nodeType = key.getNodeType();
        switch (nodeType) {
            case 1: 
            case 2: {
                String name = this.getShortDisplayNameImpl(node, key);
                return name;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 7: {
                return this._dataPropertyName;
            }
            case 8: {
                return this._commentPropertyName;
            }
            case 3: 
            case 4: {
                return this._textPropertyName;
            }
        }
        throw new IllegalArgumentException("Unknown node type for: " + node);
    }

    protected boolean isFavoritePropertyImpl(Attr attrNode, XmlKey ownerKey, XmlKey attrKey) {
        Element ownerElement = attrNode != null ? attrNode.getOwnerElement() : null;
        return attrKey.equals((Object)this.getFavoritePropertyImpl(ownerElement, ownerKey));
    }

    protected List<String> getCategoryIdImpl(Node node, XmlKey key) {
        List<String> ret = XmlMetadataMethods.getCategoryId((MetadataEvaluator)this._evaluator, (Object)key, (Node)node);
        if (ret == null) {
            ret = Collections.emptyList();
        }
        return ret;
    }

    protected List<CategoryDefinition> getCategoryDefinitionImpl(Node node, XmlKey key) {
        return this.getCategoryDefinitionImpl(this.getCategoryIdImpl(node, key));
    }

    protected List<CategoryDefinition> getCategoryDefinitionImpl(List<String> categoryId) {
        if (categoryId == null || categoryId.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<String> idIter = categoryId.iterator();
        CategoryDefinition current = this._getTopLevelCategoryDefinitions().get(idIter.next());
        List<CategoryDefinition> result = null;
        if (current != null) {
            result = new ArrayList<CategoryDefinition>(categoryId.size());
            result.add(current);
            while (idIter.hasNext() && (current = current.getSubCategoryDefinition(idIter.next())) != null) {
                result.add(current);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private synchronized Map<String, CategoryDefinition> _getTopLevelCategoryDefinitions() {
        if (this._categoryDefinitionMap == null) {
            ConcurrentHashMap<String, CategoryDefinition> newMap = new ConcurrentHashMap<String, CategoryDefinition>();
            List catDefBeans = XmlMetadataMethods.getCategoryDefinitions((MetadataEvaluator)this._evaluator);
            if (catDefBeans != null) {
                List<CategoryDefinition> catDefObjs = CategoryDefinitionFactory.createCategoryDefinitions(catDefBeans);
                for (CategoryDefinition aDef : catDefObjs) {
                    newMap.put(aDef.getIdentifier(), aDef);
                }
            }
            this._categoryDefinitionMap = newMap;
        }
        return this._categoryDefinitionMap;
    }

    private synchronized void _clearTopLevelCategoryDefinitions() {
        this._categoryDefinitionMap = null;
    }

    private synchronized Map<ContractIdentifier, ContractDefinition> _getGlobalContractDefinitions() {
        if (this._globalContractDefinitionCache == null) {
            ConcurrentHashMap<ContractIdentifier, ContractDefinition> newMap = new ConcurrentHashMap<ContractIdentifier, ContractDefinition>();
            List contractDefinitionsMetadataList = XmlMetadataMethods.getContractDefinitions((MetadataEvaluator)this._evaluator);
            if (contractDefinitionsMetadataList != null) {
                List<ContractDefinition> contractDefinitions = ContractDefinitionFactory.createContractDefinitions(contractDefinitionsMetadataList);
                for (ContractDefinition contractDefinition : contractDefinitions) {
                    newMap.put(contractDefinition.getIdentifier(), contractDefinition);
                }
            }
            this._globalContractDefinitionCache = newMap;
        }
        return this._globalContractDefinitionCache;
    }

    private synchronized void _clearGlobalContractCache() {
        this._globalContractDefinitionCache = null;
    }

    private synchronized List<ConvertPlugin> _getConvertPlugins() {
        if (this._convertPlugins == null) {
            List<ConvertPlugin> newList = new ArrayList<ConvertPlugin>();
            List convertPluginsMetadataList = XmlMetadataMethods.getConvertPlugins((MetadataEvaluator)this._evaluator);
            if (convertPluginsMetadataList != null) {
                newList = ConvertPluginFactory.createConvertPlugins(this.getContext(), convertPluginsMetadataList);
            }
            this._convertPlugins = newList;
        }
        return this._convertPlugins;
    }

    private synchronized void _clearConvertPlugins() {
        this._convertPlugins = null;
    }

    protected ContractDefinition getContractDefinitionImpl(ContractIdentifier identifier) {
        return this._getGlobalContractDefinitions().get(identifier);
    }

    private Set<ContractIdentifier> _getContractIdentifiers(XmlKey key, List<String> contractNames) {
        Set<ContractIdentifier> contractSet;
        if (contractNames != null && contractNames.size() > 0) {
            contractSet = new LinkedHashSet<ContractIdentifier>(contractNames.size());
            for (String name : contractNames) {
                if (ContractIdentifier.isValidIdentifier(name)) {
                    contractSet.add(ContractIdentifier.getContractIdentifier(name));
                    continue;
                }
                _LOGGER.log(Level.FINE, "XmlMetadataResolver: Ignored illegal contract identifier: " + name + " Key: " + key);
            }
        } else {
            contractSet = Collections.emptySet();
        }
        return contractSet;
    }

    private void _checkRequiredAndProhibitedContracts(ValidationContext validationContext, PerValidationState validationState, Element element, XmlKey elementKey) {
        Set<ContractIdentifier> requiredContracts = this.getRequiredAncestorContracts(element, elementKey);
        Set<ContractIdentifier> prohibitedContracts = this.getProhibitedAncestorContracts(element, elementKey);
        if (requiredContracts.isEmpty() && prohibitedContracts.isEmpty()) {
            return;
        }
        Set<ContractIdentifier> ancestorContracts = this.getContractsSatisfiedByNodeAndAncestors(validationState, element.getParentNode());
        for (ContractIdentifier prohibitedContract : prohibitedContracts) {
            if (!ancestorContracts.contains(prohibitedContract)) continue;
            validationContext.reportError(validationState, 21, "Element " + element.getTagName() + " not expected", (Node)element, null, null);
        }
        for (ContractIdentifier requiredContract : requiredContracts) {
            if (ancestorContracts.contains(requiredContract)) continue;
            validationContext.reportError(validationState, 21, "Element " + element.getTagName() + " not expected (missing required ancestor)", (Node)element, null, null);
        }
    }

    protected Set<ContractIdentifier> getContractsSatisfiedByNodeAndAncestors(PerValidationState validationState, Node node) {
        IdentityHashMap cache = (IdentityHashMap)validationState.getPerValidationProperty((Object)_ANCESTOR_SATISFIED_CONTRACT_CACHE);
        if (cache == null) {
            cache = new IdentityHashMap(137);
            validationState.setPerValidationProperty((Object)_ANCESTOR_SATISFIED_CONTRACT_CACHE, cache);
        }
        return this.getContractsSatisfiedByNodeAndAncestors(node, cache);
    }

    protected Set<ContractIdentifier> getContractsSatisfiedByNodeAndAncestors(Node node, Map<Node, Set<ContractIdentifier>> cache) {
        if (node == null) {
            return Collections.emptySet();
        }
        Set<ContractIdentifier> contractsInScope = null;
        if (cache != null) {
            contractsInScope = cache.get(node);
        }
        if (contractsInScope == null) {
            Set<ContractIdentifier> locallySatisfied = this.getSatisfiedContracts(node);
            Set<ContractIdentifier> inherited = this.getContractsSatisfiedByNodeAndAncestors(node.getParentNode(), cache);
            if (locallySatisfied.isEmpty()) {
                contractsInScope = inherited;
            } else if (inherited.isEmpty()) {
                contractsInScope = locallySatisfied;
            } else {
                contractsInScope = new LinkedHashSet<ContractIdentifier>(inherited.size() + locallySatisfied.size());
                contractsInScope.addAll(inherited);
                contractsInScope.addAll(locallySatisfied);
            }
            if (cache != null) {
                cache.put(node, contractsInScope);
            }
        }
        return contractsInScope;
    }

    protected List getCreatablePreferredXmlKeysImpl(DomPosition position, XmlKey parentKey) {
        List<XmlKey> preferredChildren = this.getPreferredChildrenXmlKeys(parentKey);
        int preferredCount = preferredChildren.size();
        if (preferredCount > 0) {
            Iterator<XmlKey> preferredKeys = preferredChildren.iterator();
            ArrayList<XmlKey> creatableKeys = new ArrayList<XmlKey>(preferredCount);
            while (preferredKeys.hasNext()) {
                XmlKey preferredChildKey = preferredKeys.next();
                List<XmlKey> preferredChildKeyList = Collections.singletonList(preferredChildKey);
                if (!this.isValidInsertion(position, preferredChildKeyList)) continue;
                creatableKeys.add(preferredChildKey);
            }
            return creatableKeys;
        }
        return Collections.EMPTY_LIST;
    }

    protected Collection<XmlKey> getCreateableChildrenXmlKeysImpl(final DomPosition position, XmlKey parentKey) {
        Collection<XmlKey> list = this._getCreatableChildrenXmlKeys(parentKey);
        if (position == null) {
            return list;
        }
        return new ImmutableFilteredCollection<XmlKey>(list, new ImmutableFilteredCollection.Filter<XmlKey>(){

            @Override
            public boolean accept(XmlKey o) {
                return XmlMetadataResolver.this.isValidInsertion(position, Collections.singletonList(o));
            }
        });
    }

    private Collection<XmlKey> _getCreatableChildrenXmlKeys(XmlKey parentKey) {
        Collection<XmlKey> creatableKeys = this._creatableKeys.get(parentKey);
        if (creatableKeys == null) {
            if (parentKey.getNodeType() == 0) {
                String ns = parentKey.getNamespace();
                creatableKeys = this._getTopLevelNonAbstractElementKeys(ns);
            } else {
                GrammarComponent component = this.getGrammarComponent(parentKey);
                if (component instanceof ElementDef) {
                    List<XmlKey> globalKeys;
                    Map<String, Collection<XmlKey>> wildcardNsToKeys;
                    ElementDef grammarElement = (ElementDef)component;
                    List wildcards = TypeUtils.getElementWildcards((ElementDef)grammarElement);
                    List grammars = TypeUtils.getAllowableGrammars((GrammarProvider)this.getContext().getGrammarProvider(), (List)wildcards);
                    if (grammars.isEmpty()) {
                        wildcardNsToKeys = Collections.emptyMap();
                    } else {
                        wildcardNsToKeys = new LinkedHashMap();
                        for (Grammar g : grammars) {
                            XmlKey namespaceKey;
                            Collection<XmlKey> keysForNamespace;
                            String namespace = g.getTargetNamespace();
                            if (!this.includeItemsInCreatableKeysDueToWildcard(parentKey, namespace) || (keysForNamespace = this.getCreateableChildrenXmlKeys(null, namespaceKey = ImmutableXmlKey.createNamespaceKey((String)namespace))).isEmpty()) continue;
                            wildcardNsToKeys.put(namespace, keysForNamespace);
                        }
                    }
                    List<XmlKey> keysDirectlyUnderED = this._getCreatableKeys(parentKey, grammarElement.getElementDefs());
                    if (!wildcardNsToKeys.isEmpty() && !keysDirectlyUnderED.isEmpty()) {
                        Iterator directItor = keysDirectlyUnderED.iterator();
                        while (directItor.hasNext()) {
                            XmlKey directKey = (XmlKey)directItor.next();
                            Collection wildcardListForNS = (Collection)wildcardNsToKeys.get(directKey.getElementQName().getNamespace());
                            if (wildcardListForNS == null || !wildcardListForNS.contains(directKey)) continue;
                            directItor.remove();
                        }
                    }
                    switch (grammarElement.getType().getVariety()) {
                        case 3: 
                        case 6: {
                            globalKeys = _sCommentAndPiKeys;
                            break;
                        }
                        default: {
                            globalKeys = _sCreatableGlobalKeys;
                        }
                    }
                    int numCollections = 1 + (keysDirectlyUnderED.isEmpty() ? 0 : 1) + wildcardNsToKeys.size();
                    Collection[] cols = new Collection[numCollections];
                    int i = 0;
                    if (!wildcardNsToKeys.isEmpty()) {
                        Iterator i$ = wildcardNsToKeys.values().iterator();
                        while (i$.hasNext()) {
                            Collection wcCollection;
                            cols[i] = wcCollection = (Collection)i$.next();
                            ++i;
                        }
                    }
                    if (!keysDirectlyUnderED.isEmpty()) {
                        cols[i] = keysDirectlyUnderED;
                        ++i;
                    }
                    assert (i == numCollections - 1);
                    cols[i] = globalKeys;
                    creatableKeys = new MultiCollection<XmlKey>(cols);
                } else {
                    creatableKeys = _sCreatableGlobalKeys;
                }
            }
            this._creatableKeys.put(parentKey, creatableKeys);
        }
        return creatableKeys;
    }

    private List<XmlKey> _getCreatableKeys(XmlKey parentKey, Collection<ElementDef> allowedElements) {
        GrammarResolver grammarResolver = this.getContext().getGrammarResolver();
        ArrayList<XmlKey> creatableKeys = new ArrayList<XmlKey>(allowedElements.size());
        for (ElementDef childElement : allowedElements) {
            Collection fixedDefs;
            XmlKey elementKey = DerivedXmlKey.createElementKey((GrammarResolver)this.getContext().getGrammarResolver(), (XmlKey)parentKey, (ElementDef)childElement).intern();
            if (!childElement.isAbstract()) {
                creatableKeys.add(elementKey);
            }
            if (!(fixedDefs = grammarResolver.getFixedAttributeElementDefs(childElement)).isEmpty()) {
                for (FixedAttributeElementDef fe : fixedDefs) {
                    QualifiedName feName = fe.getQualifiedName();
                    ArrayList<QualifiedName> elementQNamePath = new ArrayList<QualifiedName>(elementKey.getElementQNamePath());
                    elementQNamePath.set(elementQNamePath.size() - 1, feName);
                    XmlKey feKey = ImmutableXmlKey.createElementKey(elementQNamePath);
                    if (!this.isXmlKeyCreatableInMenu(null, parentKey, feKey)) continue;
                    creatableKeys.add(feKey);
                }
            }
            for (XmlKey pseudoKey : this._evaluator.getPseudoXmlKeys((Object)elementKey)) {
                if (this.isXmlKeyCreatableInMenu(null, parentKey, pseudoKey)) {
                    // empty if block
                }
                creatableKeys.add(pseudoKey);
            }
        }
        creatableKeys.trimToSize();
        return creatableKeys;
    }

    protected XmlKey createXmlKeyFromString(XmlKey parentKey, ElementDef parentDef, String qname) {
        String localName;
        GrammarResolver grammarResolver = this.getContext().getGrammarResolver();
        int indexOfColon = qname.indexOf(58);
        String prefix = qname.substring(0, indexOfColon);
        String namespaceURI = this.getNamespaceURIFromPrefix(prefix);
        QualifiedName elementQName = QualifiedName.getQualifiedName((String)namespaceURI, (String)(localName = qname.substring(indexOfColon + 1)));
        ElementDef currChildDef = parentDef.getElementDefByName(elementQName);
        XmlKey elementKey = currChildDef != null ? DerivedXmlKey.createElementKey((GrammarResolver)grammarResolver, (XmlKey)parentKey, (QualifiedName)elementQName) : ImmutableXmlKey.createElementKey((QualifiedName)elementQName);
        elementKey = elementKey.intern();
        return elementKey;
    }

    protected List<XmlKey> getPreferredChildrenXmlKeysImpl(Node parentNode, XmlKey parentKey) {
        if (parentKey == null) {
            parentKey = this.getNodeXmlKey(parentNode);
        }
        if (parentKey == null || parentKey.getAttributeQName() != null) {
            return Collections.emptyList();
        }
        List preferredChildrenNames = this.getPreferredChildrenImpl(parentNode, parentKey);
        if (preferredChildrenNames == null || preferredChildrenNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<XmlKey> preferredChildrenKeys = new ArrayList<XmlKey>(preferredChildrenNames.size());
        ElementDef parentDef = (ElementDef)this.getGrammarComponent(parentKey);
        GrammarResolver grammarResolver = this.getContext().getGrammarResolver();
        for (String preferredChildName : preferredChildrenNames) {
            String localName;
            String namespaceURI;
            if (preferredChildName.length() <= 0) continue;
            int indexOfColon = preferredChildName.indexOf(58);
            if (indexOfColon < 0) {
                namespaceURI = parentKey.getNamespace();
                localName = preferredChildName;
            } else {
                String prefix = preferredChildName.substring(0, indexOfColon);
                namespaceURI = this.getNamespaceURIFromPrefix(prefix);
                localName = preferredChildName.substring(indexOfColon + 1);
            }
            QualifiedName elementQName = QualifiedName.getQualifiedName((String)namespaceURI, (String)localName);
            ElementDef currChildDef = parentDef.getElementDefByName(elementQName);
            XmlKey elementKey = currChildDef != null ? DerivedXmlKey.createElementKey((GrammarResolver)grammarResolver, (XmlKey)parentKey, (QualifiedName)elementQName) : ImmutableXmlKey.createElementKey((QualifiedName)elementQName);
            elementKey = elementKey.intern();
            preferredChildrenKeys.add(elementKey);
        }
        return preferredChildrenKeys;
    }

    protected void validateValueImpl(Node node, XmlKey nodeKey, Node ownerNode, Object newValue) throws Exception {
        VetoableChangeListener vcl;
        SimpleType simpleType = this.getModifiedSimpleType(node, nodeKey, newValue);
        String stringValue = this.getStringRepresentation(nodeKey, newValue);
        if ((stringValue == null || "".equals(stringValue)) && this.isRequired(nodeKey, ownerNode)) {
            throw new IllegalArgumentException("Required attributes cannot be set to null.");
        }
        if (simpleType != null) {
            simpleType.validateValue(stringValue);
        }
        if ((vcl = this.getValidator(nodeKey)) != null) {
            String propertyName = this.getPropertyNameImpl(node, nodeKey);
            ContextualPropertyChangeEvent e = new ContextualPropertyChangeEvent(ownerNode, propertyName, newValue, stringValue, this.getContext());
            vcl.vetoableChange(e);
        }
    }

    protected String getStringRepresentationImpl(XmlKey key, Object value) throws GrammarException {
        if (value == null) {
            return null;
        }
        SimpleType st = this.getModifiedSimpleType(key, value);
        if (st == null) {
            return value.toString();
        }
        return JavaTypeManager.getInstance().convertToString(value, st);
    }

    protected boolean setAttributeEmptyStringImpl(Attr attribute, Object newValue) {
        if (this.isRequired(attribute, (Node)attribute.getOwnerElement())) {
            throw new IllegalArgumentException(this.getContext().getTranslatedString("RESOLVER.REQUIRED_ERROR"));
        }
        XmlKey key = this.getNodeXmlKey(attribute);
        Element owner = attribute.getOwnerElement();
        AttributeSetter as = this.getAttributeSetter(key);
        if (as != null) {
            return as.setAttribute(this.getContext(), key, attribute, owner, "");
        }
        owner.removeAttributeNS(attribute.getNamespaceURI(), DomUtils.getLocalName((Node)attribute));
        return true;
    }

    protected boolean setNodeEmptyStringImpl(Node node, Object newValue) {
        Node parent = node.getParentNode();
        if (this.isRequired(node, parent)) {
            throw new IllegalArgumentException(this.getContext().getTranslatedString("RESOLVER.REQUIRED_ERROR"));
        }
        parent.removeChild(node);
        return true;
    }

    protected void handleModelInvalidateEvent(XmlModelEvent event) {
    }

    protected void handleModelChangeEvent(XmlModelEvent event) {
    }

    protected boolean isPaletteDisplayedForGrammarImpl(Grammar g) {
        return true;
    }

    protected boolean isAllPalettePageDisplayedForGrammarImpl(Grammar g) {
        return true;
    }

    protected boolean isPreferredPalettePageEnabledImpl() {
        return true;
    }

    protected void syncNodeImpl(Node oldNode, Node newNode, XmlKey key, XmlKey hint) {
        try {
            DomUtils.syncNode((Node)oldNode, (Node)newNode);
        }
        catch (Exception e) {
            this.getModel().getLogger().log(Level.SEVERE, "Error calling syncNode", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<URI> getPropertyFormLayoutImpl(PropertyModel propertyModel, XmlKey key, Node node) {
        PropertyFormLayoutGenerator pflg = PropertyFormLayoutGenerator.newInstance();
        ArrayList<URI> uris = new ArrayList<URI>(3);
        URI uri = null;
        try {
            pflg.setPropertyModel(propertyModel);
            pflg.setInspectableKey(key);
            if (DomUtils.isInDocumentHierarchy((Node)node)) {
                List<URI> extraUris = this.getExtraPropertyFormLayouts(key, node);
                uri = XmlModelMetadataMethods.getPropertyFormLayout(this.getMetadataEvaluator(), key, node);
                if (uri != null) {
                    uris.add(uri);
                }
                if (extraUris != null) {
                    uris.addAll(extraUris);
                }
                if (uris.isEmpty()) {
                    uri = this._piLayoutUris.get(key);
                    if (uri == null && (uri = pflg.generatePIPropertyLayout()) != null) {
                        this._piLayoutUris.put(key, uri);
                    }
                    if (uri != null) {
                        uris.add(uri);
                    }
                }
                if (node != null) {
                    uris.addAll(this._getAnnotationLayoutFile(node));
                }
            } else {
                uri = this._creatorLayoutUris.get(key);
                if (uri == null && (uri = pflg.generateCreatorPropertyLayout()) != null) {
                    this._creatorLayoutUris.put(key, uri);
                }
                if (uri != null) {
                    uris.add(uri);
                }
            }
        }
        finally {
            pflg.dispose();
        }
        return uris;
    }

    private List<URI> _getAnnotationLayoutFile(Node node) {
        AnnotationMetadataResolver annResolver;
        List<URI> annotationLayoutURIs;
        AnnotationProvider provider = this.getContext().getAnnotationModel().getAnnotationProvider(node);
        if (provider != null && (annotationLayoutURIs = (annResolver = this.getContext().getAnnotationMetadataResolver()).getAnnotationPropertyFormLayouts(provider, node)) != null) {
            return annotationLayoutURIs;
        }
        return Collections.emptyList();
    }

    protected List<URI> getExtraPropertyFormLayouts(XmlKey key, Node node) {
        URI uri = XmlModelMetadataMethods.getExtraPropertyFormLayout(this.getMetadataEvaluator(), key, node);
        if (uri == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(uri);
    }

    protected final short getNodeType(XmlKey key, Node node) {
        if (node != null) {
            return node.getNodeType();
        }
        if (key != null) {
            return key.getNodeType();
        }
        return Short.MAX_VALUE;
    }

    protected boolean includeItemsInCreatableKeysDueToWildcard(XmlKey parentKey, String namespace) {
        return true;
    }

    protected String getBundleNameForLayoutFileImpl(Node node, XmlKey key, URI layoutFile) {
        XmlKey nsKey = ImmutableXmlKey.getNamespaceKey((XmlKey)key);
        return this.getDefaultBundleName(nsKey);
    }

    private synchronized void _clearPrefixToNamespaceMap() {
        this._prefixToNamespaceMap = null;
    }

    private synchronized Map _getPrefixToNamespaceMap() {
        if (this._prefixToNamespaceMap == null) {
            this._prefixToNamespaceMap = new HashMap<String, String>(13);
            Collection grammars = this.getContext().getGrammarResolver().getGrammars();
            for (Grammar g : grammars) {
                String ns = g.getTargetNamespace();
                XmlKey gKey = ImmutableXmlKey.createNamespaceKey((String)ns);
                String preferredPrefix = this.getPreferredPrefix(gKey);
                if (preferredPrefix == null) continue;
                this._prefixToNamespaceMap.put(preferredPrefix, ns);
            }
        }
        return this._prefixToNamespaceMap;
    }

    private boolean _booleanValue(Boolean obj, boolean defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return obj;
    }

    private int _intValue(Number obj, int defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return obj.intValue();
    }

    private String _getDefaultShortDisplayName(Element element, XmlKey key) {
        String local = key.getLocalName();
        QualifiedName lastQName = key.getElementQName();
        String fixedAttrValue = lastQName.getAttributeValue();
        if (fixedAttrValue != null) {
            return XmlMetadataResolver._formatADashB(local, fixedAttrValue);
        }
        return local;
    }

    private String _getNameAndFavoriteProperty(Node node) {
        boolean hasDisplayName;
        String displayName;
        switch (node.getNodeType()) {
            case 3: 
            case 8: {
                displayName = "";
                break;
            }
            case 10: {
                DocumentType docType = (DocumentType)node;
                if (docType.getPublicId() != null) {
                    displayName = docType.getPublicId();
                    break;
                }
                if (docType.getSystemId() != null) {
                    displayName = docType.getSystemId();
                    break;
                }
                displayName = docType.getName();
                break;
            }
            default: {
                displayName = this.getShortDisplayName(node);
            }
        }
        XmlKey nodeKey = this.getNodeXmlKey(node);
        String favoritePropertyValue = null;
        XmlKey favoriteProperty = this.getFavoriteProperty(nodeKey);
        if (favoriteProperty != null && !favoriteProperty.equals((Object)this._getFixedAttribute(nodeKey)) && (favoritePropertyValue = this.getFavoritePropertyValue(node)) != null) {
            if (favoritePropertyValue.length() > 500) {
                StringBuffer newFav = new StringBuffer(500);
                newFav.append(favoritePropertyValue.substring(0, 497));
                newFav.append("...");
                favoritePropertyValue = newFav.toString();
            }
            Matcher matcher = _WHITESPACE_PATTERN.matcher(favoritePropertyValue);
            favoritePropertyValue = matcher.replaceAll(" ");
            favoritePropertyValue = favoritePropertyValue.trim();
        }
        boolean hasFavoriteProperty = favoritePropertyValue != null && favoritePropertyValue.length() > 0;
        boolean bl = hasDisplayName = displayName != null && displayName.length() > 0;
        if (!hasDisplayName) {
            return favoritePropertyValue;
        }
        if (hasFavoriteProperty) {
            return XmlMetadataResolver._formatADashB(displayName, favoritePropertyValue);
        }
        return displayName;
    }

    protected final boolean isFavoritePropertyFixedAttributeImpl(XmlKey key) {
        XmlKey fixedAttribute = this._getFixedAttribute(key);
        return fixedAttribute != null && fixedAttribute.equals((Object)this.getFavoriteProperty(key));
    }

    private XmlKey _getFixedAttribute(XmlKey key) {
        if (key.getNodeType() != 1) {
            return null;
        }
        QualifiedName qName = key.getElementQName();
        if (qName.getAttributeValue() != null) {
            return ImmutableXmlKey.createAttributeKey((List)key.getElementQNamePath(), (String)qName.getAttributeName());
        }
        return null;
    }

    private List<XmlKey> _getTopLevelNonAbstractElementKeys(String namespace) {
        List<Object> keys = this._nsToTopLevelKeyList.get(namespace);
        if (keys == null) {
            Grammar grammar = this.getContext().getGrammarProvider().getGrammarForNamespace(namespace);
            keys = grammar == null ? Collections.emptyList() : CollectionUtils.createUnmodifiableList(this._getCreatableKeys(ImmutableXmlKey.createNamespaceKey((String)namespace), grammar.getElementDefs()));
            this._nsToTopLevelKeyList.put(namespace, keys);
        }
        return keys;
    }

    private static String _formatADashB(String first, String second) {
        return FastMessageFormat.formatMessage("{0} - {1}", first, second);
    }

    private boolean _isValidAllInsertion(Node containerNode, NodeList insertNodes, List insertKeys) {
        NodeList currentChildren;
        ElementDef containerDef = (ElementDef)this.getGrammarComponent(containerNode);
        HashSet allowedContents = new HashSet(containerDef.getElementDefs());
        boolean isValid = this._isValidAllInsertionNodes(allowedContents, currentChildren = containerNode.getChildNodes());
        if (isValid) {
            isValid = insertKeys != null ? this._isValidAllInsertionKeys(allowedContents, insertKeys) : this._isValidAllInsertionNodes(allowedContents, insertNodes);
        }
        return isValid;
    }

    private boolean _isValidAllInsertionNodes(Set availableElementDefs, NodeList insertNodes) {
        int childCount = insertNodes.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node currentChild = insertNodes.item(i);
            GrammarComponent childGrammar = this.getGrammarComponent(currentChild);
            if (availableElementDefs.remove(childGrammar)) continue;
            return false;
        }
        return true;
    }

    private boolean _isValidAllInsertionKeys(Set availableElementDefs, List insertKeys) {
        int keyCount = insertKeys.size();
        for (int i = 0; i < keyCount; ++i) {
            XmlKey currentKey = (XmlKey)insertKeys.get(i);
            GrammarComponent childGrammar = this.getGrammarComponent(currentKey);
            if (childGrammar == null) {
                childGrammar = this.getGrammarComponent(currentKey);
            }
            if (availableElementDefs.remove(childGrammar)) continue;
            return false;
        }
        return true;
    }

    private static ContentGroup _getRealContentGroup(ContentGroup group) {
        if (group != null && group.getMaxOccurs() == 1 && group.getMinOccurs() == 1) {
            int groupType = group.getVariety();
            Collection contents = group.getComponents();
            if (contents.size() <= 2) {
                Iterator contentsIterator = contents.iterator();
                Object onlyChild = contentsIterator.next();
                if (contents.size() == 2) {
                    onlyChild = contentsIterator.next();
                }
                if (onlyChild instanceof ContentGroup) {
                    return XmlMetadataResolver._getRealContentGroup((ContentGroup)onlyChild);
                }
            }
        }
        return group;
    }

    private boolean _isSelectionTransferableOrDeletable(boolean isTransfer) {
        Selection sel = this.getModel().getSelection();
        if (sel.isEmpty()) {
            return false;
        }
        Iterator<Node> itor = sel.getSelectedNodes();
        while (itor.hasNext()) {
            Node curNode = itor.next();
            if (isTransfer && !this.isTransferable(curNode)) {
                return false;
            }
            if (isTransfer || this.isDeletable(curNode)) continue;
            return false;
        }
        return true;
    }

    private void _clearCache() {
        this._favoriteProperties.clear();
        this._availableAttributeKeys.clear();
        this._requiredAttributeKeys.clear();
        this._requiredChildElementKeys.clear();
        this._cachedVirtualAttrKeys.clear();
        this._creatableKeys.clear();
        this._nsToTopLevelKeyList.clear();
        this._clearPrefixToNamespaceMap();
        this._elementKeyToIdAttributeQName.clear();
        this._clearTopLevelCategoryDefinitions();
        this._clearGlobalContractCache();
    }

    private QualifiedName _getIdAttributeName(XmlKey key) {
        Object cached = this._elementKeyToIdAttributeQName.get(key);
        if (cached == _UNSET_VALUE) {
            return null;
        }
        if (cached instanceof QualifiedName) {
            return (QualifiedName)cached;
        }
        QualifiedName ret = null;
        GrammarComponent gc = this.getGrammarComponent(key);
        if (gc instanceof ElementDef) {
            Collection attrDefs = ((ElementDef)gc).getAttributeDefs();
            for (AttributeDef attrDef : attrDefs) {
                if (!TypeUtils.isIdType((SimpleType)attrDef.getType())) continue;
                ret = attrDef.getQualifiedName();
                break;
            }
        }
        Object cacheValue = ret == null ? _UNSET_VALUE : ret;
        this._elementKeyToIdAttributeQName.put(key, cacheValue);
        return ret;
    }

    private ResourceBundle _getDefaultBundle(Node node, XmlKey key) {
        String bundleName = this.getDefaultBundleNameImpl(node, key);
        if (bundleName == null) {
            return null;
        }
        return ResourceBundle.getBundle(bundleName, this.getLocale());
    }

    private ValidatorCallback _getAttachedValidatorCallback(Node node, XmlKey xmlKey) {
        ValidatorCallback vc = this.getValidatorCallback(node, xmlKey);
        if (vc != null && vc instanceof BaseValidatorCallback) {
            ((BaseValidatorCallback)vc).__ensureContextIsAttached(this.getContext());
        }
        return vc;
    }

    private void _checkDeprecation(ValidationContext validationContext, PerValidationState validationState, Node node, XmlKey xmlKey) {
        if (this.isDeprecated(xmlKey)) {
            validationContext.reportWarning(validationState, 120, this.getDeprecated(xmlKey), node, null);
        }
    }

    public final boolean isRequired(Node child, Node parent) {
        if (parent == null) {
            _LOGGER.log(Level.WARNING, "Null parent node passed to isRequired()", new IllegalArgumentException("Null parent node passed to isRequired()"));
            return false;
        }
        return this.isRequiredImpl(child, this.getNodeXmlKey(child), parent, this.getNodeXmlKey(parent));
    }

    public final boolean isRequired(XmlKey childKey, Node parent) {
        if (parent == null) {
            _LOGGER.log(Level.WARNING, "Null parent node passed to isRequired()", new IllegalArgumentException("Null parent node passed to isRequired()"));
            return false;
        }
        return this.isRequiredImpl(null, childKey, parent, this.getNodeXmlKey(parent));
    }

    public final boolean isRequired(XmlKey childKey, XmlKey parentKey) {
        if (parentKey == null) {
            _LOGGER.log(Level.WARNING, "Null parentKey passed to isRequired()", new IllegalArgumentException("Null parentKey passed to isRequired()"));
            return false;
        }
        return this.isRequiredImpl(null, childKey, null, parentKey);
    }

    protected boolean isRequiredImpl(Node child, XmlKey childKey, Node parent, XmlKey parentKey) {
        if (childKey != null && parentKey != null) {
            short childNodeType = childKey.getNodeType();
            if (childNodeType == 2) {
                Set<XmlKey> requiredAttrKeys = this._getRequiredAttributeKeys(parentKey);
                return requiredAttrKeys.contains(childKey);
            }
            if (childNodeType == 1) {
                Set<XmlKey> requiredChildElementKeys = this._getRequiredChildElementKeys(parentKey);
                return requiredChildElementKeys.contains(childKey);
            }
            if (childNodeType == 3) {
                return this.isTextValueRequired(this.getNodeXmlKey(parent.getParentNode()));
            }
        }
        return false;
    }

    protected boolean isTextValueRequiredImpl(XmlKey key) {
        SimpleType simpleType;
        GrammarComponent gc = this.getGrammarComponent(key);
        ElementDef grammarElement = (ElementDef)gc;
        if (grammarElement != null && (simpleType = TypeUtils.getSimpleTypeAncestor((Type)grammarElement.getType())) != null) {
            try {
                simpleType.validateValue("");
            }
            catch (GrammarException e) {
                return true;
            }
        }
        return false;
    }

    private Set<XmlKey> _getRequiredAttributeKeys(XmlKey elementKey) {
        Set<Object> requiredAttrSet = this._requiredAttributeKeys.get(elementKey);
        if (requiredAttrSet == null) {
            requiredAttrSet = new HashSet<XmlKey>();
            GrammarComponent grammarComponent = this.getGrammarComponent(elementKey);
            if (grammarComponent instanceof ElementDef) {
                ElementDef elementDef = (ElementDef)grammarComponent;
                Collection attrDefs = elementDef.getAttributeDefs();
                for (AttributeDef attr : attrDefs) {
                    if (!attr.isRequired()) continue;
                    XmlKey requiredAttrKey = DerivedXmlKey.createAttributeKey((GrammarResolver)this.getContext().getGrammarResolver(), (XmlKey)elementKey, (QualifiedName)attr.getQualifiedName()).intern();
                    requiredAttrSet.add(requiredAttrKey);
                }
            }
            if (requiredAttrSet.isEmpty()) {
                requiredAttrSet = Collections.emptySet();
            }
            this._requiredAttributeKeys.put(elementKey, requiredAttrSet);
        }
        return requiredAttrSet;
    }

    private Set<XmlKey> _getRequiredChildElementKeys(XmlKey parentKey) {
        Set<Object> requiredChildSet = this._requiredChildElementKeys.get(parentKey);
        if (requiredChildSet == null) {
            ElementDef parentDef;
            Type type;
            requiredChildSet = new HashSet<XmlKey>();
            GrammarComponent grammarComponent = this.getGrammarComponent(parentKey);
            if (grammarComponent instanceof ElementDef && (type = (parentDef = (ElementDef)grammarComponent).getType()) instanceof ComplexType) {
                ComplexType complexType = (ComplexType)type;
                this._getRequiredChildElementKeysFromGroup(parentKey, complexType.getContentGroup(), requiredChildSet);
            }
            if (requiredChildSet.isEmpty()) {
                requiredChildSet = Collections.emptySet();
            }
            this._requiredChildElementKeys.put(parentKey, requiredChildSet);
        }
        return requiredChildSet;
    }

    private void _getRequiredChildElementKeysFromGroup(XmlKey parentKey, ContentGroup group, Set<XmlKey> requiredChildSet) {
        if (group == null) {
            return;
        }
        Collection particles = group.getComponents();
        if (particles != null) {
            Iterator iter = particles.iterator();
            if (group.getVariety() == 8) {
                Object choiceParticle;
                if (group.getMinOccurs() > 0 && particles.size() == 1 && (choiceParticle = iter.next()) instanceof ElementDef) {
                    ElementDef choiceParticleDef = (ElementDef)choiceParticle;
                    XmlKey childKey = DerivedXmlKey.createElementKey((GrammarResolver)this.getContext().getGrammarResolver(), (XmlKey)parentKey, (ElementDef)choiceParticleDef);
                    requiredChildSet.add(childKey);
                }
                return;
            }
            while (iter.hasNext()) {
                Object particle = iter.next();
                if (particle instanceof ElementDef) {
                    ElementDef elementDef = (ElementDef)particle;
                    if (elementDef.getMinOccurs() <= 0 || elementDef.isAbstract()) continue;
                    XmlKey childKey = DerivedXmlKey.createElementKey((GrammarResolver)this.getContext().getGrammarResolver(), (XmlKey)parentKey, (ElementDef)elementDef);
                    requiredChildSet.add(childKey);
                    continue;
                }
                if (!(particle instanceof ContentGroup)) continue;
                ContentGroup subgroup = (ContentGroup)particle;
                this._getRequiredChildElementKeysFromGroup(parentKey, subgroup, requiredChildSet);
            }
        }
    }

    private static <K, V> Map<K, V> _sCreateCacheMap(int initSize) {
        return new ConcurrentHashMap(initSize, 0.75f, 4);
    }

    private static <T> T _instantiate(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            _LOGGER.log(Level.WARNING, "Could not instantiate class " + clazz, e);
            return null;
        }
    }

    private boolean _translatableInlineEditingDisabled() {
        return (Boolean)this._model.getContext().getTransientPreferenceValue(XmlPreferences.TRANSLATABLE_INLINE_EDITING_DISABLED);
    }

    private class GrammarListener
    extends GrammarResolverAdapter {
        private GrammarListener() {
        }

        public void invalidate(GrammarResolverEvent e) {
            XmlMetadataResolver.this._clearCache();
        }

        public void grammarResolverChanged(GrammarResolverEvent e) {
            XmlMetadataResolver.this.fireXmlMetadataResolverEvent(e);
        }
    }

    private class Listener
    extends XmlModelAdapter {
        private Listener() {
        }

        @Override
        public void invalidate(XmlModelEvent event) {
            XmlMetadataResolver.this.handleModelInvalidateEvent(event);
        }

        @Override
        public void modelChanged(XmlModelEvent event) {
            XmlMetadataResolver.this.handleModelChangeEvent(event);
        }
    }
}

