/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.indexing;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.indexing.IndexingFactory;
import oracle.bali.xml.indexing.IndexingMetadataMapper;
import oracle.bali.xml.indexing.IndexingMetadataParser;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileException;

public class IndexingProvider {
    private static final QualifiedName REFERENCE_FACTORY = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata/model", (String)"reference");
    private static final QualifiedName INDEXING_FACTORY = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata/model", (String)"indexingFactory");
    private static final QualifiedName SCHEMA_LOCATION = QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema-instance", (String)"schemaLocation");
    private static final QualifiedName NO_NAMESPACE = QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema-instance", (String)"noNamespaceSchemaLocation");
    private static final ArrayList<QualifiedName> _qnList = new ArrayList();
    private static final IndexingMetadataParser _parser;
    private static final ConcurrentHashMap _factoryClassMap;
    private static final Logger _LOGGER;
    private IndexingMetadataMapper _mapper;
    private List<Map<XmlKey, Map<QualifiedName, List<String>>>> _metadataList;
    private HashMap<XmlKey, List<IndexingFactory>> _factoryMap = new HashMap();

    public IndexingProvider(IndexingMetadataMapper mapper, List<URL> urls) {
        this._mapper = mapper;
        if (!urls.isEmpty()) {
            this._metadataList = new ArrayList<Map<XmlKey, Map<QualifiedName, List<String>>>>();
            for (URL url : urls) {
                try {
                    Map<XmlKey, Map<QualifiedName, List<String>>> metadata = _parser.getMetadataMap(url);
                    this._metadataList.add(metadata);
                }
                catch (StandaloneMetadataFileException e) {
                    _LOGGER.log(Level.WARNING, "Error while loading standalone metadata file; url={0}", url);
                }
            }
        }
    }

    public final List<IndexingFactory> getIndexingFactories(QualifiedName elementQN, QualifiedName attrQN, String value) {
        if (this._mapper != null) {
            XmlKey newKey = this._mapper.getXmlKeyFor(this._getXmlKey(elementQN, attrQN), true);
            elementQN = newKey.getElementQName();
            attrQN = newKey.getAttributeQName();
        }
        return this.getIndexingFactoriesImpl(elementQN, attrQN, value);
    }

    public List<IndexingFactory.IndexEntry> getCommentIndexEntries(String value) {
        return Collections.emptyList();
    }

    protected List<IndexingFactory> getIndexingFactoriesImpl(QualifiedName elementQN, QualifiedName attrQN, String value) {
        XmlKey key = this._getXmlKey(elementQN, attrQN);
        if (this._factoryMap.containsKey(key)) {
            return this._factoryMap.get(key);
        }
        ArrayList<IndexingFactory> factories = null;
        if (this._metadataList != null) {
            for (Map<XmlKey, Map<QualifiedName, List<String>>> metadata : this._metadataList) {
                if (!metadata.containsKey(key)) continue;
                Map<QualifiedName, List<String>> factoryMap = metadata.get(key);
                for (QualifiedName qName : _qnList) {
                    if (!factoryMap.containsKey(qName)) continue;
                    if (factories == null) {
                        factories = new ArrayList();
                    }
                    factories.addAll(this._getIndexingFactories(factoryMap.get(qName)));
                }
            }
        }
        if (attrQN != null) {
            if (NO_NAMESPACE.equals((Object)attrQN)) {
                if (factories == null) {
                    factories = new ArrayList<IndexingFactory>();
                }
                factories.addAll(this._getIndexingFactories(Collections.singletonList("oracle.bali.xml.gui.jdev.dependency.url.UrlReferenceFactory")));
            }
            if (SCHEMA_LOCATION.equals((Object)attrQN)) {
                if (factories == null) {
                    factories = new ArrayList();
                }
                factories.addAll(this._getIndexingFactories(Collections.singletonList("oracle.bali.xml.gui.jdev.dependency.url.SchemaLocReferenceFactory")));
            }
        }
        this._factoryMap.put(key, factories);
        return factories;
    }

    private XmlKey _getXmlKey(QualifiedName elementQN, QualifiedName attrQN) {
        XmlKey key = null;
        if (attrQN == null) {
            key = ImmutableXmlKey.createElementKey((QualifiedName)elementQN);
        } else {
            QualifiedName parentQN = null;
            if (attrQN.getAttributeNamespace() == null) {
                parentQN = elementQN;
            }
            key = ImmutableXmlKey.createAttributeKey((QualifiedName)parentQN, (QualifiedName)attrQN);
        }
        return key;
    }

    private Collection<IndexingFactory> _getIndexingFactories(List<String> classes) {
        ArrayList<IndexingFactory> factories = new ArrayList<IndexingFactory>();
        for (String clazz : classes) {
            try {
                IndexingFactory factory = null;
                if (_factoryClassMap.contains(clazz)) {
                    factory = (IndexingFactory)_factoryClassMap.get(clazz);
                } else {
                    Class<?> factoryClass = Class.forName(clazz, true, Thread.currentThread().getContextClassLoader());
                    if (IndexingFactory.class.isAssignableFrom(factoryClass)) {
                        factory = IndexingProvider._instantiate(factoryClass.asSubclass(IndexingFactory.class));
                        _factoryClassMap.put(clazz, factory);
                    }
                }
                if (factory == null) continue;
                factories.add(factory);
            }
            catch (ClassNotFoundException e) {
                _LOGGER.log(Level.WARNING, "Unable to load class: {0}", clazz);
            }
        }
        return factories;
    }

    private static <T> T _instantiate(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            _LOGGER.log(Level.WARNING, "Could not instantiate class " + clazz, e);
            return (T)((Object)null);
        }
    }

    static {
        _qnList.add(REFERENCE_FACTORY);
        _qnList.add(INDEXING_FACTORY);
        _parser = new IndexingMetadataParser(_qnList);
        _factoryClassMap = new ConcurrentHashMap();
        _LOGGER = Logger.getLogger(IndexingProvider.class.getName());
    }
}

