/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.bali.inspector.multi.ArraySelectionModel;
import oracle.bali.inspector.multi.SelectionListener;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.XmlDomPropertyModel;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlView;
import org.w3c.dom.Node;

public class PISelectionModel
implements SelectionModel {
    private XmlDomPropertyModel[] _propertyModels;
    private BaseInspectorGui _gui;

    public PISelectionModel(BaseInspectorGui inspectorGui, boolean listenToSelection) {
        if (inspectorGui == null) {
            throw new IllegalArgumentException("BaseInspectorXmlGui required");
        }
        this._gui = inspectorGui;
    }

    public void dispose() {
        this._gui = null;
        if (this._propertyModels != null) {
            for (int i = 0; i < this._propertyModels.length; ++i) {
                this._propertyModels[i].disposeModel();
            }
            this._propertyModels = new XmlDomPropertyModel[0];
        }
    }

    public int getSelectedItemCount() {
        return this.getPropertyModels().length;
    }

    public Object getSelectedItem(int index) {
        return this.getPropertyModels()[index];
    }

    public void addSelectionListener(SelectionListener listener) {
    }

    public void removeSelectionListener(SelectionListener listener) {
    }

    public SelectionModel copyContents() {
        return new ArraySelectionModel(new Vector<XmlDomPropertyModel>(Arrays.asList(this.getPropertyModels())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final XmlDomPropertyModel[] getPropertyModels() {
        if (this._propertyModels == null) {
            XmlView view = this._gui.getView();
            Set inspectableSet = this.getInspectableNodes();
            int inspectableNodeCount = inspectableSet.size();
            XmlDomPropertyModel[] propertyModels = new XmlDomPropertyModel[inspectableNodeCount];
            view.acquireReadLock();
            try {
                Iterator inspectableNodes = inspectableSet.iterator();
                for (int i = 0; i < inspectableNodeCount; ++i) {
                    Node n = (Node)inspectableNodes.next();
                    XmlKey key = view.getNodeXmlKey(n);
                    propertyModels[i] = this._gui.createPropertyModel(n, this.getPromotionKeys(n, key));
                }
            }
            finally {
                view.releaseReadLock();
            }
            this._propertyModels = propertyModels;
        }
        return this._propertyModels;
    }

    protected List<XmlKey> getPromotionKeys(Node ancestorNode, XmlKey ancestorKey) {
        return Collections.singletonList(ancestorKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getInspectableNodes() {
        XmlView view = this._gui.getView();
        HashSet<Node> inspectableSet = null;
        view.acquireReadLock();
        try {
            Node[] nodes = view.getSelection().getSelectedNodesArray();
            inspectableSet = new HashSet<Node>(nodes.length);
            for (int i = 0; i < nodes.length; ++i) {
                Node inspectableNode = nodes[i];
                if (inspectableNode == null) continue;
                inspectableSet.add(inspectableNode);
            }
        }
        finally {
            view.releaseReadLock();
        }
        return inspectableSet;
    }

    protected BaseInspectorGui getGui() {
        return this._gui;
    }
}

