/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ListCellRenderer;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.bali.share.util.ClassLoaderUtils;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.FixedAttributeElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.resolver.GrammarResolverEvent;
import oracle.bali.xml.grammar.resolver.GrammarResolverListener;
import oracle.bali.xml.grammar.util.AttributeValueUtils;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.binding.BaseDatabindingEditorGui;
import oracle.bali.xml.gui.base.inspector.Comparators;
import oracle.bali.xml.gui.base.inspector.PISelectionModel;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.bali.xml.gui.base.inspector.PropertyRowOwner;
import oracle.bali.xml.gui.base.inspector.PropertyRowsProvider;
import oracle.bali.xml.gui.base.inspector.ResetToDefaultAction;
import oracle.bali.xml.gui.base.inspector.SimpleElementPropertyRow;
import oracle.bali.xml.gui.base.inspector.TransactedPIMultiModel;
import oracle.bali.xml.gui.base.inspector.XmlDomPropertyModel;
import oracle.bali.xml.gui.base.inspector.XmlKeyPropertyRow;
import oracle.bali.xml.gui.base.inspector.XmlPropertyId;
import oracle.bali.xml.gui.base.inspector.editors.BooleanEditor;
import oracle.bali.xml.gui.base.inspector.editors.CharEditor;
import oracle.bali.xml.gui.base.inspector.editors.URIEditor;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.message.XmlModelMessage;
import oracle.bali.xml.model.message.XmlModelMessageLog;
import oracle.bali.xml.model.metadata.PropertyEditorContext;
import oracle.bali.xml.util.AttributeValueItem;
import oracle.bali.xml.util.AttributeValueItemComparator;
import oracle.bali.xml.util.AttributeValueItemProvider;
import oracle.bali.xml.util.AttributeValueItemProvider2;
import oracle.bali.xml.util.ContextualActionProvider;
import oracle.bali.xml.util.ContextualActionProvider2;
import oracle.bali.xml.util.ContextualAttributeValueItemProvider;
import oracle.bali.xml.util.DefaultAttributeValueItem;
import oracle.bali.xml.util.SimpleTypePropertyEditorManager;
import oracle.bali.xml.validator.ValidationException;
import oracle.javatools.status.Issue;
import oracle.javatools.status.Severity;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sun.beans.editors.StringEditor;

public class BaseInspectorGui
extends XmlGui {
    public static final Object DEFAULT_EDITOR_BOOLEAN = "BOOLEAN";
    public static final Object DEFAULT_EDITOR_URI = "URI";
    public static final Object DEFAULT_EDITOR_FLOAT = "FLOAT";
    public static final Object DEFAULT_EDITOR_DOUBLE = "DOUBLE";
    public static final Object DEFAULT_EDITOR_INTEGER = "INTEGER";
    public static final Object DEFAULT_EDITOR_LONG = "LONG";
    public static final Object DEFAULT_EDITOR_SHORT = "SHORT";
    public static final Object DEFAULT_EDITOR_BYTE = "BYTE";
    public static final Object DEFAULT_EDITOR_QUALIFIEDNAME = "QUALIFIEDNAME";
    public static final Object DEFAULT_EDITOR_BIGINTEGER = "BIGINTEGER";
    public static final Object DEFAULT_EDITOR_BIGDECIMAL = "BIGDECIMAL";
    public static final Object DEFAULT_EDITOR_UNSIGNEDINTEGER = "UNSIGNED_INTEGER";
    public static final Object DEFAULT_EDITOR_IMAGE = "IMAGE_URI";
    public static final Object DEFAULT_EDITOR_JAVACLASS = "JAVACLASSNAME";
    public static final Object DEFAULT_EDITOR_DATABINDING = "DATABINDING";
    public static final Object DEFAULT_EDITOR_CHARACTER = "CHARACTER";
    public static final Object DEFAULT_EDITOR_MULTILINE = "MULTILINE";
    private static final Object[] _sDEFAULT_IDENTIFIERS = new Object[]{DEFAULT_EDITOR_BOOLEAN, DEFAULT_EDITOR_URI, DEFAULT_EDITOR_FLOAT, DEFAULT_EDITOR_DOUBLE, DEFAULT_EDITOR_INTEGER, DEFAULT_EDITOR_LONG, DEFAULT_EDITOR_SHORT, DEFAULT_EDITOR_BYTE, DEFAULT_EDITOR_QUALIFIEDNAME, DEFAULT_EDITOR_BIGINTEGER, DEFAULT_EDITOR_BIGDECIMAL, DEFAULT_EDITOR_UNSIGNEDINTEGER, DEFAULT_EDITOR_IMAGE, DEFAULT_EDITOR_JAVACLASS, DEFAULT_EDITOR_DATABINDING, DEFAULT_EDITOR_CHARACTER, DEFAULT_EDITOR_MULTILINE};
    private static final Map<Object, String> _identifierToPropertyEditorClass = new HashMap<Object, String>();
    private final Map<Object, String> _defaultIdentifierMap = new HashMap<Object, String>();
    private final ConcurrentHashMap<XmlKey, Object> _keyToPropertyId = new ConcurrentHashMap();
    private GrammarResolverListener _listener;
    private Map<Node, List<XmlModelMessage>> _nodeToMessages = new HashMap<Node, List<XmlModelMessage>>();
    private final PropertyRowsProvider _rowsProvider = new PropertyRowsProvider();
    private final Comparator<PropertyRow> _rowComparator = Comparators.createPropertyRowComparator(this);
    private static Logger _LOGGER = Logger.getLogger(BaseInspectorGui.class.getName());

    public static final void registerPropertyEditorIdentifier(Object identifier, String propertyEditorClass) {
        if (identifier == null || propertyEditorClass == null) {
            throw new IllegalArgumentException("identifier and propertyEditorClass must be non null");
        }
        if (BaseInspectorGui.isDefaultIdentifier(identifier)) {
            throw new IllegalArgumentException("identifier is reserved");
        }
        String c = _identifierToPropertyEditorClass.get(identifier);
        if (c != null) {
            throw new IllegalArgumentException("identifier " + identifier + " already used by " + c);
        }
        _identifierToPropertyEditorClass.put(identifier, propertyEditorClass);
    }

    public static final void unregisterPropertyEditorIdentifier(Object identifier) {
        _identifierToPropertyEditorClass.remove(identifier);
    }

    public static final String getPropertyEditor(Object identifier) {
        return _identifierToPropertyEditorClass.get(identifier);
    }

    public BaseInspectorGui(XmlView view) {
        super(view);
        this._listener = new GrammarResolverListener(){

            public void grammarResolverChanged(GrammarResolverEvent e) {
                BaseInspectorGui.this._clearCache();
            }
        };
        this.getGuiContext().getGrammarResolver().addGrammarResolverListener(this._listener);
        this.registerPropertyEditors();
    }

    public PropertyModel createPropertyModel(boolean listenToSelection) {
        return this.createPropertyModel(new PISelectionModel(this, listenToSelection));
    }

    public PropertyModel createPropertyModel(SelectionModel selectionModel) {
        TransactedPIMultiModel multiObjectModel = new TransactedPIMultiModel(this);
        multiObjectModel.setSelectionModel(selectionModel);
        return multiObjectModel;
    }

    public XmlDomPropertyModel createPropertyModel(Node node) {
        return this.createPropertyModel(node, this.getView().getXmlMetadataResolver().getNodeXmlKey(node));
    }

    public XmlDomPropertyModel createPropertyModel(Node node, XmlKey key) {
        return new XmlDomPropertyModel(node, key, this);
    }

    public XmlDomPropertyModel createPropertyModel(Node node, List<XmlKey> keys) {
        return new XmlDomPropertyModel(node, keys, this);
    }

    public PropertyEditor getPropertyEditor(Node node, XmlKey key, Object value) {
        return this.createPropertyEditor(node, key, value);
    }

    public void registerPropertyEditors() {
        SimpleTypePropertyEditorManager.getInstance().registerPropertyEditor("http://www.w3.org/2001/XMLSchema", "anyURI", URIEditor.class);
        SimpleTypePropertyEditorManager.getInstance().registerPropertyEditor("http://www.w3.org/2001/XMLSchema", "boolean", BooleanEditor.class);
        this.registerDefaultIdentifier(DEFAULT_EDITOR_BOOLEAN, BooleanEditor.class.getName());
        this.registerDefaultIdentifier(DEFAULT_EDITOR_URI, URIEditor.class.getName());
        this.registerDefaultIdentifier(DEFAULT_EDITOR_FLOAT, "sun.beans.editors.StringEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_DOUBLE, "sun.beans.editors.StringEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_INTEGER, "sun.beans.editors.StringEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_LONG, "sun.beans.editors.StringEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_SHORT, "sun.beans.editors.StringEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_BYTE, "sun.beans.editors.StringEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_QUALIFIEDNAME, "sun.beans.editors.StringEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_BIGINTEGER, "sun.beans.editors.StringEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_BIGDECIMAL, "sun.beans.editors.StringEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_UNSIGNEDINTEGER, "sun.beans.editors.StringEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_JAVACLASS, "sun.beans.editors.StringEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_IMAGE, "sun.beans.editors.StringEditor");
        this.registerDefaultIdentifier(DEFAULT_EDITOR_CHARACTER, CharEditor.class.getName());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getGuiContext().getGrammarResolver().removeGrammarResolverListener(this._listener);
        this._clearCache();
    }

    public void showError(XmlKey nodeKey, Object value, Throwable t) {
        LogRecord lr = new LogRecord(Level.WARNING, "Error setting {0} to {1}");
        lr.setThrown(t);
        lr.setParameters(new Object[]{nodeKey, value});
        _LOGGER.log(lr);
    }

    @Override
    public boolean isGuiActivatable() {
        return false;
    }

    public final Set<AttributeValueItem> getAttributeValues(Node attr, XmlKey attrKey, XmlKey ownerKey, Node nearestAncestor, Node targetNode) {
        return this.getAttributeValues(attr, attrKey, null, null, ownerKey, nearestAncestor, targetNode);
    }

    public final Set<AttributeValueItem> getAttributeValues(Node attr, XmlKey attrKey, Object value, Node ownerNode, XmlKey ownerKey, Node nearestAncestor, Node targetNode) {
        Attr a = this._getAttr(attr);
        return this.getAttributeValuesImpl(a, attrKey, this._getValue(a, value), this._getParent(a, ownerNode), ownerKey, nearestAncestor, targetNode);
    }

    public final ListCellRenderer getCustomListCellRenderer(XmlKey key, Object value, Node attrParent, AttributeValueItem item) {
        return this.getCustomListCellRenderer(null, key, value, attrParent, item);
    }

    public final ListCellRenderer getCustomListCellRenderer(Attr attrNode, AttributeValueItem item) {
        if (attrNode == null) {
            return null;
        }
        return this.getCustomListCellRenderer(attrNode, this.getView().getXmlMetadataResolver().getNodeXmlKey(attrNode), attrNode.getValue(), attrNode.getOwnerElement(), item);
    }

    public final ListCellRenderer getCustomListCellRenderer(Attr attrNode, XmlKey key, Object value, Node attrParent, AttributeValueItem item) {
        AttributeValueItemProvider avip;
        PropertyEditor pe = this.getPropertyEditor(attrNode, key, value);
        if (pe instanceof AttributeValueItemProvider && (avip = (AttributeValueItemProvider)((Object)pe)).hasCustomRenderer()) {
            return avip.getCustomListCellRenderer(item);
        }
        return null;
    }

    public String getNodeToolTip(Node node) {
        List<? extends Issue> list = this.getNodeMessageList(node);
        String error = this.getErrorMessage(list);
        if (error != null) {
            return error;
        }
        String warning = this.getWarningMessage(list);
        if (warning != null) {
            return warning;
        }
        return null;
    }

    public String getNodeToolTip(Node owner, XmlKey key) {
        List<? extends Issue> list = this.getNodeMessageList(owner, key);
        String error = this.getErrorMessage(list);
        if (error != null) {
            return error;
        }
        String warning = this.getWarningMessage(list);
        if (warning != null) {
            return warning;
        }
        return null;
    }

    public boolean containsErrorMessage(Object modelMessages) {
        if (modelMessages == null || !(modelMessages instanceof List)) {
            return false;
        }
        List messageList = (List)modelMessages;
        return BaseInspectorGui._getFirstOfSeverity(messageList, Severity.ERROR) != null;
    }

    public boolean containsWarningMessage(Object modelMessages) {
        if (modelMessages == null || !(modelMessages instanceof List)) {
            return false;
        }
        List messageList = (List)modelMessages;
        return BaseInspectorGui._getFirstOfSeverity(messageList, Severity.WARNING) != null;
    }

    public String getErrorMessage(List<XmlModelMessage> messageList) {
        return BaseInspectorGui._getMessage(messageList, Severity.ERROR);
    }

    public String getWarningMessage(List<XmlModelMessage> messageList) {
        return BaseInspectorGui._getMessage(messageList, Severity.WARNING);
    }

    public List<? extends Issue> getNodeMessageList(Node node) {
        if (node == null) {
            return Collections.emptyList();
        }
        List<XmlModelMessage> list = this._nodeToMessages.get(node);
        if (list == null) {
            XmlModel model = this.getView().getBaseModel();
            XmlModelMessageLog log = model.getXmlModelInternalMessageLog();
            list = DomUtils.isInDocumentHierarchy((Node)node) ? log.getNodeMessageList(node) : Collections.emptyList();
            this._nodeToMessages.put(node, list);
        }
        return list;
    }

    public List<? extends Issue> getNodeMessageList(Node owner, XmlKey key) {
        List messages = Collections.emptyList();
        List<? extends Issue> list = this.getNodeMessageList(owner);
        for (Issue issue : list) {
            XmlModelMessage message;
            if (!(issue instanceof XmlModelMessage) || !((message = (XmlModelMessage)issue).getCause() instanceof ValidationException)) continue;
            ValidationException ve = (ValidationException)message.getCause();
            QualifiedName toCheck = null;
            if (ve.getType() == 32) {
                toCheck = key.getAttributeQName();
            } else if (ve.getType() == 23) {
                toCheck = key.getElementQName();
            }
            QualifiedName qname = null;
            if (ve.getRelatedObject() instanceof QualifiedName) {
                qname = (QualifiedName)ve.getRelatedObject();
            }
            if (toCheck == null || !toCheck.equals((Object)qname)) continue;
            if (messages == Collections.EMPTY_LIST) {
                messages = new ArrayList();
            }
            messages.add(message);
        }
        return messages;
    }

    protected Set<AttributeValueItem> getAttributeValuesImpl(Attr attribute, XmlKey attrKey, Object value, Node attrParent, XmlKey ownerKey, Node nearestAncestor, Node targetNode) {
        Set grammarSet;
        XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
        String fixed = this._getFixedValue(attrKey, ownerKey);
        if (fixed != null) {
            return this.__convertCollection(Collections.singletonList(fixed));
        }
        ContextualAttributeValueItemProvider cavip = resolver.getContextualAttributeValueItemProvider(attrKey);
        if (cavip != null) {
            return this._getContextualAttributeValueItemImpl(attribute, attrKey, value, attrParent, ownerKey, nearestAncestor, targetNode);
        }
        PropertyEditor pe = this._getPropertyEditor(attribute, attrKey, value, attrParent);
        Set<AttributeValueItem> propertyEditorSet = this._getPropertyEditorSet(pe, attrKey, attribute, attrParent, ownerKey, nearestAncestor, targetNode);
        Set<AttributeValueItem> globalProviderSet = this._getPropertyEditorSet(XmlMetadataResolver.getGlobalAttributeValueProvider(attrKey), attrKey, attribute, attrParent, ownerKey, nearestAncestor, targetNode);
        List providerList = null;
        AttributeValueItemProvider avip = resolver.getAttributeValueProvider(attrKey);
        if (avip != null) {
            providerList = avip.getAttributeValueItems();
        }
        if ((grammarSet = AttributeValueUtils.getAttributeValues((SimpleType)resolver.getModifiedSimpleType(attribute, attrKey, value))) == null && globalProviderSet == null && propertyEditorSet == null && providerList == null) {
            return Collections.emptySet();
        }
        Set<AttributeValueItem> newSet = this.__createAVIPSet();
        if (propertyEditorSet != null) {
            newSet.addAll(propertyEditorSet);
        }
        if (globalProviderSet != null) {
            newSet.addAll(globalProviderSet);
        }
        if (providerList != null) {
            newSet.addAll(providerList);
        }
        this._eliminateDuplicates(newSet, grammarSet);
        return newSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<AttributeValueItem> _getContextualAttributeValueItemImpl(Node node, XmlKey nodeKey, Object value, Node parent, XmlKey parentKey, Node nearestAncestor, Node targetNode) {
        XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
        ContextualAttributeValueItemProvider cavip = resolver.getContextualAttributeValueItemProvider(nodeKey);
        PropertyEditorContext pec = PropertyEditorContext.create(this.getView().getContext(), nodeKey, node, parent, parentKey, nearestAncestor, targetNode);
        PropertyEditorContext.setContextOnContextualAttributeValueItemProvider(cavip, pec);
        try {
            if (cavip == null) {
                Set<AttributeValueItem> set = Collections.emptySet();
                return set;
            }
            TreeSet<AttributeValueItem> newSet = new TreeSet<AttributeValueItem>(cavip.getComparator());
            newSet.addAll(cavip.getAttributeValueItems());
            if (!cavip.queryOtherSources()) {
                TreeSet<AttributeValueItem> treeSet = newSet;
                return treeSet;
            }
            if (cavip.queryGrammar()) {
                Set grammarSet = AttributeValueUtils.getAttributeValues((SimpleType)resolver.getModifiedSimpleType(node, nodeKey, value));
                this._eliminateDuplicates(newSet, grammarSet);
            }
            if (cavip.queryPropertyEditorTags()) {
                newSet.addAll(this.__getTags(this._getPropertyEditor(node, nodeKey, value, parent)));
            }
            TreeSet<AttributeValueItem> treeSet = newSet;
            return treeSet;
        }
        finally {
            PropertyEditorContext.clearContextOnContextualAttributeValueItemProvider(cavip);
        }
    }

    private void _eliminateDuplicates(Set<AttributeValueItem> newSet, Set<String> grammarSet) {
        if (grammarSet != null && !grammarSet.isEmpty()) {
            Iterator<AttributeValueItem> itr_r = newSet.iterator();
            TreeSet<String> newGrammarSet = new TreeSet<String>();
            newGrammarSet.addAll(grammarSet);
            while (itr_r.hasNext() && !newGrammarSet.isEmpty()) {
                AttributeValueItem item = itr_r.next();
                if (!(item instanceof DefaultAttributeValueItem)) continue;
                DefaultAttributeValueItem defaultItem = (DefaultAttributeValueItem)item;
                for (String s : grammarSet) {
                    if (!defaultItem.equalsSelectedValue(s)) continue;
                    newGrammarSet.remove(s);
                }
            }
            for (String s : newGrammarSet) {
                newSet.add(new DefaultAttributeValueItem(s));
            }
        }
    }

    private PropertyEditor _getPropertyEditor(Node attribute, XmlKey attrKey, Object value, Node attrParent) {
        GuiXmlContext context = this.getGuiContext();
        BaseDatabindingEditorGui bdeg = (BaseDatabindingEditorGui)context.getGui(XmlUsage.DATABINDING_PROPERTY_EDITOR);
        boolean isDataBound = bdeg == null ? false : (attribute != null ? bdeg.isDatabound(attribute, attrParent) : bdeg.isDatabound(attrKey, attrParent, value));
        PropertyEditor pe = isDataBound ? bdeg.getDatabindingPropertyEditor(context, attrKey, attribute, attrParent) : this.getPropertyEditor(attribute, attrKey, value);
        return pe;
    }

    @Override
    protected void handleModelInvalidateEvent(XmlModelEvent e) {
        if (e.isDomTreeChanged()) {
            this._nodeToMessages.clear();
        }
    }

    protected String getPropertyEditorUsingIdentifier(String identifier) {
        String s = this._getDefaultPropertyEditor(identifier);
        if (s == null) {
            s = BaseInspectorGui.getPropertyEditor(identifier);
        }
        return s;
    }

    protected void registerDefaultIdentifier(Object identifier, String propertyEditor) {
        this._defaultIdentifierMap.put(identifier, propertyEditor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyEditor createPropertyEditor(Node node, XmlKey nodeKey, Object value) {
        Class type;
        XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
        String s = resolver.getPropertyEditor(nodeKey);
        PropertyEditor pe = null;
        if (s != null) {
            BaseDatabindingEditorGui bdeg;
            String propertyEditorFromIdentifier = this.getPropertyEditorUsingIdentifier(s);
            if (propertyEditorFromIdentifier != null) {
                pe = this.__loadPropertyEditor(propertyEditorFromIdentifier);
            }
            if (pe == null && DEFAULT_EDITOR_DATABINDING.equals(s) && (bdeg = (BaseDatabindingEditorGui)this.getGuiContext().getGui(XmlUsage.DATABINDING_PROPERTY_EDITOR)) != null) {
                Element owner = node != null && node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : null;
                pe = bdeg.getDatabindingPropertyEditor(this.getGuiContext(), nodeKey, node, owner);
            }
            if (pe == null) {
                pe = this.__loadPropertyEditor(s);
            }
        }
        if (pe == null) {
            SimpleType simpleType = null;
            this.getView().acquireReadLock();
            try {
                simpleType = resolver.getModifiedSimpleType(node, nodeKey, value);
            }
            finally {
                this.getView().releaseReadLock();
            }
            if (simpleType != null) {
                try {
                    pe = SimpleTypePropertyEditorManager.getInstance().getPropertyEditor(simpleType);
                }
                catch (GrammarException ge) {
                    // empty catch block
                }
            }
        }
        if (pe == null && (pe = this.__getEditorFromJavaType(type = resolver.getJavaType(nodeKey, value))) == null) {
            pe = new StringEditor();
        }
        return pe;
    }

    PropertyEditor __getEditorFromJavaType(Class type) {
        PropertyEditor pe = null;
        Class<String> stringClass = String.class;
        if (type == null) {
            type = stringClass;
        }
        pe = type == stringClass ? new StringEditor() : PropertyEditorManager.findEditor(type);
        return pe;
    }

    protected boolean isDrillable(XmlKey key, Node node, XmlKey ownerKey, Node ownerNode) {
        return key.getNodeType() == 1;
    }

    protected PropertyModel createDrilledPropertyModel(XmlKey key, Node node, XmlKey ownerKey, Node ownerNode) {
        if (node != null && key.getNodeType() == 1) {
            return this.createPropertyModel(node, key);
        }
        return null;
    }

    protected final PropertyRow createPropertyRow(XmlKey key, Node node, PropertyRowOwner owner) {
        return new XmlKeyPropertyRow(this, key, node, owner);
    }

    protected final PropertyRow createSimpleElementPropertyRow(XmlKey key, Node node, PropertyRowOwner owner) {
        return new SimpleElementPropertyRow(this, key, node, owner);
    }

    protected void gatherPropertyLevelActions(PropertyRow row, List<Action> actions) {
        if (row instanceof XmlKeyPropertyRow) {
            XmlKeyPropertyRow xrow = (XmlKeyPropertyRow)row;
            Node node = xrow.getNode();
            ContextualActionProvider2.Param param = ContextualActionProvider2.Param.create(this.getGuiContext(), xrow.getOwner().getTargetNode(), xrow.getOwner().getTargetKey(), node, xrow.getKey());
            if (node != null) {
                ContextualActionProvider mdProvider = this.getView().getXmlMetadataResolver().getContextualActionProvider(node);
                actions.addAll(ContextualActionProvider2.invoke(mdProvider, param));
            }
            Iterable<ContextualActionProvider> globals = this.getGuiContext().getGlobalContextualActionProviders();
            actions.addAll(ContextualActionProvider2.invokeAll(globals, param));
        }
        if (ResetToDefaultAction.__supported(row)) {
            actions.add(new ResetToDefaultAction(this));
        }
    }

    Set<AttributeValueItem> getAttributeValues(XmlKey attrKey, Node attr, Object value, PropertyRowOwner owner) {
        return this.getAttributeValues(attr, attrKey, value, owner.getParentNode(), owner.getParentKey(), owner.getNearestAncestor(), owner.getTargetNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAttributeValueEditable(Node attribute, XmlKey attrKey, PropertyRowOwner owner, Object value) {
        XmlKey ownerKey;
        Node attrParent = owner.getParentNode();
        XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
        XmlKey xmlKey = ownerKey = attrParent == null ? null : resolver.getNodeXmlKey(attrParent);
        if (this._getFixedValue(attrKey, ownerKey) != null) {
            return false;
        }
        SimpleType type = resolver.getModifiedSimpleType(attribute, attrKey, value);
        ContextualAttributeValueItemProvider cavip = resolver.getContextualAttributeValueItemProvider(attrKey);
        if (cavip != null) {
            return !cavip.isConstrainedToEnumeration();
        }
        if (AttributeValueUtils.containsEnumerations((SimpleType)type)) {
            return !AttributeValueUtils.isConstrainedToEnumerations((SimpleType)type);
        }
        PropertyEditor pe = this.getPropertyEditor(attribute, attrKey, value);
        PropertyEditorContext.setContext(pe, PropertyEditorContext.create(this.getView().getContext(), attrKey, attribute, attrParent, owner.getParentKey(), owner.getNearestAncestor(), owner.getTargetNode()));
        try {
            if (pe instanceof AttributeValueItemProvider2) {
                boolean bl = !((AttributeValueItemProvider2)((Object)pe)).isConstrainedToEnumeration();
                return bl;
            }
            if (pe instanceof AttributeValueItemProvider) {
                boolean bl = true;
                return bl;
            }
            pe = XmlMetadataResolver.getGlobalAttributeValueProvider(attrKey);
            if (pe instanceof AttributeValueItemProvider) {
                boolean bl = true;
                return bl;
            }
            AttributeValueItemProvider avip = resolver.getAttributeValueProvider(attrKey);
            if (avip instanceof AttributeValueItemProvider2) {
                boolean bl = !((AttributeValueItemProvider2)avip).isConstrainedToEnumeration();
                return bl;
            }
            if (avip != null) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            PropertyEditorContext.clearContext(pe);
        }
        return false;
    }

    void __clearNodeMessages(Node node) {
        if (node != null) {
            this._nodeToMessages.remove(node);
        }
    }

    Object __getPropertyId(XmlKey key, PropertyRowOwner owner) {
        Object created;
        Object cached;
        boolean useCache = owner.isTargetNodeParent();
        if (useCache && (cached = this._keyToPropertyId.get(key)) != null) {
            return cached;
        }
        switch (key.getNodeType()) {
            case 1: {
                created = this._getElemAttrPropertyId(key, owner, false);
                break;
            }
            case 2: {
                created = this._getElemAttrPropertyId(key, owner, true);
                break;
            }
            default: {
                created = key;
            }
        }
        if (useCache) {
            this._keyToPropertyId.put(key, created);
        }
        return created;
    }

    Comparator<PropertyRow> __getRowComparator() {
        return this._rowComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<PropertyRow> __createPropertyRows(PropertyRowOwner owner) {
        XmlView view = this.getView();
        view.acquireReadLock();
        try {
            List<PropertyRow> list = this._rowsProvider.createAllRows(owner, this);
            return list;
        }
        finally {
            view.releaseReadLock();
        }
    }

    Set<AttributeValueItem> __createAVIPSet() {
        return new TreeSet<AttributeValueItem>(AttributeValueItemComparator.getComparator());
    }

    private Attr _getAttr(Node n) {
        return n != null && n.getNodeType() == 2 ? (Attr)n : null;
    }

    private Object _getValue(Attr a, Object v) {
        if (v != null) {
            return v;
        }
        return a != null ? a.getNodeValue() : null;
    }

    private Node _getParent(Attr a, Node p) {
        if (p != null) {
            return p;
        }
        return a != null ? a.getOwnerElement() : null;
    }

    private String _getFixedValue(XmlKey key, XmlKey ownerKey) {
        GrammarComponent gc = this.getView().getXmlMetadataResolver().getGrammarComponent(key);
        if (gc instanceof AttributeDef) {
            if (ownerKey == null || !(this.getView().getXmlMetadataResolver().getGrammarComponent(ownerKey) instanceof FixedAttributeElementDef)) {
                return ((AttributeDef)gc).getFixedValue();
            }
        } else if (gc instanceof ElementDef) {
            return ((ElementDef)gc).getFixedValue();
        }
        return null;
    }

    Set<AttributeValueItem> __convertCollection(Collection<String> c) {
        if (c == null || c.size() == 0) {
            return null;
        }
        Set<AttributeValueItem> set = this.__createAVIPSet();
        for (String s : c) {
            set.add(new DefaultAttributeValueItem(s));
        }
        return set;
    }

    Set<AttributeValueItem> __getTags(PropertyEditor pe) {
        String[] tags;
        Set<AttributeValueItem> set = this.__createAVIPSet();
        if (pe != null && (tags = pe.getTags()) != null && tags.length > 0) {
            set = this.__convertCollection(Arrays.asList(tags));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<AttributeValueItem> _getPropertyEditorSet(PropertyEditor pe, XmlKey attrKey, Node attribute, Node attrParent, XmlKey ownerKey, Node nearestAncestor, Node targetNode) {
        Set<AttributeValueItem> set = this.__createAVIPSet();
        if (pe != null) {
            PropertyEditorContext.setContext(pe, PropertyEditorContext.create(this.getView().getContext(), attrKey, attribute, attrParent, ownerKey, nearestAncestor, targetNode));
            try {
                if (pe instanceof AttributeValueItemProvider) {
                    List l = ((AttributeValueItemProvider)((Object)pe)).getAttributeValueItems();
                    set.addAll(l);
                } else {
                    set.addAll(this.__getTags(pe));
                }
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                LogRecord lr = new LogRecord(Level.WARNING, "Error querying property editor {0} for enumerated values");
                lr.setParameters(new Object[]{pe});
                lr.setThrown(t);
                _LOGGER.log(lr);
            }
            finally {
                PropertyEditorContext.clearContext(pe);
            }
        }
        return set;
    }

    private String _getDefaultPropertyEditor(Object identifier) {
        return this._defaultIdentifierMap.get(identifier);
    }

    PropertyEditor __loadPropertyEditor(String s) {
        if (s == null) {
            return null;
        }
        try {
            Class c = ClassLoaderUtils.loadClass((String)s);
            if (PropertyEditor.class.isAssignableFrom(c)) {
                return (PropertyEditor)c.newInstance();
            }
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return null;
    }

    private void _clearCache() {
        this._keyToPropertyId.clear();
        this._rowsProvider.clearCaches();
    }

    private Object _getElemAttrPropertyId(XmlKey key, PropertyRowOwner owner, boolean isAttribute) {
        GrammarComponent gc = this.getView().getXmlMetadataResolver().getGrammarComponent(key);
        Type type = null;
        if (gc instanceof ElementDef) {
            type = ((ElementDef)gc).getType();
        } else if (gc instanceof AttributeDef) {
            type = ((AttributeDef)gc).getType();
        }
        XmlPropertyId.PropertyType propertyType = XmlPropertyId.PropertyType.ELEMENT;
        if (isAttribute) {
            propertyType = XmlPropertyId.PropertyType.ATTRIBUTE;
        }
        return new XmlPropertyId(this, isAttribute ? key.getAttributeQName() : key.getElementQName(), type, propertyType, owner.getPromotionPath());
    }

    private static String _getMessage(List<XmlModelMessage> messageList, Severity severity) {
        XmlModelMessage msg = BaseInspectorGui._getFirstOfSeverity(messageList, severity);
        if (msg != null) {
            return msg.getShortDescription();
        }
        return null;
    }

    private static XmlModelMessage _getFirstOfSeverity(List<XmlModelMessage> messageList, Severity severity) {
        for (XmlModelMessage message : messageList) {
            if (message.getSeverity() != severity) continue;
            return message;
        }
        return null;
    }

    private static final boolean isDefaultIdentifier(Object identifier) {
        for (int i = 0; i < _sDEFAULT_IDENTIFIERS.length; ++i) {
            if (!_sDEFAULT_IDENTIFIERS.equals(identifier)) continue;
            return true;
        }
        return false;
    }
}

