/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.view.standalone;

import java.util.HashMap;
import oracle.bali.xml.dom.ProxyingMapNamedNodeMap;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.view.standalone.ProxyingNode;
import oracle.bali.xml.dom.view.standalone.StandaloneElement;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProxyingElement
extends StandaloneElement
implements ProxyingNode {
    private final Element _proxiedElement;
    private final boolean _deepCopy;

    public ProxyingElement(Element proxiedElement, boolean deepCopy) {
        super(proxiedElement.getOwnerDocument(), proxiedElement.getNamespaceURI(), proxiedElement.getPrefix(), DomUtils.getLocalName((Node)proxiedElement));
        this._proxiedElement = proxiedElement;
        this._deepCopy = deepCopy;
    }

    @Override
    public Node getProxiedNode() {
        return this._proxiedElement;
    }

    @Override
    public Node getProxyingNode(Node proxiedNode) {
        if (proxiedNode == this.getProxiedNode()) {
            return this;
        }
        return null;
    }

    @Override
    public NodeList getChildNodes() {
        if (this._deepCopy) {
            return super.getChildNodes();
        }
        return this.getProxiedNode().getChildNodes();
    }

    @Override
    public Node getFirstChild() {
        if (this._deepCopy) {
            return super.getFirstChild();
        }
        return this.getProxiedNode().getFirstChild();
    }

    @Override
    public Node getLastChild() {
        if (this._deepCopy) {
            return super.getLastChild();
        }
        return this.getProxiedNode().getLastChild();
    }

    @Override
    protected NamedNodeMap createAttrMap() {
        return new ProxyingMapNamedNodeMap(this, new HashMap(7), this._proxiedElement.getAttributes());
    }

    @Override
    protected void createChildren() {
        if (this._deepCopy) {
            for (Node currChild = this._proxiedElement.getFirstChild(); currChild != null; currChild = currChild.getNextSibling()) {
                short childNodeType = currChild.getNodeType();
                if (childNodeType != 1 && childNodeType != 3) continue;
                ProxyingElement childProxy = null;
                if (childNodeType == 1) {
                    childProxy = new ProxyingElement((Element)currChild, true);
                }
                if (childProxy == null) continue;
                this.appendChild(childProxy);
            }
        }
    }
}

