/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.locator;

import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.javatools.buffer.LineMap;

public class SimpleLocator
extends Locator
implements Comparable {
    private int _startOffset = 0;
    private int _endOffset = 0;

    @Override
    public Locator getCopy() {
        return new SimpleLocator(this.getLineMap(), this._startOffset, this._endOffset);
    }

    @Override
    public int getStartOffset() {
        return this._startOffset;
    }

    @Override
    public int getEndOffset() {
        return this._endOffset;
    }

    @Override
    public void attach(LocatorManager manager, boolean attach) {
        manager.attach(this, attach);
    }

    public void setStartOffset(int startOffset) {
        this._startOffset = startOffset;
    }

    public void setEndOffset(int endOffset) {
        this._endOffset = endOffset;
    }

    public void move(int delta) {
        this.setStartOffset(this.getStartOffset() + delta);
        this.setEndOffset(this.getEndOffset() + delta);
    }

    public int getDomLength() {
        return this.getLength();
    }

    public String toString() {
        return this._startOffset + "-" + this._endOffset;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.compareTo(o) == 0;
    }

    public int compareTo(Object o) {
        if (!(o instanceof SimpleLocator)) {
            throw new IllegalArgumentException("can't compare " + this + " and " + o);
        }
        SimpleLocator other = (SimpleLocator)o;
        int startDiff = this.getStartOffset() - other.getStartOffset();
        if (startDiff != 0) {
            return startDiff;
        }
        return this.getEndOffset() - other.getEndOffset();
    }

    protected void adjustForCharactersAdded(int offset, int length) {
        if (this.getLength() == 0) {
            if (this._startOffset >= offset) {
                this.move(length);
            }
        } else {
            if (this._startOffset >= offset) {
                this._startOffset += length;
            }
            if (this._endOffset > offset) {
                this._endOffset += length;
            }
        }
    }

    protected boolean adjustForCharactersRemoved(int rangeStart, int length) {
        int rangeEnd = rangeStart + length;
        if (this.getLength() == 0 && this._startOffset >= rangeEnd) {
            this.move(-length);
            return false;
        }
        if (this._startOffset >= rangeStart) {
            if (this._endOffset <= rangeEnd) {
                return true;
            }
            if (this._startOffset < rangeEnd) {
                throw new IllegalArgumentException("charactersRemoved called with dubious offset and length. offset=" + rangeStart + " length=" + length + " dubious locator=" + this);
            }
            this._startOffset -= length;
        }
        if (this._endOffset > rangeStart) {
            if (this._endOffset >= rangeEnd) {
                this._endOffset -= length;
            } else {
                throw new IllegalArgumentException("charactersRemoved called with dubious offset and length. offset=" + rangeStart + " length=" + length + " dubious locator=" + this);
            }
        }
        return false;
    }

    protected SimpleLocator(LineMap lineMap, int startOffset, int endOffset) {
        super(lineMap);
        this._startOffset = startOffset;
        this._endOffset = endOffset;
    }
}

