/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.HashSet;
import java.util.Set;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.ParserConfigurationDecorator;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.textsync.TextSyncOptions;
import oracle.bali.xml.dom.buffer.textsync.TextSyncOptionsDecorator;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class ReformatPCWrapper
extends ParserConfigurationDecorator {
    private final Set _singleQuoteAttributes = new HashSet(27);
    private final Set _elementsWithEndTags = new HashSet(27);
    private final TextSyncOptions _tso;

    public ReformatPCWrapper(ParserConfiguration base, BufferDomModel model, Node reformatRoot, Object options) {
        super(base);
        this._tso = "rule5".equals(options) ? new Rule5TSO() : new ReformatTSO();
        this._gatherInformation(model, reformatRoot);
    }

    @Override
    public TextSyncOptions getTextSyncOptions() {
        return this._tso;
    }

    private void _gatherInformation(BufferDomModel model, Node node) {
        this._findSingleQuoteAttrs(model, node);
        this._checkForNonMinimizedElement(model, node);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this._gatherInformation(model, child);
        }
    }

    private void _checkForNonMinimizedElement(BufferDomModel model, Node node) {
        ElementLocator loc;
        if (DomUtils.isElement((Node)node) && (loc = (ElementLocator)model.getLocator(node)).getEndTagLocator() != null) {
            this._elementsWithEndTags.add(node);
        }
    }

    private void _findSingleQuoteAttrs(BufferDomModel model, Node node) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                AttributeLocator attrLoc;
                Node attr = attrs.item(i);
                Locator loc = model.getLocator(attr);
                if (!(loc instanceof AttributeLocator) || (attrLoc = (AttributeLocator)loc).getQuoteStyle() != 0) continue;
                this._singleQuoteAttributes.add(attr);
            }
        }
    }

    private class Rule5TSO
    extends ReformatTSO {
        private Rule5TSO() {
        }

        @Override
        public TextSyncOptions.AttributeWrapMode getAttributeWrapMode(Element ownerElement) {
            return ATTR_WRAP_ALWAYS_JUST_INDENTED;
        }

        @Override
        public boolean prefersWhitespaceInside(Element parent) {
            return true;
        }

        @Override
        public boolean useMinimizedForm(Element element) {
            return false;
        }

        @Override
        public boolean wrapBeforeEndOfStartTag(Element element) {
            return true;
        }

        @Override
        public boolean prefersWhitespaceInsideWhenEmpty(Element parent) {
            return true;
        }
    }

    private class ReformatTSO
    extends TextSyncOptionsDecorator {
        private ReformatTSO() {
        }

        @Override
        protected final TextSyncOptions getBaseTextSyncOptions() {
            return ReformatPCWrapper.super.getTextSyncOptions();
        }

        @Override
        public boolean isDefaultQuoteStyleDouble(Attr attr) {
            if (ReformatPCWrapper.this._singleQuoteAttributes.contains(attr)) {
                return false;
            }
            return super.isDefaultQuoteStyleDouble(attr);
        }

        @Override
        public boolean useMinimizedForm(Element element) {
            if (ReformatPCWrapper.this._elementsWithEndTags.contains(element)) {
                return false;
            }
            return super.useMinimizedForm(element);
        }

        @Override
        public boolean prefersWhitespaceInside(Element element) {
            Node firstChild = element.getFirstChild();
            if (DomUtils.isText((Node)firstChild) && firstChild == element.getLastChild()) {
                return false;
            }
            return super.prefersWhitespaceInside(element);
        }
    }
}

