/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.event.UndoableEditListener;
import oracle.bali.xml.dom.CustomizationLayer;
import oracle.bali.xml.dom.DomCommitException;
import oracle.bali.xml.dom.DomModelContext;
import oracle.bali.xml.dom.DomModelListener;
import oracle.bali.xml.dom.DomMutationListener;
import oracle.bali.xml.dom.NodeCustomizationDetails;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.model.TransactionOptions;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class DomModel {
    public static final String DOCUMENT_CHANGED_PROPERTY = "documentChanged";
    public static final String TEXTBUFFER_MODIFIED_PROPERTY = "textBufferModified";
    public static final String PARSE_PROBLEMS_PROPERTY = "parseProblems";
    public static final String READONLY_PROPERTY = "readOnly";
    private final Reference _domModelRef = new WeakReference<DomModel>(this);
    private final DomModelContext _context;
    private final Logger _logger = this.createLogger();
    private final WhitespaceHandler _whitespaceHandler;

    protected DomModel(DomModelContext context) {
        this(context, null);
    }

    protected DomModel(DomModelContext context, WhitespaceHandler whitespaceHandler) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        if (whitespaceHandler == null) {
            whitespaceHandler = WhitespaceHandler.getDefaultWhitespaceHandler();
        }
        this._context = context;
        this._whitespaceHandler = whitespaceHandler;
    }

    public final DomModelContext getContext() {
        return this._context;
    }

    public final WhitespaceHandler getWhitespaceHandler() {
        return this._whitespaceHandler;
    }

    public final Logger getLogger() {
        return this._logger;
    }

    public final Reference getDomModelReference() {
        return this._domModelRef;
    }

    public abstract DOMImplementation getDOMImplementation();

    public abstract Document getDocument();

    public abstract void destroyDocument();

    public abstract boolean isReadOnly();

    public abstract boolean isImmutable(Node var1);

    public abstract boolean isDeletable(Node var1);

    public abstract boolean canAddChild(DomPosition var1);

    public abstract boolean canAddAttribute(Element var1, String var2, String var3);

    public abstract boolean isValueModifiable(Node var1);

    public abstract NodeCustomizationDetails getCustomizationDetails(Node var1);

    public abstract CustomizationLayer getTipCustomizationLayer();

    public abstract boolean prefersSmallestPossibleChangeRoot();

    public abstract boolean needsReparse();

    public abstract void forceReparse();

    public final void startTransaction(String description) {
        this.startTransaction(new TransactionOptions(description));
    }

    public abstract void startTransaction(TransactionOptions var1);

    public abstract DomCommitException precommitTransaction();

    public abstract void commitTransaction();

    public abstract void rollbackTransaction();

    public abstract int getLockStatus();

    public abstract void acquireReadLock();

    public abstract void releaseReadLock();

    public abstract void acquireWriteLock();

    public abstract void releaseWriteLock();

    public abstract void acquireStaleDataLock();

    public abstract void releaseStaleDataLock();

    public abstract void verifyLock();

    public abstract void verifyWriteLock();

    public abstract void markCurrentUndoableEditMergable();

    public abstract Node getChangeTarget();

    public abstract String getTransactionDescription();

    public abstract boolean isInTransaction();

    public abstract boolean isInTopLevelTransaction();

    public abstract int getTextOffset(DomPosition var1);

    public abstract Node getNodeAtOffset(int var1);

    public final DomPosition getDomPosition(int caretPosition) {
        return this.getDomPosition(caretPosition, false);
    }

    public abstract DomPosition getDomPosition(int var1, boolean var2);

    public abstract void getTextOffsets(Node var1, int[] var2);

    public abstract void addUndoableEditListener(UndoableEditListener var1);

    public abstract void removeUndoableEditListener(UndoableEditListener var1);

    public abstract void addDomChangeListener(DomModelListener var1);

    public abstract void removeDomChangeListener(DomModelListener var1);

    public abstract void addDomMutationListener(DomMutationListener var1);

    public abstract void removeDomMutationListener(DomMutationListener var1);

    public abstract int getDocChangeCount();

    public abstract boolean hasModifications();

    public abstract List getCurrentDomParseProblems();

    public abstract void setDocType(String var1, String var2, String var3);

    public abstract void removeDocType();

    public abstract XmlDeclarationInfo getXmlDeclarationInfo();

    public abstract void setXmlDeclarationInfo(XmlDeclarationInfo var1);

    public final FragmentParseResult parseFragment(Node contextNode, String text) {
        return this.parseFragment(contextNode, Collections.EMPTY_MAP, text);
    }

    public abstract FragmentParseResult parseFragment(Node var1, Map var2, String var3);

    public final void reformatSubtree(String undoLabel, Node parent) {
        this.reformatSubtree(undoLabel, parent, null);
    }

    public abstract void reformatSubtree(String var1, Node var2, Object var3);

    public abstract boolean isUnspecifiedAttribute(Attr var1);

    public abstract Attr setUnspecifiedAttribute(Element var1, String var2, String var3, String var4);

    public abstract void mergeTextNodes(Text var1, Text var2);

    public abstract Text splitTextNode(Text var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        try {
            this.disposeImpl();
        }
        finally {
            this.getDomModelReference().clear();
        }
    }

    protected abstract void disposeImpl();

    protected abstract void refreshModel(boolean var1);

    protected final void flushContextPendingEvents() {
        this.getContext().flushPendingEvents();
    }

    protected final Logger createLogger() {
        return Logger.getLogger("oracle.bali.xml.dom");
    }

    public static final class FragmentParseResult {
        private final DocumentFragment _frag;

        public FragmentParseResult(DocumentFragment frag) {
            if (frag == null) {
                throw new IllegalArgumentException("null fragment");
            }
            this._frag = frag;
        }

        public DocumentFragment getDocumentFragment() {
            return this._frag;
        }
    }
}

