/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.xmlComponent;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import oracle.bali.inspector.editor.EditorFactoryUtils;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentModel;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentPropertyEditor;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.base.xmlComponent.XmlWrappedComponent;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTextAreaEditor;
import oracle.bali.xml.metadata.XmlKey;
import oracle.javatools.ui.Borders;

public class XmlWrappedComponentImpl
implements XmlWrappedComponent {
    private Component _wrappedComponent;
    private XmlComponentWrapper _xmlComponentWrapper;
    private Component _defaultWrappedComponent;
    private FocusTracker _focusTracker;
    private FocusDispatcher _focusDispatcher;
    private MyFocusDispatcher _MyFocusDispatcher;

    public XmlWrappedComponentImpl(XmlComponentWrapper xmlComponentWrapper, Component defaultWrappedComponent) {
        this._xmlComponentWrapper = xmlComponentWrapper;
        this._defaultWrappedComponent = defaultWrappedComponent;
    }

    public Component getWrappedComponent() {
        if (this._wrappedComponent == null) {
            XmlComponentPropertyEditor propertyEditor = this.getPropertyEditor();
            if (propertyEditor instanceof XmlComponentPropertyEditor) {
                XmlComponentPropertyEditor xmlPropertyEditor = propertyEditor;
                xmlPropertyEditor.setXmlComponentWrapper(this._xmlComponentWrapper);
                Component xmlComponent = xmlPropertyEditor.getXmlComponent();
                if (xmlComponent == null) {
                    this.setWrappedComponent(this._defaultWrappedComponent);
                } else {
                    this.setWrappedComponent(xmlComponent);
                }
            } else {
                this.setWrappedComponent(this._defaultWrappedComponent);
            }
        }
        return this._wrappedComponent;
    }

    public void dispose() {
        if (this._wrappedComponent != null && this._focusTracker != null) {
            this._wrappedComponent.removeFocusListener(this._focusTracker);
            this._focusTracker = null;
            if (this._MyFocusDispatcher != null) {
                this.setFocusDispatcher((JPanel)this._wrappedComponent, false);
                this._MyFocusDispatcher = null;
            }
            this._wrappedComponent = null;
        }
    }

    private XmlComponentPropertyEditor getPropertyEditor() {
        return this._xmlComponentWrapper.getPropertyEditor();
    }

    public void setWrappedComponent(Component wrappedComponent) {
        if (this._wrappedComponent != null && this._focusTracker != null) {
            this._wrappedComponent.removeFocusListener(this._focusTracker);
            if (this.getPropertyEditor() instanceof XmlComponentPropertyEditor) {
                this.getPropertyEditor().removeChildFocusListener((FocusListener)this._focusTracker);
            }
            this._focusTracker = null;
            if (this._MyFocusDispatcher != null) {
                this.setFocusDispatcher((JComponent)this._wrappedComponent, false);
                this._MyFocusDispatcher = null;
            }
        }
        this._wrappedComponent = wrappedComponent;
        if (this._xmlComponentWrapper.addFocusTracker()) {
            this.addFocusTracker();
        }
    }

    public void setEnabled(boolean enabled) {
        Component component = this.getWrappedComponent();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setEditable(enabled);
        }
        component.setEnabled(enabled);
    }

    public void highlightRequiredValue() {
        Component wrappedComponent = this.getWrappedComponent();
        if (wrappedComponent instanceof JComponent) {
            Borders.attachErrorBorder((JComponent)((JComponent)wrappedComponent));
            String errorMessage = XmlWrappedComponentImpl.createRequiredValueMessage(this._xmlComponentWrapper);
            if (errorMessage != null) {
                this.setToolTipText(errorMessage);
            }
            return;
        }
    }

    public static String createRequiredValueMessage(XmlComponentWrapper xmlComponentWrapper) {
        String errorMessage;
        String reqAttrMsg1 = "Required attribute ";
        String reqElemMsg1 = "Required element ";
        String reqAttrMsg2 = " missing from element ";
        String reqElemMsg2 = " missing from parent element ";
        XmlKey xmlKey = xmlComponentWrapper.getXmlComponentModel().getXmlKey();
        if (xmlKey.getNodeType() == 2) {
            String parentName = xmlComponentWrapper.getXmlComponentModel().getParentAttrNode().getLocalName();
            errorMessage = reqAttrMsg1 + xmlKey.getAttributeQName().getName() + reqAttrMsg2 + " " + parentName;
        } else {
            errorMessage = reqElemMsg1 + xmlKey.getElementQName().getName() + reqElemMsg2;
        }
        return errorMessage;
    }

    public void highlightErrorOrWarning() {
        Component wrappedComponent = this.getWrappedComponent();
        XmlComponentModel xmlComponentModel = this._xmlComponentWrapper.getXmlComponentModel();
        if (xmlComponentModel.modelValueContainsError()) {
            if (wrappedComponent instanceof JComponent) {
                Borders.attachErrorBorder((JComponent)((JComponent)wrappedComponent));
                String errorMessage = xmlComponentModel.getCurrentErrorMessage();
                if (errorMessage != null) {
                    this.setToolTipText(errorMessage);
                }
            }
        } else if (xmlComponentModel.modelValueContainsWarning()) {
            if (wrappedComponent instanceof JComponent) {
                Borders.attachWarningBorder((JComponent)((JComponent)wrappedComponent));
                String warningMessage = xmlComponentModel.getCurrentWarningMessage();
                if (warningMessage != null) {
                    this.setToolTipText(warningMessage);
                }
            }
        } else if (wrappedComponent instanceof JComponent) {
            Borders.restoreBorder((JComponent)((JComponent)wrappedComponent));
            this.setToolTipText(null);
        }
    }

    public void highlightInvalidXmlComponentValue(boolean validXmlComponentValue, String errorMessage, String xmlComponentValue) {
        Component wrappedComponent = this.getWrappedComponent();
        if (!validXmlComponentValue) {
            this.showErrorMessage(wrappedComponent, errorMessage, xmlComponentValue);
            if (wrappedComponent instanceof JComponent) {
                Borders.attachErrorBorder((JComponent)((JComponent)wrappedComponent));
                if (errorMessage != null) {
                    this.setToolTipText(errorMessage);
                }
            }
        } else if (wrappedComponent instanceof JComponent) {
            Borders.restoreBorder((JComponent)((JComponent)wrappedComponent));
            this.setToolTipText(null);
        }
    }

    public void showErrorMessage(Component parent, String errorMessage, String invalidValue) {
        String title = this._xmlComponentWrapper.getXmlComponentModel().getXmlGui().getTranslatedString("XMLCOMPONENTERROR");
        Component superParent = SwingUtilities.windowForComponent(parent);
        if (superParent == null) {
            superParent = parent;
        }
        if (errorMessage != null) {
            JOptionPane.showMessageDialog(superParent, errorMessage, title, 0);
        } else {
            JOptionPane.showMessageDialog(superParent, "Invalid value: '" + invalidValue + "'", title, 0);
        }
    }

    public void showExceptionErrorMessage(Exception ex) {
        Component wrappedComponent = this.getWrappedComponent();
        EditorFactoryUtils.showErrorMessage((Component)wrappedComponent, (Exception)ex, (String)this._xmlComponentWrapper.getXmlComponentValue());
        if (wrappedComponent instanceof JComponent) {
            Borders.attachErrorBorder((JComponent)((JComponent)wrappedComponent));
            String errorMessage = ex.getLocalizedMessage();
            if (errorMessage != null) {
                this.setToolTipText(errorMessage);
            }
        }
    }

    public void setToolTipText(String toolTipText) {
        Component wrappedComponent = this.getWrappedComponent();
        if (wrappedComponent instanceof XmlTextAreaEditor.TextAreaPanel) {
            XmlTextAreaEditor.TextAreaPanel textAreaPanel = (XmlTextAreaEditor.TextAreaPanel)wrappedComponent;
            textAreaPanel.setToolTipText(toolTipText);
        } else {
            ((JComponent)wrappedComponent).setToolTipText(toolTipText);
        }
    }

    private void addFocusTracker() {
        if (this._wrappedComponent == null) {
            return;
        }
        this._focusTracker = new FocusTracker();
        if (this._wrappedComponent instanceof JComboBox && ((JComboBox)this._wrappedComponent).isEditable()) {
            ((JComboBox)this._wrappedComponent).getEditor().getEditorComponent().addFocusListener(this._focusTracker);
        } else {
            this._wrappedComponent.addFocusListener(this._focusTracker);
        }
        if (this.getPropertyEditor() instanceof XmlComponentPropertyEditor) {
            this.getPropertyEditor().addChildFocusListener((FocusListener)this._focusTracker);
        }
    }

    private void setFocusDispatcher(JComponent parentJComponent, boolean add) {
        for (int i = 0; i < parentJComponent.getComponentCount(); ++i) {
            if (!(parentJComponent.getComponent(i) instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)parentJComponent.getComponent(i);
            if (jComponent.getComponentCount() > 1) {
                this.setFocusDispatcher(jComponent, add);
                continue;
            }
            if (this._MyFocusDispatcher == null) {
                this._MyFocusDispatcher = new MyFocusDispatcher((JComponent)this._wrappedComponent);
            }
            if (add) {
                jComponent.addFocusListener(this._MyFocusDispatcher);
                continue;
            }
            jComponent.removeFocusListener(this._MyFocusDispatcher);
        }
    }

    private class FocusTracker
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            XmlWrappedComponentImpl.this._xmlComponentWrapper.getXmlComponentModel().setSelection();
        }

        @Override
        public void focusLost(FocusEvent e) {
            XmlWrappedComponentImpl.this._xmlComponentWrapper.updateModelFromXmlComponent();
        }
    }

    private class FocusDispatcher
    implements PropertyChangeListener {
        private static final String PERMANENT_FOCUS_OWNER = "permanentFocusOwner";
        private KeyboardFocusManager _focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        private Component _component;

        public FocusDispatcher(Component wrappedComponent) {
            this._component = wrappedComponent;
        }

        public void start() {
            this._focusManager.addPropertyChangeListener(PERMANENT_FOCUS_OWNER, this);
        }

        public void dispose() {
            this._focusManager.removePropertyChangeListener(PERMANENT_FOCUS_OWNER, this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getOldValue() == null || evt.getNewValue() == null) {
                return;
            }
            if (evt.getOldValue() == null) {
                if (SwingUtilities.isDescendingFrom((Component)evt.getNewValue(), this._component)) {
                    this.focusGained();
                }
            } else if (evt.getNewValue() == null) {
                if (SwingUtilities.isDescendingFrom((Component)evt.getOldValue(), this._component)) {
                    this.focusLost();
                }
            } else if (SwingUtilities.isDescendingFrom((Component)evt.getOldValue(), this._component) && !SwingUtilities.isDescendingFrom((Component)evt.getNewValue(), this._component)) {
                this.focusLost();
            } else if (SwingUtilities.isDescendingFrom((Component)evt.getNewValue(), this._component) && !SwingUtilities.isDescendingFrom((Component)evt.getOldValue(), this._component)) {
                this.focusGained();
            }
        }

        public void focusLost() {
            XmlWrappedComponentImpl.this._xmlComponentWrapper.updateModelFromXmlComponent();
        }

        public void focusGained() {
            XmlWrappedComponentImpl.this._xmlComponentWrapper.getXmlComponentModel().setSelection();
        }
    }

    private class MyFocusDispatcher
    implements FocusListener {
        private JComponent _rootJComponent;

        MyFocusDispatcher(JComponent rootJComponent) {
            this._rootJComponent = rootJComponent;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Component sourceComponent = focusEvent.getComponent();
            Component oppositeComponent = focusEvent.getOppositeComponent();
            if (sourceComponent != null || !this._rootJComponent.isAncestorOf(sourceComponent)) {
                FocusListener[] focusListeners;
                for (FocusListener focusListener : focusListeners = this._rootJComponent.getFocusListeners()) {
                    focusListener.focusGained(focusEvent);
                }
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            Component sourceComponent = focusEvent.getComponent();
            Component oppositeComponent = focusEvent.getOppositeComponent();
            if (!this._rootJComponent.isAncestorOf(oppositeComponent)) {
                FocusListener[] focusListeners;
                for (FocusListener focusListener : focusListeners = this._rootJComponent.getFocusListeners()) {
                    focusListener.focusLost(focusEvent);
                }
            }
        }
    }
}

