/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.xmlComponent;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.swing.xmlComponent.XmlWrappedComponentImpl;
import oracle.javatools.ui.Borders;

public class XmlTableCellRenderer
extends DefaultTableCellRenderer {
    private XmlComponentWrapper _xmlComponentWrapper;
    private ArrayList<XmlComponentWrapper> _columnXmlComponentWrapperList;

    public XmlTableCellRenderer(XmlComponentWrapper xmlComponentWrapper, ArrayList<XmlComponentWrapper> columnXmlComponentWrapperList) {
        this._xmlComponentWrapper = xmlComponentWrapper;
        this._columnXmlComponentWrapperList = columnXmlComponentWrapperList;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String stringValue;
        JComponent tableCellRendererComponent = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        boolean missingValue = false;
        if (value == null) {
            missingValue = true;
        } else if (value instanceof String && (stringValue = (String)value).length() == 0) {
            missingValue = true;
        }
        if (missingValue && this._xmlComponentWrapper.getXmlComponentModel().isRequired().booleanValue()) {
            Borders.attachErrorBorder((JComponent)tableCellRendererComponent);
            String errorMessage = XmlWrappedComponentImpl.createRequiredValueMessage(this._xmlComponentWrapper);
            if (errorMessage != null) {
                tableCellRendererComponent.setToolTipText(errorMessage);
            }
        } else {
            Borders.restoreBorder((JComponent)tableCellRendererComponent);
            tableCellRendererComponent.setToolTipText(null);
        }
        return tableCellRendererComponent;
    }
}

