/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.xmlComponent;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyEditor;
import java.beans.VetoableChangeListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.swing.xmlComponent.AbstractXmlTableEditor;
import oracle.bali.xml.gui.swing.xmlComponent.XmlContextualActionButton;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTableEditor;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.PropertyEditorContext;
import oracle.bali.xml.share.FastMessageFormat;
import org.w3c.dom.Node;

public class XmlTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final String EMPTY_STRING = "";
    private XmlContext mXmlContext;
    private XmlKey mXmlKey;
    private NodeResolver mNodeResolver;
    private NodeResolver mOwnerNodeResolver;
    private AbstractXmlTableEditor.FocusLostBehavior mFocusLostBehavior;
    private MyFocusDispatcher mFocusDispatcher;
    private MyFocusLostListener mFocusLostListener;
    private boolean mEditing = false;
    private String mInitialValue = null;
    private String mCurrentValue = null;
    private XmlComponentWrapper _xmlComponentWrapper;
    private XmlTextComponent mTextComponent = null;

    public XmlTableCellEditor(XmlContext xmlContext, XmlKey xmlKey, Node node, Node ownerNode, AbstractXmlTableEditor.FocusLostBehavior focusLostBehavior, XmlComponentWrapper xmlComponentWrapper) {
        this.mXmlContext = xmlContext;
        this.mXmlKey = xmlKey;
        this.mNodeResolver = new SimpleNodeResolver(node);
        this.mOwnerNodeResolver = new SimpleNodeResolver(ownerNode);
        this.mFocusLostBehavior = focusLostBehavior;
        this._xmlComponentWrapper = xmlComponentWrapper;
    }

    public XmlContext getXmlContext() {
        return this.mXmlContext;
    }

    public XmlKey getXmlKey() {
        return this.mXmlKey;
    }

    public NodeResolver getNodeResolver() {
        return this.mNodeResolver;
    }

    public NodeResolver getOwnerNodeResolver() {
        return this.mOwnerNodeResolver;
    }

    public AbstractXmlTableEditor.FocusLostBehavior getFocusLostBehavior() {
        return this.mFocusLostBehavior;
    }

    @Override
    public Object getCellEditorValue() {
        return this.mCurrentValue;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
        this._xmlComponentWrapper.invalidateXmlComponent();
        this.mInitialValue = value instanceof Node ? ((Node)value).getTextContent() : (value != null ? value.toString() : EMPTY_STRING);
        if (this._xmlComponentWrapper.getXmlWrappedComponent().getWrappedComponent() instanceof JComboBox) {
            XmlComboBox comboBox = new XmlComboBox(this.mXmlContext, this.mXmlKey, this.mNodeResolver, this.mOwnerNodeResolver, this._xmlComponentWrapper);
            this.mTextComponent = comboBox;
            this.mTextComponent.initialize();
            this.mTextComponent.setText(this.mInitialValue);
            comboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (XmlTableCellEditor.this.mEditing) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                XmlTableCellEditor.this.stopCellEditing();
                            }
                        });
                    }
                }
            });
        } else {
            XmlTextField textField = new XmlTextField(this.mXmlContext, this.mXmlKey, this.mNodeResolver, this.mOwnerNodeResolver, this._xmlComponentWrapper);
            this.mTextComponent = textField;
            this.mTextComponent.initialize();
            this.mTextComponent.setText(this.mInitialValue);
            textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (XmlTableCellEditor.this.mEditing) {
                        XmlTableCellEditor.this.stopCellEditing();
                    }
                }
            });
        }
        this.mFocusDispatcher = new MyFocusDispatcher(table);
        this.mTextComponent.addFocusListener(this.mFocusDispatcher);
        this.mFocusLostListener = new MyFocusLostListener(table);
        this.mTextComponent.addFocusListener(this.mFocusLostListener);
        this.mEditing = true;
        return this.mTextComponent;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.mTextComponent == null) {
            return super.stopCellEditing();
        }
        this.mCurrentValue = this.mTextComponent.getText();
        if (!this.mInitialValue.equals(this.mCurrentValue)) {
            this.mTextComponent.removeFocusListener(this.mFocusDispatcher);
            this.mTextComponent.removeFocusListener(this.mFocusLostListener);
            this.mTextComponent = null;
            this.mEditing = false;
            return super.stopCellEditing();
        }
        this.cancelCellEditing();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.mTextComponent.removeFocusListener(this.mFocusDispatcher);
        this.mTextComponent.removeFocusListener(this.mFocusLostListener);
        this.mTextComponent = null;
        this.mEditing = false;
        super.cancelCellEditing();
    }

    protected static class XmlPropertyEditorAction
    extends AbstractAction {
        private static final String EDIT_ACTION_NAME = "Edit...";
        private static final String EDIT_DIALOG_TITLE = "Edit Property - {0}";
        private static final int EDIT_DIALOG_BUTTON_MASK = 3;
        private static final String EMPTY_STRING = "";
        private XmlTextComponentWithPropertyEditor mXmlTextComponent;
        private String mDialogTitle;

        static XmlPropertyEditorAction createXmlPropertyEditorAction(XmlTextComponentWithPropertyEditor xmlTextComponent) {
            boolean supportsCustomEditor = xmlTextComponent.supportsCustomEditor();
            if (supportsCustomEditor) {
                PropertyEditor propertyEditor = xmlTextComponent.getPropertyEditor();
                return new XmlPropertyEditorAction(xmlTextComponent, EDIT_ACTION_NAME, EDIT_DIALOG_TITLE);
            }
            return null;
        }

        protected XmlPropertyEditorAction(XmlTextComponentWithPropertyEditor xmlTextComponent, String name, String dialogTitle) {
            super(name);
            this.mXmlTextComponent = xmlTextComponent;
            this.mDialogTitle = dialogTitle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.mXmlTextComponent.setPropertyEditorContext();
            try {
                boolean result;
                PropertyEditor propertyEditor = this.mXmlTextComponent.getPropertyEditor();
                propertyEditor.setValue(this.mXmlTextComponent.getText());
                Component customEditor = propertyEditor.getCustomEditor();
                String editDialogTitle = FastMessageFormat.formatMessage((String)this.mDialogTitle, (String)this.mXmlTextComponent.getXmlKey().getLocalName());
                int buttonMask = 7;
                String helpId = HelpUtils.getHelpID((Component)customEditor);
                if (helpId == null || helpId.equals(HelpUtils.getDefaultHelpID())) {
                    buttonMask = 3;
                }
                JEWTDialog editDialog = JEWTDialog.createDialog(null, (String)editDialogTitle, (int)buttonMask);
                editDialog.setContent(customEditor);
                if (customEditor instanceof VetoableChangeListener) {
                    editDialog.addVetoableChangeListener((VetoableChangeListener)((Object)customEditor));
                }
                if (result = editDialog.runDialog()) {
                    Object propertyValue = propertyEditor.getValue();
                    if (propertyValue != null) {
                        this.mXmlTextComponent.setText(propertyValue.toString());
                    } else {
                        this.mXmlTextComponent.setText("");
                    }
                    this.mXmlTextComponent.fireActionPerformed();
                }
            }
            finally {
                this.mXmlTextComponent.clearPropertyEditorContext();
            }
        }
    }

    private static interface NodeResolver {
        public Node resolveNode();
    }

    public class XmlTextField
    extends XmlTextComponent {
        private static final String EMPTY_STRING = "";
        private JTextField mTextField;

        public XmlTextField(XmlContext xmlContext, XmlKey xmlKey, Node node, Node ownerNode, XmlComponentWrapper xmlComponentWrapper) {
            this(xmlContext, xmlKey, xmlTableCellEditor.new SimpleNodeResolver(node), xmlTableCellEditor.new SimpleNodeResolver(ownerNode), xmlComponentWrapper);
        }

        protected XmlTextField(XmlContext xmlContext, XmlKey xmlKey, NodeResolver nodeResolver, NodeResolver ownerNodeResolver, XmlComponentWrapper xmlComponentWrapper) {
            super(xmlContext, xmlKey, nodeResolver, ownerNodeResolver);
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.mTextField = xmlComponentWrapper.getXmlWrappedComponent().getWrappedComponent() instanceof JTextField ? (JTextField)xmlComponentWrapper.getXmlWrappedComponent().getWrappedComponent() : new MyTextField();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 1;
            gbc.insets.set(0, 0, 0, 0);
            gbc.anchor = 21;
            this.add((Component)this.mTextField, gbc);
            gbc.gridx = 1;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.insets.set(0, 0, 0, 0);
            gbc.anchor = 22;
            XmlContextualActionButton xmlContextualActionButton = new XmlContextualActionButton(xmlComponentWrapper, XmlTableCellEditor.this);
            if (xmlContextualActionButton.getContextualActionsCount() > 0) {
                this.add((Component)xmlContextualActionButton, gbc);
            }
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            super.addActionListener(actionListener);
            this.mTextField.addActionListener(actionListener);
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            super.removeActionListener(actionListener);
            this.mTextField.removeActionListener(actionListener);
        }

        public void addDocumentListener(DocumentListener documentListener) {
            this.mTextField.getDocument().addDocumentListener(documentListener);
        }

        public void removeDocumentListener(DocumentListener documentListener) {
            this.mTextField.getDocument().removeDocumentListener(documentListener);
        }

        @Override
        public void addFocusListener(FocusListener focusListener) {
            super.addFocusListener(focusListener);
            this.mTextField.addFocusListener(focusListener);
        }

        @Override
        public void removeFocusListener(FocusListener focusListener) {
            super.removeFocusListener(focusListener);
            this.mTextField.removeFocusListener(focusListener);
        }

        @Override
        public void initialize() {
            this.mTextField.setText("");
        }

        public Document getDocument() {
            return this.mTextField.getDocument();
        }

        @Override
        public String getText() {
            return this.mTextField.getText();
        }

        @Override
        public void setText(String text) {
            this.mTextField.setText(text);
            this.fireActionPerformed();
        }

        @Override
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int condition, boolean pressed) {
            if (condition == 0 && this.mTextField instanceof MyTextField) {
                return ((MyTextField)this.mTextField).processKeyBinding2(keyStroke, keyEvent, condition, pressed);
            }
            return super.processKeyBinding(keyStroke, keyEvent, condition, pressed);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.mTextField.requestFocus();
            this.mTextField.selectAll();
        }

        private class MyTextField
        extends JTextField {
            private MyTextField() {
            }

            boolean processKeyBinding2(KeyStroke keyStroke, KeyEvent keyEvent, int condition, boolean pressed) {
                return super.processKeyBinding(keyStroke, keyEvent, condition, pressed);
            }

            @Override
            public void updateUI() {
                super.updateUI();
                if (!(this.getCaret() instanceof BasicTextUI.BasicCaret)) {
                    this.setCaret(new BasicTextUI.BasicCaret());
                }
            }
        }
    }

    protected class XmlComboBox
    extends XmlTextComponentWithPropertyEditor {
        private JComboBox mComboBox;

        public XmlComboBox(XmlContext xmlContext, XmlKey xmlKey, Node node, Node ownerNode, XmlComponentWrapper xmlComponentWrapper) {
            this(xmlContext, xmlKey, (NodeResolver)xmlTableCellEditor.new SimpleNodeResolver(node), (NodeResolver)xmlTableCellEditor.new SimpleNodeResolver(ownerNode), xmlComponentWrapper);
        }

        public XmlComboBox(XmlContext xmlContext, XmlKey xmlKey, NodeResolver nodeResolver, NodeResolver ownerNodeResolver, XmlComponentWrapper xmlComponentWrapper) {
            super(xmlContext, xmlKey, nodeResolver, ownerNodeResolver, (PropertyEditor)xmlComponentWrapper.getPropertyEditor());
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.mComboBox = (JComboBox)xmlComponentWrapper.getXmlWrappedComponent().getWrappedComponent();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 1;
            gbc.insets.set(0, 0, 0, 0);
            gbc.anchor = 21;
            this.add((Component)this.mComboBox, gbc);
            gbc.gridx = 1;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.insets.set(0, 0, 0, 0);
            gbc.anchor = 22;
            this.add((Component)new XmlContextualActionButton(xmlComponentWrapper, XmlTableCellEditor.this), gbc);
        }

        @Override
        public void initialize() {
        }

        @Override
        public String getText() {
            return this.getPropertyEditor().getAsText();
        }

        @Override
        public void setText(String text) {
            this.getPropertyEditor().setAsText(text);
        }

        public void addItemListener(ItemListener itemListener) {
            this.mComboBox.addItemListener(itemListener);
        }

        public void removeItemListener(ItemListener itemListener) {
            this.mComboBox.removeItemListener(itemListener);
        }

        @Override
        public void addFocusListener(FocusListener focusListener) {
            super.addFocusListener(focusListener);
            this.mComboBox.addFocusListener(focusListener);
        }

        @Override
        public void removeFocusListener(FocusListener focusListener) {
            super.removeFocusListener(focusListener);
            this.mComboBox.removeFocusListener(focusListener);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.mComboBox.requestFocus();
        }
    }

    protected abstract class XmlTextComponentWithPropertyEditor
    extends XmlTextComponent {
        private PropertyEditor mPropertyEditor;

        public XmlTextComponentWithPropertyEditor(XmlContext xmlContext, XmlKey xmlKey, Node node, Node ownerNode, PropertyEditor propertyEditor) {
            this(xmlContext, xmlKey, xmlTableCellEditor.new SimpleNodeResolver(node), xmlTableCellEditor.new SimpleNodeResolver(ownerNode), propertyEditor);
        }

        public XmlTextComponentWithPropertyEditor(XmlContext xmlContext, XmlKey xmlKey, NodeResolver nodeResolver, NodeResolver ownerNodeResolver, PropertyEditor propertyEditor) {
            super(xmlContext, xmlKey, nodeResolver, ownerNodeResolver);
            this.mPropertyEditor = propertyEditor;
        }

        public PropertyEditor getPropertyEditor() {
            return this.mPropertyEditor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean supportsCustomEditor() {
            if (this.mPropertyEditor != null) {
                this.setPropertyEditorContext();
                try {
                    boolean bl = this.mPropertyEditor.supportsCustomEditor();
                    return bl;
                }
                finally {
                    this.clearPropertyEditorContext();
                }
            }
            return false;
        }

        public void setPropertyEditorContext() {
            PropertyEditorContext context = PropertyEditorContext.create((XmlContext)this.getXmlContext(), (XmlKey)this.getXmlKey(), (Node)this.getNode(), (Node)this.getOwnerNode(), (XmlKey)this.getXmlKey(), (Node)this.getOwnerNode(), (Node)this.getOwnerNode());
            PropertyEditorContext.setContext((Object)this.mPropertyEditor, (PropertyEditorContext)context);
        }

        public void clearPropertyEditorContext() {
            PropertyEditorContext.clearContext((Object)this.mPropertyEditor);
        }
    }

    protected abstract class XmlTextComponent
    extends JPanel {
        private XmlContext mXmlContext;
        private XmlKey mXmlKey;
        private NodeResolver mNodeResolver;
        private NodeResolver mOwnerNodeResolver;
        private List<ActionListener> mActionListeners = new CopyOnWriteArrayList<ActionListener>();

        public XmlTextComponent(XmlContext xmlContext, XmlKey xmlKey, Node node, Node ownerNode) {
            this(xmlContext, xmlKey, xmlTableCellEditor.new SimpleNodeResolver(node), xmlTableCellEditor.new SimpleNodeResolver(ownerNode));
        }

        public XmlTextComponent(XmlContext xmlContext, XmlKey xmlKey, NodeResolver nodeResolver, NodeResolver ownerNodeResolver) {
            this.mXmlContext = xmlContext;
            this.mXmlKey = xmlKey;
            this.mNodeResolver = nodeResolver;
            this.mOwnerNodeResolver = ownerNodeResolver;
        }

        public abstract void initialize();

        public abstract String getText();

        public abstract void setText(String var1);

        public XmlContext getXmlContext() {
            return this.mXmlContext;
        }

        public XmlKey getXmlKey() {
            return this.mXmlKey;
        }

        public Node getNode() {
            return this.mNodeResolver == null ? null : this.mNodeResolver.resolveNode();
        }

        public Node getOwnerNode() {
            return this.mOwnerNodeResolver == null ? null : this.mOwnerNodeResolver.resolveNode();
        }

        public void addActionListener(ActionListener actionListener) {
            this.mActionListeners.add(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.mActionListeners.remove(actionListener);
        }

        public void fireActionPerformed() {
            ActionEvent actionEvent = new ActionEvent(this, 0, null);
            for (ActionListener actionListener : this.mActionListeners) {
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    private class SimpleNodeResolver
    implements NodeResolver {
        private Node mNode;

        public SimpleNodeResolver() {
            this.mNode = null;
        }

        public SimpleNodeResolver(Node node) {
            this.mNode = node;
        }

        public void setNode(Node node) {
            this.mNode = node;
        }

        @Override
        public Node resolveNode() {
            return this.mNode;
        }
    }

    private class MyFocusLostListener
    implements FocusListener {
        private JTable mTable;

        MyFocusLostListener(JTable table) {
            this.mTable = table;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            TableCellEditor cellEditor;
            Component oppositeComponent;
            if (XmlTableCellEditor.this.mFocusLostBehavior != null && XmlTableCellEditor.this.mFocusLostBehavior != AbstractXmlTableEditor.FocusLostBehavior.DO_NOTHING && !this.mTable.isAncestorOf(oppositeComponent = focusEvent.getOppositeComponent()) && (cellEditor = this.mTable.getCellEditor()) != null) {
                if (XmlTableCellEditor.this.mFocusLostBehavior == AbstractXmlTableEditor.FocusLostBehavior.STOP_CELL_EDITING) {
                    cellEditor.stopCellEditing();
                } else if (XmlTableCellEditor.this.mFocusLostBehavior == AbstractXmlTableEditor.FocusLostBehavior.CANCEL_CELL_EDITING) {
                    cellEditor.cancelCellEditing();
                }
            }
        }
    }

    private class MyFocusDispatcher
    implements FocusListener {
        private JTable mTable;

        MyFocusDispatcher(JTable table) {
            this.mTable = table;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Component oppositeComponent = focusEvent.getOppositeComponent();
            if (oppositeComponent != null && !XmlTableCellEditor.this.mTextComponent.isAncestorOf(oppositeComponent)) {
                FocusListener[] focusListeners;
                for (FocusListener focusListener : focusListeners = this.mTable.getFocusListeners()) {
                    focusListener.focusGained(focusEvent);
                }
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            Component oppositeComponent = focusEvent.getOppositeComponent();
            if (oppositeComponent != null && !XmlTableCellEditor.this.mTextComponent.isAncestorOf(oppositeComponent)) {
                FocusListener[] focusListeners;
                XmlTableEditor xmlTableEditor;
                if (XmlTableCellEditor.this._xmlComponentWrapper.getPropertyEditor() instanceof XmlTableEditor && oppositeComponent == (xmlTableEditor = (XmlTableEditor)XmlTableCellEditor.this._xmlComponentWrapper.getPropertyEditor()).getTablePanel()) {
                    return;
                }
                for (FocusListener focusListener : focusListeners = this.mTable.getFocusListeners()) {
                    focusListener.focusLost(focusEvent);
                }
            }
        }
    }
}

