/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.xmlComponent;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.swing.xmlComponent.AbstractXmlContextualActionProvider;
import oracle.bali.xml.gui.swing.xmlComponent.XmlContextualActionContext;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTableCellEditor;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.bali.xml.util.CollectionUtils;
import oracle.bali.xml.util.ContextualActionProvider;
import oracle.bali.xml.util.ContextualActionProvider2;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.Filter;
import org.w3c.dom.Node;

public class XmlContextualActionButton
extends JButton {
    private static final Action[] _EMPTY_ACTIONS = new Action[0];
    private XmlComponentWrapper _xmlComponentWrapper;
    private XmlTableCellEditor _xmlTableCellEditor;
    private final Action[] _contextualActions;

    public XmlContextualActionButton(XmlComponentWrapper xmlComponentWrapper, XmlTableCellEditor xmlTableCellEditor) {
        this._xmlComponentWrapper = xmlComponentWrapper;
        this._xmlTableCellEditor = xmlTableCellEditor;
        this.setContentAreaFilled(false);
        Icon extrasDropdownIcon = OracleIcons.getIcon((String)"pi_action_enabled.png");
        int extrasDropdownVpad = (16 - extrasDropdownIcon.getIconHeight()) / 2;
        int extrasDropdownHpad = (16 - extrasDropdownIcon.getIconWidth()) / 2;
        this.setBorder(new EmptyBorder(extrasDropdownVpad, extrasDropdownHpad, extrasDropdownVpad, extrasDropdownHpad));
        this.setIcon(extrasDropdownIcon);
        IconicButtonUI.install((AbstractButton)this);
        this._contextualActions = this.getDropdownActions();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu menu = new JPopupMenu();
                for (Action action : XmlContextualActionButton.this._contextualActions) {
                    menu.add(action);
                }
                menu.show(XmlContextualActionButton.this, 0, XmlContextualActionButton.this.getHeight());
            }
        });
    }

    public int getContextualActionsCount() {
        return this._contextualActions.length;
    }

    private Action[] getDropdownActions() {
        GuiXmlContext guiXmlContext = this._xmlComponentWrapper.getXmlComponentModel().getXmlGui().getGuiContext();
        return this._getActions(new Filter<Action>(){

            public boolean matches(Action a) {
                return !Boolean.FALSE.equals(a.getValue("show-in-xmlcomponent"));
            }
        }, guiXmlContext);
    }

    private Action[] _getActions(Filter<Action> f, GuiXmlContext guiXmlContext) {
        final Node node = this._xmlComponentWrapper.getXmlComponentModel().getNode();
        XmlKey xmlKey = this._xmlComponentWrapper.getXmlComponentModel().getXmlKey();
        Node ownerNode = node != null && xmlKey.getNodeType() == 2 ? node.getParentNode() : node;
        XmlKey ownerKey = xmlKey;
        final ContextualActionProvider2.Param param = ContextualActionProvider2.Param.create((XmlContext)guiXmlContext, (Node)ownerNode, (XmlKey)ownerKey, (Node)node, (XmlKey)xmlKey);
        final ArrayList contextualActions = new ArrayList();
        XmlView xmlView = this._xmlComponentWrapper.getXmlComponentModel().getView();
        if (node != null) {
            Boolean result = (Boolean)new ReadOnlyTask<Boolean>(){

                protected Boolean runImpl(AbstractModel model) {
                    ContextualActionProvider mdProvider = model.getXmlMetadataResolver().getContextualActionProvider(node);
                    contextualActions.addAll(ContextualActionProvider2.invoke((ContextualActionProvider)mdProvider, (ContextualActionProvider2.Param)param));
                    return true;
                }
            }.run((AbstractModel)xmlView);
        }
        Iterable globals = guiXmlContext.getGlobalContextualActionProviders();
        for (ContextualActionProvider provider : globals) {
            if (!(provider instanceof AbstractXmlContextualActionProvider)) continue;
            ((AbstractXmlContextualActionProvider)provider).setContextualActionContext(new XmlContextualActionContext(this._xmlComponentWrapper, this._xmlTableCellEditor));
        }
        contextualActions.addAll(ContextualActionProvider2.invokeAll((Iterable)globals, (ContextualActionProvider2.Param)param));
        if (!contextualActions.isEmpty()) {
            return (Action[])CollectionUtils.toArray(Action.class, contextualActions, f);
        }
        return _EMPTY_ACTIONS;
    }

    public static Component addContextualActionButton(XmlComponentWrapper xmlComponentWrapper, XmlTableCellEditor xmlTableCellEditor) {
        XmlContextualActionButton xmlContextualActionButton = new XmlContextualActionButton(xmlComponentWrapper, xmlTableCellEditor);
        if (xmlContextualActionButton.getContextualActionsCount() == 0) {
            return xmlComponentWrapper.getXmlWrappedComponent().getWrappedComponent();
        }
        return new EditorContainer(xmlComponentWrapper.getXmlWrappedComponent().getWrappedComponent(), xmlContextualActionButton);
    }

    private static final class EditorContainer
    extends Box {
        private static final int MIN_WIDTH = 100;
        private Component editor;
        private JButton JButton;

        EditorContainer(Component editor) {
            this(editor, null);
        }

        EditorContainer(Component editor, JButton JButton2) {
            super(2);
            this.update(editor);
            this.JButton = JButton2;
            this.addComponents();
        }

        private void addComponents() {
            this.add(this.editor);
            if (this.JButton != null) {
                this.add(EditorContainer.createHorizontalStrut(3));
                this.add(this.JButton);
            }
        }

        Component editor() {
            return this.editor;
        }

        JButton JButton() {
            return this.JButton;
        }

        void updateWith(EditorContainer editorContainer) {
            this.updateWith(editorContainer.editor(), editorContainer.JButton());
        }

        void addPropertyEditorToContainer() {
            this.updateWith(this.editor(), this.JButton());
        }

        void updateWith(Component editor, JButton JButton2) {
            this.update(editor);
            if (this.JButton != null && this.JButton != JButton2) {
                this.JButton = JButton2;
            }
            this.removeAll();
            this.addComponents();
        }

        void clear() {
            this.JButton = null;
            this.update((Component)null);
        }

        void update(Component editor) {
            this.editor = editor;
            if (this.editor == null) {
                return;
            }
            if (this.editor instanceof JCheckBox) {
                return;
            }
            Dimension preferred = this.editor.getPreferredSize();
            this.editor.setPreferredSize(new Dimension(5, preferred.height));
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension fromSuper = super.getPreferredSize();
            if ((this.editor instanceof JTextField || this.editor instanceof JComboBox || this.editor instanceof JCheckBox) && fromSuper.width < 100) {
                fromSuper.width = 100;
            }
            return fromSuper;
        }
    }
}

