/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.bali.xml.gui.swing.util.XmlKeyList;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.util.XmlModelUtils;

public class XmlKeyPicker {
    private JComponent _component;
    private XmlKeyList _list;
    private JEditorPane _descArea;
    private final Map _xmlKeyMap;
    private final AbstractModel _model;
    private static final int DEFAULT_COMPONENT_WIDTH = 70;
    private static final int DEFAULT_DESCRIPTION_HEIGHT = 50;
    private static final int DEFAULT_LIST_HEIGHT = 100;
    private static final int DEFAULT_COMPONENT_SPACING = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlKey runDialog(Component owner, String title, String helpId, Map xmlKeyMap, AbstractModel model, String initialSelection) {
        if (xmlKeyMap.isEmpty()) {
            return null;
        }
        XmlKeyPicker picker = new XmlKeyPicker(xmlKeyMap, model, initialSelection);
        JComponent component = picker._getComponent();
        JList list = picker._getList();
        int buttons = 3;
        if (helpId != null) {
            HelpUtils.setHelpID((JComponent)component, (String)helpId);
            buttons |= 4;
        }
        JEWTDialog dialog = JEWTDialog.createDialog((Component)owner, (String)title, (int)buttons);
        dialog.setContent((Component)component);
        dialog.setResizable(true);
        dialog.setInitialFocus((Component)list);
        UIUtils.setupListDoubleClickListener(list, dialog);
        try {
            XmlModelUtils.setModalDialogRunning((boolean)true);
            if (dialog.runDialog()) {
                XmlKey xmlKey = picker._getSelectedXmlKey();
                return xmlKey;
            }
            XmlKey xmlKey = null;
            return xmlKey;
        }
        finally {
            dialog.dispose();
            XmlModelUtils.setModalDialogRunning((boolean)false);
        }
    }

    private XmlKeyPicker(Map xmlKeyMap, AbstractModel model, String initialSelection) {
        this._xmlKeyMap = xmlKeyMap;
        this._model = model;
        this._initUI(initialSelection);
    }

    private XmlKey _getSelectedXmlKey() {
        return this._list.getSelectedXmlKey();
    }

    private JList _getList() {
        return this._list;
    }

    private JComponent _getComponent() {
        return this._component;
    }

    private void _initUI(String initialSelection) {
        JLabel elementLabel;
        JPanel mainPanel = new JPanel(new BorderLayout(0, 5));
        Set categoriesSet = this._xmlKeyMap.keySet();
        Object[] categories = categoriesSet.toArray();
        Arrays.sort(categories);
        if (initialSelection == null || !categoriesSet.contains(initialSelection)) {
            initialSelection = (String)categories[0];
        }
        KeyListModel keyListModel = new KeyListModel(initialSelection);
        if (categories.length == 1) {
            elementLabel = this._createLabel("INSERT_DIALOG.MESSAGE_FORMAT", (String)categories[0]);
        } else {
            elementLabel = this._createLabel("KEY_PICKER.ELEMENT_LABEL");
            JComboBox<Object> categoryPicker = new JComboBox<Object>(categories);
            categoryPicker.setSelectedItem(initialSelection);
            categoryPicker.addItemListener(keyListModel);
            mainPanel.add(this._createLabeledComp(this._createLabel("KEY_PICKER.CATEGORY_LABEL"), categoryPicker), "North");
        }
        this._list = new XmlKeyList(keyListModel, this._model.getXmlMetadataResolver());
        Box listAndDescription = Box.createVerticalBox();
        JScrollPane listPane = new JScrollPane(this._list);
        listPane.setMinimumSize(new Dimension(70, 100));
        listAndDescription.add(this._createLabeledComp(elementLabel, listPane));
        listAndDescription.add(Box.createVerticalStrut(5));
        if (keyListModel.getSize() > 0) {
            this._list.setSelectedIndex(0);
        }
        listAndDescription.add(this._createLabeledComp(this._createLabel("KEY_PICKER.DESCRIPTION"), this._createDescArea()));
        mainPanel.add((Component)listAndDescription, "Center");
        this._component = mainPanel;
    }

    private Component _createDescArea() {
        this._descArea = new JEditorPane();
        this._descArea.setEditable(false);
        this._descArea.setContentType("text/html");
        this._descArea.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this._updateDescArea();
        this._list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                XmlKeyPicker.this._updateDescArea();
            }
        });
        JScrollPane descPane = new JScrollPane(this._descArea, 22, 31);
        Dimension size = new Dimension(70, 50);
        descPane.setMinimumSize(size);
        descPane.setPreferredSize(size);
        return descPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateDescArea() {
        XmlKey key = this._getSelectedXmlKey();
        String text = null;
        if (key != null) {
            this._model.acquireReadLock();
            try {
                text = this._model.getXmlMetadataResolver().getShortDescription(key);
            }
            finally {
                this._model.releaseReadLock();
            }
        }
        if (text == null) {
            text = "";
        }
        EditorKit kit = this._descArea.getEditorKit();
        Document newDoc = kit.createDefaultDocument();
        StyleSheet styleSheet = ((HTMLDocument)newDoc).getStyleSheet();
        styleSheet.addRule("body {font-family: Dialog; font-size: 10px; line-height: 10px}");
        try {
            kit.read(new StringReader(text), newDoc, 0);
            this._descArea.setDocument(newDoc);
        }
        catch (IOException e) {
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    private Component _createLabeledComp(JLabel label, Component comp) {
        label.setLabelFor(comp);
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.add((Component)label, "North");
        panel.add(comp, "Center");
        return panel;
    }

    private JLabel _createLabel(String bundleKey) {
        return this._createLabelDirect(this._model.getTranslatedString(bundleKey));
    }

    private JLabel _createLabel(String bundleKey, String param) {
        return this._createLabelDirect(this._model.getTranslatedString(bundleKey, param));
    }

    private JLabel _createLabelDirect(String textAndMnemonic) {
        JLabel label = new JLabel(StringUtils.stripMnemonic((String)textAndMnemonic));
        label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)textAndMnemonic));
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(1);
        return label;
    }

    private class KeyListModel
    extends AbstractListModel
    implements ItemListener {
        private List _items = null;

        public KeyListModel(String initialCategory) {
            this._setCategory(initialCategory);
        }

        @Override
        public int getSize() {
            return this._items.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this._items.get(index);
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                List oldItems = this._items;
                String category = (String)event.getItem();
                this._setCategory(category);
                this.fireContentsChanged(this, 0, oldItems.size());
                XmlKeyPicker.this._list.setSelectedIndex(0);
                XmlKeyPicker.this._updateDescArea();
            }
        }

        private void _setCategory(String category) {
            Collection col = (Collection)XmlKeyPicker.this._xmlKeyMap.get(category);
            this._items = col instanceof List ? (List)col : new ArrayList(col);
        }
    }
}

